(* LAMARC package: plots the contour graphs 
   delivered int mathfile.
   
   Sample session:
   
   Open Notebook of Mathematica:
   <<lamarc.m
   <<mathfile;
   MigrateContour[locus1,4]
 
 
   If you use this, please give some feedback, I like even fan mail.
   
   Peter Beerli, Seattle 1997
   beerli@genetics.washington.edu
   

   Also, if you use this, cite in your paper:
   
   Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
       of migration rate and population size using  coalescent theory.
   
   Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
       Estimation of population parameters
       using coalescent theory. Program documentations.
	   (httpd/evolution.washington.edu/lamarc.html)

   Perhaps also (I used this to prepare the package):
   Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
       Redwood City. pp. 267.
   
     
 *)
 
 
BeginPackage["Lamarc`"]

FluctuateContour::usage = "FluctuateContour[locus] 
plots the contourlines of the 50% and 95% confidence limits, for a locus. The Y-Axis is Theta and the X-Axis is the growth rate g. No label version.[Part of the LAMARC package]\n\n
\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"

RecombineContour::usage = "RecombineContour[locus] plots
    the contourlines of the 50% and 95% confidence limits, for
	a locus. The Y-Axis is Theta and the 
	X-Axis is the recombination rate r. No label version. [Part of the LAMARC package]\n\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Perhaps also (I used this to prepare the package):\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"

MigrateContour::usage = "MigrateContour[locusTwo,parameters] plots
    the contourlines of the 50% and 95% confidence limits, for
	a locus and two populations. The Y-Axis is Theta and the 
	X-Axis is 4Nm. No label version. [Part of the LAMARC package]\n\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Perhaps also (I used this to prepare the package):\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"
FluctuateContourL::usage = "FluctuateContourL[locus] 
plots the contourlines of the 50% and 95% confidence limits, for a locus. The Y-Axis is Theta and the X-Axis is the growth rate g. [Part of the LAMARC package]\n\n
\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Perhaps also (I used this to prepare the package):\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"

RecombineContourL::usage = "RecombineContourL[locus] plots
    the contourlines of the 50% and 95% confidence limits, for
	a locus. The Y-Axis is Theta and the 
	X-Axis is the recombination rate r.  [Part of the LAMARC package]\n\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"

MigrateContourL::usage = "MigrateContourL[locusTwo,parameters] plots
    the contourlines of the 50% and 95% confidence limits, for
	a locus and two populations. The Y-Axis is Theta and the 
	X-Axis is 4Nm. [Part of the LAMARC package]\n\nIf you use this, please give some feedback, I like even fan mail.\n
Peter Beerli, Seattle 1997\n
beerli@genetics.washington.edu\n\n
Also, if you use this, cite in your paper:\n
\n
Beerli, P., and J. Felsenstein (in prep.). Maximum likelihood estimation
of migration rate and population size using  coalescent theory.
\n\n
Kuhner, M. K. J. Yamato, P. Beerli, and J. Felsenstein (1997). 
Estimation of population parameters
using coalescent theory. Program documentations.
(httpd/evolution.washington.edu/lamarc.html)
\n\n
Maeder, Roman (1990). Programming in Mathematica. Addison-Wesley, 
Redwood City. pp. 267.
"

Begin["`Private`"]

confidence={{0.454937/2, 3.84146/2.},{1.38629/2, 5.99147/2.},
	{2.36597/2, 7.81473/2.},{3.35670/2, 9.48773/2.},{4.35146/2, 	
							 11.0705/2}}

FluctuateContourS[locus_List,parameter_, label_]:=Module[
{x, top1},
If[parameter>5,Print["Number of parameter is wrong"];Return[]];
If[parameter<2,Print["Number of parameter is wrong"];Return[]];
x = locus;
top1=Max[x];
$DefaultFont={"Helvetica",10};
ListContourPlot[x,
	Contours->{top1-confidence[[parameter,1]],top1-confidence[[parameter,2]]},
	ContourStyle->Thickness[0.005],
	ContourShading->False,MeshRange->{{-3,2},{-3,2}},
	ContourSmoothing->Automatic, FrameLabel->label,
	Frame->True, FrameTicks->{{{-3,0.001},{-2,0.01},{-1,0.1},{0,1},{1,10},{2,100}},{{-3,0.001},{-2,0.01},{-1,0.1},{0,1},{1,10},{2,100}}},DisplayFunction->Identity]
]

FluctuateContour[locus_List] :=
	Show[FluctuateContourS[locus,2,{"",""}], DisplayFunction->$DisplayFunction]

RecombineContour[locus_List] :=
	Show[FluctuateContourS[locus,2,{"",""}], DisplayFunction->$DisplayFunction]

MigrateContour[locusTwo_List, parameter_]:=Module[
	{xx,yy},
	xx = FluctuateContourS[locusTwo[[1]],parameter,{"",""}];
	yy = FluctuateContourS[locusTwo[[2]],parameter,{"",""}];
	Show[GraphicsArray[{xx,yy}], DisplayFunction->$DisplayFunction]
]

FluctuateContourL[locus_List] :=
	Show[FluctuateContourS[locus,2,{"g","Theta"}], DisplayFunction->$DisplayFunction]

RecombineContourL[locus_List,] :=
	Show[FluctuateContourS[locus,2,{"r","Theta"}], DisplayFunction->$DisplayFunction]

MigrateContourL[locusTwo_List, parameter_]:=Module[
	{xx,yy},
	xx = FluctuateContourS[locusTwo[[1]],parameter,{"4Nm","Theta"}];
	yy = FluctuateContourS[locusTwo[[2]],parameter,{"4Nm","Theta"}];
	Show[GraphicsArray[{xx,yy}], DisplayFunction->$DisplayFunction]
]


End[]
EndPackage[]
