#ifndef COMBINE_INCLUDE
#define COMBINE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice world size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 C O M B I N E L O C I (NEWTON RAPHSON)  R O U T I N E S 

 combines loci by estimating a gamma shape parameter
 

 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: combine.h,v 1.1.1.1 1998/06/06 06:09:51 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern long combine_loci(world_fmt *world);
extern void create_nr(nr_fmt *nr,long numpop, long G);
extern void destroy_nr(nr_fmt *nr);
extern double calc_loci_like(nr_fmt *nr, timearchive_fmt * atl, long loci, boolean boolgamma);
extern void calc_gamma(nr_fmt * nr); 


#endif /* COMBINE_INCLUDE*/
