#ifndef OPTIONS_INCLUDE
#define OPTIONS_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 O P T I O N S   R O U T I N E S 

 creates options structures,
 reads options from parmfile if present
 set first parameter for mcmc run,
 prints options,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: options.h,v 1.1.1.1 1998/06/06 06:09:51 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void create_options(option_fmt **options);
extern void init_options(option_fmt *options);
extern void get_options(option_fmt *options);
extern void set_param(world_fmt *world, data_fmt *data, option_fmt *options, long locus);
extern void set_profile_options(option_fmt *options);
extern void print_menu_options(option_fmt *options, world_fmt *world);
extern void print_options(FILE *file, option_fmt *options, world_fmt *world);
extern void decide_plot(option_fmt *options, long chain, long chains, char type);
extern void destroy_options(option_fmt *options);

#endif /*OPTIONS_INCLUDE*/






