/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 R A N D O M   G E N E R A T O R   R O U T I N E S 

 creates options structures,
 reads options from parmfile if present
 
 prints options,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: random.c,v 1.1.1.1 1998/06/06 06:09:51 beerli Exp $
-------------------------------------------------------*/


#include "migration.h"

/*extern gettimeofday(); */
/* prototypes ----------------------------------------- */
void getseed (option_fmt * options);

#ifdef HIGHBITS
double mk_randum (void);
#define RANDUM() mk_randum()
#define RANDINT(a,b) (long)((a)+(mk_randum()* (((b)-(a))+1.)))
#else
double jf_randum (void);
#define RANDUM() jf_randum()
#define RANDINT(a,b) (long)((a)+(jf_randum()* (((b)-(a))+1.)))
#endif


void 
getseed (option_fmt * options)
{
  long i, timeseed;

  switch (options->autoseed)
    {
    case AUTO:
      timeseed = (long) time (NULL);
      options->inseed = labs(4 * timeseed + 1);
      break;
    case NOAUTO:
      break;
    case NOAUTOSELF:
      break;
    default:
      error ("Error: Seed value not defined");
      break;
    }
  options->saveseed = options->inseed;
  for (i = 1; i <= 1000; i++)	/* clear the random numbergenerator */
    RANDUM ();
#ifdef HIGHBITS
  for (i = 0; i <= 2; i++)
    seed[i] = 0;
  i = 0;
  do
    {
      seed[i] = options->inseed & 2047;
      options->inseed /= 2048;
      i++;
    }
  while (options->inseed != 0);
#else
  for (i = 0; i <= 5; i++)
    seed[i] = 0;
  i = 0;
  do
    {
      seed[i] = options->inseed & 63;
      options->inseed /= 64;
      i++;
    }
  while (options->inseed != 0);
#endif
}

#ifdef HIGHBITS
double 
mk_randum (void)
/* Mary's version--faster but needs 32 bits.  Loops have been unrolled
   for speed. */
{
  longer newseed;

  newseed[0] = 1549 * seed[0];
  newseed[1] = newseed[0] / 2048;
  newseed[0] &= 2047;
  newseed[2] = newseed[1] / 2048;
  newseed[1] &= 2047;
  newseed[1] += 1549 * seed[1] + 812 * seed[0];
  newseed[2] += newseed[1] / 2048;
  newseed[1] &= 2047;
  newseed[2] += 1549 * seed[2] + 812 * seed[1];

  memcpy (seed, newseed, sizeof (longer));
  seed[2] &= 1023;
  return (((seed[0] / 2048.0 + seed[1]) / 2048.0 + seed[2]) / 1024.0);
}				/* randum */
#else
double 
jf_randum (void)
{				/* randum -- slow but machine independent */
  /* random number generator -- slow but machine independent */
  long i, j, k, sum;
  longer mult, newseed;
  double x;

  mult[0] = 13;
  mult[1] = 24;
  mult[2] = 22;
  mult[3] = 6;
  for (i = 0; i <= 5; i++)
    newseed[i] = 0;
  for (i = 0; i <= 5; i++)
    {
      sum = newseed[i];
      k = i;
      if (i > 3)
	k = 3;
      for (j = 0; j <= k; j++)
	sum += mult[j] * seed[i - j];
      newseed[i] = sum;
      for (j = i; j <= 4; j++)
	{
	  newseed[j + 1] += newseed[j] / 64;
	  newseed[j] &= 63;
	}
    }
  memcpy (seed, newseed, sizeof (longer));
  seed[5] &= 3;
  x = 0.0;
  for (i = 0; i <= 5; i++)
    x = x / 64.0 + seed[i];
  x /= 4.0;
  return x;
}				/* randum */
#endif
