#ifndef SEQUENCE_INCLUDE
#define SEQUENCE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 S E Q U E N C E S   R O U T I N E S 

 used in menu.c

 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: sequence.h,v 1.1.1.1 1998/06/06 06:09:51 beerli Exp $
-------------------------------------------------------*/

extern void initratio(option_fmt *options);
extern void initfreqs(double *freqa,double *freqc, 
		      double *freqg, double *freqt);
extern void initcatn(long *categs);
extern void initcategs(long categs, double *rate);
extern void initprobcat(long categs, double *probsum, 
			double *probcat);
extern void make_sequences(world_fmt *world, long locus);
extern void initlambda(option_fmt *options);

extern void init_sequences(world_fmt *world, long locus);
extern void init_sequences2(seqmodel_fmt * seq, option_fmt *options, long locus);
extern void init_tbl(world_fmt *world, long locus);
extern void print_weights(world_fmt*world, long locus);
extern void print_tbl(world_fmt *world, long locus);
extern void print_seqfreqs(world_fmt *world);
extern double treelike_seq(world_fmt *world, long locus);
#endif /*SEQUENCE_INCLUDE*/


