/* -----------------------------------------------------     
   sighandler.c                         
   handels to following signals:                
   SIGIOT         Input  Output problems             
   SIGIRAP        Over  Underflow, 0 divide          
   SIGFPE         Floating point exceptions         
   SIGBUS         Bus error                 
   SIGSEGV        Segmentation fault                
   SIGXCPU        CPU time limit exceeded           
   SIGXFSZ        File size limit exceeded          
   SIGILL         Illegal instruction                       
   SIGUSR1        User signal 1                             
   if most of those exception are encountered the system     
   tries to exit gracefully, but with some it dies          
   anyway, but tries to say why in a way which is      
   for humans better understandable  (I hope)                       
   -----------------------------------------------------     
   part of the lamarc package                   

   P. Beerli                            
   ----------------------------------------------------- */
#include <stdio.h>
#ifndef __MWERKS__
#include <sys/types.h>
#endif
#ifdef __NEXT__
#include <libc.h>
#endif
#include <signal.h>
#include <stdarg.h>
#include "migration.h"
#include "sighandler.h"
#ifdef DMALLOC_FUNC_CHECK
#include <dmalloc.h>
#endif
#ifdef WATCOM
#define __MWERKS__
#endif
#undef debug
void 
signalhandling (long switcher)
{
  if (switcher == ON)
    {
#ifndef __MWERKS__
      signal (SIGIOT, signalhandler);
      signal (SIGTRAP, signalhandler);
      signal (SIGBUS, signalhandler);
      signal (SIGUSR1, signalhandler);
#ifndef SYSTEM_V
      signal (SIGXCPU, signalhandler);
      signal (SIGXFSZ, signalhandler);
#endif
#endif
      signal (SIGFPE, signalhandler);
      signal (SIGSEGV, signalhandler);
      signal (SIGILL, signalhandler);
    }
  else
    {
#ifndef __MWERKS__
      signal (SIGIOT, SIG_DFL);
      signal (SIGTRAP, SIG_DFL);
      signal (SIGBUS, SIG_DFL);
      signal (SIGUSR1, SIG_DFL);
#ifndef SYSTEM_V
      signal (SIGXCPU, SIG_DFL);
      signal (SIGXFSZ, SIG_DFL);
#endif
#endif
      signal (SIGFPE, SIG_DFL);
      signal (SIGSEGV, SIG_DFL);
      signal (SIGILL, SIG_DFL);
    }
}

void 
signalhandler (int sig)
{
  fputc ('\040', stderr);
  switch (sig)
    {
#ifndef __MWERKS__
    case SIGIOT:
      fprintf (stderr, "\nInput/Output error!\n");
      fprintf (stderr, "Most likely a fatal error in the infile or parmfile\n\n");
      exit (sig);
      break;
    case SIGTRAP:
      fprintf (stderr, "Trace trap\n");
      fprintf (stderr, "Please report this bug!\n   (Peter Beerli, beerli@genetics.washington.edu)\n");
      fprintf (stderr, "there was an an overflow/underflow/0 divide problem\n");
      fprintf (stderr, "or some other problems.\n");
      fprintf (stderr, "But check the correctedness of your data first.\n");
      exit (sig);
      break;
    case SIGBUS:
      fprintf (stderr, "Bus error\n");
      fprintf (stderr, "Please report this bug!\n(Peter Beerli, beerli@genetics.washington.edu)\n");
      fprintf (stderr, "there was a bus error, this results in an non recoverable crash\n");
      fprintf (stderr, "But check the correctedness of your data first.\n");
      exit (sig);
      break;
    case SIGXCPU:
      fprintf (stderr, "This program has a time limit?\n");
      fprintf (stderr, "We didn' program a time limit, so it is your or,\n");
      fprintf (stderr, "your system administrator's problem, to correct this.\n");
      exit (sig);
      break;
    case SIGXFSZ:
      fprintf (stderr, "This program has a file size limit?\n");
      fprintf (stderr, "We didn't program a file size limit, so it is your or,\n");
      fprintf (stderr, "your system administrator's problem, to correct this.\n");
      exit (sig);
      break;
    case SIGUSR1:
      fprintf (stderr, "\nUser signal received and ignored\n");
      fprintf (stderr, "\n\n");
      break;

#endif
    case SIGFPE:
      fprintf (stderr, "Floating point exception\n");
      fprintf (stderr, "Please report this bug!\n   (Peter Beerli, beerli@genetics.washington.edu)\n");
      fprintf (stderr, "There was an integer/floating point problem\n");
      fprintf (stderr, "Often this is a division by zero. If you dataset is moderately sized\n");
      fprintf (stderr, "this is most likely an error in you data (infile).\n");
      exit (sig);
      break;
    case SIGSEGV:
      fprintf (stderr, "Segmentation fault\n");
      fprintf (stderr, "Please report this bug!\n(Peter Beerli, beerli@genetics.washington.edu)\n");
      fprintf (stderr, "there was a segmentation fault, this results in an non recoverable crash\n");
      fprintf (stderr, "But check the correctedness of your data first.\n");
      exit (sig);
      break;
    case SIGILL:
      fprintf (stderr, "\nIllegal instruction!\n");
      fprintf (stderr, "this is maybe a programming error\n(Peter Beerli, beerli@genetics.washington.edu),\n but check the intput file\n");
      exit (sig);
      break;
    default:
      break;
    }
#ifndef __MWERKS__
  signal (SIGIOT, signalhandler);
  signal (SIGTRAP, signalhandler);
  signal (SIGUSR1, signalhandler);
  signal (SIGBUS, signalhandler);
#ifndef SYSTEM_V
  signal (SIGXCPU, signalhandler);
  signal (SIGXFSZ, signalhandler);
#endif
#endif
  signal (SIGFPE, signalhandler);
  signal (SIGSEGV, signalhandler);
  signal (SIGILL, signalhandler);

}

void 
sig_error (char string[], char filename[], long line)
{
  fprintf (stdout, "\nIn file %s on line %li\n%s\n", filename, line, string);
  exit (-11);
}


#ifdef NEXTAPP
void 
malloc_error_found (int value)
{
  switch (value)
    {
    case 0:
      fprintf (stderr, "vm_allocate failed\n");
      break;
    case 1:
      fprintf (stderr, "vm_deallocate failed\n");
      break;
    case 2:
      fprintf (stderr, "vm_copy failed\n");
      break;
    case 3:
      fprintf (stderr, "I tried to reallocate or free space which was already freed\n");
      break;
    case 4:
      fprintf (stderr, "Internal memory verification in heap failed\n");
      break;
    case 5:
      fprintf (stderr, "I tried to reallocate or free space which was never allocated\n");
      break;
    default:
      fprintf (stderr, "huh, what malloc error was this?\n");
      break;
    }
  errno = ENOMEM;
}
#endif


/* save memory routines, this routines are used
   with defines in migration.h, DO NOT move this part somewhere else */
#ifdef LAMARC_MALLOC
#undef malloc
#undef realloc
#undef calloc
#undef free

void *
LAMARC_malloc (const long size, const char file[], const long line)
{
  void *x;
  x = malloc (size);
  if (x == NULL)
    {
      fprintf (stderr, "ERROR in memory allocation (malloc(%li)) in file %s on line %li\n",
	       size, file, line);
      exit (-1);
    }
  return x;
}


void *
LAMARC_calloc (const long repeats, const long size, const char file[], const long line)
{
  void *x;
  x = calloc (repeats, size);
  if (x == NULL)
    {
      fprintf (stderr, "ERROR in memory allocation (calloc(%li,%li)) in file %s on line %li\n",
	       repeats, size, file, line);
      exit (-1);
    }
  return x;
}

void *
LAMARC_realloc (void *ptr, const long size, const char file[], const long line)
{
  void *x;
  x = realloc (ptr, size);
  if (x == NULL)
    {
      fprintf (stderr, "ERROR in memory allocation (realloc(ptr,%li)) in file %s on lin %li\n",
	       size, file, line);
      exit (-1);
    }
  return x;
}


#endif /*LAMARC_MALLOC */
