#ifndef TREE_INCLUDE
#define TREE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 T R E E B U I L D I N G   R O U T I N E S 

 
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: tree.h,v 1.1.1.1 1998/06/06 06:09:51 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void buildtree(world_fmt *world, long locus);
extern void create_treetimelist(world_fmt *world, timelist_fmt **ltl, long locus);
extern void fix_times(world_fmt * world);
extern void first_smooth(world_fmt *world, long locus);
extern void set_dirty(node * p);
extern void construct_tymelist(world_fmt *world, timelist_fmt *timevector);
extern void timeslices(timelist_fmt **timevector);
extern void add_partlineages(long numpop,timelist_fmt **timevector);
extern double treelikelihood(world_fmt *world);
extern double pseudotreelikelihood(world_fmt *world, proposal_fmt * proposal);
extern void set_pop(node * theNode, long pop, long actualpop);
extern void pseudonuview(proposal_fmt *proposal, xarray_fmt xx1, double *lx1, double v1, xarray_fmt xx2, double lx2, double v2);
extern void ltov(node * p);
extern void treeout(FILE *treefile, node * joint, node * p, long s);
extern void print_tree(world_fmt *world, long g, long *filepos);
#endif /*TREE_INCLUDE*/



