/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 P A R A M E T E R E S T I M A T I O N   R O U T I N E S 

 estimates parameter for each locus
 using a Broyden minimization
 

 Peter Beerli 1997, Seattle
 beerli@genetics.washington.edu
 $Id: broyden.h,v 1.5 1998/12/28 21:55:17 beerli Exp $
-------------------------------------------------------*/
extern long estimateParameter (timearchive_fmt * tyme, long G,
      world_fmt * world, double **dd, long chain, char type, char ***plane,
			       long kind);

extern void broyden (world_fmt * world, double **covariance, long numg, long chain, char type, char ***plane);

extern double absmaxvec (double *v, long n);
extern void create_nr (nr_fmt * nr, world_fmt * world, long G, long profile);
extern void reset_hess (double **hess, long n);
extern void destroy_nr (nr_fmt * nr, world_fmt * world);
extern double calc_like (nr_fmt * nr, double *param,
			 tarchive_fmt * atl, long G, long locus);
extern void calc_param (nr_fmt * nr, double *param, double lamda);
extern void param_all_adjust (nr_fmt * nr, boolean boolgamma);
extern void gradient (double *d, nr_fmt * nr);
extern void grad2loggrad (nr_fmt * nr, double *d, double PGC, long nn);
extern double probG (double *param, double *lparam, tarchive_fmt * tl, nr_fmt * nr);

extern double logprob_noevent (world_fmt * world, long interval);
extern double sum_migprob (world_fmt * world, long pop, long interval);
extern void calc_cov (double **dd, double *d, double *param, long n);

extern void calc_dv (double *dv, double **hess, double *gxv, long n);
extern double calc_line (nr_fmt * nr, double a, double b, double c,
			 double (*psi) (double, nr_fmt *));
extern void calc_hessian (double **hess, long n, double *delta, double *gamma);
extern double psi (double lamda, nr_fmt * nr);
extern void log_param0 (double *param, double *lparam,long nn);
extern void create_apg0 (double *apg0, nr_fmt * nr, timearchive_fmt * tyme);
extern void force_symmetric_d(long model, nr_fmt *nr, long nn);
extern void print_contribution (nr_fmt * nr, tarchive_fmt * tyme, long G);







