/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 D E R I V A T I V E S    R O U T I N E S 
 
 Peter Beerli 1997-98, Seattle
 beerli@genetics.washington.edu
 $Id: derivatives.c,v 1.5 1998/12/28 21:55:18 beerli Exp $
-------------------------------------------------------*/

#include "tools.h"
#include "broyden.h"
#include "combroyden.h"
#include "integrate.h"

#ifdef DMALLOC_FUNC_CHECK
#include "dmalloc.h"
#endif

extern double phi (double t, void *b);

void dt (nr_fmt * nr, timearchive_fmt * atl, long loci);
double dtintegral (double theta, void *b);
double dt_locus_gsum (long which, double x, double *param, nr_fmt * nr, timearchive_fmt * atl, long locus);


void
dt (nr_fmt * nr, timearchive_fmt * atl, long loci)
{
  double a = 0.0, /*SMALLEST_THETA */ b = 9999., d = 20.0, p = 0., eps = 10e-15;
  long m = 10000, inf = 2;
  long z = 0;
  helper_fmt helper;
  long locus, i, ii;
  double result, beta, alpha, theta1, denom;
  double **stemp, **temp;
  double tempmax = -DBL_MAX;
  helper.nr = nr;
  helper.atl = atl;

  temp = (double **) calloc (1, sizeof (double *) * (loci + 1));
  temp[0] = (double *) calloc (1, sizeof (double) * (loci + 1) * nr->partsize);
  stemp = (double **) calloc (1, sizeof (double *) * (loci + 1));
  stemp[0] = (double *) calloc (1, sizeof (double) * (loci + 1) * nr->partsize);
  for (locus = 1; locus < loci + 1; locus++)
    {
      temp[locus] = temp[0] + locus * nr->partsize;
      stemp[locus] = stemp[0] + locus * nr->partsize;
    }
  alpha = 1. / nr->param[nr->numpop2];
  theta1 = nr->param[0];
  beta = theta1 / alpha;
  denom = (lgamma (alpha) + log (beta) * alpha);
  helper.weight = -denom;
  for (locus = 1; locus < loci + 1; locus++)
    {
      if (nr->skiploci[locus - 1])
	continue;

      helper.locus = locus;
      z = 0;
      for (i = 0; i < nr->partsize; i++)
	{
	  if (nr->profilenum > 0)
	    {
	      if (i == nr->profiles[z])
		{
		  z++;
		  continue;	/*<-- profile variable do not need to calculate */
		}
	    }
	  helper.which = i;
	  result = 0.0;
	  a = SMALLEST_THETA;
	  b = 9999.;
	  d = 20.0;
	  p = 0.;
	  eps = 10e-10;
	  m = 10000;
	  inf = 2;
	  inthp (&a, &b, &d, dtintegral, &m, &p, &eps, &inf, (void *) (&helper), &result);
	  if (inf > 2)
	    {
	      printf ("ERROR: integration failed\n");
	      printf ("       df: which=%li, inf=%li, result=%f\n", i, inf, result);
	    }
	  /*      if(result< EPSILON && result > -EPSILON)
	     {
	     helper.weight = -denom - helper.ll;
	     helper.ll = - DBL_MAX;
	     inthp (&a, &b, &d, dtintegral, &m, &p, &eps, &inf, (void *) (&helper), &result);
	     if(result!=0)
	     {
	     temp[locus][i] = log (fabs (result)) 
	     - helper.weight - denom;
	     }
	     else
	     {
	     temp[locus][i] = -100000;
	     }
	     helper.weight = -denom;
	     }
	     else
	     { */
	  temp[locus][i] = log (fabs (result)) - nr->locilikes[locus];
	  /* } */
	  stemp[locus][i] = (result > 0.0 ? 1. : -1.);
	  //temp[locus][i] = result;
	  if (tempmax < temp[locus][i])
	    tempmax = temp[locus][i];
	}
    }

  for (i = 0, z = 0; i < nr->partsize - nr->profilenum; i++)
    {
      ii = (nr->profilenum > 0) ? nr->indeks[z++] : i;
      for (locus = 1; locus < loci + 1; locus++)
	{
	  //nr->d[i] += temp[locus][ii];
	  nr->d[i] += exp (temp[locus][ii] - tempmax) * stemp[locus][ii];
	}
      nr->d[i] = (nr->d[i] > 0 ? 1. : -1.) * exp (log (fabs (nr->d[i])) + tempmax);
    }

  free (temp[0]);
  free (temp);
  free (stemp[0]);
  free (stemp);
}


double
dtintegral (double theta, void *b)
{
  double ll;
  long locus;
  helper_fmt helper;
  double *param;
  double theta1, alpha;

  helper = *(helper_fmt *) b;
  locus = (long) helper.locus;


  param = (double *) calloc (1, sizeof (double) * helper.nr->partsize);
  set_gamma_param (param, helper.nr->param, theta, helper.nr);
  helper.param = param;
  alpha = 1. / helper.nr->param[helper.nr->numpop2];
  theta1 = helper.nr->param[0];
  ll = calc_like (helper.nr, param, helper.atl[locus].tl,
		  helper.atl[locus].T, locus);
  ll = exp (-theta /
	(theta1 / alpha) + log (theta) * (alpha - 1.) + ll + helper.weight);
  if (helper.which == 0)
    {
      ll *= (alpha / (theta1 * theta1) * (theta - theta1) +
	     dt_locus_gsum (helper.which, theta, helper.nr->param,
			    helper.nr, &helper.atl[locus], locus));
    }
  else
    {
      if (helper.which == helper.nr->numpop2)
	{
	  ll *= (1. - theta / theta1 - log (theta1 / alpha) +
		 log (theta) - polygamma (0, alpha));
	}
      else
	{
	  ll *= dt_locus_gsum (helper.which, theta, helper.nr->param,
			       helper.nr, &helper.atl[locus], locus);
	}

    }
  free (param);
  return ll;
}

double
dt_locus_gsum (long which, double x, double *param, nr_fmt * nr,
	       timearchive_fmt * atl, long locus)
{
  long g, offset2;

  long pop, i, j;
  double expapg, summ;
  double sum = 0.0;
  tarchive_fmt *tl = atl->tl;
  double part, df = 0.0;
  double value = param[which];
  double theta1 = param[0];
  long r;
  pop = (which - nr->numpop) / (nr->numpop - 1);
  if (which < nr->numpop)
    {
      for (g = 0; g < atl->T; g++)
	{
	  if (nr->apg[g] > -100.)
	    {
	      if (which == 0)
		{
		  part = 0.0;
		  for (i = 0; i < nr->numpop; i++)
		    {
		      summ = 0;
		      for (j = nr->numpop + i * (nr->numpop - 1);
			   j < nr->numpop + (i + 1) * (nr->numpop - 1); j++)
			{
			  summ += param[j];
			}
		      part -= summ * tl[g].km[i] / x;

		      if (i != 0)
			{
			  part += ((double) tl[g].p[i]) / theta1
			    - tl[g].kt[i] / (param[i] * x);
			}
		      for (j = i * nr->numpop; j < (i + 1) * nr->numpop; j++)
			{
			  part += tl[g].l[j] / theta1;
			}
		    }
		}
	      else
		{
		  part = -((double) tl[g].p[which]) / value +
		    tl[g].kt[which] * theta1 / (value * value * x);
		}
	      expapg = tl[g].copies * exp (nr->apg[g]);
	      sum += expapg;
	      df += expapg * part;
	    }
	}
    }
  else
    {
      r = (which - nr->numpop) % (nr->numpop - 1);
      offset2 = pop * nr->numpop + r + (r >= pop ? 1. : 0.);
      for (g = 0; g < atl->T; g++)
	{
	  if (nr->apg[g] > -100)
	    {
	      part = ((double) tl[g].l[offset2]) / value - theta1 * tl[g].km[pop] / x;
	      expapg = tl[g].copies * exp (nr->apg[g]);
	      df += expapg * part;
	      sum += expapg;
	    }
	}
    }
  //  printf("which=%li df=%f sum=%f = %f\n",which,df,sum,df/sum);
  return df / sum;
}








