/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 M A I N   P R O G R A M 

 drives the whole program MIGRATE.

 for options of the program: README and parmfile.distrib, 
                             options.c
 
 Theta(1)=4 N(1)mu, Theta(2)=4 N(2)mu,
 M(1) = m(1)/mu, and M(2)= m(2)/mu
                                                                                                               
 Peter Beerli 1997, Seattle
 beerli@genetics.washington.edu
 $Id: main.c,v 1.11 1999/05/04 21:49:17 beerli Exp $
-------------------------------------------------------*/


#include "migration.h"
#include "world.h"
#include "data.h"
#include "options.h"
#include "mcmc.h"
#include "broyden.h"
#include "combroyden.h"
#include "menu.h"
#include "sequence.h"
#include "tree.h"
#include "tools.h"
#include "profile.h"

#ifdef DMALLOC_FUNC_CHECK
#include "dmalloc.h"
#endif

char appl[8];
longer seed;

/*--------------------------------------------
   main program 


*/
int
main (int argc, char **argv)
{
  long locus, i, j, accepted, G = 1, increment, outfilepos, treefilepos;
  long step, steps, oldsteps, chain, chains, runs;
  char type;
  char *this_string;
  data_fmt *data;
  world_fmt *world;
  option_fmt *options;
  this_string = (char *) calloc (1, sizeof (char) * 256);
  strcpy (appl, "Migrate");
  /* try to catch and beautify some error messages -------------- */
  signalhandling (ON);
  /* create main data structures -------------------------------- */
  create_data (&data);
  create_world (&world);
  create_options (&options);
  /* parmfile and menu ------------------------------------------ */
  init_options (options);
  get_options (options);
  print_menu_title (options);
  get_menu (options);
  /* initialization and data reading phase ---------------------- */
  init_files (world, data, options);
  /* run the mcmc sampler --------------------------------------- */
  if (!options->readsum)
    {
      get_data (data->infile, data, options);
      init_world (world, data, options);
      set_plot(options);
      calc_simple_param (world);
      /* report to screen */
      print_menu_options (options, world);
      print_data_summary (stdout, world);
      /* print to outfile*/
      outfilepos = print_title (world);
      print_options (world->outfile, options, world);
      print_data_summary (world->outfile, world);
      print_data (world, data, options);
      /* loop over all loci ------------------------------------ */
      for (locus = 0; locus < data->loci; locus++)
	{
	  world->locus = locus;
	  set_param (world, data, options, locus);
	  print_menu_locus (options, locus);
	  type = 's';
	  runs = 1;
	  buildtree (world, locus);
              /*  if (strchr(SEQUENCETYPES, options->datatype))
	    {
	      print_seqfreqs (world->outfile, world);
	      print_tbl (world->outfile, world, locus);
	      print_weights (world->outfile, world, locus);
              }*/
	  if(strchr(SNPTYPES, options->datatype))
          {
              if(options->datatype=='u')
                  data->seq->endsite *= (data->seq->addon+1);
              data->seq->endsite += data->seq->addon;
          }
	  free_datapart (data, options, locus);
	  if (data->skiploci[locus])
	    {			/* skip loci with no tips */
	      cleanup_world (world, locus);
	      continue;
	    }
	  create_treetimelist (world, &world->treetimes, locus);
	  fix_times (world);
	  first_smooth (world, locus);
	  world->likelihood[0] = treelikelihood (world);
	  world->allikemax = -DBL_MAX;	/* for best tree option */
	  /* short and long chains ---------------------------- */
	  set_bounds (&increment, &oldsteps, &chains, options, type);
	  world->increment = increment;
	  heating_ratio(world);
	  while (runs-- >= 0)
	    {
	      print_menu_chain (type, FIRSTCHAIN, oldsteps, world);
	      if (world->options->treeprint == ALL)
		print_tree (world, 0, &treefilepos);
	      for (chain = 0; chain < chains ||
		   (type == 'l' && chain >= chains
		    && world->param_like > options->lcepsilon); chain++)
		{
		  memset (world->likelihood + 1, 0,
			  sizeof (double) * (world->atl[0].allocT - 1));
		  burnin_chain (world);		/*removes start conditions */
		  G = 1;
		  accepted = 0;
		  steps = oldsteps;
		  world->maxdatallike = world->likelihood[0];
		  if ((type == 'l') && (chain == chains - 1))
		    {
		      world->in_last_chain = TRUE;
		    }
		  /* steps for each chain ------------------------ */
		  for (step = 0; step < steps + 1; step++)
		    {
		      j = 0;
		      world->increment = increment;
		      /* hop over INCREMENT trees, and sample only last */
		      for (i = 0; i < increment; i++)
			{
			  world->actualinc = i;
			  j += metropolize (world, G - 1);

			  if (world->likelihood[G - 1] > world->maxdatallike)
			    {
			      world->maxdatallike = world->likelihood[G - 1];
			    }
			}
		      /* store condensed tree information for estimation */
		      if (step == 0)
			{
			  copy_time (world, world->treetimes,
				     FIRSTSTEP, 0, world->numpop);
			  accepted += j;
			}
		      else
			{
			  copy_time (world, world->treetimes, G - 1,
				     G - 1 + (long) (j > 0), world->numpop);
			  if (step < steps)
			    {
			      G += (long) (j > 0);
			      accepted += j;
			    }
			}
		      if (step >= oldsteps - 1 && options->movingsteps)
			{
			  if (G < options->acceptfreq * oldsteps)
			    {
			      steps++;
			    }
			}
		    }
		  /*estimate locus-parameters */
		  decide_plot (options, chain, chains, type);
		  memcpy (world->param00, world->param0, 
			  sizeof (double) * world->numpop2);
		  memcpy (world->atl[0].param0, world->param00, 
			  sizeof (double) * world->numpop2);
		  log_param0 (world->atl[0].param0,
			      world->atl[0].lparam0, world->numpop2);
		  estimateParameter (&world->atl[0], G, world, 
				     world->cov[locus], chain,
				     type, world->plane[locus],SINGLELOCUS);
		  world->likelihood[0] = world->likelihood[G - 1];
		  world->treetimes[0].copies = 0;
		  if (options->progress)
		    {
		      print_menu_coalnodes (world, G);
		      print_menu_accratio (accepted, steps * increment);
		    }
		}
	      /* switch to LONG chains
	         and reset stopping criteria if we have set
	         OPTIONS->LCEPSILON */
	      if (type == 's')
		{
		  type = 'l';
		  create_treetimelist (world, &world->treetimes, locus);
		  set_bounds (&increment, &oldsteps, &chains, options, type);
		  world->increment = increment;
		  heating_ratio(world);
		}
	      if (runs < 0)
		{
		  if (type == 'l' && world->param_like > LONGCHAINEPSILON)
		    {
		      runs++;
		      continue;
		    }
		  copy_atl (world, &world->atl[0],
			    &world->atl[locus + 1],
			    world->atl[0].T /*G-1 */ );
		}
	    }
	  cleanup_world (world, locus);
	}
      /* save all genealogy-summaries --------------------------- */
      if (options->writesum)
	{
	  write_savesum (world);
	}
    }				
  /* end of mcmc sampling ----------------------------------- */
  else
    {				
      /* read saved genealogy summaries back -------------------- */
      read_savesum (world, options, data);
      synchronize_param (world, options);
      if(options->plot)
	options->plotnow=TRUE;
      set_plot(options);
      outfilepos = print_title (world);
      print_options (stdout, options, world);
      print_options(world->outfile, options, world);
    }
  /* multiple loci combination ---------------------------------- */
  if ((world->loci - world->skipped > 1) || (options->readsum))
    {
      //combine_loci (world);
      estimateParameter (world->atl, 0,
			 world, world->cov[world->loci], 0, ' ', 
			 world->plane[world->loci], MULTILOCUS);
    }
  /* printing of data ------------------------------------------- */
  print_list (world);
  fflush (world->outfile);
  if (options->profile != NONE)
    {
      PAGEFEEDWORLD;
      if (options->printprofsummary)
	allocate_profile_percentiles (world);
#ifdef HAVE_STRFTIME
      time (&world->starttime);
#endif
      for (i = 0; i < world->numpop2 + (world->options->gamma ? 1 : 0); i++)
	{
	  if(print_profile_likelihood_driver (i, world))
	    {
	      if ((i + 1) % 2 == 0)
		PAGEFEEDWORLD;
	      fflush (world->outfile);
	    }
	}
      PAGEFEEDWORLD;
      if (options->printprofsummary)
	{
	  print_profile_percentile (world);
	  destroy_profile_percentiles (world);
	}
    }

  /* closing all files ------------------------------------------ */
  print_finish (world, outfilepos);
#ifdef MAC
  fixmacfile (options->outfilename);
  if (options->plotmethod == PLOTALL)
    fixmacfile (options->mathfilename);
  if (options->treeprint)
    fixmacfile (options->treefilename);
#endif
  exit_files (world, data, options);
  return 0;
}
