#ifndef WORLD_INCLUDE
#define WORLD_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 W O R L D   R O U T I N E S 

 creates tree structures,
 calculates smple parameter estimates (FST,...)
 reads tree [has to be done]
 
 prints results,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: world.h,v 1.2 1998/09/28 23:14:52 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void create_world (world_fmt ** world);
extern void init_world (world_fmt * world, data_fmt * data, option_fmt * options);
extern void increase_timearchive (world_fmt * world, long locus, long sample, long numpop);

extern void calc_simple_param (world_fmt * world);
extern void set_bounds (long *increment, long *steps, long *chains,
			const option_fmt * options, const char type);
extern void print_menu_locus (option_fmt * options, long locus);
extern void print_menu_chain (char type, long chain, long steps, world_fmt * world);
extern void print_menu_coalnodes (world_fmt * world, long G);
extern void heating_ratio(world_fmt *world);
extern void burnin_chain (world_fmt * world);
extern void print_finish (world_fmt * world, long filepos);
extern void copy_time (world_fmt * world, timelist_fmt * ltl, long from, long to, long np);
void copy_atl (world_fmt * world, timearchive_fmt * old, timearchive_fmt * new, long steps);
extern void create_loci_plot (world_fmt * world, char ***plane, timearchive_fmt * atl, long loci);
extern void create_locus_plot (world_fmt * world, char ***plane, tarchive_fmt * tl, nr_fmt * nr, long G);
extern void print_simresults (world_fmt * world);
extern void print_list (world_fmt * world);
extern void cleanup_world (world_fmt * world, long locus);
extern void apocalypse_now (world_fmt * world);
extern void test_locus_like (nr_fmt * nr, double *param0, double *param1, long df, long locus, world_fmt * world,
			     long *maxwhich, long maxnum,boolean withhead, char *this_string);
extern void test_loci_like (nr_fmt * nr, double *param0, double *param1, long df, long loci, world_fmt * world,
			    long *maxwhich, long maxnum,boolean withhead, char *this_string);


#endif /*WORLD_INCLUDE */
