#ifndef COMBRO_INCLUDE
#define COMBRO_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice world size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 C O M B I N E   L O C I   R O U T I N E S 

 

 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: combroyden.h,v 1.9 2000/07/26 23:03:20 beerli Exp $

-------------------------------------------------------*/

#include "migration.h"

extern long estimateParameter (long rep, long G,
			       world_fmt * world, double **dd, long chain,
			       char type, char ***plane, long kind, long repkind);

extern double calc_loci_like (helper_fmt *helper, 
			      boolean multilocus, boolean boolgamma);
extern void calc_gamma (nr_fmt * nr);
extern void calc_apgg (double thetax, double **apgg,
		       nr_fmt * nr, timearchive_fmt * atl, long which);
extern void set_gamma_param (double *paramn, double *paramo, double theta,
			     nr_fmt * nr);
extern long broyden_driver (timearchive_fmt ** tyme, long loci,
			    world_fmt * world, double **covariance,
			    char ***plane, long *profiles, double *value,
			    long profilenum, double *profparam,
			    double *proflike, double *profnorm, 
			    long kind, long rep, long repkind);
extern void calc_apg0 (double *apg0, nr_fmt * nr, timearchive_fmt * tyme,
		       double thetax, double theta1);


extern void calc_loci_param (nr_fmt * nr, double *param, double lamda,
			     boolean boolgamma);

extern void which_calc_like(long repkind);
extern double (*calc_like) (nr_fmt *, double *, long);

#endif /* COMBINE_INCLUDE */





