#ifndef MIGRATION_HEADER	/*migration.h */
#define MIGRATION_HEADER

#include "definitions.h"
/*-----------------------------------------------------------------
  Maximum likelihood estimation of migration rates 
  using coalescent trees

  Peter Beerli
  Genetics 357360
  University of Washington
  Seattle, WA 98195-7360, USA
  beerli@genetics.washington.edu
 
  With help of Joe Felsenstein (joe@agenetics.washington.edu),
  Mary Kuhner and Jon Yamato (mkkuhner@genetics.washington.edu)

  *----------------------------------------------------------------
 
  Time, 'tyme', in this tree is measured from the tips to the root.
  I.e. the tips are at tyme '0', and the root node has the largest
  value for 'tyme'. 
  

  */

typedef char allele_type[DEFAULT_ALLELENMLENGTH];

typedef double sitelike[4];
typedef sitelike *ratelike;
typedef ratelike *phenotype;

typedef double contribarr[MAXCATEGS];
typedef short val[MAXCATEGS];

typedef char allele_fmt[DEFAULT_ALLELENMLENGTH];

typedef struct lr_data_fmt
{
  short type;
  long elem;
  char *value;
}
lr_data_fmt;

typedef struct lratio_fmt
{
  long alloccounter;
  long counter;
  lr_data_fmt *data;
}
lratio_fmt;

typedef struct valrec
{
  double rat, ratxi, ratxv, zz, z1, y1, ww1, zz1, ww2, zz2, z1zz, z1yy,
    xiz1, xiy1xv, ww1zz1, vv1zz1, ww2zz2, vv2zz2;
}
valrec;

typedef valrec ***tbl_fmt;

typedef union xarray_fmt
{
  double *a;
  phenotype s;
}
xarray_fmt;

typedef struct seqmodel_fmt
{
  double freqa, freqt, freqg, freqc;
  double freqr, freqy;
  double freqar, freqcy, freqgr, freqty;
  double aa, bb;
  long endsite;
  double xi, xv, ttratio, fracchange;
  long *sites;
  tbl_fmt tbl;
  long *alias;
  long *ally;
  long *category;
  short *weight;
  long weightsum;
  long *aliasweight;
  long *location;
  double **term;
  double **slopeterm;
  double **curveterm;
  val *mp;
  contribarr *contribution;
  contribarr like;
  contribarr nulike;
  contribarr clai;
  long addon;


}
seqmodel_fmt;

/* defines the data structure read from infile */
typedef struct _data
{
  FILE *infile;
  FILE *utreefile;
  FILE *weightfile;
  FILE *catfile;
  FILE *sumfile;
  FILE *distfile;
  FILE *geofile;
  char *****yy;
  double *geo;
  double *lgeo;
  double **ogeo;
  allele_fmt **allele;
  long *maxalleles;
  boolean *skiploci;
  char **popnames;
  long **numind;
  char ***indnames;
  long numpop;
  long loci;
  seqmodel_fmt *seq;
  double freq;
  double freqlast;
  char dlm;
  boolean hasghost;
}
data_fmt;

typedef long twin_fmt[2];

typedef long quad_fmt[4];

typedef struct _option
{
  FILE *parmfile;
  FILE *seedfile;
  FILE *logfile;
  /*general options */
  long nmlength;		/* length of individual names */
  long popnmlength;		/* length of population names */
  long allelenmlength;		/* length of allele names */
  char *custm;
  char *custm2;
  long zeron;
  long *zeroparam;
  long constn;
  long *constparam;
  long symn;
  long sym2n;

  twin_fmt *symparam;
  quad_fmt *sym2param;
  long mmn;
  long *mmparam;
  /*input/output options */
  int menu;
  boolean progress;
  boolean verbose;
  boolean writelog;
  boolean movingsteps;
  double acceptfreq;
  boolean printdata;
  boolean usertree;
  boolean randomtree;
  short treeprint;
  boolean plot;
  boolean plotnow;
  short plotmethod;
  short plotvar;
  short plotscale;
  double plotrange[4];
  long plotintervals;
  double *plotxvalues;
  double *plotyvalues;
  boolean simulation;
  boolean mighist;
  boolean mixplot;
  boolean dist;
  boolean geo;
  char infilename[256];
  char outfilename[256];
  char logfilename[256];
  char mathfilename[256];
  char treefilename[256];
  char utreefilename[256];
  char catfilename[256];
  char weightfilename[256];
  char sumfilename[256];
  char mighistfilename[256];
  char distfilename[256];
  char geofilename[256];
  char bootfilename[256];
  char title[LINESIZE+1];
  lratio_fmt *lratio;
  long fsttype;
  boolean printfst;
  short profile;
  char profilemethod;
  long df;
  boolean qdprofile;
  boolean printprofsummary;
  boolean printprofile;
  short profileparamtype;

  /* data options */
  char datatype;
  short migration_model;
  char dlm;
  long micro_stepnum;
  long micro_threshold;
  double **steps;
  boolean interleaved;
  double *ttratio;
  boolean freqsfrom;
  long categs;
  double *rate;
  long rcategs;
  double *rrate;
  double *probcat;
  double probsum;
  boolean gammarates;
  boolean autocorr;
  double lambda;
  boolean weights;
  double freqa;
  double freqc;
  double freqg;
  double freqt;
  /* random number options */
  short autoseed;
  long inseed;
  long saveseed;
  /* mcmc options */
  short thetaguess;
  short migrguess;
  boolean gamma;
  long burn_in;
  short heating;
  double *thetag;
  long numthetag;
  double *mg;
  long nummg;
  long schains;
  long sincrement;
  long ssteps;
  long lchains;
  long lincrement;
  long lsteps;
  double lcepsilon;
  boolean gelman;
  long pluschain;//how many chains are allowed , currently HARDCODED
  boolean replicate;
  long replicatenum;
  long gridpoints;
  long numpop;
  double heat[4];
  /* save genealogy summary options */
  boolean readsum;
  boolean writesum;
  /* threading over loci*/
  int cpu;
}
option_fmt;


/* used in the tree structure */
typedef struct _node
{
  struct _node *next, *back;
  boolean tip;
  char type;
  long number;
  long pop;
  long actualpop;
  long id;
  xarray_fmt x;
  double *s;
  double lxmax;
  char *nayme;
  boolean top;
  boolean dirty;
  double v, tyme, length, xcoord;
  short ycoord, ymin, ymax;
}
node;

typedef struct vtlist
{
  node *eventnode;		/* node with age=tyme */
  double age;			/* tyme from top nodelet */
  double interval;		/* interval t[i+1].age - t[i].age */
  long *lineages;
  long from;
  long to;
  /*  long pop; */
  long slice;
}
vtlist;

typedef struct tree_fmt
{
  node **nodep;
  node *root;
  long pop;
  long tips;
}
tree_fmt;

typedef struct timelist_fmt
{
  long numpop;
  long copies;
  long allocT;
  long T;
  long oldT;
  vtlist *tl;
}
timelist_fmt;

typedef struct tarchive_fmt
{
  long copies;
  double *km;
  double *kt;
  long *p;
  double *mindex;
}
tarchive_fmt;

typedef struct timearchive_fmt
{
  long allocT;
  long T;
  long numpop;
  long sumtips;
  double param_like;
  double thb;
  double alpha;
  tarchive_fmt *tl;
  double *param;
  double *param0;
  double *lparam0;
  double *likelihood;
  long trials;
  double normd;
}
timearchive_fmt;

typedef struct _plotmax
{
  double x1;
  double y1;
  double l1;
  double x2;
  double y2;
  double l2;
}
plotmax_fmt;

typedef struct _quantile_fmt
{
  char *name;
  double *param;
}
quantile_fmt;

typedef double migevent_fmt[3];

typedef struct _mighist_fmt
{
  migevent_fmt *migevents;
  long migeventsize;
  long copies;
  double weight;
}
mighist_fmt;

typedef struct _mighistloci_fmt
{
  mighist_fmt *mighist;
  long mighistnum;
}
mighistloci_fmt;

typedef struct _world
{
  /* generalities */
  char *name;
  char *worldname;
  option_fmt *options;
  data_fmt *data;
  long loci;
  long skipped;			/*loci with no data */
  long locus;			/* the current locus, if single then set to 0 */
  long thislocus;               /* the real current locus, the whole locus scheme 
                                   needs revision*/
  long numpop;
  long numpop2;
  long sumtips;
  /* migration parameter array  starts and ends */
  int *mstart;
  int *mend;

  /* time archives, contains the data/results for summarizing */
  timearchive_fmt **atl;

  /* migration histogram reporter */
  mighistloci_fmt *mighistloci;
  long mighistlocinum;

  /*tree material */
  node **nodep;
  node *root;
  long unique_id;

  /* parameter */
  double *param0;
  double *param00;
  double **fstparam;

  /* mcmc related */
  long *lineages;
  timelist_fmt *treetimes;
  double *mig0list;
  long *design0list;


  /*heating scheme */
  long actualinc;
  long increment;
  double heatratio;
  double *heat;
  /* reporting time */
  time_t starttime;
  long treesdone;
  long treestotal;

  /* gelman R reporting/checking "gelman-convergence option" */
  double gelmanmeanR;
  double gelmanmaxR;
  long chains;
  boolean start;		//I need this in estimateParameter() 
  /* reporting */
  double *likelihood;           /* data likelihoods */
  long numlike;                 /* how many likelihoods maximally are stored*/
  plotmax_fmt **plotmax;
  quantile_fmt *quantiles;
  double maxdatallike;		/* the maximum log likelihood of a chain */
  double allikemax;		/* the maximum log likelihood  the best tree */
  boolean in_last_chain;	/*for last CHAIN option in print-tree */
  double param_like;            /* current parameter likelihood [=current chain]*/
  double **chainlikes;           /* parameter likelihood of replicate/last chains all loci*/
  long trials;
  double normd;
  long repkind;
  long rep;// defines single cahin estimators
  long replicate; //holdss the replicate we are in
  long repstop;
  long lsteps;
  double ***cov;
  long migration_counts;
  char ****plane;

  long accept;
  long G;

  FILE *outfile;
  FILE *treefile;
  FILE *mathfile;
  FILE *mighistfile;
  FILE *bootfile;
}
world_fmt;




typedef struct _nr_fmt
{
  long partsize;		/*number of part-variables, fixed per model */
  double *parts;		/* parts of the first and second derivatives */
  double *d;			/* first derivates */
  /* migration parameter array  starts and ends */
  int *mstart;			//link to world->mstart
  int *mend;			//link to world->mend
  long repkind;
  long repstart;
  long repstop;
  //  long numg;
  double *dv;
  double *gdelta;
  double *od;
  double *delta;
  timearchive_fmt **atl;
  world_fmt *world;
  double **dd;			/* second derivatives */
  double *param;		/* changed values of param */
  double *oparam;		/* saved old parameters */
  double llike;			/* parameter LOGlikelihood */
  double lastllike;		/* parameter LOGlikelihood */
  double ollike;		/* old "   " */
  double *datalike;		/*P(D|G) */
  double *locilikes;
  double ***apg0;		/* part-loglikelihoods of param0 */
  double **apg;			/* part-loglikelihoods of param */
  double apg_max;		/* maxvalue of apg */
  double *gamma;
  long gammaI;
  double alpha;
  long numpop;			/* number of populations */
  long numpop2;			/* 2*numpop */
  double PGC;			/* uncorrected llike */
  double oPGC;			/* uncorrected ollike */
  long copy_nr;			/* number of genealogies */
  boolean *skiploci;
  long profilenum;		/* number of profile parameters */
  long *profiles;		/* which profile parameters */
  long *indeks;			/* which noprofile parameters */
}
nr_fmt;


typedef struct helper_fmt
{
  long locus;
  nr_fmt *nr;
  timearchive_fmt **atl;
  double *param;
  long which;
  double weight;
  double ll;
  boolean multilocus;
  boolean boolgamma;
}
helper_fmt;



typedef struct _migr_table_fmt
{
  long from;
  long to;
  double time;
}
migr_table_fmt;

typedef struct proposal_fmt
{
  world_fmt *world;
  boolean mig_removed;
  char datatype;
  short migration_model;
  long sumtips;
  long numpop;
  long endsite;
  double fracchange;
  double *param0;
  double rr;
  node *root;
  node *origin;
  node *target;
  node *realtarget;
  node *tsister;
  node *realtsister;
  node *osister;
  node *realosister;
  node *ocousin;
  node *realocousin;
  node *oback;
  node *realoback;
  node **line_f;
  node **line_t;
  node *connect;
  double likelihood;
  double time;
  double v;
  double vs;
  xarray_fmt xt;
  xarray_fmt xf;
  double mf;
  double mt;
  node **aboveorigin;
  node **bordernodes;
  long listsize;
  migr_table_fmt *migr_table;
  migr_table_fmt *migr_table2;
  long migr_table_counter;
  long migr_table_counter2;
  long old_migr_table_counter;
  long old_migr_table_counter2;
  long timeslice;
  double *mig0list;
  long *design0list;

}
proposal_fmt;

typedef struct spline_fmt
{
  long ntab;
  long nwork;
  double *param;
  double *like;
  double *diff;
  double *diff2;
  long *constr;
  long *diagn;
  double *work;
}
spline_fmt;


typedef struct locusdata_fmt
{
  long locus;
  world_fmt **universe;
  option_fmt *options;
  data_fmt *data;
} locusdata_fmt;


/* here a some definitions which should be remove in a future version
   (a) FLOC : place holder for first locus strcuture should finally deal
   with different number of individuals per locus */
#define FLOC 0


/* global variables (this should be not used at all) */
extern char appl[8];

#ifdef HIGHBITS
typedef long longer[3];		/* used in random.c */
extern long seed[3];
#else
typedef long longer[6];
extern long seed[6];
#endif

#include "tools.h"
#include "sort.h"
#endif
