/* part of migrate
   Peter Beerli 2000 Seattle
   $Id: derivatives2.c,v 1.1 2000/07/26 23:08:47 beerli Exp $
*/
#include "migration.h"
#include "combroyden.h"
#include "integrate.h"

extern double probG (double *param, double *lparam, tarchive_fmt * tl,
		     nr_fmt * nr);

extern double phi (double t, void *b);

extern double dtintegral (double theta, void *b);

void fill_helper(helper_fmt *helper, world_fmt *world, nr_fmt *nr, 
		 boolean multilocus, boolean boolgamma);
double calc_gammalocilike(world_fmt *world, helper_fmt *helper);
void fill_helper_denom(helper_fmt *helper);
double calc_single_gammalike(helper_fmt *helper);


void fill_helper(helper_fmt *helper, world_fmt *world, nr_fmt *nr,
		 boolean multilocus, boolean boolgamma)
{
  double alpha =0;
  double theta1 = nr->param[0];
  double denom =0;
  if(boolgamma)
    {
      alpha = 1./nr->param[nr->numpop2];
      denom = LGAMMA (alpha) + log (theta1 / alpha) * alpha;
    }
  helper->nr = nr;
  helper->ll = -DBL_MAX;
  helper->weight = -denom;
  helper->atl = world->atl;
  helper->multilocus=multilocus;
  helper->boolgamma = boolgamma;

}

void fill_helper_denom(helper_fmt *helper)
{
  double alpha = 0;
  double theta1 = helper->nr->param[0];
  if(helper->boolgamma)
    {
      alpha = 1./helper->nr->param[helper->nr->numpop2];
      helper->weight = -(LGAMMA (alpha) + log (theta1 / alpha) * alpha);
    }
}

double calc_gammalocilike(world_fmt *world, helper_fmt *helper)
{
  long locus;
  double like=0;
  for(locus=0;locus<world->loci;locus++)
    {
      helper->locus = locus;
      helper->nr->locilikes[locus] = calc_single_gammalike(helper);
      like += helper->nr->locilikes[locus];
    }
  printf("%f\n",like);
  return like;
}


double calc_single_gammalike(helper_fmt *helper)
{
  double result;
  double a=DBL_EPSILON;
  double b = 9999.0;
  double d = 20.0;
  long m = 10000;
  double p = 0.0;
  double eps = SMALLEPSILON;
  long inf=2; 
  inthp (&a, &b, &d, phi, &m, &p, &eps, &inf,
  	 (void *) helper, &result);
  //diff=2.;
  //total = 0;
  //oldtotal=1;
  //ntotal=0;
  //while (fabs(total/ntotal-oldtotal)> EPSILON * 10.)
  //  {
  //    oldtotal=total/ntotal;
  //    diff /= 2.;
  //for(i=-10; i<=10.;i+= 0.01)
  //  {
  //    total += rect*phi(exp(i),helper);
  //    ntotal++;
  //  }
  //  fprintf(stdout,"approx=%f, integral=%f\n",log(total/ntotal), log(result));
  //  }
  //return log(total);
  if (result > 0.0)
    {
      helper->nr->llike = log(result);
      return helper->nr->llike;
    }
  else
    {
      helper->nr->llike = -DBL_MAX;
      return  -DBL_MAX;
    }
}



void dt2(helper_fmt *helper)
{
  long locus, g, z, i, ii, m, r, inf;
  //  double denom,alpha, theta1, theta, beta;
  double result, a,b,d,p,eps;
  double *lparam;
  //  double *param;
  double **temp;
  double *apg0;
  nr_fmt *nr;
  nr = helper->nr;
  temp = (double **) calloc (1, sizeof (double *) * (nr->world->loci + 1));
  temp[0] = (double *) calloc (1, sizeof (double) * (nr->world->loci + 1) * nr->partsize);
  // param = (double *) calloc (1, sizeof (double) * nr->partsize);
  for (locus = 1; locus < nr->world->loci+1; locus++)
    {
      temp[locus] = temp[0] + locus * nr->partsize;
    }

  lparam = (double *) calloc (1, sizeof (double) * nr->numpop2);
  for (g = 0; g < nr->numpop2; g++)
    lparam[g] = log (nr->param[g]);

  //alpha = nr->param[nr->numpop2];
  //theta1 = nr->param[0];
  //beta = theta1 / alpha;
  //denom = (LGAMMA (alpha) + log (beta) * alpha);
  //helper->weight = -denom;
  for (locus = 0; locus < nr->world->loci; locus++)
    {
      if (nr->skiploci[locus])
	continue;
      helper->locus = locus;
      nr->apg_max = -DBL_MAX;
      for(r=nr->repstart;r<nr->repstop;r++)
	{
	  apg0 = nr->apg0[r][locus];
	  for (g = 0; g < nr->atl[r][locus].T; g++)
	    {
	      //gsum += nr->atl[r][locus].tl[g].copies;
	      nr->apg[r][g] = probG (nr->param, lparam, &(nr->atl[r][locus].tl[g]), nr) 
		- apg0[g];
	      if (nr->apg[r][g] > nr->apg_max)
		nr->apg_max = nr->apg[r][g];
	    }
	}
      z = 0;
      for (i = 0; i < nr->partsize; i++)
	{
	  if (nr->profilenum > 0)
	    {
	      if (i == nr->profiles[z])
		{
		  z++;
		  continue; /*<-- profile variable do not need to calculate */
		}
	    }
	  helper->which = i;
	  result = 0.0;	  a = 0.0;//SMALLEPSILON ;	  
	  b = 9999.;
	  d = 20.0;	  p = 0.;	  eps = SMALLEPSILON;
	  m = 10000;	  inf = 2;
	  inthp (&a, &b, &d, dtintegral, &m, &p, &eps, &inf,
	  	 (void *) (helper), &result);
	  temp[locus][i] = result / exp(helper->nr->locilikes[locus]);
	}
    }
  for (i = 0, z = 0; i < nr->partsize - nr->profilenum; i++)
    {
      ii = (nr->profilenum > 0) ? nr->indeks[z++] : i;
      for (locus = 0; locus < nr->world->loci; locus++)
	{
	  nr->d[i] += temp[locus][ii];
	}
    }
  //printf("\nd[0]=%10.10f, d[1]=%10.10f\n",nr->d[0],nr->d[nr->numpop2]);

  //free(param);
  free (temp[0]);
  free (temp);
}




