/* Joint chain estimator
Peter Beerli January 2000
$Id: joint-chains.c,v 1.10 2001/03/09 16:29:18 beerli Exp $

like(param) = Sum_g^G   ( p(g|param)/ L(param_j))

denom = Sum_j^chains (n_j P(g|param0_j) / L(param_j)

- pick param
- calc chainparamlike
- solve paramlike iteratively
- maximize paramlike

coaliter
    thetaval -> lthetai at theti[locus][lastchain]
    cycle through interp   -> new lthetai using theti[locus][chain] 
                      ((newth-lthetai)>epsilon) 
    estimate_parameter last chain
    estimate_parameter many chains

*/
#include "migration.h"
#include "broyden.h"
#include "combroyden.h"

double norm_constant (nr_fmt * nr, double *param, double *lparam, long loci);

#define EPSILON5 0.00001

void
interpolate_like (nr_fmt * nr, long locus)
{
  static double *newlike, *lparam;
  static double *diff, *oldiff;
  static boolean done = FALSE, alldone;
  long j, z, r;
  long repdiff = nr->repstop - nr->repstart;
  double delta = 0;

  boolean diffdone;
  double *oldlike = nr->world->chainlikes[locus];
  if (!done)
    {
      newlike = (double *) calloc (repdiff, sizeof (double));
      diff = (double *) calloc (repdiff, sizeof (double));
      oldiff = (double *) calloc (repdiff, sizeof (double));
      lparam = (double *) calloc (nr->numpop2, sizeof (double));
      done = TRUE;
    }
  /* following material is reverse logistic regression 
     a la Geyer 1994 */
  z = 0;
  alldone = FALSE;
  memset (oldiff, 0, sizeof (double) * repdiff);
  //  log_param0 (nr->atl[j][locus].param0, lparam, nr->numpop2);
  while (!alldone && z++ < 10000)
    {
      alldone = TRUE;
      for (r = nr->repstart; r < nr->repstop; r++)
	create_multiapg0 (nr->apg0[r][locus], nr, r, locus);
      for (j = nr->repstart; j < nr->repstop; j++)
	{
	  newlike[j] = calc_locus_like (nr, nr->atl[j][locus].param0, 
					nr->atl[j][locus].lparam0, locus);
	  //newlike[j] = norm_constant(nr, nr->atl[j][locus].param0, locus);
	  if ((diff[j] = fabs (newlike[j] - oldlike[j])) > EPSILON5)
	    {
	      if (delta < diff[j])
		delta = diff[j];
	      alldone = FALSE;
	    }
	}
      diffdone = TRUE;
      for (j = nr->repstart; j < nr->repstop; j++)
	{
	  if (fabs (oldiff[j] - diff[j]) > EPSILON)
	    diffdone = FALSE;
	}
      if (diffdone && nr->world->options->verbose)
	{
	  printf ("           Iteration%6li constant biggest difference = %f\n", z, delta);
	  return;
	}
      if (nr->world->options->progress)
	if (z % 100 == 0 && nr->world->options->verbose)
	  printf ("           Iteration%6li biggest difference = %f\n", z, delta);
      delta = fabs (oldlike[0] - newlike[0]);
      memcpy (oldlike, newlike, sizeof (double) * repdiff);
      if (z % 100 == 0)
	memcpy (oldiff, diff, sizeof (double) * repdiff);
    }
  if (nr->world->options->progress)
    {
      if (delta < EPSILON5)
	printf ("           Multichain iteration operation converged in %li cycles\n", z);
      else
	printf ("           Multichain iteration operation did not converge in %li cycles\n           (biggest difference=%f)\n", z, delta);
    }
}

/*
                            P(g[ji]|theta[x])
 sumchain_j sumtrees_i ------------------------------------------------
                        sumchains_z (n_z P(g[ji]|theta[z])/L[theta[x]])  
*/
double
norm_constant (nr_fmt * nr, double *param, double *lparam, long loci)
{
  static double *denomtmp;
  static boolean done = FALSE;

  long g, j, jj, j2, jj2;
  long G;
  long copies;
  double sumlike = 0;
  double denom;
  double denommax;
  double *oldlike = nr->world->chainlikes[loci];
  long repdiff = nr->repstop - nr->repstart;

  tarchive_fmt *tl;
  world_fmt *world = nr->world;
  if (!done)
    {
      denomtmp = (double *) calloc (repdiff, sizeof (double));
      done = TRUE;
    }
  nr->apg_max[loci] = -DBL_MAX;
  for (j = nr->repstart; j < nr->repstop; j++)	//over all chains
    {
      jj = j - nr->repstart;
      denom = 0;
      tl = world->atl[j][loci].tl;
      G = world->atl[j][loci].T;

      for (g = 0; g < G; g++)	//over all trees
	{
	  denommax = -DBL_MAX;
	  // denominator precalculation: over all chains
	  // for the given tree tl[g]
	  for (j2 = nr->repstart; j2 < nr->repstop; j2++)
	    {
	      jj2 = j2 - nr->repstart;
	      denomtmp[jj2] = probG (world->atl[j2][loci].param0, world->atl[j2][loci].lparam0, &(tl[g]), nr) - oldlike[j2] + nr->world->options->loglsteps;
	      //              if(j2>nr->repstart)
	      //              printf("%f ", denomtmp[jj2]);
	      if (denommax < denomtmp[jj2])
		denommax = denomtmp[jj2];
	    }			// end denominator precalculation
	  denom = 0.;
	  //in denominator: sum with underflow control
	  //      printf("%li %li ",j,g);
	  for (j2 = 0; j2 < nr->repstop - nr->repstart; j2++)
	    {
	      //              printf(" %f ",probG(world->atl[j2][loci].param0, 
	      //      world->atl[j2][loci].lparam0, &(tl[g]), nr));
	      denom += exp (denomtmp[j2] - denommax);
	    }
	  nr->apg[j][loci][g] = probG (param, lparam, &(tl[g]), nr) - log (denom) - denommax;
	  if (nr->apg_max[loci] < nr->apg[j][loci][g])
	    nr->apg_max[loci] = nr->apg[j][loci][g];
	  //      printf("%f %f %li %li %f %f\n", probG (param, lparam, &(tl[g]), nr) ,nr->apg[j][g], nr->atl[j][loci].tl[g].copies,G,tl[g].km[0],nr->atl[j][loci].param0[0]);
	}			// end over all trees
    }				// end over all chains
  for (j = nr->repstart; j < nr->repstop; j++)	//over all chains
    {
      G = world->atl[j][loci].T;
      for (g = 0; g < G; g++)	//over all trees
	{
	  copies = (g > 0) ? nr->atl[j][loci].tl[g].copies : nr->atl[j][loci].tl[g].copies - 1;
	  nr->apg[j][loci][g] -= nr->apg_max[loci];
	  sumlike += copies * exp (nr->apg[j][loci][g]);
	}
    }
  return (nr->llike = log (sumlike) + nr->apg_max[loci]);
}






