/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 Likelihood ratio test   R O U T I N E S 

 moved out from world.c                                                                                                               
 Peter Beerli 2000, Seattle
 beerli@genetics.washington.edu
 $Id: lrt.c,v 1.7 2001/04/11 16:53:49 beerli Exp $
-------------------------------------------------------*/
#define SICK_VALUE    -1
#include "migration.h"
//#include "mcmc.h"

//#include "fst.h"
//#include "random.h"
#include "tools.h"
#include "broyden.h"
#include "combroyden.h"
#include "options.h"
#ifndef LAGUERRE
#include "derivatives2.h"
#endif
#include "sort.h"

//#ifdef UEP
//#include "uep.h"
//#endif
#ifdef DMALLOC_FUNC_CHECK
#include <dmalloc.h>
#endif

void print_lratio_test (world_fmt * world, long *Gmax);
void test_loci_like (nr_fmt * nr, double *param0, 
		     double *param1, long df, 
		     long loci, world_fmt * world, 
		     long *maxwhich, long maxnum, 
		     boolean withhead, char *this_string1,
		     char *this_string2);
long set_test_param (double *param, char *strp, world_fmt * world, 
		     long lrline, long locus, long *maxwhich, 
		     long *maxnum);
char * reverse(char * xx);
void bitmap_pattern(unsigned long n, long numpop, char *xx);
void adjust_pattern(char *pattern, char *custm);
long count_ones(char *pattern);
void  aic_score(aic_fmt **aicvec, long *aicnum, nr_fmt *nr, 
		long zero, long which, char *temppattern, double *param0,
		char migtype);

void  aic_score_minus(aic_fmt **aicvec, long *aicnum, nr_fmt *nr, 
		      long zero, long which, char *temppattern, 
		      double *param0, char migtype);

boolean legal_pattern(char *matrix, long numpop);


boolean mywhitespace (char ch)
{
  if (!(ch == ',' || ch == '\0' || ch == '\n' || ch == ';'))
    {
      return TRUE;
    }
  return FALSE;
}


void
print_lratio_test (world_fmt * world, long *Gmax)
{
  long c;
  long r, locus;
  long df;
  int header;
  nr_fmt *nr;
  double *param0;
  double *param1;
  long *maxwhich;
  long maxnum = 0;
  long repstop = world->repstop;
  param0 = (double *) calloc (1, sizeof (double) * (world->numpop2 + 1));
  param1 = (double *) calloc (1, sizeof (double) * (world->numpop2 + 1));
  maxwhich = (long *) calloc (1, sizeof (long) * (world->numpop2 + 1));


  if (world->options->progress)
    fprintf (stdout, "           Printing likelihood ratio tests\n");

  nr = (nr_fmt *) calloc (1, sizeof (nr_fmt));
  create_nr (nr, world, *Gmax, 0, world->loci, world->repkind, world->rep);
  for (locus = 0; locus < world->loci; locus++)
    {
      if (world->options->replicate)
	for (r = 0; r < repstop; r++)
	  create_multiapg0 (nr->apg0[r][locus], nr, r, locus);
      else
	create_apg0 (nr->apg0[0][locus], nr, &world->atl[0][locus]);
    }
  if(world->loci>1)
    locus=world->loci;
  else
    locus=0;
  for(c=0; c<world->options->lratio->counter; c++)
    {
      PAGEFEEDWORLD;
      header = (c == 0) ? HEADER : NOHEADER;
      if (world->options->lratio->data[c].type == MLE)
	{
	  memcpy(param1,world->atl[0][locus].param,
		 sizeof(double)*world->numpop2);
	  df = set_test_param (param0, 
			       world->options->lratio->data[c].value1, 
			       world, 0, -1, maxwhich, &maxnum);
	  test_loci_like (nr, param0, param1,
			  df, world->loci, world, maxwhich, 
			  maxnum, header, 
			  world->options->lratio->data[c].value1,
			  NULL);
	}
      else /*arbitrary*/
	{
	  df=set_test_param(param0,world->options->lratio->data[c].value1, 
			    world, 0, -1, maxwhich, &maxnum);
	  df=set_test_param(param1,world->options->lratio->data[c].value2, 
			    world, 0, -1, maxwhich, &maxnum);
	  test_loci_like (nr, param0, param1, 
			  df, world->loci, world, maxwhich, 
			  maxnum, HEADER, 
			  world->options->lratio->data[c].value1,
			  world->options->lratio->data[c].value2);
	}
      fprintf (world->outfile, "Remember: Tests based on a single locus may not be valid\n");
    }
  fflush(world->outfile);
  free (param0);
  free (param1);
  free (maxwhich);
  destroy_nr (nr, world);
}


void
test_locus_like (nr_fmt * nr, double *param0, double *param1, long df, long locus, world_fmt * world, long *maxwhich, long maxnum, boolean withhead, char *this_string)
{
  char *teststat, temp[LRATIO_STRINGS];
  double like1, like0, testval, chiprob;
  int length;
  char tmp[LRATIO_STRINGS];
  long zi, i, part1len = 1, part2len = 1;
  long elem, w = 0, z = 0, pop;
  double normd = 0;
  long *which;
  double /**values,*/ *saveparam0, tparam;
  double *lparam0;
  double *lparam1;
  long spaces = 0;
  char spacer[100];
  helper_fmt helper;
  which = (long *) calloc (1, sizeof (long) * (world->numpop2 + 1));
  lparam0 = (double *) calloc (world->numpop2 + 1, sizeof (double));
  lparam1 = (double *) calloc (world->numpop2 + 1, sizeof (double));
  saveparam0 = (double *) malloc (sizeof (double) * (world->numpop2 + 1));
  memcpy (saveparam0, param0, sizeof (double) * (world->numpop2 + 1));
  nr->skiploci = world->data->skiploci;
  elem = nr->numpop2 = world->numpop2;
  nr->numpop = world->numpop;
  if (maxnum > 0)
    {
      for (i = 0; i < elem; i++)
	{
	  if (i != maxwhich[z])
	    {
	      which[w] = i;
	      nr->values[w++] = param0[i];
	    }
	  else
	    {
	      if (maxnum > z + 1)
		z++;
	    }
	}
      maximize(param0, world, nr, PROFILE, world->repkind);
      like0 = nr->llike;
      normd = nr->normd;
      memcpy(param0,world->param0,sizeof(double)*nr->partsize);
    }
  else
    {
      set_logparam(lparam0,param0, elem);
      fill_helper (&helper, param0, lparam0, world, nr);
      like0 = calc_loci_like (&helper, FALSE, FALSE);
    }
  set_logparam(lparam1,param1, elem);
  fill_helper (&helper, param1, lparam1, world, nr);
  like1 = calc_loci_like (&helper, param1, lparam1);
  testval = -2. * (like0 - like1);
  chiprob = probchi (df, testval);
  teststat = (char *) calloc (1, sizeof (char) * LRATIO_STRINGS);
  length = MAX (0, 5 - sprintf (tmp, "%i", ((int) param0[0])));
  sprintf (teststat, "Loc%3li: %.*f", locus, length, param0[0]);
  for (i = 1; i < elem; i++)
    {
      zi = mml2m (i, world->numpop);
      if (zi >= world->numpop)
	{
	  pop = (zi - world->numpop) / (world->numpop - 1);
	  tparam = param0[zi] * saveparam0[pop];
	}
      else
	tparam = param0[zi];
      length = MAX (0, 5 - sprintf (tmp, "%i", ((int) tparam)));
      sprintf (temp, " %.*f", length, tparam);
      strcat (teststat, temp);
      if ((i + 1) % world->numpop == 0)
	strcat (teststat, "\n        ");
    }
  sprintf (temp, "=assumed to be equal to=");
  strcat (teststat, temp);
  part1len = 43;		//strlen (teststat);
  length = MAX (0, 5 - sprintf (tmp, "%i", ((int) param1[0])));
  sprintf (temp, "\n        %.*f", length, param1[0]);
  strcat (teststat, temp);
  for (i = 1; i < elem; i++)
    {
      zi = mml2m (i, world->numpop);
      if (zi >= world->numpop)
	{
	  pop = (zi - world->numpop) / (world->numpop - 1);
	  tparam = param1[zi] * param1[pop];
	}
      else
	tparam = param1[zi];
      length = MAX (0, 5 - sprintf (tmp, "%i", ((int) tparam)));
      sprintf (temp, " %.*f", length, tparam);
      strcat (teststat, temp);
      if ((i + 1) % world->numpop == 0)
	strcat (teststat, "\n       ");
    }
//  sprintf (temp, "}");
  //  strcat (teststat, temp);
  part2len = 43;		// strlen (teststat);
  spaces = 43 - 5 * (1 + world->numpop);
  strcpy (spacer, "                          ");

  if (withhead)
    {
      fprintf (world->outfile, "==============================================================================\n");
      fprintf (world->outfile, "Likelihood ratio tests\n");
      fprintf (world->outfile, "==============================================================================\n");
      fprintf (world->outfile, "Over all loci\n");
      fprintf (world->outfile, "[Theta values are on the diagonal of the Migration matrix,\nmigration rates are specified as Theta*M]\n");
      part1len = MAX (part1len, part2len - part1len);
      fprintf (world->outfile, "%*.*s           %-10.10s   %-3.3s   %-4.4s\n", (int) part1len, (int) part1len, " ", "Test value", "Df", "Prob");
      for (i = 0; i < part1len + 35; i++)
	fputc ('-', world->outfile);
      fprintf (world->outfile, "\n");
    }
  if (testval > 10000 && chiprob < EPSILON)
    sprintf (temp, ">10000.00");
  else
    sprintf (temp, "%10.2f", testval);
  fprintf (world->outfile, "You entered\n[%s]\n", this_string);
  fprintf (world->outfile, "%s %s -2(%6.3f-%6.3f)=%11.11s %3li %8.5f\n", teststat, spacer, like0, like1, temp, df, chiprob);
  free (teststat);
  free (lparam0);
  free (lparam1);
  free (saveparam0);
  free (which);
}

//remember: param0 is the parameterset to test and
// NOT the parameterset from migrate.
void
test_loci_like (nr_fmt * nr, double *param0, double *param1, long df, long loci, world_fmt * world, long *maxwhich, long maxnum, boolean withhead, char *this_string1, char *this_string2)
{

  char *teststat, temp[LRATIO_STRINGS];
  double like1, like0, testval, chiprob;
  int length;
  char tmp[LRATIO_STRINGS];
  long i, j, g = 0, part1len = 1, part2len = 1;
  long elem, zi, z = 0, w = 0, pop;
  double normd = 0;
  long *which;
  double /**values,*/ *saveparam0, tparam;
  long spaces = 0;
  char spacer[100];
  helper_fmt helper;
  double *lparam0;
  double *lparam1;
  lparam0 = (double *) calloc (world->numpop2 + 1, sizeof (double));
  lparam1 = (double *) calloc (world->numpop2 + 1, sizeof (double));
  which = (long *) calloc (1, sizeof (long) * (world->numpop2 + 1));
  //  values = (double *) calloc (1, sizeof (double) * (world->numpop2 + 1));
  saveparam0 = (double *) malloc (sizeof (double) * (world->numpop2 + 1));
  memcpy (saveparam0, param0, sizeof (double) * (world->numpop2 + 1));
  for (i = 0; i < loci; i++)
    {
      for (j = 0; j < world->repstop; j++)
	{
	  if (g < world->atl[j][i].T)
	    g = world->atl[j][i].T;
	}
    }
  elem = world->options->gamma ? nr->numpop2 + 1 : nr->numpop2;
  nr->skiploci = world->data->skiploci;
  helper.multilocus = world->loci == 1 ? FALSE : TRUE;
  if (maxnum > 0)
    {
      for (i = 0; i < elem; i++)
	{
	  if (i != maxwhich[z])
	    {
	      which[w] = i;
	      nr->values[w++] = param0[i];
	    }
	  else
	    {
	      if (maxnum > z + 1)
		z++;
	    }
	}
      maximize(param0, world, nr, PROFILE, world->repkind);
      like0 = nr->llike;
      normd = nr->normd;
      memcpy(param0,world->param0,sizeof(double)*nr->partsize);
    }
  else
    {
      set_logparam(lparam0,param0, elem);
      fill_helper (&helper, param0, lparam0, world, nr);
      like0 = calc_loci_like (&helper, param0, lparam0);
    }
  set_logparam(lparam1,param1, elem);
  fill_helper (&helper, param1, lparam1, world, nr);
  like1 = calc_loci_like (&helper, param1, lparam1);
  testval = -2. * (like0 - like1);
  chiprob = probchi (df, testval);
  teststat = (char *) calloc (1, sizeof (char) * LRATIO_STRINGS);
  length = MAX (0, 5 - sprintf (tmp, "%i", ((int) param0[0])));
  sprintf (teststat, "All   H0:%.*f", length, param0[0]);
  for (i = 1; i < elem; i++)
    {
      zi = mml2m (i, world->numpop);
      if (zi >= world->numpop)
	{
	  pop = (zi - world->numpop) / (world->numpop - 1);
	  tparam = param0[zi] * param0[pop];
	}
      else
	tparam = param0[zi];
      length = MAX (0, 5 - sprintf (tmp, "%i", ((int) tparam)));
      sprintf (temp, " %.*f", length, tparam);
      strcat (teststat, temp);
      if ((i + 1) % world->numpop == 0)
	strcat (teststat, "\n        ");
    }
  sprintf (temp, "=assumed to be equal to=");
  strcat (teststat, temp);
  part1len = 43;		//strlen (teststat);
  length = MAX (0, 5 - sprintf (tmp, "%i", ((int) param1[0])));
  sprintf (temp, "\n        %.*f", length, param1[0]);
  strcat (teststat, temp);
  for (i = 1; i < elem; i++)
    {
      zi = mml2m (i, world->numpop);
      if (zi >= world->numpop)
	{
	  pop = (zi - world->numpop) / (world->numpop - 1);
	  tparam = param1[zi] * param1[pop];
	}
      else
	tparam = param1[zi];
      length = MAX (0, 5 - sprintf (tmp, "%i", ((int) tparam)));
      sprintf (temp, " %.*f", length, tparam);
      strcat (teststat, temp);
      if ((i + 1) % world->numpop == 0)
	strcat (teststat, "\n       ");
    }
  //  sprintf (temp, "}");
  part2len = 43;		//strlen (teststat);
  spaces = 43 - 5 * (1 + world->numpop);

  strcpy (spacer, "                          ");

  if (withhead)
    {
      fprintf (world->outfile, "==============================================================================\n");
      fprintf (world->outfile, "Likelihood ratio tests\n");
      fprintf (world->outfile, "==============================================================================\n");
      fprintf (world->outfile, "Over all loci\n");
      fprintf (world->outfile, "[Theta values are on the diagonal of the Migration matrix,\nmigration rates are specified as Theta*M]\n");
      part1len = MAX (part1len, part2len - part1len);
      fprintf (world->outfile, "%*.*s           %-10.10s   %-3.3s   %-4.4s\n", (int) part1len, (int) part1len, " ", "Test value", "Df", "Prob");
      for (i = 0; i < part1len + 35; i++)
	fputc ('-', world->outfile);
      fprintf (world->outfile, "\n");
    }

  if (testval > 10000 && chiprob < EPSILON)
    sprintf (temp, ">10000.00");
  else
    sprintf (temp, "%10.2f", testval);
  fprintf (world->outfile, "You entered\n[%s]\n", this_string1);
  fprintf (world->outfile, "%s %s -2(%6.3f-%6.3f)=%11.11s %3li %8.5f\n", teststat, spacer, like0, like1, temp, df, chiprob);
  free (teststat);
  free(lparam0);
  free(lparam1);
  free (saveparam0);
  free (which);
}


long
set_test_param (double *param, char *strp, world_fmt * world, long lrline, long locus, long *maxwhich, long *maxnum)
{
  long i = 0, z = 0, zi = 0, zz = 0, zzz = 0, df = 0;
  long offset = 0, limit = 0, pop, pop1, pop2;
  long numpop = world->numpop;
  char *tmp, *ss, *paramtype;
  double *meanparam, mean;
  ss = (char *) calloc (1, sizeof (char) * LINESIZE);
  tmp = (char *) calloc (1, sizeof (char) * LINESIZE);
  paramtype = (char *) calloc (1, sizeof (char) * world->numpop2);

  *maxnum = 0;
  strcpy (ss, strp);

  if (world->loci - world->skipped > 1)
    meanparam = world->atl[0][world->loci].param;
  else
    meanparam = world->atl[0][0].param;
  while (ss[zzz] != '\0')
    {
      tmp[i] = ss[zzz++];
      if (mywhitespace (tmp[i]))
	{
	  if (tmp[i] != ' ')
	    i++;
	}
      else
	{
	  tmp[i] = '\0';
	  i = 0;
	  zi = mml2m (z, numpop);
	  m2mm (zi, numpop, &pop1, &pop2);
	  switch (tmp[0])
	    {
	    case 'x':
	      paramtype[zi] = '-';
	      param[zi] = meanparam[zi];
	      maxwhich[(*maxnum)++] = zi;
	      z++;
	      df++;
	      break;
	    case '*':
	      paramtype[zi] = '-';
	      param[zi] = meanparam[zi];
	      z++;
	      break;
	    case 't':
	    case 'm':
	      paramtype[zi] = '-';
	      zz = atol (tmp) - 1;
	      df++;
	      if (zz < 0)
		{
		  mean = 0.0;
		  offset = (zi >= world->numpop) ? world->numpop : 0;
		  limit = (zi >= world->numpop) ? world->numpop2 : world->numpop;
		  for (zz = offset; zz < limit; zz++)
		    mean += meanparam[zz];
		  mean /= limit - offset;
		  param[zi] = mean;
		}
	      else
		{
		  param[zi] = meanparam[zz];
		}
	      z++;
	      break;
	    case 'M':
	      zz = atol (tmp) - 1;
	      df++;
	      if (zz < 0)
		{
		  mean = 0.0;
		  offset = (zi >= world->numpop) ? world->numpop : 0;
		  limit = (zi >= world->numpop) ? world->numpop2 : world->numpop;
		  if (offset < numpop)
		    {
		      paramtype[zi] = '-';
		      for (zz = offset; zz < limit; zz++)
			mean += meanparam[zz];
		      mean /= limit - offset;
		      param[zi] = mean;
		    }
		  else
		    {
		      paramtype[zi] = '+';
		      for (zz = offset; zz < limit; zz++)
			{
			  m2mm (zz, numpop, &pop1, &pop2);
			  mean += meanparam[zz] * meanparam[pop2];
			}
		      mean /= limit - offset;
		      param[zi] = mean;
		    }
		}
	      else
		{
		  paramtype[zi] = '-';
		  param[zi] = meanparam[zz];
		}
	      z++;
	      break;
	    case 's':
	      df++;
	      if (zi < world->numpop)
		{
		  paramtype[zi] = '-';
		  param[zi] = meanparam[zi];
		  z++;
		}
	      else
		{
		  paramtype[zi] = '-';
		  param[zi] = (meanparam[zi] + meanparam[mm2m (pop2, pop1, world->numpop)]) / 2.;
		  z++;
		}
	      break;
	    case 'S':
	      df++;
	      if (zi < world->numpop)
		{
		  paramtype[zi] = '-';
		  param[zi] = meanparam[zi];
		  z++;
		}
	      else
		{
		  paramtype[zi] = '+';
		  param[zi] = (meanparam[zi] * meanparam[pop2] + meanparam[mm2m (pop2, pop1, world->numpop)] * meanparam[pop1]) / 2.;
		  z++;
		}
	      break;
	    default:
	      paramtype[zi] = '+';
	      df++;
	      param[zi] = MAX (atof (tmp), SMALLEST_THETA);
	      z++;
	      break;
	    }
	}
    }
  for (zi = world->numpop; zi < world->numpop2; zi++)
    {
      if (paramtype[zi] == '+')
	{
	  pop = (zi - world->numpop) / (world->numpop - 1);
	  param[zi] /= param[pop];
	}
    }
  free (paramtype);
  free (ss);
  free (tmp);
  return df;
}
// changes a linear matrix of ddd mm mm mm
// to a diagonal matrix dmm mdm mmd
// it destroys pattern
char * reshuffle(char *pattern, char *origpattern, long numpop)
{
  long space = 0;
  long i, j, z=numpop;

  for(i=0;i<numpop;i++)
    {
      for(j=0;j<numpop;j++)
	{
	  if(i==j)
	    pattern[i*numpop + j + space] = 'x';
	  else
	    pattern[i*numpop + j + space] = origpattern[z++];
	}
      pattern[i*numpop + j + space] = ' ';
      space++;
    }
  return pattern;
}

void akaike_information(world_fmt *world, long *Gmax)
{
  //  long kind = world->loci>1 ? MULTILOCUS : SINGLELOCUS;
  long r, i;
  long locus;
  boolean mldone =FALSE;
  //  long ones;
  //  long factnumpop = (long) exp(logfac(world->numpop2));
  nr_fmt *nr;
  char *testpat;
  char *pattern;
  char *temppattern;
  char *savecustm;
  long kind = world->loci>1 ? MULTILOCUS : SINGLELOCUS;
  long repstop = !world->options->replicate ? 0 : 
    (world->options->replicatenum == 0 ? 
     world->options->lchains : world->options->replicatenum); 
  //  double likes;
  //  double normd;
  //  double aic;
  double *param0;
  aic_fmt *aicvec;
  long aicnum;
  double mleaic;
  world->options->migration_model = MATRIX_ARBITRARY;
  savecustm = calloc(world->numpop2,sizeof(char));
  testpat = calloc(world->numpop2,sizeof(char));
  memset(testpat,0x31,sizeof(char)*world->numpop);
  pattern = calloc(world->numpop2+1,sizeof(char));
  temppattern = calloc(world->numpop2+1+world->numpop,sizeof(char));
  param0 = calloc(world->numpop2+1,sizeof(double));
  if(kind==MULTILOCUS)
    mleaic = -2. * world->atl[0][world->loci].param_like + 2. * world->numpop2;
  else
    mleaic = -2. * world->atl[repstop][0].param_like + 2. * world->numpop2;
  nr = (nr_fmt *) calloc (1, sizeof (nr_fmt));
  create_nr (nr, world, *Gmax, 0, world->loci, world->repkind, world->rep);

  for (locus = 0; locus < world->loci; locus++)
    {
      if (world->options->replicate)
	for (r = 0; r < world->repstop; r++)
	  create_multiapg0 (nr->apg0[r][locus], nr, r, locus);
      else
	create_apg0 (nr->apg0[0][locus], nr, &world->atl[0][locus]);
    }
  memcpy(savecustm,world->options->custm2,sizeof(char)*nr->numpop2);
  if (world->options->progress)
    fprintf (stdout, "\n\n           Selecting the best migration model for this run,\n           This may take a while!\n           All parameter \
combinations\n           with  (AIC= -2 Log(L(Param) + n_param) < %f (AIC at MLE) + %f\n", 
	     mleaic,  nr->world->options->aicmod * world->numpop2);
  fprintf (world->outfile, "\n\n\n Akaike's Information Criterion  (AIC)\n");
  fprintf(world->outfile,        "=========================================\n\n");
  fprintf(world->outfile,        "[Linearized migration matrix, x=diagonal]\n");
  fprintf(world->outfile,        "%-*.*s            AIC     Number\n",
	  (int) MAX(18,nr->partsize+nr->numpop), 
	  (int)(nr->partsize+nr->numpop),"Pattern"); 
  if(kind==MULTILOCUS)
    memcpy(param0,nr->world->atl[0][nr->world->loci].param,
	   sizeof(double) * nr->numpop2);
  else
    memcpy(param0,nr->world->atl[repstop][nr->world->locus].param,
	   sizeof(double) * nr->numpop2);
  
  // calculates akaike information score
  aicnum=1;
  aicvec = (aic_fmt *) calloc(aicnum,sizeof(aic_fmt));
  aicvec[0].aic = mleaic;
  aicvec[0].numparam=nr->partsize;
  aicvec[0].pattern = (char *) calloc(nr->partsize+1,sizeof(char));
  memcpy(aicvec[0].pattern,world->options->custm2,sizeof(char)*nr->partsize);
  //find aic scores in a branch-and-bound fashion
  // with some parameters set to zero, this needs more
  // investigation because of boundary problems
  aic_score(&aicvec, &aicnum, nr, 0, world->numpop, temppattern, param0,'0');
  // aic scores based on averaging M (not 4Nm)
  //  memset(nr->profiles,0, sizeof(double)*nr->partsize);
  memcpy(world->options->custm2,savecustm, sizeof(char)*nr->numpop2);
  aic_score(&aicvec, &aicnum, nr, 0, world->numpop, temppattern, param0,'m');
  //memcpy(world->options->custm2,savecustm, sizeof(char)*nr->numpop2);
  //  aic_score_minus(&aicvec, &aicnum, nr, 0 , world->numpop2-1, 
  //	  temppattern, param0);
  qsort ((void *) aicvec, aicnum, sizeof (aic_fmt), aiccmp); 
  for(i=0;i<aicnum;i++)
    {
      fprintf(world->outfile,"%-*.*s %20.5f %4li\n", 
	      (int) MAX(18,nr->partsize+nr->numpop), 
	      (int)(nr->partsize+nr->numpop), 
	      reshuffle(temppattern, aicvec[i].pattern, nr->numpop), 
	      aicvec[i].aic, aicvec[i].numparam);
      if(aicvec[i].aic ==mleaic && !mldone)
	{
	  mldone=TRUE;
	  fprintf(world->outfile,"%-*.*s%21.21s-----\n", 
		  (int) MAX(18,nr->partsize+nr->numpop), 
		  (int)(nr->partsize+nr->numpop),"--------------------------------------------------------------------------------------------------------------------------------------------------------------", 
		  "---------------------");
	}
      free(aicvec[i].pattern);
    }
  free(aicvec);
  fflush(world->outfile);
  free(param0);
  free(pattern);
  free(temppattern);
  free(testpat);
  free(savecustm);
  destroy_nr(nr,world);
}



void bitmap_pattern(unsigned long n, long length, char *xx)
{
  long num=length-1;
  memset(xx,0x30,sizeof(char)*length);
  while (n != 0)
    {
      if(n & 1)
	sprintf(xx+num,"1");
      else
	sprintf(xx+num,"0");
      n >>= 1;
      num--;
    }
  //  reverse(xx);
}


char * reverse(char * xx)
{
  long i;
  char tmp;
  long n = strlen(xx);
  for(i=0;i<n/2;i++)
    {
      tmp = xx[i];
      xx[i] = xx[n-1-i];
      xx[n-1-i] = tmp;
    }
  return xx;
}

long count_ones(char *pattern)
{
  long count=0;
  while(*pattern != '\0')
  {
    if(*pattern == '1')
      count++;
    pattern++;
  }
  return count;
}

void adjust_pattern(char *pattern, char *custm)
{
  while(*custm != '\0')
    {
      if(*pattern == '\0')
      {
	*custm = '0';
      }
      else
	{
	  if(*pattern == '0')
	  {
	    *custm = '0';
	  }
	  pattern++;
	}
      custm++;
    }
}


void  aic_score(aic_fmt **aicvec, long *aicnum, nr_fmt *nr, 
		long zero, long which, char *temppattern, double *param0,
		char migtype)
{
  long m;
  //  long kind = nr->world->loci>1 ? MULTILOCUS : SINGLELOCUS;
  double likes=0;
  double normd=0;
  double aic;
  char savecustm2;
  long remainnum=0;
  boolean legal;
  char *custm2 = nr->world->options->custm2;
  long *numparam=NULL;
  switch(migtype)
    {
    case '0':
      numparam = &nr->world->options->zeron;
      remainnum=0;
      break;
    case 'm':
      numparam = &nr->world->options->mmn;
      remainnum=1;
      if(nr->world->options->custm2[which]=='m')
	return;
      break;
    }
  for(m = which; m < nr->numpop2; m++)
    {
      savecustm2 = custm2[m];
      custm2[m] = migtype;
      memcpy(nr->world->param0, param0,
	     sizeof(double) * nr->numpop2);
      resynchronize_param (nr->world);

      if((legal=legal_pattern(nr->world->options->custm2, 
				      nr->numpop)))
	{
	  do_profiles(nr->world, nr, &likes, &normd, PROFILE, 
		      nr->world->rep, nr->world->repkind);
	  aic = -2. * nr->llike + 2. * (nr->numpop2 - *numparam + remainnum);
	  //	  aic = -2. * nr->llike + (nr->numpop2 - zero - 1.);
	  if(aic < (*aicvec)[0].aic +  nr->world->options->aicmod * nr->numpop2)
	    {
		  *aicvec = (aic_fmt *) realloc(*aicvec, sizeof(aic_fmt) * (*aicnum + 1));
		  (*aicvec)[*aicnum].pattern = (char *) calloc(nr->partsize+1,sizeof(char));
		  (*aicvec)[*aicnum].aic = aic;
		  (*aicvec)[*aicnum].numparam = nr->numpop2 - *numparam + remainnum;
		  memcpy((*aicvec)[*aicnum].pattern, custm2, sizeof(char)*nr->partsize);
	      if(nr->world->options->progress)
		fprintf(stdout, "           +   %s %20.5f\n", reshuffle(temppattern,custm2, nr->numpop),aic); fflush(stdout);
	      (*aicnum)++;
	      
	      aic_score(aicvec,aicnum, nr, zero + 1, m + 1, 
			temppattern, param0, migtype);
	    }
	  else
	    {
	      if(nr->world->options->progress)
		fprintf(stdout,"           -   %s %20.5f\n", reshuffle(temppattern, custm2, nr->numpop),aic);fflush(stdout);
	    }
	}
      else
	{
	  if(nr->world->options->progress)
	    fprintf(stdout,"           F   %s %20s\n", reshuffle(temppattern, custm2, nr->numpop), "-----");fflush(stdout);
	}
      custm2[m] = savecustm2;
    }
}

void  aic_score_minus(aic_fmt **aicvec, long *aicnum, nr_fmt *nr, 
		      long zero, long which, char *temppattern, 
		      double *param0,
		      char migtype)
{
  long m;
  long kind = nr->world->loci>1 ? MULTILOCUS : SINGLELOCUS;
  long repstop = !nr->world->options->replicate ? 0 : 
    (nr->world->options->replicatenum == 0 ? 
     nr->world->options->lchains : nr->world->options->replicatenum); 
  double likes=0;
  double normd=0;
  double aic;
  char savecustm2;
  boolean legal;
  char *custm2 = nr->world->options->custm2;
  for(m = which; m >= nr->world->numpop; m--)
    {
      savecustm2 = custm2[m];
      custm2[m] = '0';
      if(kind==MULTILOCUS)
	memcpy(nr->world->param0,nr->world->atl[0][nr->world->loci].param,
	       sizeof(double) * nr->numpop2);
      else
	memcpy(nr->world->param0,nr->world->atl[repstop][nr->world->locus].param,
	       sizeof(double) * nr->numpop2);
      resynchronize_param (nr->world);
      if((legal=legal_pattern(nr->world->options->custm2, 
				      nr->numpop)))
	{
	  do_profiles(nr->world, nr, &likes, &normd, PROFILE, 
		      nr->world->rep, nr->world->repkind);
	  aic = -2. * nr->llike + (nr->numpop2 - zero - 1.);
	  if(aic < (*aicvec)[0].aic +  nr->world->options->aicmod * nr->numpop2)
	    {
	      *aicvec = (aic_fmt *) realloc(*aicvec, sizeof(aic_fmt) * (*aicnum + 1));
	      (*aicvec)[*aicnum].pattern = (char *) calloc(nr->partsize+1,sizeof(char));
	      (*aicvec)[*aicnum].aic = aic;
	      memcpy((*aicvec)[*aicnum].pattern, custm2, sizeof(char)*nr->partsize);
	      if(nr->world->options->progress)
		fprintf(stdout, "           +   %s %20.5f\n", reshuffle(temppattern,custm2, nr->numpop),aic); fflush(stdout);
	      (*aicnum)++;
	      
	      aic_score_minus(aicvec,aicnum, nr, zero + 1, m - 1, temppattern, param0, migtype);
	    }
	  else
	    {
	      if(nr->world->options->progress)
		fprintf(stdout,"           -   %s %20.5f\n", reshuffle(temppattern, custm2, nr->numpop),aic);fflush(stdout);
	    }
	}
      else
	{
	  if(nr->world->options->progress)
	    fprintf(stdout,"           F   %s %s\n", reshuffle(temppattern, custm2, nr->numpop), "-----");fflush(stdout);
	}
      custm2[m] = savecustm2;
    }
}

boolean legal_pattern(char *matrix, long numpop)
{
  long from, to, i;
  double summ = -1;
  double oldto;
  for(i=0; i < numpop; i++)
    {
      if(matrix[i] == '0')
	return FALSE;
    }
  oldto = -1;
  for(i=numpop; i < numpop*numpop; i++)
    {
      m2mm(i,numpop, &from, &to);
      if(oldto != to)
	{
	  if(summ==0)
	    return FALSE;
	  oldto = to;
	  summ=0;
	}
      summ += (matrix[i]!='0') + (matrix[mm2m(to,from,numpop)]!='0');
    }
  if(summ==0)
    return FALSE;
  return TRUE;
}







