#ifndef __UEP__
#define __UEP__
// unique event polymorphism UEP
//
// 
#ifdef UEP

#include "migration.h"
#include "tree.h"

extern void alloc_ueplike (double ***ueplike, long size, 
			   double *****ueplikestore, long storesize,
			   long ****ueprootstore, 
			   long numpop, long loci);
extern void alloc_ueptime (ueptime_fmt **ueptime, long size, 
ueptime_fmt ****ueptimestore, long storesize, long numpop, long loci);

extern void allocate_uep (node * p, world_fmt * world, char datatype, boolean withtips);


extern void constrain_distance_uep (long **uep, long uepsites, double **distm, long tips);
extern void make_uep_values (world_fmt * world, data_fmt *data, long locus);
extern void update_uep (node * p, world_fmt * world);
extern void check_uep_root(node *p, world_fmt *world);
extern boolean is_success_pseudo_uep (proposal_fmt * proposal);
extern boolean uep_compare (long *target, long *origin, long uepsites);
extern void store_uep (world_fmt * world);
extern double pseudo_ueplikelihood (world_fmt * world, proposal_fmt * proposal);
extern double ueplikelihood (world_fmt * world);
extern void calc_ueplike (node * p, world_fmt * world, double **ueplike);
extern double collect_pseudo_ueplike (proposal_fmt * proposal, double **ueplike);
extern void collect_ueplike (node * p, node * d1, node * d2, long uepsite, world_fmt * world, double *ueplike);
extern void show_uep_store (world_fmt * world);
extern node *first_uep (node * p, node * nop, long uepsites);
extern node *first_uep2 (node * p, node *root, long uepsites);
extern void analyze_uep(world_fmt * world);
extern void alloc_uepanc (long ***uepanc, long size, long numpop, long loci);
extern void update_uepanc(world_fmt *world);
#endif


#endif /* __UEP__ */
