#ifndef COMBRO_INCLUDE
#define COMBRO_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice world size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 C O M B I N E   L O C I   R O U T I N E S 

 

 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: combroyden.h,v 1.15 2001/03/26 00:04:02 beerli Exp $

-------------------------------------------------------*/

#include "migration.h"

extern long estimateParameter (long rep, long G, world_fmt * world, option_fmt *options, double **dd, long chain, char type, long kind, long repkind);

extern double calc_loci_like (helper_fmt * helper, double *param, double *lparam);

extern void calc_apgg (double thetax, double **apgg, nr_fmt * nr, timearchive_fmt * atl, long which);
extern void set_gamma_param (double *paramn, double *paramo, 
		 double *lparamn, double *lparamo, 
		 double theta, nr_fmt * nr);
extern void calc_apg0 (double *apg0, nr_fmt * nr, timearchive_fmt * tyme, double thetax, double theta1);
extern void which_calc_like (long repkind);
extern void calc_loci_param (nr_fmt *nr, double *lparam, double *olparam, 
		      double *dv, double lamda, long nnn);
extern void set_replicates (world_fmt * world, long repkind, long rep, long *repstart, long *repstop);
extern void prepare_broyden (long kind, long repstart, long repstop, world_fmt * world, boolean * multilocus, long *Gmax);
extern void simple_loci_derivatives (double *d, nr_fmt * nr, 
				     timearchive_fmt ** tyme, 
				     long locus);
extern void copy_and_clear_d (nr_fmt * nr);
extern void add_back_d (nr_fmt * nr);
extern void setup_parameter0 (world_fmt * world, nr_fmt * nr, long repkind, long repstart, long repstop, long loci, long kind, boolean multilocus);

extern double (*calc_like) (nr_fmt *, double *, double *, long);

extern void
combine_gradient (nr_fmt * nr, helper_fmt * helper, 
		  double *gxv);

extern long maximize(double *param, world_fmt *world, nr_fmt *nr, long analystype, long repkind);
extern void set_logparam(double *loga, double *a, long size);
extern void set_expparam(double *expa, double *a, long size);
extern long do_profiles (world_fmt * world, nr_fmt *nr, double *likes, double *normd, long kind, long rep, long repkind);
extern void fill_helper (helper_fmt * helper, double *param, double *lparam, 
		  world_fmt * world, nr_fmt * nr);



#endif /* COMBINE_INCLUDE */





