#ifndef __MIGRATE_MPI_
#define __MIGRATE_MPI_

extern int myID;
extern int numcpu;
extern int locidone;

#define MASTER 0
#define SLAVE 1

#ifdef MPI


#include <mpi.h>
#include "migration.h"

#ifndef tpool_t
#define tpool_t char
#endif

extern void broadcast_options(option_fmt *options);

extern void mpi_runloci_master(data_fmt * data, int *who);

extern void mpi_runloci_worker(world_fmt ** universe, int usize, 
		       option_fmt * options, data_fmt * data, 
		       tpool_t * heating_pool, long maxreplicate, 
		       long *treefilepos, long *Gmax);

extern double mpi_likelihood_master(double *param, double *lparam,
				    world_fmt *world, nr_fmt *nr,
				    helper_fmt *helper,
				    int *who);
extern void broadcast_options_master(option_fmt *options);
extern void broadcast_options_worker(option_fmt *options);

//extern void broadcast_data_master(data_fmt *data, option_fmt *options);
//extern void broadcast_data_worker(data_fmt *data, option_fmt *options);

extern void mpi_results_master(world_fmt *world,
			       timearchive_fmt **atl, long maxrep, 
			       long numpop, int *who);
extern void  mpi_results_worker(long bufsize, timearchive_fmt **atl, long maxrep,
			       long numpop, int *who);

extern void mpi_gradient_master(nr_fmt *nr, world_fmt *world, int *who);

extern void mpi_maximize_worker(world_fmt *world, long rep);

extern void mpi_gmax_master(world_fmt *world, long *Gmax);
extern void mpi_gmax_worker(world_fmt *world);

extern void mpi_send_stop(world_fmt *world);
extern void mpi_results_stop(void);
#endif
#endif













