#ifndef __MIGRATE_MPI_
#define __MIGRATE_MPI_

extern int myID;
extern int numcpu;
extern int locidone;

#define MASTER 0
#define SLAVE 1

#define MIGMPI_END 0
#define MIGMPI_LIKE 1
#define MIGMPI_GRADIENT 2
#define MIGMPI_RESULT 3
#define MIGMPI_SUMFILE 4
#define MIGMPI_MIGHIST 5

#ifdef MPI


#include <mpi.h>
#include "migration.h"

#ifndef PTHREADS
#define tpool_t char
#else
#include "heating.h"
#endif

extern void broadcast_options (option_fmt * options);

extern void mpi_runloci_master (long loci, int *who);

extern void mpi_runloci_worker (world_fmt ** universe, int usize,
				option_fmt * options, data_fmt * data,
				tpool_t * heating_pool, long maxreplicate,
				long *treefilepos, long *Gmax);

extern double mpi_likelihood_master (double *param, double *lparam,
				     world_fmt * world, nr_fmt * nr,
				     helper_fmt * helper, int *who);
extern void broadcast_options_master (option_fmt * options);
extern void broadcast_options_worker (option_fmt * options);

//extern void broadcast_data_master(data_fmt *data, option_fmt *options);
//extern void broadcast_data_worker(data_fmt *data, option_fmt *options);
extern void mpi_results_master (double sendtype, world_fmt * world,
				long maxrep,
				void (*unpack) (char *buffer,
						world_fmt * world, long locus,
						long maxrep, long numpop));
extern void mpi_results_worker (long bufsize, world_fmt * world, long maxrep,
				long (*pack) (char **buffer,
					      world_fmt * world, long locus,
					      long maxrep, long numpop));

extern long pack_result_buffer (char **buffer, world_fmt * world,
				long locus, long maxrep, long numpop);
extern void unpack_result_buffer (char *buffer, world_fmt * world,
				  long locus, long maxrep, long numpop);
extern long pack_sumfile_buffer (char **buffer, world_fmt * world,
				 long locus, long maxrep, long numpop);
extern void unpack_sumfile_buffer (char *buffer, world_fmt * world,
				   long locus, long maxrep, long numpop);
extern long pack_mighist_buffer (char **buffer, world_fmt * world,
				 long locus, long maxrep, long numpop);
extern void unpack_mighist_buffer (char *buffer, world_fmt * world,
				   long locus, long maxrep, long numpop);


extern void mpi_gradient_master (nr_fmt * nr, world_fmt * world, int *who);

extern void mpi_maximize_worker (world_fmt * world, long rep);

extern void mpi_gmax_master (world_fmt * world, long *Gmax);
extern void mpi_gmax_worker (world_fmt * world);

extern void mpi_send_stop (world_fmt * world);
extern void mpi_results_stop (void);
extern void assignloci_worker (world_fmt * world);
#endif
#endif
