/* ----------------------------------------------------- */
/* sort.c                       */
/* comparison routeins for various qsorts and bsearch's */
/* ----------------------------------------------------- */
/* part of the lamarc package               */
/*                              */
/* P. Beerli                        */
/* 
Copyright 2001 Peter Beerli and Joseph Felsenstein

$Id: sort.c,v 1.7 2001/06/02 21:40:21 beerli Exp $ */
/* ----------------------------------------------------- */

/* include files */
#include "migration.h"
#include "sort.h"
/* private functions */

/* public functions */
int
charcmp (const void *v1, const void *v2)
{
  if (*(char *) v1 < *(char *) v2)
    {
      return -1;
    }
  else
    {
      if (*(char *) v1 > *(char *) v2)
	{
	  return 1;
	}
      else
	return 0;
    }
}

int
stringcmp (const void *v1, const void *v2)
{
  if (strcmp ((char *) v1, (char *) v2) < 0)
    {
      return -1;
    }
  else
    {
      if (strcmp ((char *) v1, (char *) v2) > 1)
	return 1;
      else
	return 0;
    }
}

int
numcmp (const void *v1, const void *v2)
{
  if (*(double *) v1 < *(double *) v2)
    {
      return -1;
    }
  else
    {
      if (*(double *) v1 > *(double *) v2)
	{
	  return 1;
	}
      else
	return 0;
    }
}
int
longcmp (const void *v1, const void *v2)
{
  if (*(long *) v1 < *(long *) v2)
    {
      return -1;
    }
  else
    {
      if (*(long *) v1 > *(long *) v2)
	{
	  return 1;
	}
      else
	return 0;
    }
}

int
intcmp (const void *v1, const void *v2)
{
  if (*(int *) v1 < *(int *) v2)
    {
      return -1;
    }
  else
    {
      if (*(int *) v1 > *(int *) v2)
	{
	  return 1;
	}
      else
	return 0;
    }
}


int
agecmp (const void *x, const void *y)
{
  if (((vtlist *) x)->age < ((vtlist *) y)->age)
    {
      return -1;
    }
  else
    {
      if (((vtlist *) x)->age == ((vtlist *) y)->age)
	{
	  return 0;
	}
      else
	return 1;
    }
}

int
delcmp (const void *x, const void *y)
{
  if ((*((node **) x))->id < (*((node **) y))->id)
    {
      return -1;
    }
  else
    {
      if ((*((node **) x))->id == (*((node **) y))->id)
	{
	  return 0;
	}
      else
	return 1;
    }
}

int
migr_time_cmp (const void *x, const void *y)
{
  if (((migr_table_fmt *) x)->time < ((migr_table_fmt *) y)->time)
    {
      return -1;
    }
  else
    {
      if (((migr_table_fmt *) x)->time == ((migr_table_fmt *) y)->time)
	{
	  return 0;
	}
      else
	return 1;
    }
}


int
searchagecmp (const void *x, const void *y)
{
  double xx = (double) *((double *) x);
  double age = (double) ((vtlist *) y)->age;

  if (xx < age)
    {
      return -1;
    }
  else
    {
      if (xx == age)
	{
	  return 0;
	}
      else
	return 1;
    }

}


int
aiccmp (const void *x, const void *y)
{
  if (((aic_fmt *) x)->aic < ((aic_fmt *) y)->aic)
    {
      return -1;
    }
  else
    {
      if (((aic_fmt *) x)->aic == ((aic_fmt *) y)->aic)
	{
	  return 0;
	}
      else
	return 1;
    }
}

