#ifndef DATA_INCLUDE
#define DATA_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 D A T A   R O U T I N E S 

 creates data structures,
 read data (Electrophoretic loci, sequences, microsats),
 feeds data into tree (?),
 prints data,
 destroys data.
 
 
 Theta(1)=4 N(1)mu, Theta(2)=4 N(2)mu,
 M(1) = m(1)/mu, and M(2)= m(2)/mu
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein

$Id: data.h,v 1.9 2001/07/25 19:27:23 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void create_data (data_fmt ** data);
extern void get_data (FILE * infile, data_fmt * data, option_fmt * options);
extern void print_data (world_fmt * world, option_fmt * options,
			data_fmt * data);
extern void print_data_summary (FILE * file, world_fmt * world,
				option_fmt * options, data_fmt * data);
extern void free_datapart (data_fmt * data, option_fmt * options, long locus);
extern void read_distance_fromfile (FILE * dfile, long tips, long nmlength,
				    double **m);
extern void read_geofile (data_fmt * data, option_fmt * options, long numpop);
// used in MPI context
extern void init_data_structure1 (data_fmt ** data, option_fmt * options);
extern void init_data_structure2 (data_fmt ** data, option_fmt * options, long pop);
extern void init_data_structure3 (data_fmt * data);
extern void create_alleles (data_fmt * data);
extern void set_numind (data_fmt * data);


extern long number_genomes (char type);

#endif /*DATA_INCLUDE */
