#ifndef __BROYDENH__
#define __BROYDENH__
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 P A R A M E T E R E S T I M A T I O N   R O U T I N E S 

 estimates parameter for each locus
 using a Broyden minimization
 

 Peter Beerli 1997, Seattle
 beerli@genetics.washington.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein

$Id: broyden.h,v 1.22 2001/07/25 19:27:23 beerli Exp $

-------------------------------------------------------*/

extern void broyden (world_fmt * world, double **covariance, long numg,
		     long chain, char type, char ***plane);

extern double absmaxvec (double *v, long n);
extern void create_nr (nr_fmt * nr, world_fmt * world, long G,
		       long profilenum, long thislocus, long repkind,
		       long rep);
extern void reset_hess (double **hess, long n);
extern void destroy_nr (nr_fmt * nr, world_fmt * world);
extern void alloc_apg (double ****apg, long repstop, long loci, long G);

extern double calc_locus_like (nr_fmt * nr, double *param, double *lparam,
			       long locus);
extern void calc_param (nr_fmt * nr, double *param, double lamda);
extern void param_all_adjust (double *param, worldoption_fmt * wopt,
			      long numpop);
extern void gradient (double *d, nr_fmt * nr, long locus);
extern void grad2loggrad (double *param, long *indeks, double *d, long nn,
			  long profilenum);
extern double probG (double *param, double *lparam, tarchive_fmt * tl,
		     nr_fmt * nr, long locus);

extern double logprob_noevent (world_fmt * world, long interval);
extern double sum_migprob (world_fmt * world, long pop, long interval);
extern void calc_cov (double **dd, double *d, double *param, long n);

extern void calc_dv (double *dv, double **hess, double *gxv, long n);
extern double calc_line (helper_fmt * helper, double a, double b, double c,
			 double (*psi) (double, helper_fmt *));
extern void calc_hessian (double **hess, long n, double *delta, double *gama);
extern double psi (double lamda, helper_fmt * helper, double *param,
		   double *lparam);
extern void log_param0 (double *param, double *lparam, long nn);
extern void copies2lcopies (timearchive_fmt * atl);
extern void create_apg0 (double *apg0, nr_fmt * nr, timearchive_fmt * tyme,
			 long locus);
extern void create_multiapg0 (double *apg0, nr_fmt * nr, long rep,
			      long locus);
extern void force_symmetric_d (double *gxv, long model, nr_fmt * nr, long nn);

extern void print_contribution (nr_fmt * nr, timearchive_fmt ** atl, long G);

extern double ln_copies (long n);
#endif
