// Bayes update scheme
//
// started November 2000
// Peter Beerli Seattle 2000
// $Id: bayes->c,v 1.4 2001/07/25 19:27:23 beerli Exp $
//
#include "bayes.h"
#include "random.h"
#ifdef BAYESUPDATE
extern void precalc_world(world_fmt *world);

boolean bayes_accept (double newval, double oldval, double heat);

double propose_newparam (double param,
                         double delta, double minparam, double maxparam);

long bayes_update (world_fmt * world);

double probWait(vtlist *tlp, world_fmt *world, long numpop);

// calculate prob(g|param) from world->treetimes
//
double probg_treetimes(world_fmt *world)
{
  long i;
  vtlist *tl = world->treetimes->tl;
  double deltatime = tl[0].age;
  double sumprob = 0.;
  double eventprob=0.;
  eventprob = (tl[0].from==tl[0].to) ? (LOG2 - log(world->param0[tl[0].from]))
              : log(world->param0[mm2m(tl[0].from,tl[0].to, world->numpop)]);
  sumprob = -deltatime * probWait(&tl[0], world, world->numpop) + eventprob;

  for(i=1; i<world->treetimes->T;i++)
    {
      deltatime = (tl[i].age - tl[i-1].age);
      eventprob = (tl[i].from==tl[i].to) ? (LOG2 - log(world->param0[tl[i].from]))
                  : log(world->param0[mm2m(tl[i].from,tl[i].to, world->numpop)]);
      sumprob += -deltatime * probWait(&tl[i], world, world->numpop) + eventprob;
    }
  return sumprob;
}

double probWait(vtlist *tlp, world_fmt *world, long numpop)
{
  long j, z;
  double msum;
  double probm=0., probth=0.;
  double line;
  for(j=0; j < numpop; j++)
    {
      line =tlp->lineages[j];
      msum = 0.0;
      for(z=world->mstart[j]; z < world->mend[j]; z++)
        msum += world->param0[z];
      probm += line * msum;
      probth += line *(line-1.) / world->param0[j];
    }
  return probth + probm;
}

// do we accept parameter update
boolean
bayes_accept (double newval, double oldval, double heat)
{
  double diff = (newval - oldval) * heat;
  if (diff > 0.0)
    return TRUE;
  if (log (RANDUM ()) < diff)
    return TRUE;
  else
    return FALSE;
}

double
propose_newparam (double param,
                  double delta, double minparam, double maxparam)
{
  double r = RANDUM ();
  double sign = RANDUM () < 0.5 ? -1. : 1.;
  double np = param + sign * r * delta;
  if (np < minparam)
    return minparam - np;
  if (np > maxparam)
    return np - maxparam;
  return np;
}

long
bayes_update (world_fmt * world)
{
  double oldval = world->bayes->oldval;
  long ba=0;
  long j;
  long i = world->bayes->paramnum;
  double oldparam;
  double newval;
  double newparam;
  if(!strchr("c0",world->options->custm2[world->bayes->paramnum]))
    {
      newparam = propose_newparam (world->param0[i],
                                   world->bayes->delta[i],
                                   world->bayes->minparam[i],
                                   world->bayes->maxparam[i]);
      oldparam = world->param0[i];
      world->param0[i]=newparam;
      newval =probg_treetimes(world);
      //printf ("***%f %f %f %li\n",newval,oldval[i], world->likelihood[world->G], i);
      if(bayes_accept(newval, oldval,world->heat[0]))
        {
          world->bayes->oldval = newval;
          precalc_world(world);
          ba = 1;
        }
      else
        {
          world->param0[i] = oldparam;
          ba = 0;
        }
    }
  world->bayes->paramnum++;
  if (world->bayes->paramnum >= world->numpop2)//does not work with gamma deviated mutation rates yet
    world->bayes->paramnum = 0; //reset the parameter choosing cycle
  return ba;
}

void bayes_save(world_fmt *world)
{
  long i;
  long pnum = world->bayes->numparams;
  long allocparams = world->bayes->allocparams;
  world->bayes->params[pnum][0] = probg_treetimes(world) + world->likelihood[world->G];
  memcpy(&world->bayes->params[pnum][1], world->param0,sizeof(double)*world->numpop2);
  //DEBUG
  for(i=0; i<world->numpop2+1;i++)
    fprintf(stderr,"%f ",world->bayes->params[pnum][i]);
  fprintf(stderr,"\n");

  pnum++;
  if(pnum>=allocparams)
    {
      allocparams += 1000;
      world->bayes->params = (double **) realloc(world->bayes->params,sizeof(double*)*allocparams);
      for(i=pnum;i<allocparams;i++)
        world->bayes->params[i] = (double *) calloc(world->numpop2+1,sizeof(double));
    }
  world->bayes->numparams = pnum;
  world->bayes->allocparams = allocparams;
}

void bayes_init(bayes_fmt *bayes, long size)
{
  bayes->oldval = -DBL_MAX;
  bayes->allocparams = 1;
  bayes->numparams = 0;
  bayes->paramnum = 0;
  bayes->delta = calloc(size,sizeof(double));
  bayes->minparam = calloc(size,sizeof(double));
  bayes->maxparam = calloc(size,sizeof(double));
  bayes->params = calloc(1,sizeof(double *));
  bayes->params[0] = calloc(size+1,sizeof(double));
}

void bayes_fill(world_fmt *world, option_fmt *options)
{
  long i;
  for(i=0; i< world->numpop;i++)
    {
      world->bayes->delta[i] = 0.001;
      world->bayes->minparam[i] = SMALLEST_THETA;
      world->bayes->maxparam[i] = BIGGEST_THETA;
    }
  for(i=world->numpop; i< world->numpop2;i++)
    {
      world->bayes->delta[i] = 10;//data dependent and certainly bad for ep data
      world->bayes->minparam[i] = SMALLEST_MIGRATION;
      world->bayes->maxparam[i] = BIGGEST_MIGRATION;
    }
  //	memcpy(world->bayes->delta, options->bayes->delta,sizeof(double)*world->numpop2);
  //	memcpy(world->bayes->minparam, options->bayes->minparam,sizeof(double)*world->numpop2);
  //	memcpy(world->bayes->maxparam, options->bayes->maxparam,sizeof(double)*world->numpop2);
}

void bayes_free(world_fmt *world)
{
  long i;
  free(world->bayes->delta);
  free(world->bayes->minparam);
  free(world->bayes->maxparam);
  for(i=world->bayes->allocparams; i > 0; i--)
    free(world->bayes->params[i]);
  free(world->bayes->params);
  //   free(world->bayes);
}

void bayes_stat(world_fmt *world, long size)
{
  long i, j;
  bayes_fmt *bayes = world->bayes;

  for(i=0; i< bayes->numparams; i++)
    {
      for(j=0; j< world->numpop2+1; j++)
        {
          fprintf(world->bayesfile, "%f ", bayes->params[i][j]);
        }
      fprintf(world->bayesfile, "\n");
    }
  //average:
  //mode:
  //credibility interval:
}


#endif /*bayesupdate*/

