#ifndef MIGRATE_DEFINITION
/*definitions.h*/
#define MIGRATE_DEFINITION
/*-----------------------------------------------------------------
  Maximum likelihood estimation of migration rates 
  using coalescent trees
 
  Peter Beerli
  Genetics 357360
  University of Washington
  Seattle, WA 98195-7360, USA
  beerli@genetics.washington.edu
 
  With help of Joe Felsenstein (joe@genetics.washington.edu),
  Mary Kuhner and Jon Yamato (mkkuhner@genetics.washington.edu)
 
  
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: definitions.h,v 1.65 2001/09/07 23:56:13 beerli Exp $
 
  *----------------------------------------------------------------
  */
#ifndef MIGRATEVERSION
#define MIGRATEVERSION "1.5"
#endif

#define MAINTAINER "Peter Beerli <beerli@genetics.washington.edu>"
/*------------------------------------------------
  Adjusting the source to the system configuration
*/
#ifdef HAVE_CONFIG_H
#include "conf.h"
#endif
/* we don't want to have the sun specific define of "sun"*/
#ifdef sun
#undef sun
#endif

#define FGETS  myfgets

#ifdef __MWERKS__
#include "conf.h"
#undef HAVE_LGAMMA
#define HAVE_STRFTIME 1
#define HIGHBITS
#define LAMARC_MALLOC
#ifdef macintosh
#define MAC
#include <ansi_prefix.mac.h>	/*fixes time problems */
#else /*macintosh */
#define DOS
#undef HAVE_STRINGS_H
#undef HAVE_LGAMMA
#endif /*windows */
#endif /*MWERKS*/
/* we have found no strftime() and replace the time
   output with blanks*/
#ifndef HAVE_STRFTIME
#define NOTIME_FUNC
#endif
#define INFILE "infile"
#define WEIGHTFILE "weightfile"
#define CATFILE "catfile"
#define SEEDFILE "seedfile"
#define PARMFILE "parmfile"
#define OUTFILE "outfile"
#define LOGFILE "logfile"
#define TREEFILE "treefile"
#define UTREEFILE "usertree"
#define INTREE "intree"
#define OUTTREE "outtree"
#define MATHFILE "mathfile"
#define SUMFILE "sumfile"
#define MIGHISTFILE "mighistfile"
#define DISTFILE "distfile"
#define GEOFILE "geofile"
#define BOOTFILE "bootstrapfile"
#define UEPFILE "uepfile"
#define AICFILE "aicfile"
#define BAYESFILE "bayesfile"
#ifdef __STDIO_LOADED
#define VMS
#define MACHINE_TYPE "VAX/VMS C"
#define printf vax_printf_is_broken
#define fprintf vax_fprintf_is_broken
void vax_printf_is_broken (const char *fmt, ...);
void vax_fprintf_is_broken (FILE * fp, const char *fmt, ...);
void vax_tweak_fmt (char *);
#define signed			/* signed doesn't exist in VMS */
#endif /*__STDIO_LOADED*/


/* includes: */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <string.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#ifdef MAC
#include "mac_interface.h"
#endif /*MAC*/
#include <time.h>
#include <math.h>
#include <limits.h>
#include <signal.h>
#ifdef __MWERKS__
#undef DBL_EPSILON
#undef DBL_MAX
#include <float.h>
#endif /*__MWERKS__*/
#ifdef HAVE_MALLOCWRAP
/*if we use this then we guard against allocation problems */
/* redefinitions of calloc, malloc, realloc are in sighandler.h*/
#define LAMARC_MALLOC
#endif

#ifdef HAVE_DEBUGMPI
/* add print messages to mpi commands */
#define DEBUG_MPI
#endif

#ifdef HAVE_LGAMMA
#define LGAMMA lgamma
#else
#define LGAMMA mylgamma
#endif

#include "sighandler.h"
#define FClose(file) if (file) fclose(file) ; file=NULL
typedef unsigned char boolean;

#ifndef TRUE
#define TRUE    (boolean) 1
#endif

#ifndef FALSE
#define FALSE   (boolean) 0
#endif

#define SETBITS 32
/* for snp data with panel see sequence.c*/
#define FIRST 0
/* the first population is the panel for snps*/
#define PANEL 0
#define SEQUENCETYPES "snuf"	/*s=sequence,n=linked snp, u=unlinked snp, f=ancestral reconstruction */
#define SNPTYPES      "nu"
#define ALLELETYPES   "amb"	/*a=infinite allele,m=stepwise, b=brownian */

#define CRLF "\r\n"

#ifdef COMPAQ
#define EXP(a)  (((a)< -100) ? 0.0 : exp ((a)))
#else
#define EXP(a)  exp ((a))
#endif

// I was experimenting with a fast log implementation
// but it is
//not fast enough #define LOG(a) ((double) fast_log(((float) a)))
// so back to standard log
#define LOG(a) log((a))

/* defines for speedier calc_like when we do NOT use undefined SLOWNET*/
#ifdef SLOWNET
#define CALCLIKE (*calc_like)
#define CALCGRADIENT (*calc_gradient)
#define SETUPPARAM0 (*setup_param0)
#else
#define CALCLIKE calc_loci_like
#define CALCGRADIENT combine_gradient
#ifdef MPI
#define SETUPPARAM0 setup_parameter0_mpi
#else
#define SETUPPARAM0 setup_parameter0_standard
#endif
#endif
/*=================================================================
  SPECIFIC FOR MIGRATE
 
  *----------------------------------------------------------------
  + = works
  - = not yet implemented (needed?)
 
  */
/* number of k int k-allele model, the number
   MUST really be bigger than the number of 
   observed alleles, much bigger does not harm	*/
#define MAXALLELES            93
#define MAXBUFSIZE        100000
#define LINESIZE            1024	/* setting this smaller can break */
#define LONGLINESIZE       10000	/* setting this smaller can break */
#define STRSIZE              255	/* setting this smaller can break */
#define DEFAULT_NMLENGTH      10	/* length of individual names */
#define DEFAULT_ALLELENMLENGTH 6	/* length of allele names */
#define DEFAULT_POPNMLENGTH  100	/* length of world names */
#define NUMPOP 2
#define BURNINPERIOD 10000
#define SCALEINTERVAL 5
#define DEFAULTALLOCSIZE 2
/* don't change below here ------------------------------------
   some other constants */
/* numerical borders and epsilons*/
#define SMALL_VALUE       10e-21
#define EPSILON         0.000001	/* a small number */
#define EPSILON4        0.000099	/* another small number */
#define SMALLEPSILON       1e-15	/* a smaller number */
#define BIGEPSILON         0.001	/* a not so small number */
#define LONGCHAINEPSILON  10e100	/* an unreasonable big number,

so that the given number of
long chains is used */
#define GELMAN_MYSTIC_VALUE 1.2
#define PLUSCHAIN 10
#ifndef MAXLONG
#define MAXLONG ((long)0x7fffffff)
#endif
#ifndef DBL_EPSILON
#include <float.h>
#ifndef DBL_EPSILON
#define DBL_MAX ((double)1.7976931348623157e308)
#define DBL_EPSILON 2.2204460492503131e-16
#endif
#endif
/* some math constants */
#define LOGDBL_EPSILON -36.04365338911715608	/*N[Log[DBL_EPSILON] ,30] */
#define LOG1 0.
#define LOG2 0.693147180559945309417232121458	/*N[Log[2] ,30] */
#define LOG2PIHALF -0.918938533204672741780329736406	/*N[Log[1/Sqrt[2 Pi]] ,30] */
#define TWOPI 6.28318530717958647692528676656	/*N[Log[2 Pi] ,30] */
#define ROOTLENGTH         10000
#define FIRSTCHAIN            -1
#define FIRSTSTEP             -1
/* min/max functions */
#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif
#define MYMIN3(a,b,c) (((a)<(b))&&((a)<(c)) ? (a) : (((b)<(c)) ? (b) : (c)))
#define MYMAX3(a,b,c) (((a)>(b))&&((a)>(c)) ? (a) : (((b)>(c)) ? (b) : (c)))
/*string conversion functions
  these replace all the atoi atol etc and use the strto[lif] function*/
#define ATOL(a) strtol((a),(char **) NULL, 10)
#define ATOI(a) strtol((a),(char **) NULL, 10)
#define ATOF(a) strtod((a),(char **) NULL, 10)
/* theta (4 Ne mu) related material */
#define SMALLEST_THETA	   1e-10
#define BIGGEST_THETA	     1e4
#define SMALLEST_MIGRATION 1e-10
#define BIGGEST_MIGRATION   10e9
// defines the value that is used as a minimum summary statistic for migraiton events on all trees
// version 1.2.4 had a value of 0.00000001, it seems that values of 0.1 are too large.
#define MINMIGSUMSTAT 0.001
/* the migration limit is per population, should be plenty
   for moderate sample sizes */
#define MIGRATION_LIMIT     5000
#define SMALLEST_PROB     1e-100
#define SMALLEST_GAMMA      1e-3
#define BIGGEST_GAMMA        1e9
#define FRACTION_ALONG      0.66
#define TIMELIST_GUESS       100
#define SAMPLETREE_GUESS       1
#define START_ALPHA          10.0
/* random material */
#define AUTO                   0	/*+ use time() for seed */
#define NOAUTO                 1	/*+ seed in parmfile   */
#define NOAUTOSELF             2	/*+ seed in seedfile   */
/* definitions for the first theta0 values */
#define OWN                    0	/*+ start values in parmfile */
#define WATTERSON              1 /*- start values are Watterson estimate*/
#define EWENS                  2 /*- start values are Ewens estimate*/
#define FST                    3	/*+ start values are FST estimate */
#define RANDOMESTIMATE         4	/*+ start values are RANDOM estimate */
#define PARAMGRID              5	/*+ use a range of values + replicate=yes:# */
/* defines for the migration0 values */
/* define OWN                  0   + start values in parmfile */
/* define FST                  3   + start values are FST estimates*/
/* define RANDOMESTIMATE       4   + start values are RANDOM estimate*/
#define SLATKIN                1 /*- start values with slatkin's method*/
/* definitions for the type of FST we use*/
#define THETAVARIABLE         'T'
#define MVARIABLE             'M'
/* definitions for the sankoff procedure */
/* the SANKOFF_DELTA should be smaller than any cost_ij*/
#define SANKOFF_DELTA 0.1
/* Maximizer and gamma things */
#define STD22 1.0 /*0.1*/  /*"standard deviation" for penalizer 2*std*std=2*0.223607^2 */
#define STD2 1.0 /*0.05*/  /* std*std = 0.223607^2 */
#define LOGSTD 0.0 /*-1.49786613677699549672*/ /*LOG(std)*/
//#define INVTWOSQRTPILOGSTD /*0.57892760357232275494*/ /* log(1/(std sqrt[2 pi])) */
#define INVTWOSQRTPILOGSTD -0.91893853320467274178
#define NTRIALS             1000
#define LOCI_NORM          0.00001
#define GAMMA_INTERVALS       10
/* definitions of migration model */
#define MATRIX                 1	/*+ */
#define MATRIX_SYMMETRIC      11	/*+ */
#define MATRIX_SAMETHETA      12	/*+ */
#define MATRIX_ARBITRARY      13	/*+ */
#define ISLAND                 2	/*+ */
#define ISLAND_VARTHETA       21	/*+ */
#define STEPSTONE              3 /*- */
#define CONTINUUM              4 /*- */
#define NEIGHBOR               5 /*- */
/* replication stuff */
#define SINGLECHAIN            0	/*+ */
#define MULTIPLECHAIN          1	/*+ */
#define MULTIPLERUN            2	/*+ */
/* heating stuff */
#define HEATED_CHAIN_NUM       4
#define HEATED_THREAD_NUM      4
#define COLD                   1	/*+ */
#define WARM                   4	/*+ */
#define HOT                    7	/*+ */
#define VERYHOT                10	/*+ */
/* maximization material*/
#define SINGLELOCUS            0	/*+ */
#define MULTILOCUS             1	/*+ */
#define PROFILE                2	/*+ */
/* print and plot material*/
#define MAXPRINTVALLENGTH 16	/*+ maximal number of printpos */
#define PLOTALL                0	/*+ plot to outfile and mathfile */
#define PLOTOUTFILE            1	/*+ plot only to outifle */
#define PLOT4NM                0	/*+ use 4Nm instead of M=m/mu */
#define PLOTM                  1	/*+ use M=m/mu */
#define PLOTSCALELOG           0	/*+ plot scale in log 10 units */
#define PLOTSCALESTD           1	/*+ plot scale standard units */
#define PLANEINTERVALS        36	/*+ intervals for plot */
#define PLANESTART        0.0001	/*+ plot axes start */
#define PLANEEND           100.0	/*+ plot axes end */
#define PAGEFEED               fprintf(outfile,"\n\f\n")
#define PAGEFEEDWORLD               fprintf(world->outfile,"\n\f\n")
#define PAGEFEEDW                   fprintf(universe[0]->outfile,"\n\f\n")
#define START                  0
#define STOP                   1
#define CONT                   3
/* tree-print options */
#define NONE                   0	/*+ */
#define ALL                    1	/*+ */
#define BEST                   2	/*+ */
#define LASTCHAIN              3	/*+ */
/* likelihood ration stuff*/
#define LRATIO_STRINGS      1000	/*+ */
/* profile likelihood stuff*/
/* ALL and NONE are alread defined*/
#define TABLES                 2	/*+ */
#define SUMMARY                3	/*+ */
#define MAX_PROFILE_TRIALS   100	/*+ */
/* likelihood ratio stuff*/
#define MLE 0
#define ARBITRARY 1
#define MAXPOP   100		/*n*(n-1)+n) */
#define MAXPARAM 10000
#define HEADER 1
#define NOHEADER 0
/* migration histogram material*/
#define MIGHIST_ELEM 5
#define MIGHIST_YSIZE 30
/* stop while loops after some time*/
#define PANIC_MAX           1000
/* microsatellite stuff*/
#define MICRO_THRESHOLD       10
#define MAX_MICROSTEPNUM     200
#define XBROWN_SIZE            3
/* sequence stuff*/
#define MAXCATEGS              9
#define MANYCATEGS             2
#define ONECATEG               1

#ifdef MEMDEBUG
#include <memdebug.h>
#endif
#endif /*definitions */
