#ifndef __ALTIVEC_INCLUDE__
#define __ALTIVEC_INCLUDE__
// ALTIVEC specific utility functions
// tips from Doug
// from http://home.san.rr.com/altivec/Pages/TipArchive.html
//First we have the two missing logical operators:
#define vec_not(A) vec_nor(A,A)
#define vec_nand(A,B) vec_not(vec_and(A,B))

//Next we have the missing arithmetic operators:
#define vec_abs(A) vec_sel(A,vec_sub( vec_sub(A,A),A),vec_cmpgt(vec_sub(A,A),A))
#define vec_2sComp(x) vec_sub(vec_sub(x,x), x)
//Finally here a two of the missing multiplies:
#define vec_halfmul_16(A,B) vec_mladd(A,B,vec_sub(A,A))
#define vec_halfmul_8(A,B) vec_mergel(vec_pack(vec_mule(A,B),vec_mule(A,B)),vec_pack(vec_mulo(A,B),vec_mulo(A,B)))

typedef union {
    float f[4];
    vector float v;
  } FloatVec;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//functions
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/* load a single float and spread it to all vector elements */
extern inline vector float load_float_splat(float *thisptr);
extern inline vector float vec_zero(void);
extern inline vector float vec_float_one(void);
extern inline void load_double_floatvec(FloatVec *out, double *in, long size);

#endif /*ALTIVEC_INCLUDE*/
