#ifndef WORLD_INCLUDE
#define WORLD_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 W O R L D   R O U T I N E S 
 
 creates tree structures,
 calculates smple parameter estimates (FST,...)
 reads tree [has to be done]
 
 prints results,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: world.h,v 1.20 2001/07/25 19:27:24 beerli Exp $
 
-------------------------------------------------------*/

#include "migration.h"
extern void create_world (world_fmt ** world, char name[], long loci);
extern void init_world (world_fmt * world, data_fmt * data,
                          option_fmt * options);
extern void increase_timearchive (world_fmt * world, long locus, long sample,
                                    long numpop, long rep);

extern void calc_simple_param (world_fmt * world, data_fmt * data);
extern void set_bounds (long *increment, long *steps, long *chains,
                          const option_fmt * options, const char type);
extern void print_menu_locus (world_fmt * world, long locus);
extern void print_menu_chain (char type, long chain, long steps,
                                world_fmt * world, option_fmt * options,
                                long rep);
extern void print_menu_coalnodes (FILE * file, world_fmt * world, long G,
                                    long rep);
extern void heating_ratio (world_fmt * world);
extern void burnin_chain (world_fmt * world);
extern void print_finish (world_fmt * world, long filepos);
extern void copy_time (world_fmt * world, timelist_fmt * ltl, long from,
                         long to, long np, long rep);
//void copy_atl (world_fmt * world, long rep, timearchive_fmt * old, timearchive_fmt * new,
//       long steps, long locus);
extern void create_loci_plot (world_fmt * world, char ***plane,
                                nr_fmt * nr, long loci);
extern void create_locus_plot (world_fmt * world, char ***plane, nr_fmt * nr,
                                 long G);
extern void print_simresults (world_fmt * world);
extern void print_list (world_fmt ** universe, option_fmt * options,
                          data_fmt * data);
extern void cleanup_world (world_fmt * world, long locus);
extern void free_universe (world_fmt ** worlds, long numworlds);
extern void test_locus_like (nr_fmt * nr, double *param0, double *param1,
                               long df, long locus, world_fmt * world,
                               long *maxwhich, long maxnum, boolean withhead,
                               char *this_string);
extern void test_loci_like (nr_fmt * nr, double *param0, double *param1,
                              long df, long loci, world_fmt * world,
                              long *maxwhich, long maxnum, boolean withhead,
                              char *this_string);


extern void precalc_world (world_fmt * world);
extern void klone (world_fmt * original, world_fmt * kopie,
                     option_fmt * options, data_fmt * data, double temperature);
extern void klone_part (world_fmt * original, world_fmt * kopie,
                          option_fmt * options, data_fmt * data, double temperature);
extern void clone_polish (world_fmt * original, world_fmt * kopie);
extern long chance_swap_tree (world_fmt * tthis, world_fmt * that);
extern void advance_clone_like (world_fmt * world, long accepted, long *j);
extern void polish_world (world_fmt * world);
extern void fill_worldoptions (worldoption_fmt * wopt, option_fmt * options);
extern void fill_worlddata (worlddata_fmt * wdata, data_fmt * data);
extern void print_alpha_curve (world_fmt * world, timearchive_fmt ** atl, long *gmaxptr);
extern void print_cov (world_fmt * world, long numpop, long loci, double ***cov);


extern void print_mighist (world_fmt * world);
//=================================
#include "reporter.h"


#endif /*WORLD_INCLUDE */
