/* -----------------------------------------------------
   sighandler.c                         
   handels to following signals:                
   SIGIOT         Input  Output problems             
   SIGIRAP        Over  Underflow, 0 divide          
   SIGFPE         Floating point exceptions         
   SIGBUS         Bus error                 
   SIGSEGV        Segmentation fault                
   SIGXCPU        CPU time limit exceeded           
   SIGXFSZ        File size limit exceeded          
   SIGILL         Illegal instruction                       
   SIGUSR1        User signal 1                             
   if most of those exception are encountered the system     
   tries to exit gracefully, but with some it dies          
   anyway, but tries to say why in a way which is      
   for humans better understandable  (I hope)                       
   -----------------------------------------------------     
   part of the migrate                   
 
   Copyright 1996-2002 Peter Beerli
    This software is distributed free of charge for non-commercial use
 and is copyrighted. Of course, we do not guarantee that the software
 works and are not responsible for any damage you may cause or have.
 
   $Id: sighandler.c,v 1.16 2002/06/20 06:25:38 beerli Exp $                  
   ----------------------------------------------------- */
//#include <stdio.h>
#ifndef __MWERKS__
#include <sys/types.h>
#endif
#ifdef __NEXT__
#include <libc.h>
#endif
#include <stdarg.h>
#include <signal.h>
#include <stdarg.h>
#include "migration.h"
#ifdef MPI
#include "migrate_mpi.h"
#endif

#ifdef DMALLOC_FUNC_CHECK
#include <dmalloc.h>
#endif
#ifdef WATCOM
#define __MWERKS__
#endif
#undef debug

extern int myID;


void
signalhandling (long switcher)
{
    if (switcher == ON)
    {
#ifndef __MWERKS__
        signal (SIGIOT, signalhandler);
        signal (SIGTRAP, signalhandler);
        signal (SIGBUS, signalhandler);
        signal (SIGUSR1, signalhandler);
#ifndef SYSTEM_V

        signal (SIGXCPU, signalhandler);
        signal (SIGXFSZ, signalhandler);
#endif
#endif

        signal (SIGFPE, signalhandler);
        signal (SIGSEGV, signalhandler);
        signal (SIGILL, signalhandler);
    }
    else
    {
#ifndef __MWERKS__
        signal (SIGIOT, SIG_DFL);
        signal (SIGTRAP, SIG_DFL);
        signal (SIGBUS, SIG_DFL);
        signal (SIGUSR1, SIG_DFL);
#ifndef SYSTEM_V

        signal (SIGXCPU, SIG_DFL);
        signal (SIGXFSZ, SIG_DFL);
#endif
#endif

        signal (SIGFPE, SIG_DFL);
        signal (SIGSEGV, SIG_DFL);
        signal (SIGILL, SIG_DFL);
    }
}

void
signalhandler (int sig)
{
    fputc ('\040', stderr);
    fflush (NULL);

    switch (sig)
    {
#ifndef __MWERKS__
    case SIGIOT:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "\nSEVERE ERROR: Input/Output problem!\n");
        fprintf (stderr,
                 "              Most likely a fatal error in the infile or parmfile\n\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    case SIGTRAP:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: Trace trap\n");
        fprintf (stderr,
                 "              there was an an overflow/underflow/0 divide problem\n");
        fprintf (stderr, "              or some other problems.\n");
        fprintf (stderr,
                 "              But check your infile for errors, too.\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    case SIGBUS:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: Bus problems\n");
        fprintf (stderr,
                 "              this results in an non recoverable crash\n");
        fprintf (stderr,
                 "              But check your infile for errors, too.\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    case SIGXCPU:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: This program has a time limit?\n");
        fprintf (stderr, "              We didn' program in a time limit,\n");
        fprintf (stderr,
                 "              report this error to your system administrator, please.\n");
        exit (sig);
        break;
    case SIGXFSZ:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: This program has a file size limit?\n");
        fprintf (stderr,
                 "              We didn't program in a file size limit,\n");
        fprintf (stderr,
                 "              report this error to your system administrator, please.\n");
        exit (sig);
        break;
    case SIGUSR1:
#ifdef MPI

        fprintf(stderr, "On node %i happened a USER (?) SIGNAL\n", myID);
        exit(sig);
#endif
        //      warning ("\nUser signal received and ignored\n\n");
        break;

#endif

    case SIGFPE:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: Floating point exception\n");
        fprintf (stderr,
                 "              There was an integer/floating point problem\n");
        fprintf (stderr,
                 "              Often this is a division by zero. If you dataset is moderately sized\n");
        fprintf (stderr,
                 "              this is most likely an error in you data (infile).\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    case SIGSEGV:
#ifdef MPI

        fprintf (stderr, "SEVERE ERROR: Segmentation fault on Node **%i**\n",
                 myID);
#else

        fprintf (stderr, "SEVERE ERROR: Segmentation fault\n");
#endif

        fprintf (stderr,
                 "              this results in an non recoverable crash.\n");
        fprintf (stderr,
                 "              But check the datatype and your infile for errors, too.\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    case SIGILL:
#ifdef MPI

        fprintf(stderr, "On node %i happened a", myID);
#endif

        fprintf (stderr, "SEVERE ERROR: Illegal instruction!\n");
        fprintf (stderr, "              this is maybe a programming error.\n");
        fprintf (stderr,
                 "              But check your infile for errors, too.\n");
        fprintf (stderr,
                 "              Please report error with as much detail as possible to\n");
        fprintf (stderr, "              %s\n\n", MAINTAINER);
        exit (sig);
        break;
    default:
        break;
    }
#ifndef __MWERKS__
    signal (SIGIOT, signalhandler);
    signal (SIGTRAP, signalhandler);
    signal (SIGUSR1, signalhandler);
    signal (SIGBUS, signalhandler);
#ifndef SYSTEM_V

    signal (SIGXCPU, signalhandler);
    signal (SIGXFSZ, signalhandler);
#endif
#endif

    signal (SIGFPE, signalhandler);
    signal (SIGSEGV, signalhandler);
    signal (SIGILL, signalhandler);

}

void
warning (char string[], ...)
{
    va_list args;
    fprintf (stdout, "WARNING: ");
    va_start (args, string);
    vfprintf (stdout, string, args);
    va_end (args);
}

void
usererror (char string[], ...)
{
    va_list args;
    fprintf (stdout, "\nERROR: ");
    va_start (args, string);
    vfprintf (stdout, string, args);
    va_end (args);
    exit (EXIT_FAILURE);
}

void
sig_error (char string[], char filename[], long line)
{
    fprintf (stdout, "\nIn file %s on line %li\n%s\n", filename, line, string);
    exit (-11);
}

char *
myfgets (char *buffer, long bufsize, FILE * infile)
{
    long count = 0;
    char ch = '\0';
    bufsize--;
    while (!(ch == '\r' || ch == '\n') && count < bufsize)
    {
        ch = fgetc (infile);
        buffer[count] = ch;
        count++;
    }
    //buffer[count]=ch;
    if (ch == '\r')
    {
        ch = fgetc (infile);
        if (ch != '\n')
            ungetc (ch, infile);
    }
    buffer[count - 1] = '\0';
    return buffer;
}

#ifdef NEXTAPP
void
malloc_error_found (int value)
{
    switch (value)
    {
    case 0:
        fprintf (stderr, "vm_allocate failed\n");
        break;
    case 1:
        fprintf (stderr, "vm_deallocate failed\n");
        break;
    case 2:
        fprintf (stderr, "vm_copy failed\n");
        break;
    case 3:
        fprintf (stderr,
                 "I tried to reallocate or free space which was already freed\n");
        break;
    case 4:
        fprintf (stderr, "Internal memory verification in heap failed\n");
        break;
    case 5:
        fprintf (stderr,
                 "I tried to reallocate or free space which was never allocated\n");
        break;
    default:
        fprintf (stderr, "huh, what malloc error was this?\n");
        break;
    }
    errno = ENOMEM;
}
#endif


/* save memory routines, this routines are used
   with defines in migration.h, DO NOT move this part somewhere else */
#ifdef LAMARC_MALLOC
#undef malloc
#undef realloc
#undef calloc
#undef free

void *
LAMARC_malloc (const unsigned long size, const char file[], const long line)
{
    void *x;
    x = malloc (size);
    if (x == NULL)
    {
        fprintf (stderr,
                 "ERROR in memory allocation (malloc(%li)) in file %s on line %li\n",
                 size, file, line);
        exit (-1);
    }
    return x;
}


void *
LAMARC_calloc (const unsigned long repeats, const unsigned long size,
               const char file[], const long line)
{
    void *x;
    x = calloc (repeats, size);
    if (x == NULL)
    {
        fprintf (stderr,
                 "ERROR in memory allocation (calloc(%li,%li)) in file %s on line %li\n",
                 repeats, size, file, line);
        exit (-1);
    }
    return x;
}

void *
LAMARC_realloc (void *ptr, const unsigned long size, const char file[],
                const long line)
{
    void *x;
    x = realloc (ptr, size);
    if (x == NULL)
    {
        fprintf (stderr,
                 "ERROR in memory allocation (realloc(ptr,%li)) in file %s on lin %li\n",
                 size, file, line);
        exit (-1);
    }
    return x;
}


#endif /*LAMARC_MALLOC */
