//
// ALTIVEC specific utility functions
// tips from Doug
// from http://home.san.rr.com/altivec/Pages/TipArchive.html
//First we have the two missing logical operators:
#ifdef ALTIVEC
#include "migration.h"
#include "altivec.h"

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//functions
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/* load a single float and spread it to all vector elements */
vector float load_float_splat(float *thisptr)
{
    vector unsigned char tempc;
    vector float temp;
    temp = vec_lde(0,thisptr);
    tempc  = vec_lvsl(0,thisptr);
    temp  = vec_perm(temp,temp,tempc);
    return vec_splat(temp,0);
}

inline vector float vec_zero(void)
{
    return vec_ctf(vec_splat_u32(0),0);
}

inline vector float vec_float_one(void)
{
    return vec_ctf(vec_splat_u32(1),0);
}

inline void load_double_floatvec(FloatVec *out, double *in, long size)
{
    long i;
    float *tmp = calloc(size, sizeof(float));
    for(i=0; i < size; i++)
        tmp[i] = (float) in[i];
    memcpy(out,tmp,sizeof(float)*size);
    free(tmp);
}


#endif /*ALTIVEC*/
