#ifndef SEQUENCE_INCLUDE
#define SEQUENCE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 S E Q U E N C E S   R O U T I N E S 
 
 
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: sequence.h,v 1.13 2002/06/20 06:25:38 beerli Exp $
-------------------------------------------------------*/

extern void initratio (option_fmt * options);
extern void initfreqs (double *freqa, double *freqc, double *freqg,
                           double *freqt);
extern void initcatn (long *categs);
extern boolean initcategs (long categs, double *rate, double *probcat);
extern void initprobcat (long categs, double *probsum, double *probcat);
extern void initlambda (option_fmt * options);

extern void init_sequences (world_fmt * world, option_fmt * options,
                                data_fmt * data, long locus);
extern void init_sequences2 (world_fmt * world, seqmodel_fmt * seq,
                                 long locus);
extern void init_tbl (world_fmt * world, long locus);
extern void print_weights (FILE * outfile, world_fmt * world,
                               option_fmt * options, long locus);
extern void print_tbl (FILE * outfile, world_fmt * world,
                           option_fmt * options, long locus);
extern void print_seqfreqs (FILE * outfile, world_fmt * world,
                                option_fmt * options);
extern double treelike_seq (world_fmt * world, long locus);
extern double treelike_snp (world_fmt * world, long locus);
extern void snp_invariants (contribarr invariants, long endsite, long rcategs,
                                seqmodel_fmt * seq, phenotype x1);
extern void make_sequences (world_fmt * world, option_fmt * options,
                                data_fmt * data, long locus);
extern void make_invarsites (world_fmt * world, data_fmt * data, long locus);
extern void make_invarsites_unlinked (world_fmt * world, data_fmt * data,
                                          long locus);
extern void make_snp (world_fmt * world, option_fmt * options,
                          data_fmt * data, long locus);
extern double treelike_snp_unlinked (world_fmt * world, long locus);
extern void copy_seq (world_fmt * original, world_fmt * kopie);
extern void init_sequences_aliases (world_fmt * world, option_fmt * options,
                                        data_fmt * data, long locus);

#endif /*SEQUENCE_INCLUDE */
