/* Joint chain estimator
Peter Beerli January 2000
 
 
like(param) = Sum_g^G   ( p(g|param)/ L(param_j))
 
denom = Sum_j^chains (n_j P(g|param0_j) / L(param_j)
 
- pick param
- calc chainparamlike
- solve paramlike iteratively
- maximize paramlike
 
 Copyright 2001 Peter Beerli and Joseph Felsenstein
 
 This software is distributed free of charge for non-commercial use
 and is copyrighted. Of course, we do not guarantee that the software
 works and are not responsible for any damage you may cause or have.
 
 This software is distributed free of charge for non-commercial use
 and is copyrighted. Of course, we do not guarantee that the software
 works and are not responsible for any damage you may cause or have.
 
$Id: joint-chains.c,v 1.21 2002/06/20 06:25:34 beerli Exp $
*/
#include "migration.h"
#include "broyden.h"
#include "combroyden.h"

#define EPSILON5 0.00001

void create_multiapg0 (double *apg0, nr_fmt * nr, long rep, long locus);

void
create_multiapg0 (double *apg0, nr_fmt * nr, long rep, long locus)
{
    long g, r;
    //  double lsteps = log((double) nr->world->options->lsteps) ;
    double *tmp;
    double tmpmax;
    double reps = log (nr->repstop - nr->repstart);
    //  long copies;
    tmp = (double *) calloc (nr->repstop, sizeof (double));
    for (g = 0; g < nr->world->atl[rep][locus].T; g++)
    {
        tmpmax = -DBL_MAX;
        for (r = nr->repstart; r < nr->repstop; r++)
        {
            tmp[r] = -reps +
                     probG (nr->world->atl[r][locus].param0,
                            nr->world->atl[r][locus].lparam0,
                            &nr->world->atl[rep][locus].tl[g], nr, locus)
                     - (nr->world->chainlikes[locus][r]);

            if (tmp[r] > tmpmax)
                tmpmax = tmp[r];
        }
        apg0[g] = 0.0;
        for (r = nr->repstart; r < nr->repstop; r++)
            apg0[g] += EXP (tmp[r] - tmpmax);
        apg0[g] = log (apg0[g]) + tmpmax;
    }
    free (tmp);
}


void
interpolate_like (nr_fmt * nr, long locus)
{
    double *newlike, *lparam;
    double *diff, *oldiff;
    boolean alldone;
    long j, z, r;
    long repdiff = nr->repstop - nr->repstart;
    double delta = 0.;

    boolean diffdone;
    double *oldlike;
    double *chainlike = nr->world->chainlikes[locus];
    oldlike = (double *) calloc (repdiff, sizeof (double));
    memcpy (oldlike, chainlike, sizeof (double) * repdiff);

    newlike = (double *) calloc (repdiff, sizeof (double));
    diff = (double *) calloc (repdiff, sizeof (double));
    oldiff = (double *) calloc (repdiff, sizeof (double));
    lparam = (double *) calloc (nr->numpop2, sizeof (double));
    /* following material is reverse logistic regression
       a la Geyer 1994 */
    z = 0;
    alldone = FALSE;
    memset (oldiff, 0, sizeof (double) * repdiff);
    //  log_param0 (nr->atl[j][locus].param0, lparam, nr->numpop2);
    while (!alldone && z++ < 10000)
    {
        alldone = TRUE;
        for (r = nr->repstart; r < nr->repstop; r++)
            create_multiapg0 (nr->apg0[r][locus], nr, r, locus);
        for (j = nr->repstart; j < nr->repstop; j++)
        {
            newlike[j] = calc_locus_like (nr, nr->atl[j][locus].param0,
                                          nr->atl[j][locus].lparam0, locus);
            //newlike[j] = norm_constant(nr, nr->atl[j][locus].param0,
            //     nr->atl[j][locus].lparam0, locus);
            diff[j] = fabs (newlike[j] - oldlike[j]);
            if (delta < diff[j])
                delta = diff[j];
            if (delta > EPSILON)
                alldone = FALSE;
        }

        if (nr->world->options->progress)
            if (z % 100 == 0 && nr->world->options->verbose)
                printf ("           Iteration%6li biggest difference = %f\n", z,
                        delta);
        memcpy (oldlike, newlike, sizeof (double) * repdiff);
        diffdone = TRUE;
        for (j = nr->repstart; j < nr->repstop; j++)
        {
            if (fabs (oldiff[j] - diff[j]) > EPSILON)
            {
                diffdone = FALSE;
                break;
            }
        }
        if (diffdone)
            break;
        else
            memcpy (oldiff, diff, sizeof (double) * repdiff);
        delta = diff[0];
    }
    if ((nr->world->options->progress || diffdone) && delta > EPSILON)
    {
        printf ("           Reweighting operation converged to\n");
        printf ("           constant multiplier %f in %li cycles\n",
                delta, z);
    }
    free (newlike);
    free(oldlike);
    free (diff);
    free (oldiff);
    free (lparam);
}
