#ifndef OPTIONS_INCLUDE
#define OPTIONS_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 O P T I O N S   R O U T I N E S 
 
 creates options structures,
 reads options from parmfile if present
 set first parameter for mcmc run,
 prints options,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: options.h,v 1.20 2002/10/23 22:43:43 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void create_options (option_fmt ** options);
extern void init_options (option_fmt * options);
//extern void get_options (option_fmt * options);
extern void set_param (world_fmt * world, data_fmt * data,
                           option_fmt * options, long locus);
extern void set_profile_options (option_fmt * options);
extern void print_menu_options (world_fmt * world, option_fmt * options,
                                    data_fmt * data);
extern void print_options (FILE * file, world_fmt * world,
                               option_fmt * options, data_fmt * data);
extern void print_options_nomcmc (FILE * file, option_fmt * options,
                                      world_fmt * world);
extern void decide_plot (worldoption_fmt * options, long chain, long chains,
                             char type);
extern void destroy_options (option_fmt * options);
extern void read_custom_migration (FILE * file, option_fmt * options,
                                       char *value, long customnumpop);
extern void fillup_custm (long len, world_fmt * world, option_fmt * options);
extern void save_parmfile (option_fmt * options);
extern void set_plot (option_fmt * options);
extern void synchronize_param (world_fmt * world, option_fmt * options);
extern void resynchronize_param (world_fmt * world);
extern long save_options_buffer (char **buffer, option_fmt * options);
extern void read_options_master (option_fmt * options);
extern void read_options_worker (char **buffer, option_fmt * options);
extern long scan_connect (char *custm2, long start, long stop, char check);

#endif /*OPTIONS_INCLUDE */
