#ifndef MIGRATION_HEADER /*migration.h */
#define MIGRATION_HEADER

#include "definitions.h"
/*-----------------------------------------------------------------
  Maximum likelihood estimation of migration rates 
  using coalescent trees
 
  Peter Beerli
  Genetics 357730
  University of Washington
  Seattle, WA 98195-7730, USA
  beerli@gs.washington.edu
 
 copyright 2002 Peter Beerli and Joseph Felsenstein. 
  *----------------------------------------------------------------
 
  Time, 'tyme', in this tree is measured from the tips to the root.
  I.e. the tips are at tyme '0', and the root node has the largest
  value for 'tyme'. 
  
  */


/* Altivec support [NOT WORKING YET]*/
#ifdef ALTIVEC
#include "altivec.h"
#endif /*ALTIVEC*/


typedef char allele_type[DEFAULT_ALLELENMLENGTH];

typedef double pair[2];
typedef double sitelike[4];
typedef sitelike *ratelike;
typedef ratelike *phenotype;
typedef double contribarr[MAXCATEGS];
typedef short val[MAXCATEGS];

typedef char allele_fmt[DEFAULT_ALLELENMLENGTH];

typedef struct lr_data_fmt
{
    short type;
    long elem;
    char *value1; // values to test using a mix of numbers and m,c, etc
    char *value2; // not used, reserved fo pairwise tests 
    char *connect;// custom migration matrix for value1 [no user interaction]
}
lr_data_fmt;

typedef struct lratio_fmt
{
    long alloccounter;
    long counter;
    lr_data_fmt *data;
}
lratio_fmt;

typedef struct valrec
{
    double rat, ratxi, ratxv, zz, z1, y1, ww1, zz1, ww2, zz2, z1zz, z1yy, xiz1,
    xiy1xv, ww1zz1, vv1zz1, ww2zz2, vv2zz2;
}
valrec;

typedef valrec ***tbl_fmt;

typedef union xarray_fmt
{
    double *a;
    phenotype s;
}
xarray_fmt;

#ifdef UEP
typedef union ueparray_fmt
{
    double *a;
    pair *s;
}
ueparray_fmt;
#endif

typedef struct seqmodel_fmt
{
    double freqa, freqt, freqg, freqc;
    double freqr, freqy;
    double freqar, freqcy, freqgr, freqty;
    double aa, bb;
    long endsite;
    double xi, xv, ttratio, fracchange;
    long *sites;
    long *alias;
    long *ally;
    long *category;
    short *weight;
    long weightsum;
    long *aliasweight;
    long *location;
    long addon;


}
seqmodel_fmt;

/* defines the data structure read from infile */
typedef struct _data
{
    FILE *infile;
    FILE *utreefile;
    FILE *weightfile;
    FILE *catfile;
    FILE *sumfile;
    FILE *distfile;
    FILE *geofile;
#ifdef UEP

    FILE *uepfile;
    int **uep;
    long uepsites;
    double uepfreq0;
    double uepfreq1;
#endif

    char *****yy;
    double *geo;
    double *lgeo;
    double **ogeo;
    allele_fmt **allele;
    long *maxalleles;
    boolean *skiploci;
    char **popnames;
    long **numind;
    long **numalleles;
    char ***indnames;
    long numpop;
    long loci;
    seqmodel_fmt *seq;
    double freq;
    double freqlast;
    char dlm;
    boolean hasghost;
}
data_fmt;

#ifdef BAYESUPDATE
typedef struct _bayes
{
	long count;
    double *delta; // change scale [how big can this be
    double *minparam;// minimal allowed parameter value
    double *maxparam; // maximal allowed parameter value
    double **params;  // save for parameter vectors
    long allocparams; //number of allocated parameter vectors
    long numparams;  //number of saved parameter vectors
    long paramnum;  // which param one is working with
    double oldval;    //holds prob(G|param)
}
bayes_fmt;
#endif


typedef long twin_fmt[2];

typedef long quad_fmt[4];

typedef struct _option
{
    char **buffer;  //pointer to buffer when MPI-worker otherwise NULL
    FILE *parmfile;
    FILE *seedfile;
    FILE *logfile;
    /*general options */
    //
    // name length
    long nmlength;  /* length of individual names */
    long popnmlength;  /* length of population names */
    long allelenmlength;  /* length of allele names */
    //
    // custom migration matrix setup
    char *custm;   /* custom migration matrix: theta are first */
    char *custm2;   /*custom migration matrix: theta on diagonal */
    //long symn;
    //long sym2n;
    //long zeron;
    //long constn;
    //long tmn;
    //long mmn;
   // long *zeroparam;
   // long *constparam;
   // twin_fmt *symparam;
   // quad_fmt *sym2param;
   // long *mmparam;
    
    /*input/output options */
    int menu;
    boolean progress;
    boolean verbose;
    boolean writelog;
    boolean uep;
    double ueprate;
    double uepmu;
    double uepnu;
    double uepfreq0;
    double uepfreq1;
    boolean movingsteps;
    double acceptfreq;
    boolean printdata;
    boolean usertree;
    boolean usertreewithmig;
    boolean randomtree;
    short treeprint;
    boolean usem;
    short migvar;
    boolean plot;
    boolean plotnow;
    short plotmethod;
    short plotvar;
    short plotscale;
    double plotrange[4];
    long plotintervals;
    double *plotxvalues;
    double *plotyvalues;
    boolean simulation;
    boolean mighist;
    boolean mixplot;
    boolean dist;
    boolean geo;
    char parmfilename[1024];
    char infilename[256];
    char outfilename[256];
    char logfilename[256];
    char mathfilename[256];
    char treefilename[256];
    char utreefilename[256];
    char catfilename[256];
    char weightfilename[256];
    char sumfilename[256];
    char mighistfilename[256];
    char distfilename[256];
    char geofilename[256];
    char bootfilename[256];
#ifdef UEP

    char uepfilename[256];
#endif
#ifdef BAYESUPDATE

    char bayesfilename[256];
#endif

    char title[LINESIZE + 1];
    lratio_fmt *lratio;
    boolean aic;
    boolean fast_aic;
    double aicmod;
    FILE *aicfile;
    char aicfilename[256];
    char aictype[2];
    char fsttype;
    boolean printfst;
    short profile;
    char profilemethod;
    long df;
    boolean qdprofile;
    boolean printprofsummary;
    boolean printprofile;
    short profileparamtype;

    /* data options */
    char datatype;
  boolean include_unknown;
    short migration_model;
    char dlm;
    long micro_stepnum;
    long micro_threshold;
    double **steps;
    boolean interleaved;
    double seqerror;
    double *ttratio;
    boolean fastlike;
    boolean freqsfrom;
    long categs;
    double *rate;
    long rcategs;
    double *rrate;
    double *probcat;
    double probsum;
    boolean gammarates;
    boolean autocorr;
    double lambda;
    boolean weights;
    double freqa;
    double freqc;
    double freqg;
    double freqt;
    /* random number options */
    short autoseed;
    long inseed;
    long saveseed;
    /* mcmc options */
    boolean bayes_infer;
	double updateratio;
#ifdef BAYESUPDATE

    bayes_fmt *bayes;
#endif

    short thetaguess;
    short migrguess;
    boolean gamma;
    boolean murates;
    double alphavalue;
    double *mu_rates;
    long muloci;
#ifdef LONGSUM

    boolean fluctuate;
    double *flucrates;
#endif

    long burn_in;
    short heating;
    double *thetag;
    long numthetag;
    double *mg;
    long nummg;
    long schains;
    long sincrement;
    long ssteps;
    long lchains;
    long lincrement;
    long lsteps;
    double lcepsilon;
    boolean gelman;
    long pluschain;  //how many chains are allowed , currently HARDCODED
    boolean replicate;
    long replicatenum;
    long gridpoints;
    long numpop;
    double heat[50];
    boolean adaptiveheat;
    long heating_interval;
    long heated_chains;
    /* save genealogy summary options */
    boolean readsum;
    boolean writesum;
    /* threading over loci */
    int cpu;
    //
    // fatal attraction of zero resistance
    double minmigsumstat;
}
option_fmt;


/* used in the tree structure */
typedef struct _node
{
    struct _node *next, *back;
    boolean tip;
    char type;
    long number;
    long pop;
    long actualpop;
    long id;
    xarray_fmt x;
#ifdef UEP

    int *uep;
    ueparray_fmt ux;
    double uepscale;
#endif

    double *s;
    double *scale;
    char *nayme;
    boolean top;
    boolean dirty;
    double v, tyme;
    double length;
    // double xcoord;
    //short ycoord,  ymin, ymax;
    //double status;?????
}
node;

typedef struct vtlist
{
    node *eventnode;  /* node with age=tyme */
    double age;   /* tyme from top nodelet */
    double interval;  /* interval t[i+1].age - t[i].age */
    long *lineages;
    long from;
    long to;
    /*  long pop; */
    long slice;
}
vtlist;

typedef struct tree_fmt
{
    node **nodep;
    node *root;
    long pop;
    long tips;
}
tree_fmt;

typedef struct timelist_fmt
{
    long numpop;
    long copies;
    long allocT;
    long T;
    long oldT;
    vtlist *tl;
}
timelist_fmt;

// holds all tree information: ordered: list of lineages, frompop, topop, eventtime, eventtype
#ifdef LONGSUM
typedef struct longsum_fmt
{
    long *lineages;
    long *lineages2;
    long fromto; //indicator into migration matrix mm2m(from,to)
    long to;
    double eventtime;
    double interval;
    char eventtype;
}
longsum_fmt;
#endif /*LONGSUM*/

typedef struct tarchive_fmt
{
    long copies;
    double lcopies;
    double *data;   //hold content
#ifdef ALTIVEC

    FloatVec *vdata;
#endif

    double *point;  // points into data
    double *wait;   // points into data
    double *kt;   //points to wait
    double *km;   //points to wait
    double *p;   // points to point
    double *mindex;  // points to point
#ifdef LONGSUM

    longsum_fmt *longsum; // holds all tree information: ordered: list of lineages, frompop, topop, eventtime, eventtype
    long longsumlen; // holds list of groups in longsum.
#endif /*LONGSUM*/

}
tarchive_fmt;

typedef struct timearchive_fmt
{
    long allocT;
    long T;
    long numpop;
    long sumtips;
    double param_like;
    double thb;
    double alpha;
#ifdef ALTIVEC
    // FloatVec *lcopiesvec;
    // FloatVec *data;
#endif /*ALTIVEC*/

    tarchive_fmt *tl;         // holds each tree (summary)
    double *parameters;  // holds all the parameter data
    double *param;  // pointer into parameters
    double *param0;  //pointer into parameters
    double *lparam0;  //pointer into parameters
    double *likelihood;  //pointer into parameters
    long trials;
    double normd;
}
timearchive_fmt;

typedef struct _plotmax
{
    double x1;
    double y1;
    double l1;
    double x2;
    double y2;
    double l2;
}
plotmax_fmt;

typedef struct _quantile_fmt
{
    char *name;
    double *param;
}
quantile_fmt;

typedef double migevent_fmt[3];

typedef struct _mighist_fmt
{
    long allocsize;
    long copies;
    long weight;
    long migeventsize;
    migevent_fmt *migevents;
}
mighist_fmt;

typedef struct _mighistloci_fmt
{
    mighist_fmt *mighist;
    long mighistnum;
    long allocsize;
}
mighistloci_fmt;

typedef struct _histogram_fmt
{
    long count;
    double *time;
    long *weight;
}
histogram_fmt;

typedef struct _worldoption
{
    boolean gamma;
    double alphavalue;
    boolean murates;
    long muloci;
    double *mu_rates;
    double *lmu_rates;
#ifdef LONGSUM

    boolean fluctuate;
#endif

    short migration_model;
    char *custm;
    char *custm2;
    double *thetag;
    double *mg;
    long zeron;
    long *zeroparam;
    long constn;
    long *constparam;
    long symn;
    long sym2n;
    twin_fmt *symparam;
    quad_fmt *sym2param;
    long tmn;
    long mmn;
    long *mmparam;
    boolean mixplot;
    boolean progress;
    boolean writelog;
    FILE *logfile;
    boolean plotnow;
    boolean verbose;
    boolean replicate;
    boolean gelman;
    double lcepsilon;
    boolean simulation;
    char datatype;
    long lsteps;
    double loglsteps;
    long treeprint;
    long movingsteps;
    double acceptfreq;
    long rcategs;
    long categs;
    long heating;
    long heated_chains;
    long heating_interval;
    boolean adaptiveheat;
    char profilemethod;
    boolean printprofile;
    boolean printprofsummary;
    long profileparamtype;
    long df;
    long lchains;
    long replicatenum;
    long micro_threshold;
    long micro_stepnum;
    double **steps;
    double *rrate;
    double *rate;
    double *probcat;
    long pluschain;
    boolean mighist;
    long burn_in;
    boolean usem;
    short migvar;
    boolean plot;
    long plotmethod;
    long plotintervals;
    double plotrange[4];
    short plotscale;
    long plotvar;
    double *plotxvalues;
    double *plotyvalues;
    lratio_fmt *lratio;
    boolean aic;
    boolean fast_aic;
    double aicmod;
    FILE *aicfile;
    char aictype[2];
    double lambda;
#ifdef UEP

    boolean uep;
    double ueprate;
    double uepmu;
    double uepnu;
    double uepfreq0;
    double uepfreq1;
#endif

    boolean fastlike;
    boolean bayes_infer;
	double updateratio;
    double minmigsumstat;
}
worldoption_fmt;

typedef struct _ueptime
{
    long size;
    long *populations;  // population the nodes are in
    double *ueptime;  // first elementis bottom most time , last elem is
    // topmost time,in between are for each migration events
}
ueptime_fmt;

typedef struct _worlddata
{
    boolean *skiploci;
    double *geo;
    double *lgeo;
    long *maxalleles;
    seqmodel_fmt *seq;
    FILE *sumfile;
    double freq;
    double freqlast;
#ifdef UEP

    long uepsites;
#endif

}
worlddata_fmt;

typedef struct _world
{
    /* generalities */
    char *name;
    char *worldname;
    worldoption_fmt *options;
    worlddata_fmt *data;
#ifdef MPI

    int *who;
#ifdef SLOWNET

    int *profilewho;
#endif
#endif

    char *buffer;   // buffer for profiles, not needed before profiletables()
    long loci;
    long skipped;   /*loci with no data */
    long locus;   /* the current locus, if single then set to 0 */
    long thislocus;  /* the real current locus, the whole locus scheme
               needs revision */
    long numpop;
    long numpop2;
    long sumtips;
    /* migration parameter array  starts and ends */
    int *mstart;
    int *mend;

    /* time archives, contains the data/results for summarizing */
    timearchive_fmt **atl;

    /* migration histogram reporter */
    mighistloci_fmt *mighistloci;
    long mighistlocinum;

    /*tree material */
    node **nodep;
    node *root;
    double treelen;
    long unique_id;
    tbl_fmt tbl;
    contribarr *contribution;
    /* parameter */
    double *param0;
    double *param00;
    double **fstparam;
    /*allows for 3 different rate changes at specific times*/
#ifdef LONGSUM

    double *flucrates;
    double *lflucrates;
#endif
    /* mcmc related */
    long *lineages;
    timelist_fmt *treetimes;
    double *mig0list;
    double **migproblist;
    long *design0list;

    /*nr related */
    double ***apg0;  /* part-loglikelihoods of param0 */
    double ***apg;  /* part-loglikelihoods of param */

    /*heating scheme */
    long actualinc;
    long increment;
    //  double heatratio;
    double heat;
    double averageheat;
    long treeswapcount;
    /* reporting time */
    time_t starttime;
    long treesdone;
    long treestotal;

    /* gelman R reporting/checking "gelman-convergence option" */
    double gelmanmeanR;
    double gelmanmaxR;
    long chains;
    boolean start;  //I need this in estimateParameter()
    /* reporting */
    double *likelihood;  /* data likelihoods */
    long numlike;   /* how many likelihoods maximally are stored */
    plotmax_fmt **plotmax;
    quantile_fmt *quantiles;
    double maxdatallike;  /* the maximum log likelihood of a chain */
    double allikemax;  /* the maximum log likelihood  the best tree */
    boolean in_last_chain; /*for last CHAIN option in print-tree */
    double param_like;  /* current parameter likelihood [=current chain] */
    double **chainlikes;  /* parameter likelihood of replicate/last chains all loci */
    long trials;
    double normd;
    long repkind;
    long rep;   // defines single cahin estimators
    long replicate;  //holdss the replicate we are in
    long repstop;
    long lsteps;
    double ***cov;
    long migration_counts;
    char ****plane;
#ifdef UEP

    double ueplikelihood;
    double **ueplike;  // contains uep like per tree pop x ueps
    double ****ueplikestore; // constains all ueplike long-steps x pop x uep
    ueptime_fmt *ueptime;  //contains ueptime per tree and mutation
    ueptime_fmt ***ueptimestore; //contains all ueptimes
    long ***ueprootstore;  //stores uep status at root
    long *oldrootuep;
    long **uepanc;
#endif
    long accept;
    double accept_freq;
    long swapped;
    long G;
#ifdef BAYESUPDATE
	long bayesaccept;
    bayes_fmt *bayes;
    FILE *bayesfile;
#endif

    FILE *outfile;
    FILE *treefile;
    FILE *mathfile;
    FILE *mighistfile;
    FILE *bootfile;
}
world_fmt;




typedef struct _nr_fmt
{
    long partsize;  /*number of part-variables, fixed per model */
    double *parts;  /* parts of the first and second derivatives */
    double *d;   /* first derivates */
    double *saved;  /* saved first derivates (used in MPI code) */
    /* migration parameter array  starts and ends */
    int *mstart;   //link to world->mstart
    int *mend;   //link to world->mend
    double normd;
    long repkind;
    long repstart;
    long repstop;
    //  long numg;
    double *dv;
    double *gdelta;
    double *od;
    double *delta;
    timearchive_fmt **atl;
    world_fmt *world;
    double **dd;   /* second derivatives */
    double *param;  /* changed values of param */
    double *lparam;  /* changed values of log(param) */
    double llike;   /* parameter LOGlikelihood */
    double lastllike;  /* parameter LOGlikelihood */
    double ollike;  /* old "   " */
    double *datalike;  /*P(D|G) */
    double *locilikes;
    double ***apg0;  /* part-loglikelihoods of param0 */
    double ***apg;  /* part-loglikelihoods of param */
    double *apg_max;  /* maxvalue of apg */
    double *rate;   /* rates for gamma rates */
    double *probcat;  /* probabilities for gamma rates */
    long categs;   /* #categories for gamma rates */
    double alpha;
    long numpop;   /* number of populations */
    long numpop2;   /* 2*numpop */
    double *PGC;   /* uncorrected llike */
    double *oPGC;   /* uncorrected ollike */
    long copy_nr;   /* number of genealogies */
    boolean *skiploci;
    long profilenum;  /* number of profile parameters */
    long *profiles;  /* which profile parameters */
    long *indeks;   /* which noprofile parameters */
    double *values;  /* profile values */
}
nr_fmt;


typedef struct helper_fmt
{
    long locus;
    nr_fmt *nr;
    timearchive_fmt **atl;
    //double *param;
    long which;
    double weight;
    double ll;
    boolean multilocus;
    boolean boolgamma;
    long analystype;
    double *dv;
    double *xv;
    double *expxv;
    double sign;
    double lamda;
}
helper_fmt;



typedef struct _migr_table_fmt
{
    long from;
    long to;
    double time;
}
migr_table_fmt;

typedef struct proposal_fmt
{
    world_fmt *world;
    boolean mig_removed;
    char datatype;
    short migration_model;
    long sumtips;
    long numpop;
    long endsite;
    double fracchange;
    double *param0;
    double rr;
    node *root;
    node *origin;
    node *target;
    node *realtarget;
    node *tsister;
    node *realtsister;
    node *osister;
    node *realosister;
    node *ocousin;
    node *realocousin;
    node *oback;
    node *realoback;
    node **line_f;
    node **line_t;
    node *connect;
    double likelihood;
    double ueplikelihood;
    double **ueplike;
    double time;
    double v;
    double vs;
    xarray_fmt xt;
    xarray_fmt xf;
    double *mf;
    double *mt;
#ifdef UEP

    ueparray_fmt ut;
    ueparray_fmt uf;
    node *firstuep;
    double *umf;
    double *umt;
#endif

    node **aboveorigin;
    node **bordernodes;
    long listsize;
    migr_table_fmt *migr_table;
    migr_table_fmt *migr_table2;
    long migr_table_counter;
    long migr_table_counter2;
    long old_migr_table_counter;
    long old_migr_table_counter2;
    long timeslice;
    double *mig0list;
    long *design0list;
    double treelen;
}
proposal_fmt;

typedef struct spline_fmt
{
    long ntab;
    long nwork;
    double *param;
    double *like;
    double *diff;
    double *diff2;
    long *constr;
    long *diagn;
    double *work;
}
spline_fmt;


typedef struct locusdata_fmt
{
    long locus;
    world_fmt **universe;
    option_fmt *options;
    data_fmt *data;
}
locusdata_fmt;



typedef struct _aic_fmt
{
    double aic;
    char *pattern;
    long numparam;
    double mle;
    double lrt;
    double prob;
    double probcorr;
}
aic_fmt;


typedef struct _aic
{
    aic_fmt * aicvec;
    long aicnum;
    double *param0;
}
aic_struct;


typedef struct _plotfield_fmt
{
    boolean print;
    char type;   // 'a' = ascii plot, 'p' = postscript plot
    long xsize;   // width  printpositions in chars
    long ysize;   // height printpositions in chars
    char xaxis[255];  //xaxis label
    char yaxis[255];  //yaxis label
    char yfaxis[255];  //frequency yaxis label
    char title[255];
    double *yfreq;
    long *y;
    char **data;   //the plotplane
}
plotfield_fmt;

/* global variables (this should be not used at all) */
extern char appl[20];

typedef long longer[3];  /* used in random.c */
extern long *seed;
extern long *newseed;
#ifdef SLOWNET
extern double (*calc_like) (helper_fmt *, double *, double *);
extern void (*calc_gradient) (nr_fmt *, helper_fmt *, double *);
extern void (*setup_param0) (world_fmt *, nr_fmt *, long, long, long, long,
                                 long, boolean);

#endif

#include "tools.h"
#include "sort.h"
#include "migrate_mpi.h"
#endif
