#ifndef MIGRATION_RANDOM
#define MIGRATION_RANDOM
/* -------------------------------------------------------
   R A N D O M   G E N E R A T O R   R O U T I N E S 
 
   creates options structures,
   reads options from parmfile if present
 
   prints options,
   and finally helps to destroy itself.
 
   Peter Beerli 1996, Seattle
   beerli@csit.fsu.edu
   
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: random.h,v 1.12 2003/11/04 16:12:09 beerli Exp $
   ------------------------------------------------------- */
extern long *seed;
extern long *newseed;
#ifdef MERSENNE_TWISTER
#include "mtwist-0.4/mtwist.h"
#include "mtwist-0.4/randistrs.h"
#endif
/*-----------------------------------------------------*
 * calculates the start seed for randum
 * picks up the global variable iseed
 * PB 94
 *-----------------------------------------------------*/
extern void getseed (option_fmt * options);

/*-----------------------------------------------------*
 * RANDUM 
 * generates an uniform random number between o..1
 * using seed (generated by getseed)
 * JF <93 (6bit) and Mary K. Kuhner 1997 (32bit)
 * RANDINT
 * generates an uniform random integer number
 * between a..b
 * using seed (generated by getseed)
 *-----------------------------------------------------*/
#ifdef PTHREADS
    extern double randum_thread (void);
    #define RANDUM() randum_thread()
    #define RANDINT(a,b) (long)((a)+(randum_thread() * (((b)-(a))+1.)))
#else
    #ifdef MERSENNE_TWISTER
 //       extern double mt_drand(void);
        extern long rd_iuniform(long, long);
        #define RANDUM() mt_drand()
        #define RANDINT(a,b) rd_iuniform((a),(b))
    #else
        extern double randum (void);
        #define RANDUM() randum()
        #define RANDINT(a,b) (long)((a)+(randum() * (((b)-(a))+1.)))
    #endif
#endif
#endif
