#ifndef TREE_INCLUDE
#define TREE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 T R E E B U I L D I N G   R O U T I N E S 
 
 
 Peter Beerli 1996, Seattle
 beerli@csit.fsu.edu
 
Copyright 2001 Peter Beerli and Joseph Felsenstein
 
$Id: tree.h,v 1.20 2003/11/04 16:12:10 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void buildtree (world_fmt * world, option_fmt * options,
                           data_fmt * data, long locus);
extern void create_treetimelist (world_fmt * world, timelist_fmt ** ltl,
                                     long locus);
extern void fix_times (world_fmt * world, option_fmt * options);
extern void first_smooth (world_fmt * world, long locus);
extern void set_dirty (node * p);
extern void construct_tymelist (world_fmt * world, timelist_fmt * timevector);
extern void timeslices (timelist_fmt ** timevector);
extern void add_partlineages (long numpop, timelist_fmt ** timevector);
extern double treelikelihood (world_fmt * world);
extern double pseudotreelikelihood (world_fmt * world,
                                        proposal_fmt * proposal);
extern void set_pop (node * theNode, long pop, long actualpop);
extern void pseudonuview (proposal_fmt * proposal, xarray_fmt xx1,
                              double *lx1, double v1, xarray_fmt xx2, double *lx2,
                              double v2);
extern void ltov (node * p);
extern void treeout (FILE * treefile, node * joint, node * p, long s);
extern void print_tree (world_fmt * world, long g, long *filepos);

extern void allocate_x (node * p, world_fmt * world, char datatype,
                            boolean withtips);

extern void copy_tree (world_fmt * original, world_fmt * kopie);
extern void swap_tree (world_fmt * tthis, world_fmt * that);

extern void calc_treelength (node * p, double *treelen);
extern double calc_pseudotreelength (proposal_fmt * proposal, double treelen);
extern void swap (void *a, void *b);
extern void free_treetimes (world_fmt * world, long size);
extern void free_tree (node * p, world_fmt * world);
extern long number_genomes (char datatype);

#endif /*TREE_INCLUDE */
