(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    117433,       2721]*)
(*NotebookOutlinePosition[    118091,       2744]*)
(*  CellTagsIndexPosition[    118047,       2740]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*mathematica\ program\ to\ read\ the\ mathfile\ from\ \
migrate*) \)\(\[IndentingNewLine]\)\( (*the\ data\ \((log\ likelihood)\)\ is\ \
organized\ per\ populations*) \)\(\[IndentingNewLine]\)\( (*and\ contains\ \
all\ immigration\ rates\ vs\ population\ size*) \)\(\[IndentingNewLine]\)\( \
(*and\ all' 
        emmigration'\ rates\ vs\ population\ size*) \)\(\[IndentingNewLine]\)\
\( (*written\ around\ 1997, 
      by\ Peter\ Beerli*) \)\(\[IndentingNewLine]\)\( (*number\ in\ rows\ and\
\ \(columns : 
          the\ produces\ a\ grid\ of\)*) \)\(\[IndentingNewLine]\)\( (*1296\ \
log\ likelihood\ values*) \)\(\[IndentingNewLine]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(rows = \(cols = 36\);\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(\( (*population\ number*) \)\(\[IndentingNewLine]\)\( (*you\ might\ \
need\ to\ adjust\ this\ to\ your\ specific\ setting*) \)\(\[IndentingNewLine]\
\)\(\(pop = 3;\)\(\n\)
    \)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*read\ the\ data\ in\ \
mathfile*) \)\(\[IndentingNewLine]\)\(\(data = 
        ReadList["\<mathfile\>", 
          Table[Table[
              Table[Table[
                  Number, {cols}], {rows}], {2}], {pop}]];\)\(\
\[IndentingNewLine]\)
    \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*now\ you\ can\ do\ something\ like\ the\ following\ after\ \
having\ filled\ in\ the*) \)\(\[IndentingNewLine]\)\( (*xstart, xend\ etc, 
      looking\ it\ up\ in\ the\ outfile*) \)\(\[IndentingNewLine]\)\(\(xstart\
\  = \ \(-4\);\)\[IndentingNewLine]
    \(xend\  = \ 2;\)\[IndentingNewLine]
    \(ystart\  = \ \(-4\);\)\[IndentingNewLine]
    \(yend\  = \ 
        2;\)\[IndentingNewLine] (*Generates\ a\ contourplot\
*) \[IndentingNewLine]
    $DefaultFont = {"\<Helvetica\>", 12}; 
    ListContourPlot[
      data[\([1, 1, 1]\)] - 
        Max[data[\([1, 1, 
              1]\)]], \[IndentingNewLine]MeshRange \[Rule] {{xstart, 
            xend}, {ystart, 
            yend}}, \[IndentingNewLine]Contours \[Rule] {0, \(-2\), \ \
\(-10\), \ \(-100\), \ \(-1000\)},  (*\(ContourStyle -> {{RGBColor[1, 1, 
                0]}, {Dashing[{0.01, 0.01}]}, {Dashing[{0.01, 
                  0.01}]}, {Dashing[{0.01, 0.01}]}}\)\(,\)*) \ 
      PlotRange \[Rule] {0, \(-10\)}, \[IndentingNewLine]ColorFunction \
\[Rule] \((RGBColor[\ #, 1 - #, #]\  &)\), 
      FrameTicks \[Rule] {{{\(-4\), 0.0001}, {\(-3\), 0.001}, {\(-2\), 
              0.01}, {\(-1\), 0.1}, {0, 1}, {1, 10}, {2, 100}}, {{\(-4\), 
              0.0001}, {\(-3\), 0.001}, {\(-2\), 0.01}, {\(-1\), 0.1}, {0, 
              1}, {1, 10}, {2, 
              100}}, {}, {}}\[IndentingNewLine]]\[IndentingNewLine]
    \)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12  scalefont  setfont
% Scaling calculations
0.660256 0.160256 0.660256 0.160256 [
[.01923 -0.0125 -20.2188 -14 ]
[.01923 -0.0125 20.2188 0 ]
[.17949 -0.0125 -16.9062 -14 ]
[.17949 -0.0125 16.9062 0 ]
[.33974 -0.0125 -13.5938 -14 ]
[.33974 -0.0125 13.5938 0 ]
[.5 -0.0125 -10.2812 -14 ]
[.5 -0.0125 10.2812 0 ]
[.66026 -0.0125 -5.3125 -14 ]
[.66026 -0.0125 5.3125 0 ]
[.82051 -0.0125 -8.625 -14 ]
[.82051 -0.0125 8.625 0 ]
[.98077 -0.0125 -11.9375 -14 ]
[.98077 -0.0125 11.9375 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -40.4375 -7 ]
[-0.0125 .01923 0 7 ]
[-0.0125 .17949 -33.8125 -7 ]
[-0.0125 .17949 0 7 ]
[-0.0125 .33974 -27.1875 -7 ]
[-0.0125 .33974 0 7 ]
[-0.0125 .5 -20.5625 -7 ]
[-0.0125 .5 0 7 ]
[-0.0125 .66026 -10.625 -7 ]
[-0.0125 .66026 0 7 ]
[-0.0125 .82051 -17.25 -7 ]
[-0.0125 .82051 0 7 ]
[-0.0125 .98077 -23.875 -7 ]
[-0.0125 .98077 0 7 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
gsave
.01923 -0.0125 -81.2188 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
1.000 setlinewidth
grestore
.17949 0 m
.17949 .00625 L
s
gsave
.17949 -0.0125 -77.9062 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
1.000 setlinewidth
grestore
.33974 0 m
.33974 .00625 L
s
gsave
.33974 -0.0125 -74.5938 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
1.000 setlinewidth
grestore
.5 0 m
.5 .00625 L
s
gsave
.5 -0.0125 -71.2812 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
.66026 0 m
.66026 .00625 L
s
gsave
.66026 -0.0125 -66.3125 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.82051 0 m
.82051 .00625 L
s
gsave
.82051 -0.0125 -69.625 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.98077 0 m
.98077 .00625 L
s
gsave
.98077 -0.0125 -72.9375 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
gsave
-0.0125 .01923 -101.438 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0001) show
1.000 setlinewidth
grestore
0 .17949 m
.00625 .17949 L
s
gsave
-0.0125 .17949 -94.8125 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
1.000 setlinewidth
grestore
0 .33974 m
.00625 .33974 L
s
gsave
-0.0125 .33974 -88.1875 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
1.000 setlinewidth
grestore
0 .5 m
.00625 .5 L
s
gsave
-0.0125 .5 -81.5625 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
1.000 setlinewidth
grestore
0 .66026 m
.00625 .66026 L
s
gsave
-0.0125 .66026 -71.625 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
0 .82051 m
.00625 .82051 L
s
gsave
-0.0125 .82051 -78.25 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
0 .98077 m
.00625 .98077 L
s
gsave
-0.0125 .98077 -84.875 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
1.000 setlinewidth
grestore
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 0 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 .6 .4 r
.01923 .50486 m
.0467 .50486 L
.07418 .50486 L
.10165 .50486 L
.12912 .50486 L
.15659 .50486 L
.18407 .50486 L
.21154 .50486 L
.23901 .50486 L
.26648 .50486 L
.29396 .50485 L
.32143 .50485 L
.3489 .50484 L
.37637 .50484 L
.40385 .50483 L
.43132 .50481 L
.45879 .50479 L
.48626 .50475 L
.51374 .5047 L
.54121 .50462 L
.56868 .5045 L
.59615 .50432 L
.62363 .50406 L
.6511 .50368 L
.67857 .50315 L
.70604 .50246 L
.73352 .50169 L
.76099 .50089 L
.78846 .49957 L
.81593 .4964 L
.84341 .48923 L
.85114 .48626 L
.87088 .47548 L
.88905 .45879 L
.89576 .43132 L
.87088 .40634 L
.86567 .40385 L
.84341 .39545 L
.81593 .39084 L
.78846 .38919 L
.76099 .38851 L
.73352 .38789 L
.70604 .38723 L
.67857 .38667 L
.6511 .38625 L
.62363 .38597 L
.59615 .38577 L
.56868 .38563 L
.54121 .38554 L
.51374 .38548 L
.48626 .38544 L
.45879 .38541 L
.43132 .3854 L
.40385 .38538 L
.37637 .38537 L
.3489 .38537 L
.32143 .38537 L
.29396 .38536 L
.26648 .38536 L
.23901 .38536 L
.21154 .38536 L
.18407 .38536 L
.15659 .38536 L
.12912 .38536 L
.10165 .38536 L
.07418 .38536 L
.0467 .38536 L
.01923 .38536 L
F
0 g
.01923 .50486 m
.0467 .50486 L
.07418 .50486 L
.10165 .50486 L
.12912 .50486 L
.15659 .50486 L
.18407 .50486 L
.21154 .50486 L
.23901 .50486 L
.26648 .50486 L
.29396 .50485 L
.32143 .50485 L
.3489 .50484 L
.37637 .50484 L
.40385 .50483 L
.43132 .50481 L
.45879 .50479 L
.48626 .50475 L
.51374 .5047 L
.54121 .50462 L
.56868 .5045 L
.59615 .50432 L
.62363 .50406 L
.6511 .50368 L
.67857 .50315 L
.70604 .50246 L
.73352 .50169 L
.76099 .50089 L
.78846 .49957 L
.81593 .4964 L
.84341 .48923 L
.85114 .48626 L
.87088 .47548 L
.88905 .45879 L
.89576 .43132 L
.87088 .40634 L
.86567 .40385 L
.84341 .39545 L
.81593 .39084 L
.78846 .38919 L
.76099 .38851 L
.73352 .38789 L
.70604 .38723 L
.67857 .38667 L
.6511 .38625 L
.62363 .38597 L
.59615 .38577 L
.56868 .38563 L
.54121 .38554 L
.51374 .38548 L
Mistroke
.48626 .38544 L
.45879 .38541 L
.43132 .3854 L
.40385 .38538 L
.37637 .38537 L
.3489 .38537 L
.32143 .38537 L
.29396 .38536 L
.26648 .38536 L
.23901 .38536 L
.21154 .38536 L
.18407 .38536 L
.15659 .38536 L
.12912 .38536 L
.10165 .38536 L
.07418 .38536 L
.0467 .38536 L
.01923 .38536 L
Mfstroke
.9 .1 .9 r
.01923 .46991 m
.0467 .46991 L
.07418 .46991 L
.10165 .46991 L
.12912 .46991 L
.15659 .46991 L
.18407 .46991 L
.21154 .4699 L
.23901 .4699 L
.26648 .4699 L
.29396 .46989 L
.32143 .46989 L
.3489 .46988 L
.37637 .46986 L
.40385 .46984 L
.43132 .46981 L
.45879 .46976 L
.48626 .46968 L
.51374 .46958 L
.54121 .46941 L
.56868 .46917 L
.59615 .46881 L
.62363 .46827 L
.6511 .46748 L
.67857 .46633 L
.70604 .4648 L
.73352 .46301 L
.76099 .46102 L
.78024 .45879 L
.78846 .45732 L
.80642 .43132 L
.78846 .42642 L
.76099 .42326 L
.73352 .42151 L
.70604 .41989 L
.67857 .41852 L
.6511 .4175 L
.62363 .4168 L
.59615 .41633 L
.56868 .41601 L
.54121 .4158 L
.51374 .41566 L
.48626 .41556 L
.45879 .4155 L
.43132 .41545 L
.40385 .41542 L
.37637 .4154 L
.3489 .41539 L
.32143 .41538 L
.29396 .41538 L
.26648 .41537 L
.23901 .41537 L
.21154 .41537 L
.18407 .41537 L
.15659 .41536 L
.12912 .41536 L
.10165 .41536 L
.07418 .41536 L
.0467 .41536 L
.01923 .41536 L
F
0 g
.01923 .46991 m
.0467 .46991 L
.07418 .46991 L
.10165 .46991 L
.12912 .46991 L
.15659 .46991 L
.18407 .46991 L
.21154 .4699 L
.23901 .4699 L
.26648 .4699 L
.29396 .46989 L
.32143 .46989 L
.3489 .46988 L
.37637 .46986 L
.40385 .46984 L
.43132 .46981 L
.45879 .46976 L
.48626 .46968 L
.51374 .46958 L
.54121 .46941 L
.56868 .46917 L
.59615 .46881 L
.62363 .46827 L
.6511 .46748 L
.67857 .46633 L
.70604 .4648 L
.73352 .46301 L
.76099 .46102 L
.78024 .45879 L
.78846 .45732 L
.80642 .43132 L
.78846 .42642 L
.76099 .42326 L
.73352 .42151 L
.70604 .41989 L
.67857 .41852 L
.6511 .4175 L
.62363 .4168 L
.59615 .41633 L
.56868 .41601 L
.54121 .4158 L
.51374 .41566 L
.48626 .41556 L
.45879 .4155 L
.43132 .41545 L
.40385 .41542 L
.37637 .4154 L
.3489 .41539 L
.32143 .41538 L
.29396 .41538 L
Mistroke
.26648 .41537 L
.23901 .41537 L
.21154 .41537 L
.18407 .41537 L
.15659 .41536 L
.12912 .41536 L
.10165 .41536 L
.07418 .41536 L
.0467 .41536 L
.01923 .41536 L
Mfstroke
1 0 1 r
.01923 .43132 m
.01923 .43132 L
.01923 .43132 L
F
0 g
.01923 .43132 m
.01923 .43132 L
.01923 .43132 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQ
ooooo`007_ooool4o`0000?ooooo00?o0000ooooooooool01?l00003ooooo`Co00000oooool4o`00
00Gooooo00?o0000ooooooooool01Oooool4o`0000?ooooo00?o0000ooooooooool01?l00003oooo
o`Co00001Oooool00ol0003oooooooooo`0=ooooo`Co00000oooool00ol0003oooooooooo`04o`00
00Gooooo00?o0000ooooooooool04oooool4o`0000?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool00_ooool4o`00
01[ooooo00?o0000ooooooooool00_ooool4o`0000?ooooo1?l00004ooooo`007Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooo`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool00ol0003o
ooooooooo`0Oooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Goooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000004ooooo`03o`000?oooooo
oooo007ooooo000Mooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooool000001?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00Go0000ooooooooooooooooo`000004
ooooo`03o`000?oooooooooo01Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooo000000Cooooo00?o0000ooooooooool00Oooool001gooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001?ooool0
0ol0003oooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool07oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool05oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`01ooooo`007Ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooo`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_oo
ool00ol0003oooooooooo`0Oooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`0Gooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000004ooooo`03
o`000?oooooooooo007ooooo000Mooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooool00000
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool00000
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo01oooooo00Go0000oooooooooooo
ooooo`000004ooooo`03o`000?oooooooooo01Oooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooo000000Cooooo00?o0000ooooooooool00Oooool001gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool0
00001?ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00?o00001_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooo`000004ooooo`03o`000?oooooooooo00?o00003_ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03o`0001Co
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`?o00007_ooool3o`0001oo
oooo0ol00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05Oooool3o`0000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo007o
oooo000Mooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooool000001?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Nooooo`03o`000?oooooooooo01oooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo01Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo0000
00Cooooo00?o0000ooooooooool00Oooool001kooooo1?l00006ooooo`Co00000oooool4o`0000?o
oooo1?l00005ooooo`03o`000?oooooooooo00Gooooo1?l00006ooooo`Co00000oooool4o`0000Go
oooo00?o0000ooooooooool03Oooool4o`0000Kooooo1?l00005ooooo`03o`000?oooooooooo01?o
oooo1?l00008ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool07oooool00ol0003o
ooooooooo`02ooooo`Co00006_ooool00ol0003oooooooooo`02ooooo`Co00000oooool4o`0000Co
oooo003oooooob7ooooo003oooooob7ooooo003oooooob7ooooo000[ooooongo00002?ooool002_o
oooo00Go0000ooooooooooooooooo`00000Uooooo`03o`000?oooooooooo02?ooooo00?o0000oooo
ooooool08oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo00?o0000oooo
ooooool08oooool01Ol0003ooooooooooooooooo000000Sooooo000[ooooo`05o`000?oooooooooo
ooooool000009Oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo00?o0000
ooooooooool08oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo00Go0000
ooooooooooooooooo`000008ooooo`000oooool4o`0000?ooooo00?o0000ooooooooool01?l00003
ooooo`Co00000oooool4o`0000Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3Y
ooooo`03o`000?oooooooooo00Kooooo0002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000oooo
ool000001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0jOooool00ol0003oooooooooo`06ooooo`000_ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03
o`000?oooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`;o
0000j_ooool00ol0003oooooooooo`06ooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`00
0?oooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`04o`00
0?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`000_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
o`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`04ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
0_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003o
ooooooooo`06ooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`000?oooooo000000Cooooo
00?o0000ooooooooool00ol00006ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003o
ooooooooo`06ooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`000?oooooo000000Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooooooonCo
0?l01?ooool00ol0003oooooooooo`06ooooo`000oooool4o`0000Kooooo1?l00003ooooo`Co0000
0oooool4o`0000Gooooo00?o0000ooooooooool01?ooool01?l0003ooooooooooooooooTo`3o00Co
oooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03
o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003o
ooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000oooooooo
ool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Ko
oooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo
00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`00
0?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooo
oooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooo
ooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo
0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Co
oooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03
o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003o
ooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000oooooooo
ool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Ko
oooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo
00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`00
0?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooo
oooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooo
ooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo
0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Co
oooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03
o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003o
ooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000oooooooo
ool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Ko
oooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
2Oooool4o`0000?ooooo00?o0000ooooooooool01?l00003ooooo`Co00001Oooool00ol0003ooooo
ooooo`05ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
2?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1Oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool000Sooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo
0_l00002ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`002?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`00
0004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool01?l0003ooooooooo
oooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool000Sooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooooooo
i?l0o`04ooooo`03o`000?oooooooooo00Kooooo0008ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooooooonCo0?l0
1?ooool00ol0003oooooooooo`06ooooo`002?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`000?oo
oooooooo00?o00001oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool0
1_ooool000Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Gooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo
0009ooooo`Co00001_ooool4o`0000?ooooo1?l00005ooooo`03o`000?oooooooooo00Gooooo00Co
0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oo
ooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooo
oooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo
i?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l0
1?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo
00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`00
0?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003ooooo
ooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool0
1_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo
000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:ooo
ool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co
0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oo
ooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooo
oooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo
i?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l0
1?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo
00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`00
0?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003ooooo
ooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool0
1_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo
000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:ooo
ool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co
0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oo
ooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooo
oooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo
i?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l0
1?ooool00ol0003oooooooooo`06ooooo`004?ooool4o`0000?ooooo00?o0000ooooooooool01?l0
0005ooooo`03o`000?oooooooooo00Gooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`00
0?oooooooooo00Kooooo000?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Ooo
ool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool000oooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`;o00000_oooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool000oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05
ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`003oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00Co0000ooooooooooooooooi?l0
o`04ooooo`03o`000?oooooooooo00Kooooo000?ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01Oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_oo
ool000oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00ol00007ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`003oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Gooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000@
ooooo`Co00001_ooool4o`0000Gooooo00?o0000ooooooooool01Oooool01?l0003ooooooooooooo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`04o`000?oooooooooooooooj7o0000@ol0o`04ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`04o`000?oooooooooooooooj7oIYUV7ol0000To`3o00Cooooo00?o
0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo`?mVVFH3o`00027o0?l01?oo
ool00ol0003oooooooooo`06ooooo`00:oooool01?l0003oooooooooooooooo3ofJIIP;o00007ol0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooolGoIYUV0ol0
000Lo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooob?mV
VFH3o`0001Wo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooo
ooo:ofJIIP03o`000?l0o`3o0?l001Oo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool0
1?l0003ooooooooooooooon=o`0003koIYUV00?o0000o`3o0?l0o`005_l0o`04ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooohgoiQWV6_l0000UofJIIP03o`000?l0
o`3o0?l001Go0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooo
oonWonHIiPgo00006OmVVFH00ol0003o0?l0o`3o000Do`3o00Cooooo00?o0000ooooooooool01_oo
ool002_ooooo00Co0000oooooooooooooooo]?oV6NH5o`0001GoIYUV00?o0000o`3o0?l0o`004ol0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`06o`000?oooooooooooooooooV6NKo0000
]ooV6NH2o`0001CoIYUV00?o0000o`3o0?l0o`004_l0o`04ooooo`03o`000?oooooooooo00Kooooo
000[ooooo`04o`000?oooooooooooooook[oiQWV00?o0000ofJII_mVVFH04_mVVFH00ol0003o0?l0
o`3o000Bo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo
^OoV6NH00ol0003oIYUVofJIIP0CofJIIP03o`000?l0o`3o0?l001;o0?l01?ooool00ol0003ooooo
ooooo`06ooooo`00:oooool01?l0003ooooooooooooooonhonHIiP03o`000?mVVFKoIYUV01CoIYUV
00?o0000o`3o0?l0o`004_l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oo
oooooooooooookSoiQWV00?o0000ofJII_mVVFH04omVVFH00ol0003o0?l0o`3o000Co`3o00Cooooo
00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo]ooV6NH00ol0003oIYUV
ofJIIP0DofJIIP03o`000?l0o`3o0?l001?o0?l01?ooool00ol0003oooooooooo`06ooooo`00:ooo
ool01?l0003oooooooooooooooneonHIiP;o00005omVVFH00ol0003o0?l0o`3o000Co`3o00Cooooo
00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo[OoV6NH8o`0001SoIYUV
0_l0000Eo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooo
VOoV6NHDo`0001ooIYUV00?o0000o`3o0?l0o`005Ol0o`04ooooo`03o`000?oooooooooo00Kooooo
000[ooooo`04o`000?oooooooooooooooiWo0000<_mVVFH00ol0003o0?l0o`3o000Fo`3o00Cooooo
00?o0000ooooooooool01_ooool002_ooooo00Co0000oooooooooooooooobOmVVFH2o`0001Wo0?l0
1?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003oooooooooooooooo7ofJIIP;o0000
6ol0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooolKoIYUV
00?o0000o`3o0?l0o`006ol0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oo
ooooooooooooolCoIYUV0_l0000No`3o00Cooooo00?o0000ooooooooool01_ooool001Kooooo1?l0
0003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool01?l0003ooooooooo
ooooooo0ofJIIPCo00008?l0o`04ooooo`03o`000?oooooooooo00Kooooo000Eooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`04o`000?oo
oooooooooooook[oIYUV1_l0000To`3o00Cooooo00?o0000ooooooooool01_ooool001Gooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo0_l0
0002ooooojgoIYUV3Ol0000Zo`3o00Cooooo00?o0000ooooooooool01_ooool001Gooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00Co0000
oooooooooooooooo[Ol0000go`3o00Cooooo00?o0000ooooooooool01_ooool001Gooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00Co0000
ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000Eooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`04o`000?oooooo
ooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`005Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo0ol00008ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`005Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01_ooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool001Kooooo1?l00008ooooo`03o`000?oooooooooo00Kooooo00Co0000
ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooo
ooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003ooooooooo
o`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_oo
ool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[
ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool0
1?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000
ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooo
ooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003ooooooooo
o`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_oo
ool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[
ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool0
1?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000
ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooo
ooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0
o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?oo
ool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o
0000ooooooooool01_ooool002;ooooo00?o0000ooooooooool01_ooool01?l0003ooooooooooooo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool002;ooooo00?o0000ooooooooool01_ooool0
1?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002;ooooo00?o0000
ooooooooool01_ooool2o`0000;oooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000Roooo
o`03o`000?oooooooooo00Kooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000Rooooo`03o`000?oooooooooo00Kooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000Rooooo`03o`000?oooooooooo00Kooooo00Co0000oooo
ooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000Pooooo`?o00002?ooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002;ooooo00?o0000oooo
ooooool01_ooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02;ooooo00?o0000ooooooooool01_ooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06
ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[oooo
o`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooo
ooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooooooo
ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooT
o`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool0
0ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06
ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[oooo
o`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooo
ooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooooooo
ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooT
o`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool0
0ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06
ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[oooo
o`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`007?ooool00ol0
003oooooooooo`02ooooo`Co00001_ooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo00?ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000L
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`03ooooo`;o00000_oo
oooTo`3o00Cooooo00?o0000ooooooooool01_ooool001cooooo00Go0000ooooooooooooooooo`00
0004ooooo`03o`000?oooooooooo00?ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`00
0?oooooooooo00Kooooo000Looooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`03ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00
7?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00oooool01?l0003o
oooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool001[ooooo0ol00003ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool01?l0003ooooooooooooooooTo`3o
00Cooooo00?o0000ooooooooool01_ooool001cooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo00?ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000Looooo`03o`000?oooooooooo00;ooooo1?l00006ooooo`04o`000?oooooooooo
ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooT
o`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool0
0ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06
ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[oooo
o`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooo
ooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooooooo
ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooT
o`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool0
0ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06
ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool0
02_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[oooo
o`04o`000?ooooooooooooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000oooo
ooooooooooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?oooooooooo
ooooonCo0?l01?ooool00ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooT
o`3o00Cooooo00?o0000ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04
ooooo`03o`000?oooooooooo00Kooooo000[ooooo`04o`000?ooooooooooooooonCo0?l01?ooool0
0ol0003oooooooooo`06ooooo`00:oooool01?l0003ooooooooooooooooTo`3o00Cooooo00?o0000
ooooooooool01_ooool002_ooooo00Co0000ooooooooooooooooi?l0o`04ooooo`03o`000?oooooo
oooo00Kooooo000Eooooo`03o`000?oooooooooo00;ooooo1?l00003ooooo`Co00001_ooool01?l0
003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool001Gooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00oooool0
1?l0003ooooooooooooooooTo`3o00Cooooo00?o0000ooooooooool01_ooool001Gooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00ooo
ool2o`0000;oooooi?l0o`04ooooo`03o`000?oooooooooo00Kooooo000Eooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0jOooool00ol0003oooooooooo`06ooooo`005Oooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0>Wooooo00?o0000ooooooooool01_ooool001Gooooo00Go0000ooooooooooooooooo`00
0004ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`3Yooooo`03o`000?oooooooooo00Kooooo000Cooooo`?o00000oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00oooooo]o`0000Sooooo000Eoooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooo`000004ooooo`03o`000?oooooo
oooo0?Sooooo000Eooooo`03o`000?oooooooooo00;ooooo1?l00003ooooo`Co0000noooool00?oo
oooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oo
oooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oo
oooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Oooool00?oo
oooo8Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.26628, -4.98229, 0.026417, \
0.026417}}],

Cell[OutputFormData["\<\
ContourGraphics[{{-1.7976931348623157081`19.\
254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308, 
   -1.7976931348623157081`19.254715559916743*^308}, 
  {-570.292095441575018097`19.714704666911018, \
-570.292113967976636247`19.714704681019427, 
   -570.292141457648174447`19.714704701953636, \
-570.292182244838475217`19.714704733014297, 
   -570.292242756910898297`19.71470477909604, \
-570.292332521870410037`19.71470484745472, 
   -570.292465656896727207`19.71470494884096, \
-570.292663062747440247`19.714705099171294, 
   -570.292955648198446997`19.71470532198359, \
-570.293389044665079977`18.75177696340291, 
   -570.294030447985367257`19.71470614047375, \
-570.294978432242803737`19.714706862389065, 
   -570.296376770313006687`19.714707927258623, \
-570.298433320816773317`19.714709493368737, 
   -570.301444528569479787`19.71471178646194, \
-570.305824167504031407`19.714715121620454, 
   -570.312129741308442727`19.714719923361297, \
-570.321067637357007387`19.714726729543937, 
   -570.333431967384601787`19.714736144770555, \
-570.349883603345777057`19.714748672094515, 
   -570.370409337628050397`19.714764301189913, \
-570.393296101290705027`19.714781727402052, 
   -570.413850947454736937`19.71479737747278, \
-570.424701775170976957`19.71480563886014, 
   -570.422561517130223047`19.71480400936549, \
-570.426044967355753807`19.714806661502156, 
   -570.497437807247568027`19.714861013116302, \
-570.751898032284405107`19.715054679250347, 
   -571.354707900620585547`19.71551312511242, \
-572.522511652602677397`19.716399882699623, 
   -574.523910327806650147`19.71791542255249, \
-577.616774804388430907`19.720247112109718, 
   -581.881814337440662397`19.72344209915958, \
-587.660595693428692957`19.727733885857972, 
   -596.067061136080017287`19.733902438076907, \
-608.521609485845235807`19.742883320109296}, 
  {-356.444048933675762927`19.51059868312114, \
-356.444067305393250677`18.54767001688098, 
   -356.444094565603084137`19.51059873871947, \
-356.444135012466492897`19.51059878800026, 
   -356.444195019919877867`19.510598861113834, \
-356.444284036957615317`19.510598969572897, 
   -356.444416064115305427`19.510599130435782, \
-356.444611830386723027`19.510599368958772, 
   -356.444901992586697047`19.510599722494174, \
-356.445331814676510617`19.510600246191526, 
   -356.445967961381459337`19.51060102127463, \
-356.446908249758255497`19.51060216692237, 
   -356.448295397532636027`19.510603857018246, \
-356.450335846814230227`19.510606343082394, 
   -356.453324265769342817`19.510609984118165, \
-356.457672497052303837`19.510615281870226, 
   -356.463936692543573057`19.510622913860896, \
-356.472824433810647097`19.510633742021817, 
   -356.485138182769706107`19.51064874372881, \
-356.501564032834867387`19.5106687543574, 
   -356.522148654852262697`19.51069383006694, \
-356.545297745549735427`19.510722028023263, 
   -356.566501662692676437`19.510747854953124, \
-356.578540119566273607`19.51076251742733, 
   -356.577940587700798147`19.510761787227477, \
-356.582434768169978407`19.510767260884858, 
   -356.652862696070744877`18.54792434047934, \
-356.902979161104074277`18.548228799356057, 
   -357.496908576329619937`19.511879605471055, \
-358.650077412395521747`19.51327824375301, 
   -360.629924248506629427`19.51566907548884, \
-363.695540447378878217`19.519345290708227, 
   -367.931685525650525647`19.524374504837624, \
-373.667611826848460767`19.531092771229126, 
   -382.006224353758259577`18.57774906551773, \
-394.363253202376061067`19.554503755403697}, 
  {-216.758634170099245607`19.29458372063361, \
-216.758652478483188727`19.294583757316015, 
   -216.758679644743327937`19.294583811745937, \
-216.758719952266378787`19.294583892505486, 
   -216.758779753116218817`19.294584012321547, \
-216.758868463943176867`19.294584190061126, 
   -216.759000037537393977`18.33165576505531, \
-216.759195132595269937`19.294584844568544, 
   -216.759484302834469107`19.294585423943985, \
-216.759912661911616997`19.29458628219386, 
   -216.760546657413474487`19.29458755244878, \
-216.761483797145988457`19.29458943006784, 
   -216.762866368364885967`19.294592200122402, \
-216.764900236603015317`19.29459627505287, 
   -216.767879350022500517`19.294602243748113, \
-216.772214776694884367`19.294610929689302, 
   -216.778462149955291947`19.294623445871967, \
-216.787329615174687807`19.294641210609345, 
   -216.799623211363044817`19.294665837923215, \
-216.816039686174381277`18.331770033647942, 
   -216.836650884245219827`19.29474000567629, \
-216.859912380339498127`19.29478659280775, 
   -216.881391730962921117`19.294829606296993, \
-216.893933653814119817`19.29485472016387, 
   -216.893990847504117167`19.29485483468482, \
-216.898927439466124407`19.2948647192844, 
   -216.968977377265165527`19.295004956906823, \
-217.217311428339119317`19.29550174882583, 
   -217.807591598658294887`19.29668032769013, \
-218.954789968532001157`19.29896176532515, 
   -220.925965959456110707`19.302854077386744, \
-223.980908822382676957`19.308818317343636, 
   -228.206448333494453347`19.31693522677361, \
-233.927345506371697327`19.327688307528906, 
   -242.242849422921469937`19.34285828115488, \
-254.566803790091629627`19.36440908465923}, 
  {-127.239163964194734287`19.06322812171745, \
-127.239182252914151407`19.063228184140762, 
   -127.239209390066736917`19.063228276765642, \
-127.239249654558467027`19.063228414196896, 
   -127.239309391910925487`19.06322861809307, \
-127.239398009302423277`18.100300231938313, 
   -127.239529445987233917`19.06322936918319, \
-127.239724341720151557`19.063230034401595, 
   -127.240013224630690307`19.063231020415294, \
-127.240441175947612607`19.063232481092466, 
   -127.241074607324311077`18.100305954477744, \
-127.242011000015057927`19.063237839150947, 
   -127.243392660599997867`19.06324255492293, \
-127.245425611847043257`19.063249493534336, 
   -127.248404315780991427`19.063259659868677, \
-127.252741212081833307`19.06327446129622, 
   -127.258995280832198917`19.063295804968504, \
-127.267882417506758227`19.063326132880857, 
   -127.280225924017873497`19.063368252359208, \
-127.296759539246043147`19.06342466325477, 
   -127.317630363844532577`18.10056717315122, \
-127.341434397614197137`19.063577052371013, 
   -127.363961024530230047`19.063653872022005, \
-127.378292731856266327`19.063702738523915, 
   -127.380880482878826147`19.063711561334692, \
-127.388494215721141957`19.063737518945686, 
   -127.460192159064124697`19.063981883728744, \
-127.707774402699900657`19.06482465123925, 
   -128.293232765572813747`19.066811063577727, \
-129.428681254304908777`18.10770915239738, 
   -131.377106988720701257`19.077127009025457, \
-134.402884043735273427`19.087015902836676, 
   -138.626003967018736067`19.100452019288493, \
-144.344567546789907197`19.118007758556626, 
   -152.584436488552146467`19.14211755297018, \
-164.378118300824187517`19.174451319446682}, 
  {-71.150938389342019974`19.551150636579592, \
-71.150956763529112692`19.551150748732816, 
   -71.15098402842412284`19.551150915153507, \
-71.151024484486800503`19.551151162090918, 
   -71.151084510538883165`19.551151528480187, \
-71.151173566069619625`19.551152072060116, 
   -71.151305674333290341`19.551152878425405, \
-71.151501613763176834`19.551154074402, 
   -71.151792149144856836`19.551155847768023, \
-71.152222780782370393`19.5511584762384, 
   -71.152860691462922915`19.55116236986021, \
-71.153804834590903994`19.551168132572016, 
   -71.155200420498605496`19.551176650588957, \
-71.157259355480977803`19.55118921707966, 
   -71.160288269047345722`19.551207703070606, \
-71.164725121477037106`19.551234780539023, 
   -71.171182850626880878`19.551274188109147, \
-71.180491633108790239`19.551330987621842, 
   -71.193715443591674585`19.551411662739294, \
-71.212086659284953072`19.55152371600577, 
   -71.236750690667168584`19.551674106181462, \
-71.268170887360756893`19.55186561701652, 
   -71.305180119004905492`19.552091085595745, \
-71.34449372712159132`19.552330464811142, 
   -71.383717463004391135`19.552569165378333, \
-71.432939579294046695`19.552868526738294, 
   -71.534695448383775584`19.55348673686537, \
-71.778987761055677907`18.814604644390855, 
   -72.303211342752451429`19.558127591222036, \
-73.291301716730590243`19.56402243954219, 
   -74.994332507397945875`19.57399844834417, \
-77.751394054113053045`19.58967818884623, 
   -81.837646534012836952`19.61192313589071, \
-87.234839165340307687`18.89929727953945, 
   -94.618284203100149199`19.67494507267463, \
-105.011584952268837156`19.72020721772316}, 
  {-36.42614862479640081`19.260383259590558, \
-36.426168366290855971`19.260383494960482, 
   -36.426197661846689613`19.260383844239417, \
-36.426241134899729701`19.260384362550326, 
   -36.426305645876251304`19.26038513168641, \
-36.426401374052179705`19.260386273008955, 
   -36.426543422046709253`19.260387966575642, \
-36.426754194734659364`19.26039047950006, 
   -36.427066924825840743`19.260394207978564, \
-36.427530894447908594`19.260399739529152, 
   -36.428219161173100104`19.260407945070668, \
-36.429239973307598888`19.26042011494544, 
   -36.430753599916993579`19.260438159407208, \
-36.432997064048390001`19.260464903133247, 
   -36.436320313420626604`19.260504515659267, \
-36.441238725078317628`19.260563135598634, 
   -36.448508446587251086`19.260649765064894, \
-36.459232554258786507`18.52041483760949, 
   -36.475006245569463914`19.260965379265215, \
-36.498105478362791842`19.261240326281627, 
   -36.531709295984018837`18.52127730789812, \
-36.580108775517803821`19.26221499690717, 
   -36.648774029553539577`17.559738077469937, \
-36.744006774072804688`19.26415651681181, 
   -36.871754307606945389`19.265663805570785, \
-37.035420313683271587`18.527224592650164, 
   -37.235103645507525272`19.269922571394407, \
-37.481388969064848737`18.532422991252375, 
   -37.851217814372052572`19.277049861264675, \
-38.566197695973077231`19.285176827514793, 
   -39.986911834726132753`19.300887869461658, \
-42.489958329645535428`19.327256309508524, 
   -46.176507919412866698`19.36339109080644, \
-51.054449112591161253`19.40700359876784, 
   -58.155087273949231274`19.46355771614968, \
-68.625786885051727637`18.795094652086835}, 
  {-15.5557502387203481218`19.15049827639252, \
-15.555771265591003427`18.150498863432524, 
   -15.55580246899066843`18.890862424079376, \
-15.5558487740616566695`19.150501027350767, 
   -15.5559174894903069484`19.150502945771677, \
-15.5560194609361417404`19.150505792629872, 
   -15.5561707825036510398`19.15051001721973, \
-15.5563953361027405007`19.150516286222977, 
   -15.556728558857473743`18.890888278338466, \
-15.5572230317567576917`19.150539392738658, 
   -15.5579567684194355335`19.15055987520322, \
-15.5590455050329925511`19.15059026581087, 
   -15.5606609150635080139`19.150635353875227, \
-15.5630575870255647429`19.150702239289966, 
   -15.5666129396302643782`19.150801441754886, \
-15.5718861802930668146`19.150948535507524, 
   -15.5797051546459588421`19.1511665492488, \
-15.5912936880753552059`19.15148946712378, 
   -15.6084567696830518456`19.15196728071377, \
-15.6338457757312578876`19.1526731382695, 
   -15.6713270505928363717`19.153713088996845, \
-15.726461618029109246`18.89560102367723, 
   -15.8070303509060465784`19.157457602019115, \
-15.9232769329021301983`19.160639763132114, 
   -16.0866891209727107535`19.165073983897184, \
-16.3038085676612070072`19.170896382234226, 
   -16.5596111464088657781`19.17765744928631, \
-16.8118934465594023207`19.18422394363426, 
   -17.1009767021576983835`19.19162823016049, \
-17.7092002904284555596`19.20680626466563, 
   -19.0596377240923899875`19.238721956373734, \
-21.5070031847877167762`19.291187214258425, 
   -25.1049573838997908125`19.35836680333036, \
-29.9903108691002096007`19.435588282369736, 
   -37.175938010908151199`19.26923193964224, \
-47.84219628537698199`19.37878111287335}, 
  {-4.648859310796682465`18.366316407591768, \
-4.64888044654034438`18.366318382079562, 
   -4.64891181154468569`18.366321312161872, \
-4.648958356520221713`18.366325660303044, 
   -4.649027428152507468`18.36633211276048, \
-4.649129928615707285`18.366341687858828, 
   -4.649282036155154785`18.36635589662163, \
-4.649507758147844782`18.366376981046177, 
   -4.649842719237931021`18.366408267479247, \
-4.650339781617734758`18.36645469053576, 
   -4.651077382651720882`18.366523569514936, \
-4.652171901547184518`18.366625758224345, 
   -4.653795997229915215`18.366777346067312, \
-4.656205789321422372`18.36700217082143, 
   -4.65978111963968189`18.367335521720182, \
-4.66508512244455531`18.3678295769353, 
   -4.672952192886226541`18.36856134228909, \
-4.684617434775116607`17.62928144523099, 
   -4.701905863480689618`18.371243934233377, \
-4.727505160481907609`18.373602015923453, 
   -4.765347115755947271`18.377064545190073, \
-4.821102698202949455`18.382116387175135, 
   -4.902692891395624031`18.389404693880486, \
-5.020332469343204096`18.39970248339737, 
   -5.184412824809669473`18.41366958060876, \
-5.396918637705194754`18.4311158751598, 
   -5.634226852901022653`18.449804333492644, \
-5.860358592912241704`18.466894195466445, 
   -6.154046745556069453`18.48813079511973, \
-6.802581698154941847`17.791281081147275, 
   -8.182180392752703923`18.611839054506127, \
-10.6135403278967945793`18.98446758926187, 
   -14.2050103132029406082`19.111048868209817, \
-19.1807819217974895308`19.24147362244181, 
   -26.5069454818799883354`19.381966999693155, \
-37.379205533714387144`19.271600070881494}, 
  {0``17.698970004336022, -0.00002159767588239`13.033377023738833, 
   -0.000053648207167356`13.428525217491035, \
-0.000101210553726361`13.704195805240449, 
   -0.000171792081651745`13.93397314651922, \
-0.000276533501093468`14.140717756463877, 
   -0.000431967236778519`14.334420812665073, \
-0.000662626694367674`14.520238932083373, 
   -0.00100491809012837`14.70110066862488, \
-0.001512865564762933`14.87877034209112, 
   -0.002266635458539667`14.313988993294238, \
-0.003385183085232057`14.48818947700792, 
   -0.005045013233328177, -0.007508003924574069`15.574494495299236, 
   -0.011162657042522284`15.746737586174044, \
-0.016585216504058309`15.918691149525506, 
   -0.024630116293341331`16.090436466740986, \
-0.036563521235809304`16.262018017974455, 
   -0.054259512499079676`16.433445891809686, \
-0.080485029041252431`16.604685109431426, 
   -0.11930213355273267`16.7756182148286, \
-0.176593228725760554`16.945944051349844, 
   -0.260585248666327374`17.11491983165986, \
-0.381740402733054651`17.28073813168211, 
   -0.549819868383703891`17.439190433865843, \
-0.763345783130422006`17.581691315145004, 
   -0.994807791530060825`17.696709182426943, \
-1.228811142204733642`17.788455144992284, 
   -1.598838362069194829`17.902774564386366, \
-2.411491660528575664`18.08125576871016, 
   -4.006950710216340639`18.301784004514484, \
-6.65267696304094791`18.521966440066024, 
   -10.422035921002700931`18.716922570025943, \
-15.5041871903571024658`19.14905631805004, 
   -22.9344289522113449207`19.319095245880913, \
-34.043325582801056583`19.231001982649676}, 
  {-0.534652505916913156`17.42704161103909, \
-0.534673823363689848`17.427058926706444, 
   -0.534705458048954085`17.42708462155483, \
-0.534752403307113155`17.4271227494088, 
   -0.534822069130068911`17.42717932421179, \
-0.534925451754730829`17.4272632664555, 
   -0.535078869272386015`17.42738780498398, \
-0.535306537159108586`17.42757255135254, 
   -0.535644390132347325`17.42784656519034, \
-0.536145753306339401`17.42825287472231, 
   -0.536889757158750314`17.428855122860877, \
-0.537993823082217659`17.429747293726003, 
   -0.539632186845246053`17.43106784999191, \
-0.542063375559209248`17.433020069558207, 
   -0.545670954953958898`17.435900842050028, \
-0.551023926455645352`17.440140461449246, 
   -0.558966165286221894`17.446355524790942, \
-0.570748604433283901`17.455414862583854, 
   -0.588223745780823037`16.72814986723558, \
-0.614128931297347691`17.487229561589267, 
   -0.652488064078816876`17.513542575898647, \
-0.709140411842863472`17.549702239591067, 
   -0.792279129610175658`17.597848220133216, \
-0.91237779716261258`17.65914471245413, 
   -1.079317805689605336`17.732119346085756, \
-1.291923703145382518`17.810206870718492, 
   -1.523322345102581465`17.881761816986955, \
-1.760123859345007702`17.94451323438732, 
   -2.141987443275610303`18.029786924925183, \
-2.989865243154550711`18.174621618923585, 
   -4.674003386452515229`18.36865902705143, \
-7.506536670576430481`18.574409614871133, 
   -11.5396725800917252512`19.020800801419142, \
-16.7813015398753151429`19.183432956058247, 
   -24.297432141155958618`19.08453038222017, \
-35.611614572938432133`19.2505616686652}, 
  {-5.243973153760929762`18.41863046401247, \
-5.243993890892273413`18.418632181413308, 
   -5.244024664404848934`18.418634729991314, \
-5.244070331709195898`18.418638512004787, 
   -5.244138101095650484`18.418644124378105, \
-5.24423866949523898`18.418652452892985, 
   -5.244387910869029667`17.67830212244396, \
-5.244609381687354244`18.418683151833175, 
   -5.244938038881411302`18.418710366354475, \
-5.24542575691474866`18.418750748795897, 
   -5.246149514333543706`18.418810668082678, \
-5.247223540885105564`18.41889957063173, 
   -5.248817339928679715`18.419031463817564, \
-5.251182424466803056`18.41922711014224, 
   -5.254691970705485104`18.41951726716579, \
-5.259899605131497679`18.419947459259056, 
   -5.267626483038331031`18.420584976755904, \
-5.279090039668160372`18.421529073686393, 
   -5.296093572277541739`18.422925654023857, \
-5.321302616398062568`18.424987961793867, 
   -5.358637585623306165`18.42802439024952, \
-5.413792526429022089`18.43247161255781, 
   -5.494769573217560321`18.438919489052147, \
-5.611833611970812541`18.448074790271427, 
   -5.774774299761148199`18.460505019344573, \
-5.982766472769526444`18.475872055553978, 
   -6.209698524478454828`18.492040520400906, \
-6.44125236601045259`18.507940319330878, 
   -6.814758606758736903`18.532420481145106, \
-7.656847181501307275`18.583019983688935, 
   -9.360294297711041267`17.929896818479737, \
-12.2845339322187054874`19.047965999100676, 
   -16.5086186978654438916`19.17631805152122, \
-21.89675285485616385`19.03934972092154, 
   -29.4839447305283393062`19.428192903258477, \
-40.916585920685573541`19.310869393362843}, 
  {-13.0196300080501874417`19.073205957465248, \
-13.0196501271877984605`19.07320662857677, 
   -13.0196799836136420934`19.073207624491864, \
-13.0197242899882947851`19.073209102406942, 
   -13.0197900398026096268`19.07321129559543, \
-13.0198876112440089513`19.07321455022393, 
   -13.0200324052967051356`19.073219379982095, \
-13.020247276614325571`18.813589236636496, 
   -13.0205661408041386549`19.073237182828315, \
-13.0210393273744085006`19.07325296544331, 
   -13.0217415229570896427`19.07327638534371, \
-13.0227835578369113277`19.0733111373691, 
   -13.0243298943620118278`19.07336270280817, \
-13.0266245729594221102`19.07343921180951, 
   -13.0300296986527008867`19.07355272041977, \
-13.0350825079295660201`19.073721099300872, 
   -13.0425799200312706459`19.073970821437822, \
-13.053703593770901392`18.814703751423483, 
   -13.0702041517978955197`19.074889685995917, \
-13.0946698907811960309`19.075701869422865, 
   -13.1309087368411017137`19.07690209772782, \
-13.1844529981875382417`19.07866943116337, 
   -13.2630785888954623173`19.081251657838536, \
-13.3767548756205734149`19.08495808368867, 
   -13.5349539423960294469`19.09006409710587, \
-13.7367002367486588098`19.09648973598741, 
   -13.9561461390873713382`19.1033728232724, \
-14.1791034998370228946`19.110256087481346, 
   -14.5426221770445547319`19.121250035969116, \
-15.3766850810872455211`19.145470034822065, 
   -17.086442174335108035`18.931621645470358, \
-20.0603485821458029646`19.260945790185556, 
   -24.4100840633454190252`19.34617658988306, \
-29.9183869599328282616`19.43454548982015, 
   -37.567621804108075167`18.53342101802218, \
-49.067127538692549393`19.38976063882785}, 
  {-22.9613758045657228022`19.31960522149585, \
-22.9613953347606098985`19.319605590892365, 
   -22.9614243172115770618`19.319606139069442, \
-22.9614673266353399582`19.319606952552864, 
   -22.9615311518243352394`19.31960815974439, \
-22.9616258672145043816`19.31960995118792, 
   -22.9617664230662157364`19.319612609642697, \
-22.9619750052504585368`19.319616554708535, 
   -22.9622845370966714993`19.319622409042346, \
-22.9627438759946507217`19.319631096607957, 
   -22.9634255248676275583`19.319643988444927, \
-22.9644370753700215458`19.319663118915035, 
   -22.9659381880757891279`19.31969150644557, \
-22.9681657870962716571`19.319733629133484, 
   -22.9714714376513065018`19.31979612966176, \
-22.9763767806104439727`19.319888859287612, 
   -22.9836556903689768204`19.320026421869663, \
-22.9944558422556220021`19.32023045140885, 
   -23.0104778918489074611`19.320532953225225, \
-23.034236980217528412`19.061343834956862, 
   -23.0694345869799448677`19.321644265289887, \
-23.1214495322758288863`19.322622372277777, 
   -23.1978395672425214967`19.324054855434646, \
-23.3082724376056198422`19.326117400519433, 
   -23.4618326787864859282`19.328969248077264, \
-23.6571631289786132866`19.332569979423717, 
   -23.8684158818485521179`19.336430911200797, \
-24.0822319077792244`19.08066673859599, 
   -24.4368542957489438548`19.346652614205837, \
-25.2644152748662342843`19.361116566126192, 
   -26.976566884386958378`19.12995668362165, \
-29.9787129321319412155`19.435420298308284, 
   -34.409893531713631631`19.23565333320046, \
-40.013513041000539516`19.301176686865833, 
   -47.716971059871799099`19.377642872407804, \
-59.25889647258636117`19.4717235640631}, 
  {-34.400461122059379448`19.235534268460565, \
-34.400480133207015143`19.235534508469968, 
   -34.400508345407406097`18.495172175145115, \
-34.400550211806777412`19.2355353931878, 
   -34.400612340798037536`19.235536177543096, \
-34.400704539126873982`19.23553734150993, 
   -34.400841359849042789`19.23553906881079, \
-34.401044399485410707`18.495178942589124, 
   -34.4013457069880495`19.235545435910115, \
-34.401792842643896364`19.23555108066854, 
   -34.4024563855056833`19.235559457273375, \
-34.403441074455503923`19.235571887747888, 
   -34.404902341485165351`19.235590333772777, \
-34.407070846309817824`19.23561770603478, 
   -34.410288881541635675`19.23565832296488, \
-34.415064379669235706`19.23571859065375, 
   -34.422150986341296885`19.235808009557978, \
-34.432666608198776004`19.23594066190509, 
   -34.448268270960586079`19.236137398960818, \
-34.47140755090771691`19.236429021399662, 
   -34.505694107489578215`19.236860772319762, \
-34.556375660160359331`19.23749819088206, 
   -34.63082546479025936`19.238432847907738, \
-34.738455950095836755`19.239780515417284, 
   -34.888009265724004848`19.241646193343406, \
-35.077734482397378457`18.503638851258536, 
   -35.281664646652355799`19.24651907200329, \
-35.487325243017320275`19.249043271196314, 
   -35.834536357561521669`19.253271794091624, \
-36.656966952455373843`19.263126532329775, 
   -38.369784773044923298`19.282959367460812, \
-41.388309984620807569`19.31584769748386, 
   -45.871643644426473685`19.360514306118663, \
-51.547261765614880602`19.41117560447605, 
   -59.295794174109428098`19.471993894466667, \
-70.866794131277632829`19.549412790948423}, 
  {-46.863009746916102216`19.36980018177883, \
-46.863028330609250105`19.36980035399982, 
   -46.863055908481197065`19.369800609572593, \
-46.863096833562433829`19.369800988837852, 
   -46.863157565684911532`19.369801551660423, \
-46.863247691152455587`18.629439697384242, 
   -46.863381435932755181`19.369803626326025, \
-46.86357991125005995`19.36980546564171, 
   -46.863874446097188553`19.369808195148448, \
-46.864311532821435691`19.36981224567712, 
   -46.864960166701610689`19.36981825656592, \
-46.865922738596591301`19.369827176564318, 
   -46.867351201077500633`19.369840413557906, \
-46.869471061504182074`19.36986005671763, 
   -46.872616990875169307`18.629526516558442, \
-46.877285665262785841`19.36993246112749, 
   -46.884214145323642953`19.369996645268525, \
-46.894495990036570987`18.62972918737715, 
   -46.909752677564537038`19.370233147557062, \
-46.932384315117541717`18.63007993316241, 
   -46.965926955942730814`19.370752902665767, \
-47.01552486961980648`19.37121129316315, 
   -47.08840899254986212`19.371884021229597, \
-47.193799556196115219`19.37285494798247, 
   -47.340181286932232041`19.37419992104196, \
-47.525482416726813284`19.375896538287158, 
   -47.723563487557701279`19.377702869032607, \
-47.92261170321741659`19.37951048269448, 
   -48.263900771987440663`19.382592423758933, \
-49.082317505964976334`19.389895064835375, 
   -50.795047453737165455`19.404791374722986, \
-53.823294748038915003`19.429940283551495, 
   -58.339972736506222617`18.724573536672615, \
-64.067707036014500232`19.505609185336997, 
   -71.851614142840777077`17.85211515520054, \
-83.443082406695172182`19.62036034298907}, 
  {-60.020831023713103747`18.736909319034815, \
-60.020849273911306199`19.47727214058253, 
   -60.02087635688854661`19.477272336547518, \
-60.020916547567598087`18.736909937861828, 
   -60.020976189878258111`19.477273058910857, \
-60.021064698145845995`19.477273699330695, 
   -60.021196043165023326`19.477274649702952, \
-60.021390957576119973`19.477276060039987, 
   -60.021680208754457197`18.73691546346438, \
-60.022109456045182441`19.47728125882075, 
   -60.022746459510987193`19.47728586788272, \
-60.02369177905506703`19.477292707686843, 
   -60.025094654742456868`19.477302857913067, \
-60.027176578791394235`19.47731792082053, 
   -60.030266286321893432`19.47734027416905, \
-60.034851694646523157`18.737010756966093, 
   -60.041656977769516601`19.47742267335649, \
-60.051756819063069059`19.477495721581427, 
   -60.06674523903411611`19.477604104353574, \
-60.088982828882731013`19.477764856784237, 
   -60.121949699271343803`19.478003060247985, \
-60.170712811188185043`19.47835516071935, 
   -60.24239954685856091`19.478872266486253, \
-60.346095071955385691`19.479619176970377, 
   -60.490106437977868126`19.480654353025646, \
-60.672125486271081485`19.48195921389668, 
   -60.865828433854144208`19.483343541833392, \
-61.059819440533619428`19.484725520052088, 
   -61.396547480897343263`19.48711395443236, \
-62.211890711510097418`19.492843404731868, 
   -63.924264500705266556`19.50463574416114, \
-66.958432666494903884`19.52477528366622, 
   -71.496569452897890784`19.553255208327045, \
-77.260965137450373419`19.586930133348694, 
   -85.07136365301176184`19.628753398728225, \
-96.677257695588682651`19.684294327240803}, 
  {-73.649316825324863345`19.56613872699644, \
-73.649334825872731613`19.56613883314186, 
   -73.649361538378190772`19.5661389906598, \
-73.649401179294390118`19.566139224413718, 
   -73.649460005790221117`18.82577688180637, \
-73.649547303454514946`19.566140086075215, 
   -73.649676852072960997`18.825778160498782, \
-73.649869100906034447`18.82577929414256, 
   -73.650154396961273306`19.56614366595157, \
-73.650577776125093265`19.566146162493606, 
   -73.651206074051035699`19.566149867354678, \
-73.652138480585325197`18.825792675889193, 
   -73.653522206519955517`18.82580083503984, \
-73.655575741228094699`19.56617563293478, 
   -73.658623382651658318`19.566193602334348, \
-73.663146505662059127`18.825857580553457, 
   -73.669859669731952323`19.566259846924456, \
-73.679823501819246445`19.566318581184454, 
   -73.694611637725333963`19.566405738849713, \
-73.716555482292836387`18.826172348795453, 
   -73.749094189592629078`19.566726694872628, \
-73.797238976014842393`19.567010117921768, 
   -73.868044434296226797`18.827063916602224, \
-73.970504195180826201`19.568028583270976, 
   -74.112807728709274357`18.82850058146149, \
-74.292480745997426794`19.569914864721458, 
   -74.483030834541782639`19.571027344811135, \
-74.673300717905963353`19.572135352823658, 
   -75.006629357259317459`19.57406965394159, \
-75.819682403830856998`19.578751965242148, 
   -77.531658614881184377`17.885157701036675, \
-80.569520747377143976`19.605140784668805, 
   -85.121598739345078144`19.62900977620846, \
-90.911341516021241915`19.65758807073259, 
   -98.740917734715441867`18.953104474238057, \
-110.356901003952177831`19.741769500639542}, 
  {-87.595777145475626213`19.641453174355437, \
-87.595794964808650462`19.641453262702584, 
   -87.59582140839835418`19.64145339380823, \
-87.595860650256714308`19.64145358836681, 
   -87.59591888457618225`19.641453877088615, \
-87.596005303501673467`18.90109161605319, 
   -87.596133548176116079`19.641454941374533, \
-87.59632386217464628`19.641455884934786, 
   -87.596606287399655599`19.641457285170702, \
-87.597025407249038409`19.641459363116528, 
   -87.597647386514413625`19.641462446796623, \
-87.598570420870164099`19.641467023022436, 
   -87.59994024881629926`19.64147381427558, \
-87.601973181608844499`19.64148389283553, 
   -87.604990299867967707`18.901136160712678, \
-87.60946823736819411`19.641521048643778, 
   -87.616114592511753045`19.641553994465024, \
-87.625979829903219098`19.64160289159993, 
   -87.640622882890983902`19.641675459870523, \
-87.662354190376053253`19.641783133877336, 
   -87.694583690874271298`19.64194277505889, \
-87.742283327079821475`19.64217893624502, 
   -87.812457511031727364`19.642526135783356, \
-87.914038836944616406`19.643028236663294, 
   -88.055140232810220624`19.643724717388736, \
-88.23317326118730719`19.644601903023716, 
   -88.421505866186979716`19.64552791123936, \
-88.609110079615934552`19.646448379201786, 
   -88.939973253131316966`19.648066998843817, \
-89.751363143009175616`19.6520110576977, 
   -91.462991081090951439`19.660215404188165, \
-94.50320523071716039`19.6744165429025, 
   -99.064424006622719076`19.694887723084037, \
-104.87151441901444926`19.719627543905844, 
   -112.714652903372101633`19.75095038232908, \
-124.337628969279354147`19.053209896264008}, 
  {-101.756813241383301971`19.7065335018802, \
-101.756830932097020792`19.706533577383535, 
   -101.756857184820805884`19.706533689429197, \
-101.756896143443842817`18.966171166208877, 
   -101.75695395746086902`19.70653410245103, \
-101.757039752695266799`19.7065344686214, 
   -101.757167071889629284`19.706535012013664, \
-101.757356012638414455`19.706535818402553, 
   -101.757636400307038826`19.70653701507918, \
-101.758052497167998496`19.706538790947878, 
   -101.758669991935111199`19.70654142635362, \
-101.759586374822593058`19.706545337354417, 
   -101.760946339720337761`19.70655114143957, \
-101.762964652755673711`19.706559755092968, 
   -101.765960112839668028`19.70657253864977, \
-101.770405992794355399`19.70659151138834, 
   -101.777004959597579869`19.706619670870758, \
-101.786800286210652899`19.706661466673253, 
   -101.801340519729155431`19.70672350116277, \
-101.822921332453791621`19.706815557264843, 
   -101.854932194180438642`19.706952068333496, \
-101.902317792454301326`19.707154066586074, 
   -101.97204830794503394`19.707451147380073, \
-102.073015838850754022`19.707880950916717, 
   -102.213283606404250037`18.968114655083486, \
-102.390185573480057002`19.70922833445675, 
   -102.576981520175809947`18.96965723000026, \
-102.762711760905549596`19.71080556049143, 
   -103.091824355723705508`19.71219422948392, \
-103.902031632081506274`19.715594043885268, 
   -105.613385218669538545`19.722688967592713, \
-108.655121129882761721`19.735020204629343, 
   -113.222379031118368431`19.752902280385673, \
-119.041271745640120372`19.77466756223174, 
   -126.893850668867262497`19.062047891347145, \
-138.521635718073614637`19.100124926069903}, 
  {-116.062558877905463106`19.763662145735164, \
-116.062576478782066402`19.763662211595875, 
   -116.062602598191251246`19.763662309332066, \
-116.06264135898233647`19.76366245437099, 
   -116.06269887943024699`19.763662669606546, \
-116.062784239035114098`19.763662989013138, 
   -116.062910911811190573`19.763663463008815, \
-116.063098893392638189`19.76366416641438, 
   -116.063377857907102708`19.763665210265568, \
-116.063791843346269417`19.02330406984972, 
   -116.064406205933341454`19.763669058196783, \
-116.065317943219401542`19.763672469758777, 
   -116.066671019643994356`19.7636775326855, \
-116.06867912250853081`19.763685046474265, 
   -116.071659457916542379`19.76369619785993, \
-116.076082953189445135`19.763712748523474, 
   -116.08264883544535806`19.76373731384058, \
-116.092395365011444852`19.763773776536436, 
   -116.106863858808043943`19.7638278989057, \
-116.128339731842036286`19.763908221380802, 
   -116.160198290005755695`19.76402734905035, \
-116.207365492158135822`19.764203659853546, 
   -116.276788298408906286`19.76446303187592, \
-116.377331928175895115`19.764838400653172, 
   -116.517027186403328898`19.76535939985043, \
-116.693155543136530383`19.76601538825612, 
   -116.87889669904607004`19.766706107674842, \
-117.063326818409212393`19.767390866488583, 
   -117.391215841907982309`19.768605605045614, \
-118.200595542211349453`19.771589669037304, 
   -119.911745157149699281`19.777831727944637, \
-122.954477570587332737`19.048351663685448, 
   -127.525748714564119977`18.101276508208063, \
-133.352642553195014587`19.083608941053647, 
   -141.211723202223058847`19.1084780675823, \
-152.842795562536228007`19.142852287369532}, 
  {-130.465862921852679077`18.111175517323925, \
-130.465880460683454347`19.074104264331563, 
   -130.465906488019161457`19.07410435097128, \
-130.465945112178079767`19.07410447954323, 
   -130.466002429873388027`19.07410467034209, \
-130.466087488612462407`19.07410495348504, 
   -130.466213714943140897`19.07410537366605, \
-130.466401034082426947`19.074105997211472, 
   -130.466679015709676297`19.07410692255131, \
-130.467091542925320627`19.074108295760247, 
   -130.467703742336258447`19.07411033362435, \
-130.468612271276132477`18.1111846692559, 
   -130.469960590478624597`19.074117846044587, \
-130.471961642351093497`19.07412450688144, 
   -130.474931533363818657`19.074134392473585, \
-130.479339571903498297`19.074149064675012, 
   -130.485882611577697077`18.111242153711242, \
-130.495595455828865997`19.07420316826695, 
   -130.510014439813776477`18.11132246393826, \
-130.531417921753448037`19.07432237048419, 
   -130.563171489416792067`19.07442800575849, \
-130.610188315499872407`19.074584370468582, 
   -130.679399655411518917`19.074814445489523, \
-130.779652843552330667`19.075147495029174, 
   -130.918957407949168467`19.075609852924597, \
-131.094559389063025637`19.07619198306628, 
   -131.279580985446390427`19.076804496719852, \
-131.463117367251673077`18.114482552650546, 
   -131.790160786512220877`18.11556161405022, \
-132.598968044421301467`19.08114745901342, 
   -134.309971180521475987`19.08671557075643, \
-137.353361867444338177`17.137405216219832, 
   -141.927311350820676947`19.110673290479994, \
-147.759617650981486037`19.128163073476696, 
   -155.623144220607120047`19.15068150042501, \
-167.256453858008146797`19.181990199552743}, 
  {-144.934925212872915527`19.119780365596423, \
-144.934942709185609287`19.119780418023755, 
   -144.934968673426286757`19.119780495825044, \
-144.935007203955539267`19.11978061128092, 
   -144.935064382710951487`19.119780782615738, \
-144.935149235276501397`19.119781036874368, 
   -144.935275155673057417`19.119781414191465, \
-144.935462020863813137`19.119781974127395, 
   -144.935739328954500847`19.119782805071434, \
-144.936150856907350007`19.119784038197686, 
   -144.936761573988608377`18.15685717955494, \
-144.937667904410293577`18.15685989531226, 
   -144.939012963773510737`19.119792614284044, \
-144.941009184125224607`19.119798595706822, 
   -144.943971918597615197`19.119807473015523, \
-144.948369366635890997`19.11982064885459, 
   -144.954896756405762657`19.119840205787472, \
-144.964586524857796947`19.119869236005954, 
   -144.978971598855881807`19.11991232962255, \
-145.000325513783000277`18.157047603408756, 
   -145.032007228222600047`19.120071172446558, \
-145.078921223272207187`19.120211632438608, 
   -145.147988149652494627`19.120418335432756, \
-145.248043406660062967`19.12071760569131, 
   -145.387082467335861937`19.121133136341612, \
-145.562327482818606227`19.12165630600483, 
   -145.746860205857021957`19.122206522458367, \
-145.929786099766037207`19.122751260734418, 
   -146.256249753150971317`19.12372174805968, \
-147.064664282521963657`19.126115650719562, 
   -148.775564496098187557`19.131138921616454, \
-151.819392734473158417`19.139934564791513, 
   -156.395135087262278977`18.18990186574926, \
-162.231097773820213347`19.168741421788777, 
   -170.097649942774499007`19.189305628313633, \
-181.732477494457388187`19.21803986205194}, 
  {-159.448306491369695687`19.16122722578131, \
-159.448323958702335547`19.161227273357643, 
   -159.448349879937868677`18.198298655335716, \
-159.448388346649810647`19.16122744873312, 
   -159.448445430704769167`19.16122760421468, \
-159.448530142744122177`17.202186442626232, 
   -159.448655854618554177`17.2021867850311, \
-159.448842410402225057`19.16122868547877, 
   -159.449119259417589237`19.16122943953815, \
-159.449530106285411787`19.161230558567834, 
   -159.450139813033846537`19.161232219229802, \
-159.451044644989284647`19.161234683714376, 
   -159.452387482532206067`19.16123834116598, \
-159.454380409894529437`19.161243769193504, 
   -159.457338266834685927`19.161251825222003, \
-159.461728497167403167`19.1612637821917, 
   -159.468245221658978747`19.161281530147175, \
-159.477919265396909767`19.16130787555767, 
   -159.492281234768430667`19.16134698469101, \
-159.513601383990621937`19.161405035176468, 
   -159.545234167399659237`19.16149115059968, \
-159.592078174792991517`19.161618644899345, 
   -159.661046902182594207`19.161806287467844, \
-159.760967763706990037`19.162077997482868, 
   -159.899826897706734737`19.162455308435344, \
-160.074830354021120367`19.16293036507653, 
   -160.259031830877152207`19.163429829561668, \
-160.441542530382125877`18.200995454977058, 
   -160.767610867510118307`19.164805872697194, \
-161.575757494766580887`19.166983515488017, 
   -163.286586401703122107`19.171557824802022, \
-166.330706741470553567`19.17957974768924, 
   -170.907651766886946377`18.228440133325133, \
-176.746082402727271447`19.20595711123018, 
   -184.614686969731398137`19.224873563081967, \
-196.250542146484892927`19.251418180008887}, 
  {-173.991555558809782407`19.199135485749633, \
-173.991573006462321157`19.19913552930013, 
   -173.991598898493382567`19.199135593928343, \
-173.991637321867447237`19.199135689835607, 
   -173.991694341612177507`19.19913583216059, \
-173.991778958221264157`19.199136043369045, 
   -173.991904528490127997`19.199136356800263, \
-173.992090874158325417`19.199136821930246, 
   -173.992367411420278957`19.199137512182954, \
-173.992777795771164757`19.19913853652357, 
   -173.993386816416151677`18.236211368041804, \
-173.994290630787791227`19.199142312617333, 
   -173.995631959538943787`19.19914566059748, \
-173.997622650722863827`19.19915062935009, 
   -174.000577195514328107`19.199158003770414, \
-174.004962524685257817`19.199168949137906, 
   -174.011472007202289807`19.199185195682936, \
-174.021135374067856817`19.199209312658294, 
   -174.035481657050215887`19.199245114371195, \
-174.056778884948617047`19.199298256998116, 
   -174.088378459848545527`19.199377094923953, \
-174.135174985995778487`19.1994938215095, 
   -174.204077134625354257`19.199665630016, \
-174.303906966446252367`19.199914436633076, 
   -174.442644393978898877`18.237331287783345, \
-174.617484616636719607`19.2006950427127, 
   -174.801462055527938587`19.2011523756344, \
-174.983691218664862537`19.20160488842067, 
   -175.309491025765229467`19.202412743705327, \
-176.117455617514142577`18.24148102876424, 
   -177.828235576176727047`19.208608034250723, \
-180.872551501773077827`19.215979979900638, 
   -185.450304464261055417`19.226834865512824, \
-191.290399965844418517`19.240300490062612, 
   -199.160393752386031707`19.25781029107303, \
-210.796943594271684927`19.282471624466886}, 
  {-188.554932632264499407`19.234045212956808, \
-188.554950066585806927`19.234045253112903, 
   -188.554975938833852207`19.234045312703877, \
-188.555014332851047957`19.23404540113596, 
   -188.555071309032232567`19.234045532367876, \
-188.555155860997306407`19.234045727114395, 
   -188.555281335343241977`18.271117327491876, \
-188.555467538680236577`18.271117756368973, 
   -188.555743864762153097`19.234047081446988, \
-188.556153935807007117`19.234048025949626, 
   -188.556762491690879107`19.234049427611836, \
-188.557665616761202187`19.234051507735035, 
   -188.559005923476096457`19.23405459477867, \
-188.560995099911426817`19.234059176282422, 
   -188.563947401133280127`19.234065975981856, \
-188.568329410426319017`19.234076068368918, 
   -188.574833987595216197`19.23409104889751, \
-188.584490122751933687`19.234113286747398, 
   -188.598825781575104797`19.234146299329144, \
-188.620107486660376847`19.234195302845553, 
   -188.651684575521390027`19.2342680024524, \
-188.698448959587299357`19.23437564526076, 
   -188.767306057405480857`19.23453409278908, \
-188.867074335113276357`19.234763567729576, 
   -189.005729539956409017`19.235082284464077, \
-189.180459559822171657`19.235483590968844, 
   -189.364285653808597227`19.235905388737976, \
-189.546324297328059317`19.236322681800665, 
   -189.871942168239261407`19.237068107584093, \
-190.679783400576841497`19.238911964767706, 
   -192.390529963763331267`19.24279100579876, \
-195.434977118798801857`19.24960960713288, 
   -200.013273381177729247`19.259666132330366, \
-205.854491584576070547`19.272167662245796, 
   -213.725424331381763207`19.288463502846056, \
-225.362443283190092557`19.31148885727998}, 
  {-203.131873743161751377`18.303456700802297, \
-203.131891168467834777`18.303456738057466, 
   -203.131917027337667747`19.266385481967962, \
-203.131955401502327877`18.303456875387205, 
   -203.132012348223785377`18.303456997138817, \
-203.132096856473456367`19.2663858664411, 
   -203.132222265951700277`18.303457445940868, \
-203.132408373037609547`19.266386532460032, 
   -203.132684556309701667`19.266387122935917, \
-203.133094415482478467`19.266387999207492, 
   -203.133702657073801137`19.266389299613873, \
-203.134605316008165947`19.266391229470507, 
   -203.135944931579221157`19.26639409351098, \
-203.137933083682586497`19.26639834405986, 
   -203.140883867725538177`17.307363260259773, \
-203.145263632026289007`19.26641401596911, 
   -203.151764892117601137`19.266427914477767, \
-203.161416137194780877`18.303519857635322, 
   -203.175744612247857647`19.266479174901434, \
-203.197015821893987917`19.266524640394596, 
   -203.228577708862818697`19.266592092610182, \
-203.275320366767889627`19.266691969037364, 
   -203.344147021673880007`19.266838991199933, \
-203.443873723464239587`19.267051931379797, 
   -203.582473426462659207`19.267347701365964, \
-203.757129091772643647`19.267720127694542, 
   -203.940853030168913307`19.268111546350205, \
-204.122762922915772067`19.268498752975688, 
   -204.448257743495165787`19.269190728799824, \
-205.256015531453162027`19.270903208885787, 
   -206.966739402913024297`19.274507872596274, \
-210.011274730164021917`19.280849925869283, 
   -214.589936583778015947`19.290216666261962, \
-220.431911699329308617`19.30188178193485, 
   -228.303478458206487997`19.317119843343384, \
-239.940813982678381677`18.37578275405113}, 
  {-217.717955382780733227`19.29650156199083, \
-217.717972801997266427`19.296501596737937, 
   -217.717998651830558997`19.296501648302076, \
-217.718037012585345027`19.296501724822452, 
   -217.718093939407541627`19.296501838377587, \
-217.718178418128733397`19.296502006891995, 
   -217.718303783790677387`19.29650225696573, \
-217.718489825861727387`19.296502628073764, 
   -217.718765912669827147`19.296503178798236, \
-217.719175628729264107`19.296503996078528, 
   -217.719783658025253457`19.296505208940918, \
-217.720686002099089507`19.2965070088795, 
   -217.722025150824610047`19.296509680114493, \
-217.724012611026555677`18.33358495589863, 
   -217.726962370271596827`19.29651952837329, \
-217.731340618174218807`19.29652826146618, 
   -217.737839637742812467`19.2965412244425, \
-217.747487579867456727`19.296560467561687, 
   -217.761811202848324597`19.296589034898552, \
-217.783075323955618077`18.333702752422163, 
   -217.814626944410665747`19.296694355495454, \
-217.861354931402960487`19.296787515127033, 
   -217.930161033297284947`19.296924654605554, \
-218.029859674516533377`18.334194601490967, 
   -218.168421933726623507`19.297399205125306, \
-218.343027452169113897`19.297746642597197, 
   -218.526682474559354577`18.335183098846336, \
-218.708505439769513857`19.298472987654133, 
   -219.033917135729954137`19.29911868486165, \
-219.841618548842237857`19.300717227656836, 
   -221.552327043593582087`19.304083630784152, \
-224.596921669399680607`19.3100111143578, 
   -229.175829645593839957`19.318776127067892, \
-235.018314980978576757`19.329709023008135, 
   -242.890309559773616147`19.34401750322176, \
-254.527858619016857487`19.364342638576893}, 
  {-232.310196585512759527`19.324675587163046, \
-232.310214000619172477`18.36174693109546, 
   -232.310239844353194627`19.324675668033688, \
-232.310278196057058867`19.324675739730623, 
   -232.310335109448320877`18.361747157503427, \
-232.310419568239300507`19.324676004020002, 
   -232.310544904327546337`19.324676238330444, \
-232.310730902516954897`19.324676586045847, 
   -232.311006924216915337`19.324677102055716, \
-232.311416543682330627`19.32467786781933, 
   -232.312024429690271887`19.324679004230095, \
-232.312926561250211677`18.361752002087464, 
   -232.314265394880468567`19.324683193570376, \
-232.316252388087836067`19.324686908092573, 
   -232.319201455653772117`19.324692421075966, \
-232.323578680080718327`19.324700603725077, 
   -232.330076187444891647`19.324712749681808, \
-232.339721900320800077`18.361802091408805, 
   -232.354042248570667797`19.32475754711601, \
-232.375301585663667227`19.32479728126629, 
   -232.406846277639036917`19.324856232264054, \
-232.453564364578912917`19.324943524737094, 
   -232.522356598963401807`19.325072030694763, \
-232.622036311145738097`19.325258167947116, 
   -232.760573318779993457`19.325516733086793, \
-232.935145026037989877`18.362913645620917, 
   -233.118753573458807437`19.32618452721203, \
-233.300517885315461087`19.326523017692477, 
   -233.625873472999163737`19.32712825295812, \
-234.433536831208105157`19.32862705452101, 
   -236.144234925194272277`18.368855973670886, \
-239.188869456747401187`19.3373482809358, 
   -243.767943178621127487`19.345583907772998, \
-249.610772406754652057`19.355870639024662, 
   -257.483055542335737447`19.369355969086588, \
-269.120748589496404437`19.388554497000005}, 
  {-246.906588533492371337`19.351139993779636, \
-246.906605945826104427`19.351140024406924, 
   -246.906631785445600967`19.351140069857326, \
-246.906670131043799897`19.351140137305002, 
   -246.906727035374618847`19.351140237396404, \
-246.906811480720765677`18.38821169730638, 
   -246.906936796858762047`19.35114060635442, \
-246.907122765445823377`18.388212244837458, 
   -246.907398743224266727`19.351141418889586, \
-246.907808297527939347`19.351142139269083, 
   -246.908416086874698437`19.351143208328978, \
-246.909318075074143197`19.351144794859675, 
   -246.910656696143494317`19.3511471493847, \
-246.912643374320058597`19.351150643765656, 
   -246.915591975286080387`19.35115583002695, \
-246.919968509288398907`19.351163527749502, 
   -246.926464996542510017`19.35117495392726, \
-246.936109205612471127`19.351191915839337, 
   -246.950427344822319497`19.351217096881506, \
-246.971683454819245897`19.351254476909986, 
   -247.003223473282705667`19.35130993582421, \
-247.049934882635628947`19.351392058595987, 
   -247.118717764216544457`19.351512956698098, \
-247.218384711705116527`19.351688079324713, 
   -247.356904694341640297`19.351931352561174, \
-247.531453608851027327`19.352237707044026, 
   -247.715030822609126207`19.352559674295065, \
-247.896755575525194357`19.352878157685165, 
   -248.222073311282688477`18.390519025020033, \
-249.029710995666082597`19.35485847941426, 
   -250.740402063234260057`19.357831632762537, \
-253.785063461555299827`19.363073372919164, 
   -258.364248824572630527`19.37083973278555, \
-264.207309823009584447`19.380552143910897, 
   -272.079787526609866437`19.39330359461598, \
-283.717577644976163497`19.411493558067082}}, 
 {PlotRange -> {0, -10}, DisplayFunction :> $DisplayFunction, ColorOutput -> \
Automatic, 
  Axes -> False, AxesOrigin -> Automatic, Frame -> True, FrameLabel -> None, 
  FrameStyle -> Automatic, FrameTicks -> {{{-4, 0.0001}, {-3, 0.001}, {-2, \
0.01}, 
     {-1, 0.1}, {0, 1}, {1, 10}, {2, 100}}, {{-4, 0.0001}, {-3, 0.001}, {-2, \
0.01}, 
     {-1, 0.1}, {0, 1}, {1, 10}, {2, 100}}, {}, {}}, PlotLabel -> None, \
AxesLabel -> None, 
  Ticks -> Automatic, Prolog -> {}, Epilog -> {}, AxesStyle -> Automatic, 
  Background -> Automatic, DefaultColor -> Automatic, DefaultFont :> \
$DefaultFont, 
  RotateLabel -> True, Contours -> {0, -2, -10, -100, -1000}, ContourStyle -> \
Automatic, 
  AspectRatio -> 1, ContourLines -> True, ContourShading -> True, \
ContourSmoothing -> True, 
  ColorFunction -> (RGBColor[#1, 1 - #1, #1] & ), ColorFunctionScaling -> \
True, 
  PlotRegion -> Automatic, ImageSize -> Automatic, TextStyle :> $TextStyle, 
  FormatType :> $FormatType, MeshRange -> {{-4, 2}, {-4, 2}}}]\
\>", \
"\<\
-ContourGraphics-\
\>"], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*end\ mathematica\ program*) \)], "Input"]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{4, 1440}, {0, 878}},
WindowSize->{762, 744},
WindowMargins->{{47, Automatic}, {Automatic, 46}},
ShowSelection->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 677, 11, 139, "Input"],
Cell[2434, 64, 90, 2, 43, "Input"],
Cell[2527, 68, 215, 4, 75, "Input"],
Cell[2745, 74, 289, 8, 75, "Input"],

Cell[CellGroupData[{
Cell[3059, 86, 1423, 27, 315, "Input"],
Cell[4485, 115, 50570, 1279, 296, 19056, 885, "GraphicsData", "PostScript", \
"Graphics"],
Cell[55058, 1396, 62292, 1319, 25, "Output"]
}, Open  ]],
Cell[117365, 2718, 64, 1, 27, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

