/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 R e p o r t e r   R O U T I N E S 
 
 reports things progress=True or verbose
 
 stuff from world.c comes here, transfer not yet complete.
                                                                                                               
 Peter Beerli 1999, Seattle
 beerli@csit.fsu.edu
 
Copyright 1996-2002 Peter Beerli and Joseph Felsenstein, Seattle WA
Copyright 2003-2004 Peter Beerli, Tallahassee FL
 
  This software is distributed free of charge for non-commercial use
 and is copyrighted. Of course, we do not guarantee that the software
 works and are not responsible for any damage you may cause or have.
 
 
$Id: reporter.c,v 1.24 2004/08/28 19:59:34 beerli Exp $
 
-------------------------------------------------------*/
/* \file reporter.c 
Routines that report progress and also calculates Gelman-Rubin convergence statistic
*/

#include "migration.h"
#include "mcmc.h"

#include "fst.h"
#include "random.h"
#include "tools.h"
#include "broyden.h"
#include "combroyden.h"
#include "options.h"
#include "sighandler.h"

#ifdef DMALLOC_FUNC_CHECK
#include <dmalloc.h>
#endif


void both_chain_means (MYREAL *mc, MYREAL *lc, MYREAL *tc, long len,
                       long lastn, long n);
void calc_gelmanb (MYREAL *gelmanb, MYREAL *mc, MYREAL *tc, MYREAL *lc,
                   long len, long lastn, long n);
void calc_gelmanw (MYREAL *gelmanw, world_fmt * world, MYREAL *mc, MYREAL *tc,
                   long len, long lastn, long n);
void calc_gelmanr (MYREAL *gelmanr, MYREAL *gelmanw, MYREAL *gelmanb,
                   long len, long lastn, long n);
void calc_average_biggest_gelmanr (MYREAL *gelmanr, long len, MYREAL *meanR,
                                   MYREAL *bigR);
void print_gelmanr (MYREAL average, MYREAL biggest);
MYREAL calc_s (long tthis, MYREAL *tc, world_fmt * world);
void chain_means (MYREAL *thischainmeansm, world_fmt * world);


//public function
void
convergence_check (world_fmt * world, boolean progress)
{
    static MYREAL *lastchainmeans, *chainmeans, *thischainmeans;
    static MYREAL *gelmanw, *gelmanb, *gelmanr;

    static boolean done = FALSE;
    static long len = 0;
    static long lastn = 0;
    static boolean first = TRUE;
    long n = 0;
    if (world->chains < 2 || world->repkind != SINGLECHAIN)
        return;

    if (world->start)
        first = TRUE;
    if (progress || world->options->gelman)
    {
        if (!done)
        {
            done = TRUE;
            // len defines the length of arrays that
            // have to hold all km, kt, p, and mindex means
            len = world->numpop2 + world->numpop * 3;
            lastchainmeans = (MYREAL *) mycalloc (len, sizeof (MYREAL));
            thischainmeans = (MYREAL *) mycalloc (len, sizeof (MYREAL));
            chainmeans = (MYREAL *) mycalloc (len, sizeof (MYREAL));
            gelmanw = (MYREAL *) mycalloc (len, sizeof (MYREAL));
            gelmanb = (MYREAL *) mycalloc (len, sizeof (MYREAL));
            gelmanr = (MYREAL *) mycalloc (len, sizeof (MYREAL));
        }
        n = world->atl[world->rep][world->locus].T;
        memset (thischainmeans, 0, sizeof (MYREAL) * len);
        if (first)
        {
            first = FALSE;
            chain_means (lastchainmeans, world);
            return;
        }
        else
        {
            chain_means (thischainmeans, world);
            both_chain_means (chainmeans, lastchainmeans, thischainmeans, len,
                              lastn, n);
            calc_gelmanb (gelmanb, chainmeans, thischainmeans, lastchainmeans,
                          len, lastn, n);
            calc_gelmanw (gelmanw, world, thischainmeans, lastchainmeans, len,
                          lastn, n);
            calc_gelmanr (gelmanr, gelmanw, gelmanb, len, lastn, n);
            calc_average_biggest_gelmanr (gelmanr, len, &world->gelmanmeanR,
                                          &world->gelmanmaxR);
            memcpy (lastchainmeans, thischainmeans, sizeof (MYREAL) * len);
            lastn = n;
        }
    }
}

void
both_chain_means (MYREAL *mc, MYREAL *lc, MYREAL *tc, long len, long lastn,
                  long n)
{
    long i;

    for (i = 0; i < len; i++)
    {
        mc[i] = (lc[i] * lastn + tc[i] * n) / (n + lastn);
    }
}


void
calc_gelmanb (MYREAL *gelmanb, MYREAL *mc, MYREAL *tc, MYREAL *lc, long len,
              long lastn, long n)
{
    long i;
    MYREAL nn = (n + lastn) / 2.;

    for (i = 0; i < len; i++)
    {
        gelmanb[i] =
            nn * (pow ((lc[i] - mc[i]), 2.) + (pow ((tc[i] - mc[i]), 2.)));
    }

}

void
calc_gelmanw (MYREAL *gelmanw, world_fmt * world, MYREAL *mc, MYREAL *tc,
              long len, long lastn, long n)
{
    long i;
    MYREAL s1, s2;

    for (i = 0; i < len; i++)
    {
        s1 = calc_s (i, tc, world);
        s2 = calc_s (i, mc, world);
        gelmanw[i] = 0.5 * (s1 + s2);

    }
}


void
calc_gelmanr (MYREAL *gelmanr, MYREAL *gelmanw, MYREAL *gelmanb, long len,
              long lastn, long n)
{
    long i;
    MYREAL nn = (n + lastn) / 2.;

    for (i = 0; i < len; i++)
    {
        gelmanr[i] =
            sqrt (((nn - 1.) / nn * gelmanw[i] +
                   1. / nn * gelmanb[i]) / gelmanw[i]);
    }
}

void
calc_average_biggest_gelmanr (MYREAL *gelmanr, long len,
                              MYREAL *meanR, MYREAL *bigR)
{
    long i;
    MYREAL average = 0;
    MYREAL biggest = 0.;
    for (i = 0; i < len; i++)
    {
        if (biggest < gelmanr[i])
            biggest = gelmanr[i];
        average += gelmanr[i];
    }
    if (len > 0)
        *meanR = average / len;
    else
        *meanR = average;
    *bigR = biggest;
}

MYREAL
calc_s (long tthis, MYREAL *tc, world_fmt * world)
{
    long i, j;
    MYREAL s = 0;
    long rep = world->rep;
    static long startp, startl, startkm;
    static boolean done = FALSE;

    if (!done)
    {
        startkm = world->numpop;
        startp = startkm + world->numpop;
        startl = startp + world->numpop;
    }
    if (tthis < startkm)
    {
        i = tthis;
        for (j = 0; j < world->atl[rep][world->locus].T; j++)
            s +=
                (world->atl[rep][world->locus].tl[j].kt[i] -
                 tc[i]) * (world->atl[rep][world->locus].tl[j].kt[i] - tc[i]);
        s /= world->atl[rep][world->locus].T - 1.;
        return s;
    }
    else
    {
        if (tthis < startp)
        {
            i = tthis - startkm;
            for (j = 0; j < world->atl[rep][world->locus].T; j++)
                s +=
                    (world->atl[rep][world->locus].tl[j].km[i] -
                     tc[i]) * (world->atl[rep][world->locus].tl[j].km[i] - tc[i]);
            s /= world->atl[rep][world->locus].T - 1.;
            return s;
        }
        else
        {
            if (tthis < startl)
            {
                i = tthis - startp;
                for (j = 0; j < world->atl[rep][world->locus].T; j++)
                    s +=
                        (world->atl[rep][world->locus].tl[j].p[i] -
                         tc[i]) * (world->atl[rep][world->locus].tl[j].p[i] -
                                   tc[i]);
                s /= world->atl[rep][world->locus].T - 1.;
                return s;
            }
            else
            {
                i = tthis - startl;
                for (j = 0; j < world->atl[rep][world->locus].T; j++)
                    s +=
                        (world->atl[rep][world->locus].tl[j].mindex[i] -
                         tc[i]) * (world->atl[rep][world->locus].tl[j].mindex[i] -
                                   tc[i]);
                s /= world->atl[rep][world->locus].T - 1.;
                return s;
            }
        }
    }
    return s;
}



void
chain_means (MYREAL *thischainmeans, world_fmt * world)
{
    /*static */ long startp, startl, startkm;

    long i, j;

    //if (!done)
    //  {
    //    done = TRUE;
    startkm = world->numpop;
    startp = startkm + world->numpop;
    startl = startp + world->numpop;
    // }

    for (j = 0; j < world->atl[world->rep][world->locus].T; j++)
    {
        for (i = 0; i < world->numpop; i++)
        {
            thischainmeans[i] +=
                world->atl[world->rep][world->locus].tl[j].kt[i];
            thischainmeans[i + startkm] +=
                world->atl[world->rep][world->locus].tl[j].km[i];
            thischainmeans[i + startp] +=
                world->atl[world->rep][world->locus].tl[j].p[i];
        }
        for (i = 0; i < world->numpop2; i++)
            thischainmeans[i + startl] +=
                world->atl[world->rep][world->locus].tl[j].mindex[i];
    }
    for (i = 0; i < world->numpop; i++)
    {
        thischainmeans[i] /= world->atl[world->rep][world->locus].T;
        thischainmeans[i + startkm] /= world->atl[world->rep][world->locus].T;
        thischainmeans[i + startp] /= world->atl[world->rep][world->locus].T;
    }
    for (i = startl; i < world->numpop2 + startl; i++)
        thischainmeans[i] /= world->atl[world->rep][world->locus].T;

}
