#ifndef SIGNAL_HANDLER
#define SIGNAL_HANDLER
/* -----------------------------------------------------
   sighandler.h                                           
   handels to following signals:                          
   SIGIOT         Input/Output problems                   
   SIGFPE         Floating point exceptions               
   SIGBUS         Bus error                               
   SIGSEGV        Segmentation fault                      
   SIGXCPU        CPU time limit exceeded                 
   SIGXFSZ        File size limit exceeded                
   if most of those exception are encountered the system  
   tries to exit gracefully, but with some it dies        
   anyway, but tries to say it why in a way which is     
   for humans better understandable                       
   -----------------------------------------------------  
   part of the lamarc package                             
 
   P. Beerli                                              
   ----------------------------------------------------- */
#ifndef __MWERKS__
#include <sys/types.h>
#endif
#include <stdarg.h>
#include <signal.h>
#include "definitions.h"
#define ON 1
#define OFF 0
extern void signalhandling (long switcher);
extern void signalhandler (int sig);
extern void warning (char string[], ...);
extern void usererror (char string[], ...);
#define error(x) sig_error(x, __FILE__,__LINE__)
extern void sig_error (char string[], char filename[], long line);

extern char myfgets (char *buffer, long bufsize, FILE * infile);

#ifdef NEXTAPP
extern void malloc_error_found (int value);
#endif
#ifdef LAMARC_MALLOC
extern void *LAMARC_malloc (size_t size, const char file[],
                                const long line);
extern void *LAMARC_calloc (size_t repeats,
                                size_t size, const char file[],
                                const long line);
extern void *LAMARC_realloc (void *ptr, size_t,
                                 const char file[], const long line);
#define mymalloc(a) LAMARC_malloc((size_t) a,__FILE__,__LINE__)
#define mycalloc(b,a) LAMARC_calloc((size_t) b, (size_t) a,__FILE__,__LINE__)
#define myrealloc(c,a) LAMARC_realloc(c, (size_t) a,__FILE__,__LINE__)
#else
#define mymalloc(a) malloc((size_t) a)
#define mycalloc(b,a) calloc((size_t) b, (size_t) a)
#define myrealloc(c,a) realloc(c, (size_t) a)
#endif
#ifdef MPI
#ifdef DEBUG_MPI
#define MYMPISEND(a,b,c,d,e,f) printf("%i>before ssend of %li bytes to %i with tag %i (%s,%i)\n",myID, b* sizeof(c), d, e,__FILE__,__LINE__);fflush(stdout);MPI_Ssend(a,b,c, d,  e,f);printf("%i>after send (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#define MYMPIISEND(a,b,c,d,e,f,g) printf("%i>before isend of %li bytes to %i with tag %i (%s,%i)\n",myID, b* sizeof(c), d, e, __FILE__,__LINE__);fflush(stdout);MPI_Isend(a,b,c,d,  e,f,g);printf("%i>after send (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#define MYMPIRECV(a,b,c,d,e,f,g) printf("%i>before receive of %li bytes from %i with tag %i (%s,%i)\n",myID, b* sizeof(c),d,e, __FILE__,__LINE__);fflush(stdout);MPI_Recv(a,b,c,d,e,f,g);printf("%i>after receive (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#define MYMPIBCAST(a,b,c,d,e) printf("%i>before broadcast of %li bytes (%s,%i)\n",myID, ((long) b) * ((long) sizeof(c)), __FILE__,__LINE__);fflush(stdout);MPI_Bcast(a,b,c,d,e);printf("%i>after broadcast (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#define MYMPIBARRIER(a) printf("%i>before barrier (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout);MPI_Barrier(a);printf("%i>after barrier (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#define MYMPIWAITALL(a,b,c) printf("%i>before waitall (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout);MPI_Waitall(a,b,c);printf("%i>after waitall (%s,%i)\n",myID, __FILE__,__LINE__);fflush(stdout)
#else
#define MYMPISEND(a,b,c,d,e,f) MPI_Send(a,b,c,d,e,f)
#define MYMPIISEND(a,b,c,d,e,f,g) MPI_Isend(a,b,c,d,e,f,g)
#define MYMPIRECV(a,b,c,d,e,f,g) MPI_Recv(a,b,c,d,e,f,g)
#define MYMPIBCAST(a,b,c,d,e) MPI_Bcast(a,b,c,d,e)
#define MYMPIBARRIER(a) MPI_Barrier(a)
#define MYMPIWAITALL(a,b,c) MPI_Waitall(a,b,c)
#endif
#endif
#endif

