#ifndef TOOLS_INCLUDE
#define TOOLS_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                       
 
 H E L P E R     R O U T I N E S 
 
 Peter Beerli 1996, Seattle
 beerli@csit.fsu.edu
 
Copyright 1996-2002 Peter Beerli and Joseph Felsenstein, Seattle WA
Copyright 2003-2004 Peter Beerli, Tallahassee FL
 
$Id: tools.h,v 1.29 2004/04/19 15:27:14 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern MYREAL lengthof (node * p);
extern node *crawlback (const node * theNode);
extern node *crawl (node * theNode);
extern node *showtop (node * theNode);
extern void adjust_time (node * theNode, MYREAL tyme);
extern void insert_migr_node (world_fmt * world, node * up, node * down,
                                  migr_table_fmt * migr_table,
                                  long *migr_table_counter);
extern void children (node * mother, node ** brother, node ** sister);
/* math tools */
extern MYREAL incompletegamma (MYREAL x, MYREAL alpha);
extern MYREAL polygamma (long n, MYREAL z);
extern void invert_matrix (MYREAL **a, long nsize);
extern boolean nrcheck (MYREAL **m, MYREAL **tm, MYREAL *v, long nrows,
                            MYREAL *r1, MYREAL *r2, boolean do_newton);
extern MYREAL rannor (MYREAL mean, MYREAL sd);
extern MYREAL find_chi (long df, MYREAL prob);
extern MYREAL probchiboundary (MYREAL chi, long zeros, long all);
extern MYREAL chiboundary (long zeros, long nonzeros, MYREAL alpha);
extern MYREAL probchi (long df, MYREAL chi);
extern MYREAL chisquare (long df, MYREAL alpha);
extern void gamma_rates (MYREAL *rate, MYREAL *probcat, long categs,
                             char *input);
#ifndef HAVE_LGAMMA
extern MYREAL mylgamma (MYREAL z);
#endif
extern MYREAL calc_sum (MYREAL *vector, long n);
extern MYREAL logfac (long n);
extern float fast_log(float vval);

extern char lowercase (char c);
extern char uppercase (char c);
extern void upper(char *from, char **to);

/* vector initialization and calc*/
extern void doublevec1d (MYREAL **v, long size);
extern void doublevec2d (MYREAL ***v, long size1, long size2);
extern void free_doublevec2d (MYREAL **v);
extern void setdoublevec1d (MYREAL **v, MYREAL *w, long size);
extern void add_vector (MYREAL *result, MYREAL *v, long size);

/*filemanipulation */
extern void init_files (world_fmt * world, data_fmt * data,
                            option_fmt * options);
extern void exit_files (world_fmt * world, data_fmt * data,
                            option_fmt * options);
extern void openfile (FILE ** fp, char *filename, char *mode, char *perm);
extern long read_savesum (world_fmt * world, option_fmt * options,
                              data_fmt * data);
extern void write_savesum (world_fmt * world);

/* string manipulation */
extern void translate (char *text, char from, char to);
extern long count_words (char *text);
extern void read_word(FILE *infile, char *word);
extern void unread_word(FILE *infile, char *word);
/* time reporting */
extern void get_time (char *nowstr, char ts[]);
/* printing aid */
extern void print_llike (MYREAL llike, char *strllike);
/* searching and finding*/
extern boolean find (long i, long *list, long listlen);
/* conversion between the different parameter schemes*/
extern long mstart (long pop, long numpop);
extern long mend (long pop, long numpop);
extern long mm2m (long frompop, long topop, long numpop);
extern void m2mm (long i, long numpop, long *frompop, long *topop);
extern long m2mml (long i, long numpop);
extern long m2mml2 (long i, long topop, long numpop);
extern long mmstart (long pop, long numpop);
extern long mmend (long pop, long numpop);
extern long mml2m (long pos, long numpop);
extern void print_line (FILE * outfile, char c, long nn, long flag);
extern void sprint_line (char *buffer, char c, long nn, long flag);
/* reading from char * buffer */
char sgetc (char **buffer);
char *sgets (char *s, int size, char **stream);

#endif /*TOOLS_INCLUDE */
