#ifndef TREE_INCLUDE
#define TREE_INCLUDE
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 T R E E B U I L D I N G   R O U T I N E S 
 
 
 Peter Beerli 1996, Seattle
 beerli@csit.fsu.edu
 
Copyright 1996-2002 Peter Beerli and Joseph Felsenstein, Seattle WA
Copyright 2003-2004 Peter Beerli, Tallahassee FL
 
$Id: tree.h,v 1.22 2004/08/28 19:59:36 beerli Exp $
-------------------------------------------------------*/

#include "migration.h"

extern void buildtree (world_fmt * world, option_fmt * options,
                           data_fmt * data, long locus);
extern void create_treetimelist (world_fmt * world, timelist_fmt ** ltl,
                                     long locus);
extern void fix_times (world_fmt * world, option_fmt * options);
extern void first_smooth (world_fmt * world, long locus);
extern void set_dirty (node * p);
extern void construct_tymelist (world_fmt * world, timelist_fmt * timevector);
extern void timeslices (timelist_fmt ** timevector);
extern void add_partlineages (long numpop, timelist_fmt ** timevector);
extern MYREAL treelikelihood (world_fmt * world);
extern MYREAL pseudotreelikelihood (world_fmt * world,
                                        proposal_fmt * proposal);
extern void set_pop (node * theNode, long pop, long actualpop);
extern void pseudonuview (proposal_fmt * proposal, xarray_fmt xx1,
                              MYREAL *lx1, MYREAL v1, xarray_fmt xx2, MYREAL *lx2,
                              MYREAL v2);
extern void ltov (node * p);
extern void treeout (FILE * treefile, node * joint, node * p, long s);
extern void print_tree (world_fmt * world, long g, long *filepos);

extern void allocate_x (node * p, world_fmt * world, char datatype,
                            boolean withtips);

extern void     allocate_xseq(xarray_fmt *x, long sites, long categs);

extern void copy_tree (world_fmt * original, world_fmt * kopie);
extern void swap_tree (world_fmt * tthis, world_fmt * that);

extern void calc_treelength (node * p, MYREAL *treelen);
extern MYREAL calc_pseudotreelength (proposal_fmt * proposal, MYREAL treelen);
extern void swap (void *a, void *b);
extern void free_treetimes (world_fmt * world, long size);
extern void free_tree (node * p, world_fmt * world);
extern long number_genomes (char datatype);

#endif /*TREE_INCLUDE */
