/*
 *  pretty.h
 *  part of migrate
 *  will be PDF printout system
 *  Created by Peter Beerli on 7/25/05.
 *  Copyright 2005 Peter Beerli. All rights reserved.
 *
 */
#ifdef PRETTY
#include "migration.h"
#include "sighandler.h"
#include "tools.h"
#undef USE_ENCRYPTION
#define HAVE_BOOLEAN 
//#include <libharuc.h>
#include "haru/libharuc.h"
#define SEARCHUP 0
#define SEARCHDOWN 1
// GENERAL
// initialize PDF structures
extern int pdf_init();
// print title on every new page
extern int pdf_new_page(char *title);
// print title with page number
extern int pdf_print_title(char *title, float *orig_page_height, float *orig_left_margin);

// OPTIONS
// print options onto the first page
extern void pdf_print_options(world_fmt * world, option_fmt *options, data_fmt * data, 
			      float *orig_page_height, float *orig_left_margin);

// DATA
// print data summary
extern void pdf_print_data_summary(world_fmt * world, option_fmt *options, data_fmt * data, 
                              float *orig_page_height, float *orig_left_margin);
// print data
extern void pdf_print_data (world_fmt * world, option_fmt * options, data_fmt * data, float *orig_page_height, float *orig_left_margin);

// BAYES OUTPUTS
// print bayes table
extern void pdf_print_bayestable(world_fmt *world);
// print histogram at location lx ly with widht and height
extern void pdf_histogram(MYREAL *binvals, char *set50, char *set95, long bins, float bindelta, float binmin, float binmax, float lx, float ly, float width, float height);
// print histogram for each locus and overall loci
extern void pdf_loci_histogram(world_fmt *world);

// MIGHIST output
extern void 
pdf_mig_histogram(histogram_fmt ** histogram,
                  plotfield_fmt ** plotfield, long loci, long nmigs,
                  long bins, long *sum, MYREAL ***migtable,  boolean precalc, world_fmt *world);
extern void pdf_print_mighist_table (world_fmt * world, MYREAL ***migtable,
				     long *total);

// ML OUPUTS
// print mcmc table
extern void pdf_print_mcmctable(float *page_height, float page_width, world_fmt *world, data_fmt *data, option_fmt *options);


// write PDF content to file
extern int pdf_write_file(option_fmt *options);
#endif
