// histogrammer for bayes histogram data
// takes the file bayesallfile and reads it into the histogram structure
// to use the calculate_hpd etc and also call the pretty printer functions
//
// (c) Peter Beerli 2007
//
#include "migration.h"
#include "bayes.h"
#include "tools.h"
#include "sighandler.h"


long get_fullbinsum(world_fmt *world, option_fmt *options, long locus)
{
  long temp=0;
  long i;
  for(i = 0; i < world->numpop; i++)
    {
      temp += options->bayespriortheta->bins;
    }
  for(i = world->numpop; i < world->numpop2; i++)
    {
      temp += options->bayespriorm->bins;
    }
  for(i = world->numpop2; i < world->numpop2+world->bayes->mu * world->loci; i++)
    {
      temp += options->bayespriorrate->bins;
    }
  return temp;
}


void read_bayes_fromfile(FILE *mdimfile, world_fmt *world,option_fmt *options);

///
/// read bayesallfile from disk and creates all the needed parts to 
/// recreate the output and pdf output
void read_bayes_fromfile(FILE *mdimfile, world_fmt *world,option_fmt *options)
{

  long *n = NULL;

  long j0;
  long j;
  //  char *input;
  long step;
  long locus;
  long replicate;
  long T ; // was world->treetimes->T, but this construct is freed, we do not need to
  // keep this values as it only used for the output into bayesallfile
  MYREAL post;
  MYREAL like;
  MYREAL probg;
  MYREAL prior;
  MYREAL *params;
  char *input;
  char *inptr;
  bayes_fmt * bayes = world->bayes;
  bayeshistogram_fmt *hist;
  long bin;
  MYREAL *delta = bayes->deltahist;
  //  long binwidth;
  long numbins = 0;
  long numbinsall = 0;
  MYREAL m;
  boolean *done;

  done = (boolean *) mycalloc(world->loci, sizeof(boolean));
  params = (MYREAL *) mycalloc(2+ world->numpop2 + world->bayes->mu, sizeof(MYREAL));
  n = (long *) mycalloc(world->numpop2 + world->bayes->mu, sizeof(long));
  input = (char *) mycalloc((2+world->numpop2) * 40 , sizeof(char));
  while(FGETS(input,LINESIZE,mdimfile) != EOF)
    {
      // grab the commentlines
      while(input[0]=='#')
	{
	  FGETS(input,LINESIZE,mdimfile);
	}
      // read the bayesallfile
      if(input !=NULL)
	{
	  inptr = input;
	  step       = atol(strsep(&inptr,"\t"));
	  locus      = atol(strsep(&inptr,"\t"))-1;
	  replicate  = atol(strsep(&inptr,"\t"))-1;
	  post       = atof(strsep(&inptr,"\t"));
	  like       = atof(strsep(&inptr,"\t"));
	  probg      = atof( strsep(&inptr,"\t"));
	  prior      = atof( strsep(&inptr,"\t"));
	  T = atol(strsep(&inptr,"\t"))+1;
	  params[0] = post;
	  params[1] = like;
	  //	  if(fabs(like - world->likelihood[world->G])> SMALLEPSILON)
	  //   world->likelihood[world->G++]=like;
	  if(!done[locus])
	    {

	      done[locus] = TRUE;
	      // allocate the number of bins for the histogram
	      bayes->histogram[locus].binsum = get_fullbinsum(world, options, locus);
	      bayes->histogram[locus].results = (MYREAL *) mycalloc(bayes->histogram[locus].binsum, sizeof(MYREAL));
	      bayes->histogram[locus].set95 = (char *) mycalloc(bayes->histogram[locus].binsum* 2 + 2, sizeof(char));
	      bayes->histogram[locus].set50 = world->bayes->histogram[locus].set95 + bayes->histogram[locus].binsum + 1;
	      memset(world->bayes->histogram[locus].results, 0 , sizeof(MYREAL) * (world->bayes->histogram[locus].binsum)); 
   
	    }
	  hist = &bayes->histogram[locus];
	  numbinsall = 0;
	  for(j0=0;j0 <  world->numpop2; j0++)
	    {
	      if(bayes->map[j0][1] == INVALID)
		continue;
	      else
		{
		  j = bayes->map[j0][1];
		}
	      if(j < j0)
		{
		  //params[j0+2] = params[j+2];
		  continue;
		}
	      else
		{
		  params[j+2] =  atof(strsep(&inptr,"\t"));
		  //mn = mn  + (xn - mn)/n
		  n[j] += 1;
		  hist->means[j] += (params[j+2] - hist->means[j]) / n[j];
		}
	      numbinsall += hist->bins[j];
	      numbins = numbinsall - hist->bins[j];

	      //binwidth = hist->bins[j];
	      bin = (long) (params[j+2] / delta[j]);
	      m = bin * delta[j];
	      if(m < hist->minima[j0])
		hist->minima[j0] = m;
	      if(m > hist->maxima[j0])
		hist->maxima[j0] = m;
	      hist->results[numbins + bin] += 1.;
	    }
	  if(bayes->mu)
	    {
	      //binwidth = hist->bins[j0];
	      numbins = numbinsall;
	      params[j0+2] = atof(strsep(&inptr,"\t"));
	      bin = (long) (params[j0+2] / delta[j0]); 
	      m = bin * delta[j0];
	      if(m < hist->minima[j0])
		hist->minima[j0] = m;
	      if(m > hist->maxima[j0])
		hist->maxima[j0] = m;

	      hist->results[numbins + bin] += 1.;
	    }
	}
    } 
  myfree(params);
  myfree(n);
  myfree(done);
  myfree(input);
}
