#ifndef MIGRATION_RANDOM
#define MIGRATION_RANDOM
/* -------------------------------------------------------
   R A N D O M   G E N E R A T O R   R O U T I N E S 
 
   creates options structures,
   reads options from parmfile if present
 
   prints options,
   and finally helps to destroy itself.
 
   Peter Beerli 1996, Seattle
   beerli@scs.fsu.edu
   
Copyright 1996-2002 Peter Beerli and Joseph Felsenstein, Seattle WA
Copyright 2003-2006 Peter Beerli, Tallahassee FL

Addition of Quasi random module Hongmei Chi (2005)

$Id: random.h 663 2007-04-08 04:16:09Z beerli $
   ------------------------------------------------------- */
extern long *seed;
extern long *newseed;
extern char *generator;
#ifdef MERSENNE_TWISTER
#include "SFMT.h"
#endif
/*-----------------------------------------------------*
 * calculates the start seed for randum
 * picks up the global variable iseed
 * PB 94
 *-----------------------------------------------------*/
extern void getseed (option_fmt * options);

/*-----------------------------------------------------*
 * RANDUM 
 * generates an uniform random number between o..1
 * using seed (generated by getseed)
 * JF <93 (6bit) and Mary K. Kuhner 1997 (32bit)
 * RANDINT
 * generates an uniform random integer number
 * between a..b
 * using seed (generated by getseed)
 *-----------------------------------------------------*/
#ifdef PTHREADS
extern MYREAL randum_thread (void);
extern long random_integer(long low, long high);
#define RANDUM randum_thread
#ifndef QUASIRANDOM
#define UNIF_RANDUM randum_thread     
#endif
#define RANDINT   random_integer
#else
extern MYREAL randum (void);
extern long random_integer(long low, long high);
#define RANDUM randum
#ifndef QUASIRANDOM
#define UNIF_RANDUM randum     
#endif
#define RANDINT   random_integer
#define RANDDOUBLE(a,b)  (double) ((a) + (randum() * ((b) - (a))))  
#endif
#endif
#ifdef QUASIRANDOM
extern double get_quasi();
#define UNIF_RANDUM  get_quasi
#endif
