/*
 * << H a r u free pdf library >> -- PdfFontDef_Times.cc
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */


#include "libharu.h"

/*----- TimesRoman Font -----------------------------------------------------*/

PdfTimesRomanFontDef::PdfTimesRomanFontDef()
    : PdfType1FontDef("Times-Roman")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 250},
        {33, "exclam", 333},
        {34, "quotedbl", 408},
        {35, "numbersign", 500},
        {36, "dollar", 500},
        {37, "percent", 833},
        {38, "ampersand", 778},
        {39, "quoteright", 333},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 500},
        {43, "plus", 564},
        {44, "comma", 250},
        {45, "hyphen", 333},
        {46, "period", 250},
        {47, "slash", 278},
        {48, "zero", 500},
        {49, "one", 500},
        {50, "two", 500},
        {51, "three", 500},
        {52, "four", 500},
        {53, "five", 500},
        {54, "six", 500},
        {55, "seven", 500},
        {56, "eight", 500},
        {57, "nine", 500},
        {58, "colon", 278},
        {59, "semicolon", 278},
        {60, "less", 564},
        {61, "equal", 564},
        {62, "greater", 564},
        {63, "question", 444},
        {64, "at", 921},
        {65, "A", 722},
        {66, "B", 667},
        {67, "C", 667},
        {68, "D", 722},
        {69, "E", 611},
        {70, "F", 556},
        {71, "G", 722},
        {72, "H", 722},
        {73, "I", 333},
        {74, "J", 389},
        {75, "K", 722},
        {76, "L", 611},
        {77, "M", 889},
        {78, "N", 722},
        {79, "O", 722},
        {80, "P", 556},
        {81, "Q", 722},
        {82, "R", 667},
        {83, "S", 556},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 722},
        {87, "W", 944},
        {88, "X", 722},
        {89, "Y", 722},
        {90, "Z", 611},
        {91, "bracketleft", 333},
        {92, "backslash", 278},
        {93, "bracketright", 333},
        {94, "asciicircum", 469},
        {95, "underscore", 500},
        {96, "quoteleft", 333},
        {97, "a", 444},
        {98, "b", 500},
        {99, "c", 444},
        {100, "d", 500},
        {101, "e", 444},
        {102, "f", 333},
        {103, "g", 500},
        {104, "h", 500},
        {105, "i", 278},
        {106, "j", 278},
        {107, "k", 500},
        {108, "l", 278},
        {109, "m", 778},
        {110, "n", 500},
        {111, "o", 500},
        {112, "p", 500},
        {113, "q", 500},
        {114, "r", 333},
        {115, "s", 389},
        {116, "t", 278},
        {117, "u", 500},
        {118, "v", 500},
        {119, "w", 722},
        {120, "x", 500},
        {121, "y", 500},
        {122, "z", 444},
        {123, "braceleft", 480},
        {124, "bar", 200},
        {125, "braceright", 480},
        {126, "asciitilde", 541},
        {161, "exclamdown", 333},
        {162, "cent", 500},
        {163, "sterling", 500},
        {164, "fraction", 167},
        {165, "yen", 500},
        {166, "florin", 500},
        {167, "section", 500},
        {168, "currency", 500},
        {169, "quotesingle", 180},
        {170, "quotedblleft", 444},
        {171, "guillemotleft", 500},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 556},
        {175, "fl", 556},
        {177, "endash", 500},
        {178, "dagger", 500},
        {179, "daggerdbl", 500},
        {180, "periodcentered", 250},
        {182, "paragraph", 453},
        {183, "bullet", 350},
        {184, "quotesinglbase", 333},
        {185, "quotedblbase", 444},
        {186, "quotedblright", 444},
        {187, "guillemotright", 500},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 444},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 889},
        {227, "ordfeminine", 276},
        {232, "Lslash", 611},
        {233, "Oslash", 722},
        {234, "OE", 889},
        {235, "ordmasculine", 310},
        {241, "ae", 667},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 500},
        {250, "oe", 722},
        {251, "germandbls", 500},
        {-1, "Idieresis", 333},
        {-1, "eacute", 444},
        {-1, "abreve", 444},
        {-1, "uhungarumlaut", 500},
        {-1, "ecaron", 444},
        {-1, "Ydieresis", 722},
        {-1, "divide", 564},
        {-1, "Yacute", 722},
        {-1, "Acircumflex", 722},
        {-1, "aacute", 444},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 500},
        {-1, "scommaaccent", 389},
        {-1, "ecircumflex", 444},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 444},
        {-1, "Uacute", 722},
        {-1, "uogonek", 500},
        {-1, "Edieresis", 611},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 760},
        {-1, "Emacron", 611},
        {-1, "ccaron", 444},
        {-1, "aring", 444},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 278},
        {-1, "agrave", 444},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 667},
        {-1, "atilde", 444},
        {-1, "Edotaccent", 611},
        {-1, "scaron", 389},
        {-1, "scedilla", 389},
        {-1, "iacute", 278},
        {-1, "lozenge", 471},
        {-1, "Rcaron", 667},
        {-1, "Gcommaaccent", 722},
        {-1, "ucircumflex", 500},
        {-1, "acircumflex", 444},
        {-1, "Amacron", 722},
        {-1, "rcaron", 333},
        {-1, "ccedilla", 444},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 556},
        {-1, "Omacron", 722},
        {-1, "Racute", 667},
        {-1, "Sacute", 556},
        {-1, "dcaron", 588},
        {-1, "Umacron", 722},
        {-1, "uring", 500},
        {-1, "threesuperior", 300},
        {-1, "Ograve", 722},
        {-1, "Agrave", 722},
        {-1, "Abreve", 722},
        {-1, "multiply", 564},
        {-1, "uacute", 500},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 476},
        {-1, "ydieresis", 500},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 611},
        {-1, "adieresis", 444},
        {-1, "edieresis", 444},
        {-1, "cacute", 444},
        {-1, "nacute", 500},
        {-1, "umacron", 500},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 333},
        {-1, "plusminus", 564},
        {-1, "brokenbar", 200},
        {-1, "registered", 760},
        {-1, "Gbreve", 722},
        {-1, "Idotaccent", 333},
        {-1, "summation", 600},
        {-1, "Egrave", 611},
        {-1, "racute", 333},
        {-1, "omacron", 500},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 667},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 326},
        {-1, "eogonek", 444},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 722},
        {-1, "Adieresis", 722},
        {-1, "egrave", 444},
        {-1, "zacute", 444},
        {-1, "iogonek", 278},
        {-1, "Oacute", 722},
        {-1, "oacute", 500},
        {-1, "amacron", 444},
        {-1, "sacute", 389},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 722},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 500},
        {-1, "twosuperior", 300},
        {-1, "Odieresis", 722},
        {-1, "mu", 500},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 500},
        {-1, "Eogonek", 611},
        {-1, "dcroat", 500},
        {-1, "threequarters", 750},
        {-1, "Scedilla", 556},
        {-1, "lcaron", 344},
        {-1, "Kcommaaccent", 722},
        {-1, "Lacute", 611},
        {-1, "trademark", 980},
        {-1, "edotaccent", 444},
        {-1, "Igrave", 333},
        {-1, "Imacron", 333},
        {-1, "Lcaron", 611},
        {-1, "onehalf", 750},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 500},
        {-1, "ntilde", 500},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 611},
        {-1, "emacron", 444},
        {-1, "gbreve", 500},
        {-1, "onequarter", 750},
        {-1, "Scaron", 556},
        {-1, "Scommaaccent", 556},
        {-1, "Ohungarumlaut", 722},
        {-1, "degree", 400},
        {-1, "ograve", 500},
        {-1, "Ccaron", 667},
        {-1, "ugrave", 500},
        {-1, "radical", 453},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 333},
        {-1, "Ntilde", 722},
        {-1, "otilde", 500},
        {-1, "Rcommaaccent", 667},
        {-1, "Lcommaaccent", 611},
        {-1, "Atilde", 722},
        {-1, "Aogonek", 722},
        {-1, "Aring", 722},
        {-1, "Otilde", 722},
        {-1, "zdotaccent", 444},
        {-1, "Ecaron", 611},
        {-1, "Iogonek", 333},
        {-1, "kcommaaccent", 500},
        {-1, "minus", 564},
        {-1, "Icircumflex", 333},
        {-1, "ncaron", 500},
        {-1, "tcommaaccent", 278},
        {-1, "logicalnot", 564},
        {-1, "odieresis", 500},
        {-1, "udieresis", 500},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 500},
        {-1, "eth", 500},
        {-1, "zcaron", 444},
        {-1, "ncommaaccent", 500},
        {-1, "onesuperior", 300},
        {-1, "imacron", 278},
        {-1, "Euro", 500},
        {-1, NULL, 0}
    };
    fFontBBox.left = -168;
    fFontBBox.bottom = -218;
    fFontBBox.right = 1000;
    fFontBBox.top = 898;
    fAscent = 683;
    fDescent =-217;
    fXHeight = 450;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- TimesBold Font ------------------------------------------------------*/

PdfTimesBoldFontDef::PdfTimesBoldFontDef()
    : PdfType1FontDef("Times-Bold")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 250},
        {33, "exclam", 333},
        {34, "quotedbl", 555},
        {35, "numbersign", 500},
        {36, "dollar", 500},
        {37, "percent", 1000},
        {38, "ampersand", 833},
        {39, "quoteright", 333},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 500},
        {43, "plus", 570},
        {44, "comma", 250},
        {45, "hyphen", 333},
        {46, "period", 250},
        {47, "slash", 278},
        {48, "zero", 500},
        {49, "one", 500},
        {50, "two", 500},
        {51, "three", 500},
        {52, "four", 500},
        {53, "five", 500},
        {54, "six", 500},
        {55, "seven", 500},
        {56, "eight", 500},
        {57, "nine", 500},
        {58, "colon", 333},
        {59, "semicolon", 333},
        {60, "less", 570},
        {61, "equal", 570},
        {62, "greater", 570},
        {63, "question", 500},
        {64, "at", 930},
        {65, "A", 722},
        {66, "B", 667},
        {67, "C", 722},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 611},
        {71, "G", 778},
        {72, "H", 778},
        {73, "I", 389},
        {74, "J", 500},
        {75, "K", 778},
        {76, "L", 667},
        {77, "M", 944},
        {78, "N", 722},
        {79, "O", 778},
        {80, "P", 611},
        {81, "Q", 778},
        {82, "R", 722},
        {83, "S", 556},
        {84, "T", 667},
        {85, "U", 722},
        {86, "V", 722},
        {87, "W", 1000},
        {88, "X", 722},
        {89, "Y", 722},
        {90, "Z", 667},
        {91, "bracketleft", 333},
        {92, "backslash", 278},
        {93, "bracketright", 333},
        {94, "asciicircum", 581},
        {95, "underscore", 500},
        {96, "quoteleft", 333},
        {97, "a", 500},
        {98, "b", 556},
        {99, "c", 444},
        {100, "d", 556},
        {101, "e", 444},
        {102, "f", 333},
        {103, "g", 500},
        {104, "h", 556},
        {105, "i", 278},
        {106, "j", 333},
        {107, "k", 556},
        {108, "l", 278},
        {109, "m", 833},
        {110, "n", 556},
        {111, "o", 500},
        {112, "p", 556},
        {113, "q", 556},
        {114, "r", 444},
        {115, "s", 389},
        {116, "t", 333},
        {117, "u", 556},
        {118, "v", 500},
        {119, "w", 722},
        {120, "x", 500},
        {121, "y", 500},
        {122, "z", 444},
        {123, "braceleft", 394},
        {124, "bar", 220},
        {125, "braceright", 394},
        {126, "asciitilde", 520},
        {161, "exclamdown", 333},
        {162, "cent", 500},
        {163, "sterling", 500},
        {164, "fraction", 167},
        {165, "yen", 500},
        {166, "florin", 500},
        {167, "section", 500},
        {168, "currency", 500},
        {169, "quotesingle", 278},
        {170, "quotedblleft", 500},
        {171, "guillemotleft", 500},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 556},
        {175, "fl", 556},
        {177, "endash", 500},
        {178, "dagger", 500},
        {179, "daggerdbl", 500},
        {180, "periodcentered", 250},
        {182, "paragraph", 540},
        {183, "bullet", 350},
        {184, "quotesinglbase", 333},
        {185, "quotedblbase", 500},
        {186, "quotedblright", 500},
        {187, "guillemotright", 500},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 500},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 1000},
        {227, "ordfeminine", 300},
        {232, "Lslash", 667},
        {233, "Oslash", 778},
        {234, "OE", 1000},
        {235, "ordmasculine", 330},
        {241, "ae", 722},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 500},
        {250, "oe", 722},
        {251, "germandbls", 556},
        {-1, "Idieresis", 389},
        {-1, "eacute", 444},
        {-1, "abreve", 500},
        {-1, "uhungarumlaut", 556},
        {-1, "ecaron", 444},
        {-1, "Ydieresis", 722},
        {-1, "divide", 570},
        {-1, "Yacute", 722},
        {-1, "Acircumflex", 722},
        {-1, "aacute", 500},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 500},
        {-1, "scommaaccent", 389},
        {-1, "ecircumflex", 444},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 500},
        {-1, "Uacute", 722},
        {-1, "uogonek", 556},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 747},
        {-1, "Emacron", 667},
        {-1, "ccaron", 444},
        {-1, "aring", 500},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 278},
        {-1, "agrave", 500},
        {-1, "Tcommaaccent", 667},
        {-1, "Cacute", 722},
        {-1, "atilde", 500},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 389},
        {-1, "scedilla", 389},
        {-1, "iacute", 278},
        {-1, "lozenge", 494},
        {-1, "Rcaron", 722},
        {-1, "Gcommaaccent", 778},
        {-1, "ucircumflex", 556},
        {-1, "acircumflex", 500},
        {-1, "Amacron", 722},
        {-1, "rcaron", 444},
        {-1, "ccedilla", 444},
        {-1, "Zdotaccent", 667},
        {-1, "Thorn", 611},
        {-1, "Omacron", 778},
        {-1, "Racute", 722},
        {-1, "Sacute", 556},
        {-1, "dcaron", 672},
        {-1, "Umacron", 722},
        {-1, "uring", 556},
        {-1, "threesuperior", 300},
        {-1, "Ograve", 778},
        {-1, "Agrave", 722},
        {-1, "Abreve", 722},
        {-1, "multiply", 570},
        {-1, "uacute", 556},
        {-1, "Tcaron", 667},
        {-1, "partialdiff", 494},
        {-1, "ydieresis", 500},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 500},
        {-1, "edieresis", 444},
        {-1, "cacute", 444},
        {-1, "nacute", 556},
        {-1, "umacron", 556},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 389},
        {-1, "plusminus", 570},
        {-1, "brokenbar", 220},
        {-1, "registered", 747},
        {-1, "Gbreve", 778},
        {-1, "Idotaccent", 389},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 444},
        {-1, "omacron", 500},
        {-1, "Zacute", 667},
        {-1, "Zcaron", 667},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 722},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 416},
        {-1, "eogonek", 444},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 722},
        {-1, "Adieresis", 722},
        {-1, "egrave", 444},
        {-1, "zacute", 444},
        {-1, "iogonek", 278},
        {-1, "Oacute", 778},
        {-1, "oacute", 500},
        {-1, "amacron", 500},
        {-1, "sacute", 389},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 778},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 556},
        {-1, "twosuperior", 300},
        {-1, "Odieresis", 778},
        {-1, "mu", 556},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 500},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 556},
        {-1, "threequarters", 750},
        {-1, "Scedilla", 556},
        {-1, "lcaron", 394},
        {-1, "Kcommaaccent", 778},
        {-1, "Lacute", 667},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 444},
        {-1, "Igrave", 389},
        {-1, "Imacron", 389},
        {-1, "Lcaron", 667},
        {-1, "onehalf", 750},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 500},
        {-1, "ntilde", 556},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 444},
        {-1, "gbreve", 500},
        {-1, "onequarter", 750},
        {-1, "Scaron", 556},
        {-1, "Scommaaccent", 556},
        {-1, "Ohungarumlaut", 778},
        {-1, "degree", 400},
        {-1, "ograve", 500},
        {-1, "Ccaron", 722},
        {-1, "ugrave", 556},
        {-1, "radical", 549},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 444},
        {-1, "Ntilde", 722},
        {-1, "otilde", 500},
        {-1, "Rcommaaccent", 722},
        {-1, "Lcommaaccent", 667},
        {-1, "Atilde", 722},
        {-1, "Aogonek", 722},
        {-1, "Aring", 722},
        {-1, "Otilde", 778},
        {-1, "zdotaccent", 444},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 389},
        {-1, "kcommaaccent", 556},
        {-1, "minus", 570},
        {-1, "Icircumflex", 389},
        {-1, "ncaron", 556},
        {-1, "tcommaaccent", 333},
        {-1, "logicalnot", 570},
        {-1, "odieresis", 500},
        {-1, "udieresis", 556},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 500},
        {-1, "eth", 500},
        {-1, "zcaron", 444},
        {-1, "ncommaaccent", 556},
        {-1, "onesuperior", 300},
        {-1, "imacron", 278},
        {-1, "Euro", 500},
        {-1, NULL, 0}
    };
    fFontBBox.left = -168;
    fFontBBox.top = -218;
    fFontBBox.right = 1000;
    fFontBBox.bottom = 935;
    fAscent = 683;
    fDescent =-217;
    fXHeight = 461;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- TimesBoldItalic Font ------------------------------------------------*/

PdfTimesBoldItalicFontDef::PdfTimesBoldItalicFontDef()
    : PdfType1FontDef("Times-BoldItalic")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 250},
        {33, "exclam", 389},
        {34, "quotedbl", 555},
        {35, "numbersign", 500},
        {36, "dollar", 500},
        {37, "percent", 833},
        {38, "ampersand", 778},
        {39, "quoteright", 333},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 500},
        {43, "plus", 570},
        {44, "comma", 250},
        {45, "hyphen", 333},
        {46, "period", 250},
        {47, "slash", 278},
        {48, "zero", 500},
        {49, "one", 500},
        {50, "two", 500},
        {51, "three", 500},
        {52, "four", 500},
        {53, "five", 500},
        {54, "six", 500},
        {55, "seven", 500},
        {56, "eight", 500},
        {57, "nine", 500},
        {58, "colon", 333},
        {59, "semicolon", 333},
        {60, "less", 570},
        {61, "equal", 570},
        {62, "greater", 570},
        {63, "question", 500},
        {64, "at", 832},
        {65, "A", 667},
        {66, "B", 667},
        {67, "C", 667},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 667},
        {71, "G", 722},
        {72, "H", 778},
        {73, "I", 389},
        {74, "J", 500},
        {75, "K", 667},
        {76, "L", 611},
        {77, "M", 889},
        {78, "N", 722},
        {79, "O", 722},
        {80, "P", 611},
        {81, "Q", 722},
        {82, "R", 667},
        {83, "S", 556},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 667},
        {87, "W", 889},
        {88, "X", 667},
        {89, "Y", 611},
        {90, "Z", 611},
        {91, "bracketleft", 333},
        {92, "backslash", 278},
        {93, "bracketright", 333},
        {94, "asciicircum", 570},
        {95, "underscore", 500},
        {96, "quoteleft", 333},
        {97, "a", 500},
        {98, "b", 500},
        {99, "c", 444},
        {100, "d", 500},
        {101, "e", 444},
        {102, "f", 333},
        {103, "g", 500},
        {104, "h", 556},
        {105, "i", 278},
        {106, "j", 278},
        {107, "k", 500},
        {108, "l", 278},
        {109, "m", 778},
        {110, "n", 556},
        {111, "o", 500},
        {112, "p", 500},
        {113, "q", 500},
        {114, "r", 389},
        {115, "s", 389},
        {116, "t", 278},
        {117, "u", 556},
        {118, "v", 444},
        {119, "w", 667},
        {120, "x", 500},
        {121, "y", 444},
        {122, "z", 389},
        {123, "braceleft", 348},
        {124, "bar", 220},
        {125, "braceright", 348},
        {126, "asciitilde", 570},
        {161, "exclamdown", 389},
        {162, "cent", 500},
        {163, "sterling", 500},
        {164, "fraction", 167},
        {165, "yen", 500},
        {166, "florin", 500},
        {167, "section", 500},
        {168, "currency", 500},
        {169, "quotesingle", 278},
        {170, "quotedblleft", 500},
        {171, "guillemotleft", 500},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 556},
        {175, "fl", 556},
        {177, "endash", 500},
        {178, "dagger", 500},
        {179, "daggerdbl", 500},
        {180, "periodcentered", 250},
        {182, "paragraph", 500},
        {183, "bullet", 350},
        {184, "quotesinglbase", 333},
        {185, "quotedblbase", 500},
        {186, "quotedblright", 500},
        {187, "guillemotright", 500},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 500},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 944},
        {227, "ordfeminine", 266},
        {232, "Lslash", 611},
        {233, "Oslash", 722},
        {234, "OE", 944},
        {235, "ordmasculine", 300},
        {241, "ae", 722},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 500},
        {250, "oe", 722},
        {251, "germandbls", 500},
        {-1, "Idieresis", 389},
        {-1, "eacute", 444},
        {-1, "abreve", 500},
        {-1, "uhungarumlaut", 556},
        {-1, "ecaron", 444},
        {-1, "Ydieresis", 611},
        {-1, "divide", 570},
        {-1, "Yacute", 611},
        {-1, "Acircumflex", 667},
        {-1, "aacute", 500},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 444},
        {-1, "scommaaccent", 389},
        {-1, "ecircumflex", 444},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 500},
        {-1, "Uacute", 722},
        {-1, "uogonek", 556},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 747},
        {-1, "Emacron", 667},
        {-1, "ccaron", 444},
        {-1, "aring", 500},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 278},
        {-1, "agrave", 500},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 667},
        {-1, "atilde", 500},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 389},
        {-1, "scedilla", 389},
        {-1, "iacute", 278},
        {-1, "lozenge", 494},
        {-1, "Rcaron", 667},
        {-1, "Gcommaaccent", 722},
        {-1, "ucircumflex", 556},
        {-1, "acircumflex", 500},
        {-1, "Amacron", 667},
        {-1, "rcaron", 389},
        {-1, "ccedilla", 444},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 611},
        {-1, "Omacron", 722},
        {-1, "Racute", 667},
        {-1, "Sacute", 556},
        {-1, "dcaron", 608},
        {-1, "Umacron", 722},
        {-1, "uring", 556},
        {-1, "threesuperior", 300},
        {-1, "Ograve", 722},
        {-1, "Agrave", 667},
        {-1, "Abreve", 667},
        {-1, "multiply", 570},
        {-1, "uacute", 556},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 494},
        {-1, "ydieresis", 444},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 500},
        {-1, "edieresis", 444},
        {-1, "cacute", 444},
        {-1, "nacute", 556},
        {-1, "umacron", 556},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 389},
        {-1, "plusminus", 570},
        {-1, "brokenbar", 220},
        {-1, "registered", 747},
        {-1, "Gbreve", 722},
        {-1, "Idotaccent", 389},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 389},
        {-1, "omacron", 500},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 667},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 366},
        {-1, "eogonek", 444},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 667},
        {-1, "Adieresis", 667},
        {-1, "egrave", 444},
        {-1, "zacute", 389},
        {-1, "iogonek", 278},
        {-1, "Oacute", 722},
        {-1, "oacute", 500},
        {-1, "amacron", 500},
        {-1, "sacute", 389},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 722},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 500},
        {-1, "twosuperior", 300},
        {-1, "Odieresis", 722},
        {-1, "mu", 576},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 500},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 500},
        {-1, "threequarters", 750},
        {-1, "Scedilla", 556},
        {-1, "lcaron", 382},
        {-1, "Kcommaaccent", 667},
        {-1, "Lacute", 611},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 444},
        {-1, "Igrave", 389},
        {-1, "Imacron", 389},
        {-1, "Lcaron", 611},
        {-1, "onehalf", 750},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 500},
        {-1, "ntilde", 556},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 444},
        {-1, "gbreve", 500},
        {-1, "onequarter", 750},
        {-1, "Scaron", 556},
        {-1, "Scommaaccent", 556},
        {-1, "Ohungarumlaut", 722},
        {-1, "degree", 400},
        {-1, "ograve", 500},
        {-1, "Ccaron", 667},
        {-1, "ugrave", 556},
        {-1, "radical", 549},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 389},
        {-1, "Ntilde", 722},
        {-1, "otilde", 500},
        {-1, "Rcommaaccent", 667},
        {-1, "Lcommaaccent", 611},
        {-1, "Atilde", 667},
        {-1, "Aogonek", 667},
        {-1, "Aring", 667},
        {-1, "Otilde", 722},
        {-1, "zdotaccent", 389},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 389},
        {-1, "kcommaaccent", 500},
        {-1, "minus", 606},
        {-1, "Icircumflex", 389},
        {-1, "ncaron", 556},
        {-1, "tcommaaccent", 278},
        {-1, "logicalnot", 606},
        {-1, "odieresis", 500},
        {-1, "udieresis", 556},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 500},
        {-1, "eth", 500},
        {-1, "zcaron", 389},
        {-1, "ncommaaccent", 556},
        {-1, "onesuperior", 300},
        {-1, "imacron", 278},
        {-1, "Euro", 500},
        {-1, NULL, 0}
    };
    fFontBBox.left = -200;
    fFontBBox.top = -218;
    fFontBBox.right = 996;
    fFontBBox.bottom = 921;
    fAscent = 683;
    fDescent =-217;
    fXHeight = 462;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- TimesItalic Font ----------------------------------------------------*/

PdfTimesItalicFontDef::PdfTimesItalicFontDef()
    : PdfType1FontDef("Times-Italic")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 250},
        {33, "exclam", 333},
        {34, "quotedbl", 420},
        {35, "numbersign", 500},
        {36, "dollar", 500},
        {37, "percent", 833},
        {38, "ampersand", 778},
        {39, "quoteright", 333},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 500},
        {43, "plus", 675},
        {44, "comma", 250},
        {45, "hyphen", 333},
        {46, "period", 250},
        {47, "slash", 278},
        {48, "zero", 500},
        {49, "one", 500},
        {50, "two", 500},
        {51, "three", 500},
        {52, "four", 500},
        {53, "five", 500},
        {54, "six", 500},
        {55, "seven", 500},
        {56, "eight", 500},
        {57, "nine", 500},
        {58, "colon", 333},
        {59, "semicolon", 333},
        {60, "less", 675},
        {61, "equal", 675},
        {62, "greater", 675},
        {63, "question", 500},
        {64, "at", 920},
        {65, "A", 611},
        {66, "B", 611},
        {67, "C", 667},
        {68, "D", 722},
        {69, "E", 611},
        {70, "F", 611},
        {71, "G", 722},
        {72, "H", 722},
        {73, "I", 333},
        {74, "J", 444},
        {75, "K", 667},
        {76, "L", 556},
        {77, "M", 833},
        {78, "N", 667},
        {79, "O", 722},
        {80, "P", 611},
        {81, "Q", 722},
        {82, "R", 611},
        {83, "S", 500},
        {84, "T", 556},
        {85, "U", 722},
        {86, "V", 611},
        {87, "W", 833},
        {88, "X", 611},
        {89, "Y", 556},
        {90, "Z", 556},
        {91, "bracketleft", 389},
        {92, "backslash", 278},
        {93, "bracketright", 389},
        {94, "asciicircum", 422},
        {95, "underscore", 500},
        {96, "quoteleft", 333},
        {97, "a", 500},
        {98, "b", 500},
        {99, "c", 444},
        {100, "d", 500},
        {101, "e", 444},
        {102, "f", 278},
        {103, "g", 500},
        {104, "h", 500},
        {105, "i", 278},
        {106, "j", 278},
        {107, "k", 444},
        {108, "l", 278},
        {109, "m", 722},
        {110, "n", 500},
        {111, "o", 500},
        {112, "p", 500},
        {113, "q", 500},
        {114, "r", 389},
        {115, "s", 389},
        {116, "t", 278},
        {117, "u", 500},
        {118, "v", 444},
        {119, "w", 667},
        {120, "x", 444},
        {121, "y", 444},
        {122, "z", 389},
        {123, "braceleft", 400},
        {124, "bar", 275},
        {125, "braceright", 400},
        {126, "asciitilde", 541},
        {161, "exclamdown", 389},
        {162, "cent", 500},
        {163, "sterling", 500},
        {164, "fraction", 167},
        {165, "yen", 500},
        {166, "florin", 500},
        {167, "section", 500},
        {168, "currency", 500},
        {169, "quotesingle", 214},
        {170, "quotedblleft", 556},
        {171, "guillemotleft", 500},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 500},
        {175, "fl", 500},
        {177, "endash", 500},
        {178, "dagger", 500},
        {179, "daggerdbl", 500},
        {180, "periodcentered", 250},
        {182, "paragraph", 523},
        {183, "bullet", 350},
        {184, "quotesinglbase", 333},
        {185, "quotedblbase", 556},
        {186, "quotedblright", 556},
        {187, "guillemotright", 500},
        {188, "ellipsis", 889},
        {189, "perthousand", 1000},
        {191, "questiondown", 500},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 889},
        {225, "AE", 889},
        {227, "ordfeminine", 276},
        {232, "Lslash", 556},
        {233, "Oslash", 722},
        {234, "OE", 944},
        {235, "ordmasculine", 310},
        {241, "ae", 667},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 500},
        {250, "oe", 667},
        {251, "germandbls", 500},
        {-1, "Idieresis", 333},
        {-1, "eacute", 444},
        {-1, "abreve", 500},
        {-1, "uhungarumlaut", 500},
        {-1, "ecaron", 444},
        {-1, "Ydieresis", 556},
        {-1, "divide", 675},
        {-1, "Yacute", 556},
        {-1, "Acircumflex", 611},
        {-1, "aacute", 500},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 444},
        {-1, "scommaaccent", 389},
        {-1, "ecircumflex", 444},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 500},
        {-1, "Uacute", 722},
        {-1, "uogonek", 500},
        {-1, "Edieresis", 611},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 760},
        {-1, "Emacron", 611},
        {-1, "ccaron", 444},
        {-1, "aring", 500},
        {-1, "Ncommaaccent", 667},
        {-1, "lacute", 278},
        {-1, "agrave", 500},
        {-1, "Tcommaaccent", 556},
        {-1, "Cacute", 667},
        {-1, "atilde", 500},
        {-1, "Edotaccent", 611},
        {-1, "scaron", 389},
        {-1, "scedilla", 389},
        {-1, "iacute", 278},
        {-1, "lozenge", 471},
        {-1, "Rcaron", 611},
        {-1, "Gcommaaccent", 722},
        {-1, "ucircumflex", 500},
        {-1, "acircumflex", 500},
        {-1, "Amacron", 611},
        {-1, "rcaron", 389},
        {-1, "ccedilla", 444},
        {-1, "Zdotaccent", 556},
        {-1, "Thorn", 611},
        {-1, "Omacron", 722},
        {-1, "Racute", 611},
        {-1, "Sacute", 500},
        {-1, "dcaron", 544},
        {-1, "Umacron", 722},
        {-1, "uring", 500},
        {-1, "threesuperior", 300},
        {-1, "Ograve", 722},
        {-1, "Agrave", 611},
        {-1, "Abreve", 611},
        {-1, "multiply", 675},
        {-1, "uacute", 500},
        {-1, "Tcaron", 556},
        {-1, "partialdiff", 476},
        {-1, "ydieresis", 444},
        {-1, "Nacute", 667},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 611},
        {-1, "adieresis", 500},
        {-1, "edieresis", 444},
        {-1, "cacute", 444},
        {-1, "nacute", 500},
        {-1, "umacron", 500},
        {-1, "Ncaron", 667},
        {-1, "Iacute", 333},
        {-1, "plusminus", 675},
        {-1, "brokenbar", 275},
        {-1, "registered", 760},
        {-1, "Gbreve", 722},
        {-1, "Idotaccent", 333},
        {-1, "summation", 600},
        {-1, "Egrave", 611},
        {-1, "racute", 389},
        {-1, "omacron", 500},
        {-1, "Zacute", 556},
        {-1, "Zcaron", 556},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 667},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 300},
        {-1, "eogonek", 444},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 611},
        {-1, "Adieresis", 611},
        {-1, "egrave", 444},
        {-1, "zacute", 389},
        {-1, "iogonek", 278},
        {-1, "Oacute", 722},
        {-1, "oacute", 500},
        {-1, "amacron", 500},
        {-1, "sacute", 389},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 722},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 500},
        {-1, "twosuperior", 300},
        {-1, "Odieresis", 722},
        {-1, "mu", 500},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 500},
        {-1, "Eogonek", 611},
        {-1, "dcroat", 500},
        {-1, "threequarters", 750},
        {-1, "Scedilla", 500},
        {-1, "lcaron", 300},
        {-1, "Kcommaaccent", 667},
        {-1, "Lacute", 556},
        {-1, "trademark", 980},
        {-1, "edotaccent", 444},
        {-1, "Igrave", 333},
        {-1, "Imacron", 333},
        {-1, "Lcaron", 611},
        {-1, "onehalf", 750},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 500},
        {-1, "ntilde", 500},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 611},
        {-1, "emacron", 444},
        {-1, "gbreve", 500},
        {-1, "onequarter", 750},
        {-1, "Scaron", 500},
        {-1, "Scommaaccent", 500},
        {-1, "Ohungarumlaut", 722},
        {-1, "degree", 400},
        {-1, "ograve", 500},
        {-1, "Ccaron", 667},
        {-1, "ugrave", 500},
        {-1, "radical", 453},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 389},
        {-1, "Ntilde", 667},
        {-1, "otilde", 500},
        {-1, "Rcommaaccent", 611},
        {-1, "Lcommaaccent", 556},
        {-1, "Atilde", 611},
        {-1, "Aogonek", 611},
        {-1, "Aring", 611},
        {-1, "Otilde", 722},
        {-1, "zdotaccent", 389},
        {-1, "Ecaron", 611},
        {-1, "Iogonek", 333},
        {-1, "kcommaaccent", 444},
        {-1, "minus", 675},
        {-1, "Icircumflex", 333},
        {-1, "ncaron", 500},
        {-1, "tcommaaccent", 278},
        {-1, "logicalnot", 675},
        {-1, "odieresis", 500},
        {-1, "udieresis", 500},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 500},
        {-1, "eth", 500},
        {-1, "zcaron", 389},
        {-1, "ncommaaccent", 500},
        {-1, "onesuperior", 300},
        {-1, "imacron", 278},
        {-1, "Euro", 500},
        {-1, NULL, 0}
    };
    fFontBBox.left = -169;
    fFontBBox.top = -217;
    fFontBBox.right = 1010;
    fFontBBox.bottom = 883;
    fAscent = 683;
    fDescent =-217;
    fXHeight = 441;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
