#ifdef BEAGLE
#include "beagle.h"
#include "migration.h"
#include "tools.h"
#include "sighandler.h"
/*-----------------------------------------------------------------------------
|	This function sets up the beagle library and initializes all data members.
*/
void init_beagle(world_fmt *world, long locus)
{

  beagle_fmt *beagle = world->beagle;
  beagle->instance_handle1    = (int *) mycalloc(world->nummutationmodels[locus],sizeof(int));
  beagle->instance_handle2    = (int *) mycalloc(world->nummutationmodels[locus],sizeof(int));
  beagle->instance_handle     = beagle->instance_handle1;
  beagle->numallocpartials    = world->sumtips*world->mutationmodels[0].numstates*world->mutationmodels[0].numsites;
  beagle->partials            = (double *) mycalloc(beagle->numallocpartials, sizeof(double));

  beagle->numallocbranches1   = 20;
  beagle->branch_lengths1     = (double *) mycalloc(beagle->numallocbranches1, sizeof(double));
  beagle->numallocoperations1 = 10;
  beagle->operations1         = (int *) mycalloc(beagle->numallocoperations1 * 6,sizeof(int));//parent,parentIDscalingfactor, lchild,lchildtrans,rchild,rtrans
  beagle->branch_indices1     = (int *) mycalloc(beagle->numallocoperations1 * 2, sizeof(int));

  beagle->numallocbranches2   = 20;
  beagle->branch_lengths2     = (double *) mycalloc(beagle->numallocbranches2, sizeof(double));
  beagle->numallocoperations2 = 10;
  beagle->operations2         = (int *) mycalloc(beagle->numallocoperations2 * 6,sizeof(int));//parent,lchild,lchildtrans,rchild,rtrans
  beagle->branch_indices2     = (int *) mycalloc(beagle->numallocoperations2 * 2, sizeof(int));

  beagle->scalingfactorsindices= (int *) mycalloc(world->sumtips-1, sizeof(int));
  beagle->scalingfactorscount  = world->sumtips-1;

  beagle->numallocbranches    = beagle->numallocbranches1;
  beagle->branch_lengths      = beagle->branch_lengths1;
  beagle->numallocoperations  = beagle->numallocoperations1;
  beagle->operations          = beagle->operations1;
  beagle->branch_indices      = beagle->branch_indices1;

  beagle->numallocallyweights = world->mutationmodels[0].numsites;
  beagle->allyweights = (int *) mycalloc(beagle->numallocallyweights,sizeof(int));
  // this is already set and definitely should be set here, left as reminder
  // that the current setting in makevalues() is a hack
  //  world->mutationmodels[world->sublocistarts[locus]].basefreqs = (double *) calloc(world->mutationmodels[world->sublocistarts[locus]].numstates,sizeof(double));
} 

void  set_beagle_instances(world_fmt *world, boolean instance)
{
  long i;
  long ii;
  long locus = world->locus;
  beagle_fmt *beagle = world->beagle;
  //  if(instance)
    beagle->instance_handle = beagle->instance_handle1;
    //else
    //beagle->instance_handle = beagle->instance_handle2;
  for(i=0;i<world->nummutationmodels[locus];i++)
    {
      ii = world->sublocistarts[locus] + i;
      beagle->instance_handle[i] = createInstance(
						  world->sumtips,       // number of tips
						  2 * world->sumtips-1, // total buffers (= total nodes in tree)
						  0,			// number of compact state representation [funny tips]
						  world->mutationmodels[ii].numstates, // number of states (nucleotides etc)
						  world->mutationmodels[ii].numsites,  // number of site patterns
						  1,			// number of rate matrices eigen-decomp buffers
						  2 * world->sumtips - 2,// number of rate matrix buffers (=number of branches)
						  1,                    // categoryCount
                                                  NULL,		        // List of resources (?)
						  0,			// Number of resources
						  CPU,			// preferenceFlags (see BeagleFlags)
						  0L			// requirementFlags (see BeagleFlags) 
						  );

      if (beagle->instance_handle[i] < 0)
	usererror("createInstance returned a negative instance handle (and that's not good)");
    // initialize the instance
    int code = initializeInstance(beagle->instance_handle[i], NULL);
	
    if (code < 0) 
      {
	usererror("initializeInstance returned a negative error code (and that is bad)\n\n");
      }
    }
}


long
set_branch_index (node * p,  long *bid)
{
  long bbid = *bid;
    if (p->type != 't')
    {
      bbid = set_branch_index (crawlback (p->next), &bbid);
      bbid = set_branch_index (crawlback (p->next->next), &bbid);
    }
    p->bid = bbid;
    printf("%li -- %li\n",p->id, bbid);
    return bbid+1;
}    /* set_branch_index */


void adjust_beagle(beagle_fmt *beagle, boolean instance)
{
  if(instance) // is equivalent to beagle->operations==beagle->operations2
    {
      beagle->numallocoperations2 = beagle->numoperations + 10;
      beagle->operations2 = (int *) myrealloc(beagle->operations2, sizeof(int) * 6 * beagle->numallocoperations2);
      beagle->branch_lengths2   = (double *) myrealloc(beagle->branch_lengths2, sizeof(double) * 2 * beagle->numallocoperations2);
      beagle->branch_indices2 = (int *) myrealloc(beagle->branch_indices2, beagle->numallocoperations2 * 2 * sizeof(int));
      beagle->operations =        beagle->operations2 ;  
      beagle->branch_lengths   =  beagle->branch_lengths2;
      beagle->branch_indices =    beagle->branch_indices2;
      beagle->numoperations2 = beagle->numoperations;
      beagle->numbranches2 = beagle->numbranches;
      beagle->numallocbranches2 = beagle->numallocbranches = beagle->numallocoperations2 * 2;
      beagle->numallocoperations = beagle->numallocoperations2;
    }
  else
    {  //is equivalent to beagle->operations != beagle->operations2)
      beagle->numallocoperations1 = beagle->numoperations + 10;
      beagle->operations1 = (int *) myrealloc(beagle->operations1, sizeof(int) * 6 * beagle->numallocoperations1);
      beagle->branch_lengths1   = (double *) myrealloc(beagle->branch_lengths1, sizeof(double) * 2 * beagle->numallocoperations1);
      beagle->branch_indices1 = (int *) myrealloc(beagle->branch_indices1, beagle->numallocoperations1 * 2 * sizeof(int));
      beagle->operations =        beagle->operations1 ;  
      beagle->branch_lengths   =  beagle->branch_lengths1;
      beagle->branch_indices =    beagle->branch_indices1;
      beagle->numoperations1 = beagle->numoperations;
      beagle->numbranches1 = beagle->numbranches;
      beagle->numallocbranches1 = beagle->numallocbranches = beagle->numallocoperations1 * 2;
      beagle->numallocoperations = beagle->numallocoperations1;
    }
}


void prepare_beagle_instances(node *theNode, node * left, node *right, beagle_fmt *beagle)
{
  long parentid = theNode->id;
  long rightid  = right->id;
  long leftid   = left->id;
 
  long rightbid  = right->bid;
  long leftbid   = left->bid;

  double leftbranch = left->v;
  double rightbranch = right->v;
  long ii = beagle->numoperations;
  long i = ii * 6;
  long j = ii * 2;
  if(beagle->numoperations  >=  beagle->numallocoperations)
    {
      adjust_beagle(beagle,beagle->operations==beagle->operations2);
    }
  beagle->branch_indices[j] = leftbid;
  beagle->branch_indices[j+1] = rightbid;

  beagle->operations[i]   = parentid;
  beagle->operations[i+1]   = parentid;
  beagle->operations[i+2] = leftid;
  beagle->operations[i+3] = leftbid;
  beagle->operations[i+4] = rightid;
  beagle->operations[i+5] = rightbid;

  beagle->branch_lengths[j]     = leftbranch; 
  beagle->branch_lengths[j+1]   = rightbranch; 

  beagle->scalingfactorsindices[ii] = parentid;
  beagle->scalingfactorscount += 1;
  beagle->numbranches += 2;
  beagle->numoperations++;
  //  printf("c");
}

void prepare_beagle_instances_proposal(proposal_fmt *proposal, long parentid, long leftid, long leftbid, double leftbranch, 
				       long rightid, long rightbid, double rightbranch, beagle_fmt *beagle)
{
  long i = beagle->numoperations * 6;
  long j = beagle->numoperations * 2;
  if(beagle->numoperations  >=  beagle->numallocoperations)
    {
      adjust_beagle(beagle,beagle->operations==beagle->operations2);
    }
  beagle->branch_indices[j] = leftbid;
  beagle->branch_indices[j+1] = rightbid;
  beagle->operations[i]   = parentid;
  beagle->operations[i+1]   = parentid;
  beagle->operations[i+2] = leftid;
  beagle->operations[i+3] = leftbid;
  beagle->operations[i+4] = rightid;
  beagle->operations[i+5] = rightbid;

  beagle->branch_lengths[j]     = leftbranch; 
  beagle->branch_lengths[j+1]   = rightbranch; 
  beagle->numbranches += 2;
  beagle->numoperations++;
  //printf("p");
}


void fill_beagle_instances(world_fmt *world)
{
  beagle_fmt *beagle = world->beagle;
  unsigned long i;
  unsigned long ii;
  unsigned long j;
  unsigned long zz;
  unsigned long site;
  unsigned int numsites;
  unsigned int numstates;
  unsigned int numweights=0;
  int code;
  long locus = world->locus;
  // set partials for all tipnodes
  // use z to advance through the partial array
  unsigned long z = 0L;

  for(i=0; i<world->nummutationmodels[locus]; i++)
    {
      ii = world->sublocistarts[locus] + i;
      numstates = world->mutationmodels[ii].numstates;
      numsites = world->mutationmodels[ii].numsites;
      // will currently fail with more complex data
      if(numsites + numweights < beagle->numallocallyweights)
	{
	  beagle->numallocallyweights += numsites * 2;
	  beagle->allyweights = (int *) myrealloc(beagle->allyweights,sizeof(int) * beagle->numallocallyweights);
	}
      memcpy(beagle->allyweights+numweights, world->data->seq[0]->aliasweight, sizeof(int) * numsites);
      numweights += numsites;
      for (j = 0; j < world->sumtips; ++j)
	{
	  for(site=0;site<numsites;site++)
	    {
	      if(z > beagle->numallocpartials)
		{
		  beagle->numallocpartials += numsites * numstates;
		  beagle->partials = (double *) myrealloc(beagle->partials,sizeof(double) * beagle->numallocpartials);
		}
	      memcpy(&beagle->partials[z], 
		     &(world->nodep[j]->x.s[site][0][0]),
		     sizeof(double) * numstates);
	      beagle->numpartials++;
	      fprintf(stdout,"Site %li Partial: %li (%f ", site, j, 
		      beagle->partials[z]);
	      for(zz=1;zz<world->mutationmodels[ii].numstates;zz++)
		{
		  fprintf(stdout,"%f ",beagle->partials[z+zz]);
		}
	      fprintf(stdout,")\n");
	      // advance z
	      z += numstates;
	    }
	  code = setPartials(
			     beagle->instance_handle1[i],			// instance
			     j,							// indicator for tips
			     &beagle->partials[z - numsites*numstates]);// inPartials
	  if (code != 0)
	    usererror("setPartials encountered a problem");
	  //  code = setPartials(
	  //		     beagle->instance_handle2[i],			// instance
			       //		     j,							// indicator for tips
	  //&beagle->partials[z - numsites*numstates]);// inPartials
	  //if (code != 0)
	  //  usererror("setPartials encountered a problem");
	}
    }

  
  for(i=0; i<world->nummutationmodels[locus]; i++)
    {
      ii = world->sublocistarts[locus] + i;

      code = setCategoryRates(beagle->instance_handle1[i], world->mutationmodels[ii].siterates);
      if (code != 0)
	usererror("setCategoryRates encountered a problem");

      code = setEigenDecomposition(beagle->instance_handle1[i],		  // instance
				   0,					  // eigenIndex,
				   (const double *)world->mutationmodels[ii].eigenvectormatrix,	// inEigenVectors,
				   (const double *)world->mutationmodels[ii].inverseeigenvectormatrix,// inInverseEigenVectors,
				   world->mutationmodels[i].eigenvalues); // inEigenValues
      
      if (code != 0)
	usererror("setEigenDecomposition encountered a problem");
      // code = setEigenDecomposition(beagle->instance_handle2[i],		  // instance
      //				   0,					  // eigenIndex,
      //				   (const double *)world->mutationmodels[ii].eigenvectormatrix,	// inEigenVectors,
      //				   (const double *)world->mutationmodels[ii].inverseeigenvectormatrix,// inInverseEigenVectors,
      //				   world->mutationmodels[i].eigenvalues); // inEigenValues
      // 
      //if (code != 0)
      //	usererror("setEigenDecomposition encountered a problem");
    }
}
/*-----------------------------------------------------------------------------
|	Calculates the log likelihood by calling the beagle functions
|	updateTransitionMatrices, updatePartials and calculateEdgeLogLikelihoods.
*/
double calcLnL(world_fmt *world, boolean instance)
{
  beagle_fmt *beagle = world->beagle;
  double logL = 0.0;
  unsigned long i;
  unsigned long j;
  //unsigned long z;
  long locus = world->locus;
  long ii;
  double *patternloglike = (double *) calloc(world->maxnumpattern[locus],sizeof(double));
  double *outlike = (double *) calloc(4,sizeof(double));
  int rootIndex = world->root->next->back->id;
  //  if(instance)
    beagle->instance_handle = beagle->instance_handle1;
    //else
    //beagle->instance_handle = beagle->instance_handle2;

  for(i=0; i<world->nummutationmodels[locus]; i++)
    {
      ii = world->sublocistarts[locus] + i;
      int code = updateTransitionMatrices(beagle->instance_handle[i],		// instance,
					  0,					// eigenIndex,
					  (const int *) beagle->branch_indices,	// indicators transitionrates for each branch,
					  NULL, 			        // firstDerivativeIndices,
					  NULL,					// secondDervativeIndices,
					  beagle->branch_lengths,		// edgeLengths,
					  beagle->numbranches);			// number branches to update, count

	if (code != 0)
		usererror("updateTransitionMatrices encountered a problem");

	code = updatePartials((const int *) &beagle->instance_handle[i],	// instance
			      1,					        // instanceCount
			      beagle->operations,		                // operations
			      beagle->numoperations,				// operationCount
			      0);					        // rescale 1=yes

	//for(j=0;j<world->sumtips * 2 - 2; j++)
	//  {
	//    getPartials(beagle->instance_handle[i],j,outlike);
	//    printf("%li: {%f, %f, %f, %f}\n",j, outlike[0],outlike[1],outlike[2],outlike[3]);
	//  }

	if (code != 0)
	  usererror("updatePartials encountered a problem");
	if(beagle->weights==NULL)
	  beagle->weights = (double *) mycalloc(1,sizeof(double));
	//	else
	//  beagle->weights = (double *) myrealloc(beagle->weights,beagle->numoperations * sizeof(double));
	//for(z=0;z<beagle->numoperations;z++)
	beagle->weights[0]= 1.0;

	// calculate the site likelihoods at the root node
	code = calculateRootLogLikelihoods(beagle->instance_handle[i],         // instance
					   (const int *) &rootIndex, // bufferIndices
					   (const double *) beagle->weights,   // weights
					   (const double *) world->mutationmodels[ii].basefreqs,// stateFrequencies
					   beagle->scalingfactorsindices, //scalingfactors index,
					   &beagle->scalingfactorscount,//size of the scaling factor index
					   1,              // count is this correct
	                            patternloglike);         // outLogLikelihoods

	if (code != 0)
		usererror("calculateRootLogLikelihoods encountered a problem");

	for (j = 0; j < world->mutationmodels[ii].numsites; j++) 
	  {
		logL += beagle->allyweights[j] * patternloglike[j];
		//		printf("%.1f ",patternloglike[j]);
	}
    }
  printf("Log LnL=%f (instance=%li)\n",logL,(long) instance);
  debug_beagle(beagle);
  myfree(patternloglike);
  myfree(outlike);
  return logL; 
}


void copy_beagle(beagle_fmt *beagle)
{
  if(beagle->operations==beagle->operations2)
      {
	adjust_beagle(beagle,beagle->operations==beagle->operations2);

	memcpy(beagle->branch_lengths1,beagle->branch_lengths2,sizeof(double)*beagle->numbranches);
	memcpy(beagle->branch_indices1,beagle->branch_indices2,sizeof(int)*beagle->numbranches);
	memcpy(beagle->operations1,beagle->operations2,sizeof(int)*beagle->numoperations);	
      }
    else
      {
	adjust_beagle(beagle,beagle->operations==beagle->operations1);

	memcpy(beagle->branch_lengths2,beagle->branch_lengths1,sizeof(double)*beagle->numbranches);
	memcpy(beagle->branch_indices2,beagle->branch_indices1,sizeof(int)*beagle->numbranches);
	memcpy(beagle->operations2,beagle->operations1,sizeof(int)*beagle->numoperations);
      }
}
void change_beagle(beagle_fmt *beagle)
{
  //beagle->instance       = !beagle->instance; //set back to the original state
  //if(!beagle->instance)
  if(beagle->operations!=beagle->operations1)
      {
	beagle->branch_lengths = beagle->branch_lengths1;
	beagle->branch_indices = beagle->branch_indices1;
	beagle->operations     = beagle->operations1;
	
	beagle->numallocbranches2=beagle->numallocbranches;
	beagle->numallocoperations2 =   beagle->numallocoperations;
	beagle->numbranches2    = beagle->numbranches;
	beagle->numoperations2  = beagle->numoperations;

	beagle->numbranches    = beagle->numbranches1;
	beagle->numoperations  = beagle->numoperations1;
	beagle->numallocbranches=beagle->numallocbranches1;
	beagle->numallocoperations =   beagle->numallocoperations1;
      }
    else
      {
	beagle->branch_lengths = beagle->branch_lengths2;
	beagle->branch_indices = beagle->branch_indices2;
	beagle->operations     = beagle->operations2;

	beagle->numallocbranches1   =   beagle->numallocbranches;
	beagle->numallocoperations1 =   beagle->numallocoperations;
	beagle->numbranches1    = beagle->numbranches;
	beagle->numoperations1  = beagle->numoperations;

	beagle->numbranches    = beagle->numbranches2;
	beagle->numoperations  = beagle->numoperations2;
	beagle->numallocbranches=beagle->numallocbranches2;
	beagle->numallocoperations =   beagle->numallocoperations2;

      }
}


void reset_beagle(beagle_fmt *beagle)
{
  beagle->numoperations = 0;
  beagle->numbranches   = 0;
  beagle->scalingfactorscount = 0;
}

void beagle_stop(world_fmt **universe, long usize)
{
  long u;
  for(u=0;u< usize; u++)
    {
      world_fmt *world = universe[u];
      beagle_fmt *beagle = world->beagle;
      unsigned long i;
      long locus = world->locus;
      for(i=0; i<world->nummutationmodels[locus]; i++)
	{
	  finalize(beagle->instance_handle[i]);
	}
    }
}


void set_beagle_dirty(node *origin, node *target, node *mrca)
{
  node *nn = origin;
  while((nn=showtop(crawlback(nn)))!=mrca)
    {
      set_dirty(nn);
    }
  nn = target;
  while((nn=showtop(crawlback(nn)))!=mrca)
    {
      set_dirty(nn);
    }
}

void debug_beagle(beagle_fmt *beagle)
{
  printf("-----------------------beagle content---------------------\n");
  printf("operations    : %p: (1=%p 2=%p)\n",beagle->operations, beagle->operations1,beagle->operations2);
  printf("     alloc    : %i: (1=%i 2=%i)\n",beagle->numallocoperations, beagle->numallocoperations1,beagle->numallocoperations2);
  printf("       num    : %i: (1=%i 2=%i)\n",beagle->numoperations, beagle->numoperations1,beagle->numoperations2);
  printf("branch indices: %p: (1=%p 2=%p)\n",beagle->branch_indices, beagle->branch_indices1,beagle->branch_indices2);
  printf("     alloc    : %i: (1=%i 2=%i)\n",beagle->numallocbranches, beagle->numallocbranches1,beagle->numallocbranches2);
  printf("       num    : %i: (1=%i 2=%i)\n",beagle->numbranches, beagle->numbranches1,beagle->numbranches2);
  printf("-----------------------beagle content end-----------------\n\n");
}



#endif /*BEAGLE*/
