/*
 * << H a r u free pdf library >> -- PdfFontDef_Helvetica.cc
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */


#include "libharu.h"

/*----- Helvetica Font ------------------------------------------------------*/

PdfHelveticaFontDef::PdfHelveticaFontDef()
    : PdfType1FontDef("Helvetica")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 278},
        {33, "exclam", 278},
        {34, "quotedbl", 355},
        {35, "numbersign", 556},
        {36, "dollar", 556},
        {37, "percent", 889},
        {38, "ampersand", 667},
        {39, "quoteright", 222},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 389},
        {43, "plus", 584},
        {44, "comma", 278},
        {45, "hyphen", 333},
        {46, "period", 278},
        {47, "slash", 278},
        {48, "zero", 556},
        {49, "one", 556},
        {50, "two", 556},
        {51, "three", 556},
        {52, "four", 556},
        {53, "five", 556},
        {54, "six", 556},
        {55, "seven", 556},
        {56, "eight", 556},
        {57, "nine", 556},
        {58, "colon", 278},
        {59, "semicolon", 278},
        {60, "less", 584},
        {61, "equal", 584},
        {62, "greater", 584},
        {63, "question", 556},
        {64, "at", 1015},
        {65, "A", 667},
        {66, "B", 667},
        {67, "C", 722},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 611},
        {71, "G", 778},
        {72, "H", 722},
        {73, "I", 278},
        {74, "J", 500},
        {75, "K", 667},
        {76, "L", 556},
        {77, "M", 833},
        {78, "N", 722},
        {79, "O", 778},
        {80, "P", 667},
        {81, "Q", 778},
        {82, "R", 722},
        {83, "S", 667},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 667},
        {87, "W", 944},
        {88, "X", 667},
        {89, "Y", 667},
        {90, "Z", 611},
        {91, "bracketleft", 278},
        {92, "backslash", 278},
        {93, "bracketright", 278},
        {94, "asciicircum", 469},
        {95, "underscore", 556},
        {96, "quoteleft", 222},
        {97, "a", 556},
        {98, "b", 556},
        {99, "c", 500},
        {100, "d", 556},
        {101, "e", 556},
        {102, "f", 278},
        {103, "g", 556},
        {104, "h", 556},
        {105, "i", 222},
        {106, "j", 222},
        {107, "k", 500},
        {108, "l", 222},
        {109, "m", 833},
        {110, "n", 556},
        {111, "o", 556},
        {112, "p", 556},
        {113, "q", 556},
        {114, "r", 333},
        {115, "s", 500},
        {116, "t", 278},
        {117, "u", 556},
        {118, "v", 500},
        {119, "w", 722},
        {120, "x", 500},
        {121, "y", 500},
        {122, "z", 500},
        {123, "braceleft", 334},
        {124, "bar", 260},
        {125, "braceright", 334},
        {126, "asciitilde", 584},
        {161, "exclamdown", 333},
        {162, "cent", 556},
        {163, "sterling", 556},
        {164, "fraction", 167},
        {165, "yen", 556},
        {166, "florin", 556},
        {167, "section", 556},
        {168, "currency", 556},
        {169, "quotesingle", 191},
        {170, "quotedblleft", 333},
        {171, "guillemotleft", 556},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 500},
        {175, "fl", 500},
        {177, "endash", 556},
        {178, "dagger", 556},
        {179, "daggerdbl", 556},
        {180, "periodcentered", 278},
        {182, "paragraph", 537},
        {183, "bullet", 350},
        {184, "quotesinglbase", 222},
        {185, "quotedblbase", 333},
        {186, "quotedblright", 333},
        {187, "guillemotright", 556},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 611},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 1000},
        {227, "ordfeminine", 370},
        {232, "Lslash", 556},
        {233, "Oslash", 778},
        {234, "OE", 1000},
        {235, "ordmasculine", 365},
        {241, "ae", 889},
        {245, "dotlessi", 278},
        {248, "lslash", 222},
        {249, "oslash", 611},
        {250, "oe", 944},
        {251, "germandbls", 611},
        {-1, "Idieresis", 278},
        {-1, "eacute", 556},
        {-1, "abreve", 556},
        {-1, "uhungarumlaut", 556},
        {-1, "ecaron", 556},
        {-1, "Ydieresis", 667},
        {-1, "divide", 584},
        {-1, "Yacute", 667},
        {-1, "Acircumflex", 667},
        {-1, "aacute", 556},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 500},
        {-1, "scommaaccent", 500},
        {-1, "ecircumflex", 556},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 556},
        {-1, "Uacute", 722},
        {-1, "uogonek", 556},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 737},
        {-1, "Emacron", 667},
        {-1, "ccaron", 500},
        {-1, "aring", 556},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 222},
        {-1, "agrave", 556},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 722},
        {-1, "atilde", 556},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 500},
        {-1, "scedilla", 500},
        {-1, "iacute", 278},
        {-1, "lozenge", 471},
        {-1, "Rcaron", 722},
        {-1, "Gcommaaccent", 778},
        {-1, "ucircumflex", 556},
        {-1, "acircumflex", 556},
        {-1, "Amacron", 667},
        {-1, "rcaron", 333},
        {-1, "ccedilla", 500},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 667},
        {-1, "Omacron", 778},
        {-1, "Racute", 722},
        {-1, "Sacute", 667},
        {-1, "dcaron", 643},
        {-1, "Umacron", 722},
        {-1, "uring", 556},
        {-1, "threesuperior", 333},
        {-1, "Ograve", 778},
        {-1, "Agrave", 667},
        {-1, "Abreve", 667},
        {-1, "multiply", 584},
        {-1, "uacute", 556},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 476},
        {-1, "ydieresis", 500},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 556},
        {-1, "edieresis", 556},
        {-1, "cacute", 500},
        {-1, "nacute", 556},
        {-1, "umacron", 556},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 278},
        {-1, "plusminus", 584},
        {-1, "brokenbar", 260},
        {-1, "registered", 737},
        {-1, "Gbreve", 778},
        {-1, "Idotaccent", 278},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 333},
        {-1, "omacron", 556},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 722},
        {-1, "lcommaaccent", 222},
        {-1, "tcaron", 316},
        {-1, "eogonek", 556},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 667},
        {-1, "Adieresis", 667},
        {-1, "egrave", 556},
        {-1, "zacute", 500},
        {-1, "iogonek", 222},
        {-1, "Oacute", 778},
        {-1, "oacute", 556},
        {-1, "amacron", 556},
        {-1, "sacute", 500},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 778},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 556},
        {-1, "twosuperior", 333},
        {-1, "Odieresis", 778},
        {-1, "mu", 556},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 556},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 556},
        {-1, "threequarters", 834},
        {-1, "Scedilla", 667},
        {-1, "lcaron", 299},
        {-1, "Kcommaaccent", 667},
        {-1, "Lacute", 556},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 556},
        {-1, "Igrave", 278},
        {-1, "Imacron", 278},
        {-1, "Lcaron", 556},
        {-1, "onehalf", 834},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 556},
        {-1, "ntilde", 556},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 556},
        {-1, "gbreve", 556},
        {-1, "onequarter", 834},
        {-1, "Scaron", 667},
        {-1, "Scommaaccent", 667},
        {-1, "Ohungarumlaut", 778},
        {-1, "degree", 400},
        {-1, "ograve", 556},
        {-1, "Ccaron", 722},
        {-1, "ugrave", 556},
        {-1, "radical", 453},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 333},
        {-1, "Ntilde", 722},
        {-1, "otilde", 556},
        {-1, "Rcommaaccent", 722},
        {-1, "Lcommaaccent", 556},
        {-1, "Atilde", 667},
        {-1, "Aogonek", 667},
        {-1, "Aring", 667},
        {-1, "Otilde", 778},
        {-1, "zdotaccent", 500},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 278},
        {-1, "kcommaaccent", 500},
        {-1, "minus", 584},
        {-1, "Icircumflex", 278},
        {-1, "ncaron", 556},
        {-1, "tcommaaccent", 278},
        {-1, "logicalnot", 584},
        {-1, "odieresis", 556},
        {-1, "udieresis", 556},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 556},
        {-1, "eth", 556},
        {-1, "zcaron", 500},
        {-1, "ncommaaccent", 556},
        {-1, "onesuperior", 333},
        {-1, "imacron", 278},
        {-1, "Euro", 556},
        {-1, NULL, 0}
    };
    fFontBBox.left = -166;
    fFontBBox.top = -225;
    fFontBBox.right = 1000;
    fFontBBox.bottom = 931;
    fAscent = 718;
    fDescent =-207;
    fXHeight = 523;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- HelveticaBold Font --------------------------------------------------*/

PdfHelveticaBoldFontDef::PdfHelveticaBoldFontDef()
    : PdfType1FontDef("Helvetica-Bold")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 278},
        {33, "exclam", 333},
        {34, "quotedbl", 474},
        {35, "numbersign", 556},
        {36, "dollar", 556},
        {37, "percent", 889},
        {38, "ampersand", 722},
        {39, "quoteright", 278},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 389},
        {43, "plus", 584},
        {44, "comma", 278},
        {45, "hyphen", 333},
        {46, "period", 278},
        {47, "slash", 278},
        {48, "zero", 556},
        {49, "one", 556},
        {50, "two", 556},
        {51, "three", 556},
        {52, "four", 556},
        {53, "five", 556},
        {54, "six", 556},
        {55, "seven", 556},
        {56, "eight", 556},
        {57, "nine", 556},
        {58, "colon", 333},
        {59, "semicolon", 333},
        {60, "less", 584},
        {61, "equal", 584},
        {62, "greater", 584},
        {63, "question", 611},
        {64, "at", 975},
        {65, "A", 722},
        {66, "B", 722},
        {67, "C", 722},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 611},
        {71, "G", 778},
        {72, "H", 722},
        {73, "I", 278},
        {74, "J", 556},
        {75, "K", 722},
        {76, "L", 611},
        {77, "M", 833},
        {78, "N", 722},
        {79, "O", 778},
        {80, "P", 667},
        {81, "Q", 778},
        {82, "R", 722},
        {83, "S", 667},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 667},
        {87, "W", 944},
        {88, "X", 667},
        {89, "Y", 667},
        {90, "Z", 611},
        {91, "bracketleft", 333},
        {92, "backslash", 278},
        {93, "bracketright", 333},
        {94, "asciicircum", 584},
        {95, "underscore", 556},
        {96, "quoteleft", 278},
        {97, "a", 556},
        {98, "b", 611},
        {99, "c", 556},
        {100, "d", 611},
        {101, "e", 556},
        {102, "f", 333},
        {103, "g", 611},
        {104, "h", 611},
        {105, "i", 278},
        {106, "j", 278},
        {107, "k", 556},
        {108, "l", 278},
        {109, "m", 889},
        {110, "n", 611},
        {111, "o", 611},
        {112, "p", 611},
        {113, "q", 611},
        {114, "r", 389},
        {115, "s", 556},
        {116, "t", 333},
        {117, "u", 611},
        {118, "v", 556},
        {119, "w", 778},
        {120, "x", 556},
        {121, "y", 556},
        {122, "z", 500},
        {123, "braceleft", 389},
        {124, "bar", 280},
        {125, "braceright", 389},
        {126, "asciitilde", 584},
        {161, "exclamdown", 333},
        {162, "cent", 556},
        {163, "sterling", 556},
        {164, "fraction", 167},
        {165, "yen", 556},
        {166, "florin", 556},
        {167, "section", 556},
        {168, "currency", 556},
        {169, "quotesingle", 238},
        {170, "quotedblleft", 500},
        {171, "guillemotleft", 556},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 611},
        {175, "fl", 611},
        {177, "endash", 556},
        {178, "dagger", 556},
        {179, "daggerdbl", 556},
        {180, "periodcentered", 278},
        {182, "paragraph", 556},
        {183, "bullet", 350},
        {184, "quotesinglbase", 278},
        {185, "quotedblbase", 500},
        {186, "quotedblright", 500},
        {187, "guillemotright", 556},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 611},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 1000},
        {227, "ordfeminine", 370},
        {232, "Lslash", 611},
        {233, "Oslash", 778},
        {234, "OE", 1000},
        {235, "ordmasculine", 365},
        {241, "ae", 889},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 611},
        {250, "oe", 944},
        {251, "germandbls", 611},
        {-1, "Idieresis", 278},
        {-1, "eacute", 556},
        {-1, "abreve", 556},
        {-1, "uhungarumlaut", 611},
        {-1, "ecaron", 556},
        {-1, "Ydieresis", 667},
        {-1, "divide", 584},
        {-1, "Yacute", 667},
        {-1, "Acircumflex", 722},
        {-1, "aacute", 556},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 556},
        {-1, "scommaaccent", 556},
        {-1, "ecircumflex", 556},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 556},
        {-1, "Uacute", 722},
        {-1, "uogonek", 611},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 737},
        {-1, "Emacron", 667},
        {-1, "ccaron", 556},
        {-1, "aring", 556},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 278},
        {-1, "agrave", 556},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 722},
        {-1, "atilde", 556},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 556},
        {-1, "scedilla", 556},
        {-1, "iacute", 278},
        {-1, "lozenge", 494},
        {-1, "Rcaron", 722},
        {-1, "Gcommaaccent", 778},
        {-1, "ucircumflex", 611},
        {-1, "acircumflex", 556},
        {-1, "Amacron", 722},
        {-1, "rcaron", 389},
        {-1, "ccedilla", 556},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 667},
        {-1, "Omacron", 778},
        {-1, "Racute", 722},
        {-1, "Sacute", 667},
        {-1, "dcaron", 743},
        {-1, "Umacron", 722},
        {-1, "uring", 611},
        {-1, "threesuperior", 333},
        {-1, "Ograve", 778},
        {-1, "Agrave", 722},
        {-1, "Abreve", 722},
        {-1, "multiply", 584},
        {-1, "uacute", 611},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 494},
        {-1, "ydieresis", 556},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 556},
        {-1, "edieresis", 556},
        {-1, "cacute", 556},
        {-1, "nacute", 611},
        {-1, "umacron", 611},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 278},
        {-1, "plusminus", 584},
        {-1, "brokenbar", 280},
        {-1, "registered", 737},
        {-1, "Gbreve", 778},
        {-1, "Idotaccent", 278},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 389},
        {-1, "omacron", 611},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 722},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 389},
        {-1, "eogonek", 556},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 722},
        {-1, "Adieresis", 722},
        {-1, "egrave", 556},
        {-1, "zacute", 500},
        {-1, "iogonek", 278},
        {-1, "Oacute", 778},
        {-1, "oacute", 611},
        {-1, "amacron", 556},
        {-1, "sacute", 556},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 778},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 611},
        {-1, "twosuperior", 333},
        {-1, "Odieresis", 778},
        {-1, "mu", 611},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 611},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 611},
        {-1, "threequarters", 834},
        {-1, "Scedilla", 667},
        {-1, "lcaron", 400},
        {-1, "Kcommaaccent", 722},
        {-1, "Lacute", 611},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 556},
        {-1, "Igrave", 278},
        {-1, "Imacron", 278},
        {-1, "Lcaron", 611},
        {-1, "onehalf", 834},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 611},
        {-1, "ntilde", 611},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 556},
        {-1, "gbreve", 611},
        {-1, "onequarter", 834},
        {-1, "Scaron", 667},
        {-1, "Scommaaccent", 667},
        {-1, "Ohungarumlaut", 778},
        {-1, "degree", 400},
        {-1, "ograve", 611},
        {-1, "Ccaron", 722},
        {-1, "ugrave", 611},
        {-1, "radical", 549},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 389},
        {-1, "Ntilde", 722},
        {-1, "otilde", 611},
        {-1, "Rcommaaccent", 722},
        {-1, "Lcommaaccent", 611},
        {-1, "Atilde", 722},
        {-1, "Aogonek", 722},
        {-1, "Aring", 722},
        {-1, "Otilde", 778},
        {-1, "zdotaccent", 500},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 278},
        {-1, "kcommaaccent", 556},
        {-1, "minus", 584},
        {-1, "Icircumflex", 278},
        {-1, "ncaron", 611},
        {-1, "tcommaaccent", 333},
        {-1, "logicalnot", 584},
        {-1, "odieresis", 611},
        {-1, "udieresis", 611},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 611},
        {-1, "eth", 611},
        {-1, "zcaron", 500},
        {-1, "ncommaaccent", 611},
        {-1, "onesuperior", 333},
        {-1, "imacron", 278},
        {-1, "Euro", 556},
        {-1, NULL, 0}
    };
    fFontBBox.left = -170;
    fFontBBox.top = -228;
    fFontBBox.right = 1003;
    fFontBBox.bottom = 962;
    fAscent = 718;
    fDescent =-207;
    fXHeight = 532;
    fIsBase14Font = true;

    SetWidths(char_data);
}


/*---------------------------------------------------------------------------*/
/*----- HelveticaBoldOblique Font -------------------------------------------*/

PdfHelveticaBoldObliqueFontDef::PdfHelveticaBoldObliqueFontDef()
    : PdfType1FontDef("Helvetica-BoldOblique")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 278},
        {33, "exclam", 333},
        {34, "quotedbl", 474},
        {35, "numbersign", 556},
        {36, "dollar", 556},
        {37, "percent", 889},
        {38, "ampersand", 722},
        {39, "quoteright", 278},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 389},
        {43, "plus", 584},
        {44, "comma", 278},
        {45, "hyphen", 333},
        {46, "period", 278},
        {47, "slash", 278},
        {48, "zero", 556},
        {49, "one", 556},
        {50, "two", 556},
        {51, "three", 556},
        {52, "four", 556},
        {53, "five", 556},
        {54, "six", 556},
        {55, "seven", 556},
        {56, "eight", 556},
        {57, "nine", 556},
        {58, "colon", 333},
        {59, "semicolon", 333},
        {60, "less", 584},
        {61, "equal", 584},
        {62, "greater", 584},
        {63, "question", 611},
        {64, "at", 975},
        {65, "A", 722},
        {66, "B", 722},
        {67, "C", 722},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 611},
        {71, "G", 778},
        {72, "H", 722},
        {73, "I", 278},
        {74, "J", 556},
        {75, "K", 722},
        {76, "L", 611},
        {77, "M", 833},
        {78, "N", 722},
        {79, "O", 778},
        {80, "P", 667},
        {81, "Q", 778},
        {82, "R", 722},
        {83, "S", 667},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 667},
        {87, "W", 944},
        {88, "X", 667},
        {89, "Y", 667},
        {90, "Z", 611},
        {91, "bracketleft", 333},
        {92, "backslash", 278},
        {93, "bracketright", 333},
        {94, "asciicircum", 584},
        {95, "underscore", 556},
        {96, "quoteleft", 278},
        {97, "a", 556},
        {98, "b", 611},
        {99, "c", 556},
        {100, "d", 611},
        {101, "e", 556},
        {102, "f", 333},
        {103, "g", 611},
        {104, "h", 611},
        {105, "i", 278},
        {106, "j", 278},
        {107, "k", 556},
        {108, "l", 278},
        {109, "m", 889},
        {110, "n", 611},
        {111, "o", 611},
        {112, "p", 611},
        {113, "q", 611},
        {114, "r", 389},
        {115, "s", 556},
        {116, "t", 333},
        {117, "u", 611},
        {118, "v", 556},
        {119, "w", 778},
        {120, "x", 556},
        {121, "y", 556},
        {122, "z", 500},
        {123, "braceleft", 389},
        {124, "bar", 280},
        {125, "braceright", 389},
        {126, "asciitilde", 584},
        {161, "exclamdown", 333},
        {162, "cent", 556},
        {163, "sterling", 556},
        {164, "fraction", 167},
        {165, "yen", 556},
        {166, "florin", 556},
        {167, "section", 556},
        {168, "currency", 556},
        {169, "quotesingle", 238},
        {170, "quotedblleft", 500},
        {171, "guillemotleft", 556},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 611},
        {175, "fl", 611},
        {177, "endash", 556},
        {178, "dagger", 556},
        {179, "daggerdbl", 556},
        {180, "periodcentered", 278},
        {182, "paragraph", 556},
        {183, "bullet", 350},
        {184, "quotesinglbase", 278},
        {185, "quotedblbase", 500},
        {186, "quotedblright", 500},
        {187, "guillemotright", 556},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 611},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 1000},
        {227, "ordfeminine", 370},
        {232, "Lslash", 611},
        {233, "Oslash", 778},
        {234, "OE", 1000},
        {235, "ordmasculine", 365},
        {241, "ae", 889},
        {245, "dotlessi", 278},
        {248, "lslash", 278},
        {249, "oslash", 611},
        {250, "oe", 944},
        {251, "germandbls", 611},
        {-1, "Idieresis", 278},
        {-1, "eacute", 556},
        {-1, "abreve", 556},
        {-1, "uhungarumlaut", 611},
        {-1, "ecaron", 556},
        {-1, "Ydieresis", 667},
        {-1, "divide", 584},
        {-1, "Yacute", 667},
        {-1, "Acircumflex", 722},
        {-1, "aacute", 556},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 556},
        {-1, "scommaaccent", 556},
        {-1, "ecircumflex", 556},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 556},
        {-1, "Uacute", 722},
        {-1, "uogonek", 611},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 737},
        {-1, "Emacron", 667},
        {-1, "ccaron", 556},
        {-1, "aring", 556},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 278},
        {-1, "agrave", 556},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 722},
        {-1, "atilde", 556},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 556},
        {-1, "scedilla", 556},
        {-1, "iacute", 278},
        {-1, "lozenge", 494},
        {-1, "Rcaron", 722},
        {-1, "Gcommaaccent", 778},
        {-1, "ucircumflex", 611},
        {-1, "acircumflex", 556},
        {-1, "Amacron", 722},
        {-1, "rcaron", 389},
        {-1, "ccedilla", 556},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 667},
        {-1, "Omacron", 778},
        {-1, "Racute", 722},
        {-1, "Sacute", 667},
        {-1, "dcaron", 743},
        {-1, "Umacron", 722},
        {-1, "uring", 611},
        {-1, "threesuperior", 333},
        {-1, "Ograve", 778},
        {-1, "Agrave", 722},
        {-1, "Abreve", 722},
        {-1, "multiply", 584},
        {-1, "uacute", 611},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 494},
        {-1, "ydieresis", 556},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 556},
        {-1, "edieresis", 556},
        {-1, "cacute", 556},
        {-1, "nacute", 611},
        {-1, "umacron", 611},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 278},
        {-1, "plusminus", 584},
        {-1, "brokenbar", 280},
        {-1, "registered", 737},
        {-1, "Gbreve", 778},
        {-1, "Idotaccent", 278},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 389},
        {-1, "omacron", 611},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 722},
        {-1, "lcommaaccent", 278},
        {-1, "tcaron", 389},
        {-1, "eogonek", 556},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 722},
        {-1, "Adieresis", 722},
        {-1, "egrave", 556},
        {-1, "zacute", 500},
        {-1, "iogonek", 278},
        {-1, "Oacute", 778},
        {-1, "oacute", 611},
        {-1, "amacron", 556},
        {-1, "sacute", 556},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 778},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 611},
        {-1, "twosuperior", 333},
        {-1, "Odieresis", 778},
        {-1, "mu", 611},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 611},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 611},
        {-1, "threequarters", 834},
        {-1, "Scedilla", 667},
        {-1, "lcaron", 400},
        {-1, "Kcommaaccent", 722},
        {-1, "Lacute", 611},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 556},
        {-1, "Igrave", 278},
        {-1, "Imacron", 278},
        {-1, "Lcaron", 611},
        {-1, "onehalf", 834},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 611},
        {-1, "ntilde", 611},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 556},
        {-1, "gbreve", 611},
        {-1, "onequarter", 834},
        {-1, "Scaron", 667},
        {-1, "Scommaaccent", 667},
        {-1, "Ohungarumlaut", 778},
        {-1, "degree", 400},
        {-1, "ograve", 611},
        {-1, "Ccaron", 722},
        {-1, "ugrave", 611},
        {-1, "radical", 549},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 389},
        {-1, "Ntilde", 722},
        {-1, "otilde", 611},
        {-1, "Rcommaaccent", 722},
        {-1, "Lcommaaccent", 611},
        {-1, "Atilde", 722},
        {-1, "Aogonek", 722},
        {-1, "Aring", 722},
        {-1, "Otilde", 778},
        {-1, "zdotaccent", 500},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 278},
        {-1, "kcommaaccent", 556},
        {-1, "minus", 584},
        {-1, "Icircumflex", 278},
        {-1, "ncaron", 611},
        {-1, "tcommaaccent", 333},
        {-1, "logicalnot", 584},
        {-1, "odieresis", 611},
        {-1, "udieresis", 611},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 611},
        {-1, "eth", 611},
        {-1, "zcaron", 500},
        {-1, "ncommaaccent", 611},
        {-1, "onesuperior", 333},
        {-1, "imacron", 278},
        {-1, "Euro", 556},
        {-1, NULL, 0}
    };
    fFontBBox.left = -174;
    fFontBBox.top = -228;
    fFontBBox.right = 1114;
    fFontBBox.bottom = 962;
    fAscent = 718;
    fDescent =-207;
    fXHeight = 532;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- HelveticaOblique Font -----------------------------------------------*/

PdfHelveticaObliqueFontDef::PdfHelveticaObliqueFontDef()
    : PdfType1FontDef("Helvetica-Oblique")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 278},
        {33, "exclam", 278},
        {34, "quotedbl", 355},
        {35, "numbersign", 556},
        {36, "dollar", 556},
        {37, "percent", 889},
        {38, "ampersand", 667},
        {39, "quoteright", 222},
        {40, "parenleft", 333},
        {41, "parenright", 333},
        {42, "asterisk", 389},
        {43, "plus", 584},
        {44, "comma", 278},
        {45, "hyphen", 333},
        {46, "period", 278},
        {47, "slash", 278},
        {48, "zero", 556},
        {49, "one", 556},
        {50, "two", 556},
        {51, "three", 556},
        {52, "four", 556},
        {53, "five", 556},
        {54, "six", 556},
        {55, "seven", 556},
        {56, "eight", 556},
        {57, "nine", 556},
        {58, "colon", 278},
        {59, "semicolon", 278},
        {60, "less", 584},
        {61, "equal", 584},
        {62, "greater", 584},
        {63, "question", 556},
        {64, "at", 1015},
        {65, "A", 667},
        {66, "B", 667},
        {67, "C", 722},
        {68, "D", 722},
        {69, "E", 667},
        {70, "F", 611},
        {71, "G", 778},
        {72, "H", 722},
        {73, "I", 278},
        {74, "J", 500},
        {75, "K", 667},
        {76, "L", 556},
        {77, "M", 833},
        {78, "N", 722},
        {79, "O", 778},
        {80, "P", 667},
        {81, "Q", 778},
        {82, "R", 722},
        {83, "S", 667},
        {84, "T", 611},
        {85, "U", 722},
        {86, "V", 667},
        {87, "W", 944},
        {88, "X", 667},
        {89, "Y", 667},
        {90, "Z", 611},
        {91, "bracketleft", 278},
        {92, "backslash", 278},
        {93, "bracketright", 278},
        {94, "asciicircum", 469},
        {95, "underscore", 556},
        {96, "quoteleft", 222},
        {97, "a", 556},
        {98, "b", 556},
        {99, "c", 500},
        {100, "d", 556},
        {101, "e", 556},
        {102, "f", 278},
        {103, "g", 556},
        {104, "h", 556},
        {105, "i", 222},
        {106, "j", 222},
        {107, "k", 500},
        {108, "l", 222},
        {109, "m", 833},
        {110, "n", 556},
        {111, "o", 556},
        {112, "p", 556},
        {113, "q", 556},
        {114, "r", 333},
        {115, "s", 500},
        {116, "t", 278},
        {117, "u", 556},
        {118, "v", 500},
        {119, "w", 722},
        {120, "x", 500},
        {121, "y", 500},
        {122, "z", 500},
        {123, "braceleft", 334},
        {124, "bar", 260},
        {125, "braceright", 334},
        {126, "asciitilde", 584},
        {161, "exclamdown", 333},
        {162, "cent", 556},
        {163, "sterling", 556},
        {164, "fraction", 167},
        {165, "yen", 556},
        {166, "florin", 556},
        {167, "section", 556},
        {168, "currency", 556},
        {169, "quotesingle", 191},
        {170, "quotedblleft", 333},
        {171, "guillemotleft", 556},
        {172, "guilsinglleft", 333},
        {173, "guilsinglright", 333},
        {174, "fi", 500},
        {175, "fl", 500},
        {177, "endash", 556},
        {178, "dagger", 556},
        {179, "daggerdbl", 556},
        {180, "periodcentered", 278},
        {182, "paragraph", 537},
        {183, "bullet", 350},
        {184, "quotesinglbase", 222},
        {185, "quotedblbase", 333},
        {186, "quotedblright", 333},
        {187, "guillemotright", 556},
        {188, "ellipsis", 1000},
        {189, "perthousand", 1000},
        {191, "questiondown", 611},
        {193, "grave", 333},
        {194, "acute", 333},
        {195, "circumflex", 333},
        {196, "tilde", 333},
        {197, "macron", 333},
        {198, "breve", 333},
        {199, "dotaccent", 333},
        {200, "dieresis", 333},
        {202, "ring", 333},
        {203, "cedilla", 333},
        {205, "hungarumlaut", 333},
        {206, "ogonek", 333},
        {207, "caron", 333},
        {208, "emdash", 1000},
        {225, "AE", 1000},
        {227, "ordfeminine", 370},
        {232, "Lslash", 556},
        {233, "Oslash", 778},
        {234, "OE", 1000},
        {235, "ordmasculine", 365},
        {241, "ae", 889},
        {245, "dotlessi", 278},
        {248, "lslash", 222},
        {249, "oslash", 611},
        {250, "oe", 944},
        {251, "germandbls", 611},
        {-1, "Idieresis", 278},
        {-1, "eacute", 556},
        {-1, "abreve", 556},
        {-1, "uhungarumlaut", 556},
        {-1, "ecaron", 556},
        {-1, "Ydieresis", 667},
        {-1, "divide", 584},
        {-1, "Yacute", 667},
        {-1, "Acircumflex", 667},
        {-1, "aacute", 556},
        {-1, "Ucircumflex", 722},
        {-1, "yacute", 500},
        {-1, "scommaaccent", 500},
        {-1, "ecircumflex", 556},
        {-1, "Uring", 722},
        {-1, "Udieresis", 722},
        {-1, "aogonek", 556},
        {-1, "Uacute", 722},
        {-1, "uogonek", 556},
        {-1, "Edieresis", 667},
        {-1, "Dcroat", 722},
        {-1, "commaaccent", 250},
        {-1, "copyright", 737},
        {-1, "Emacron", 667},
        {-1, "ccaron", 500},
        {-1, "aring", 556},
        {-1, "Ncommaaccent", 722},
        {-1, "lacute", 222},
        {-1, "agrave", 556},
        {-1, "Tcommaaccent", 611},
        {-1, "Cacute", 722},
        {-1, "atilde", 556},
        {-1, "Edotaccent", 667},
        {-1, "scaron", 500},
        {-1, "scedilla", 500},
        {-1, "iacute", 278},
        {-1, "lozenge", 471},
        {-1, "Rcaron", 722},
        {-1, "Gcommaaccent", 778},
        {-1, "ucircumflex", 556},
        {-1, "acircumflex", 556},
        {-1, "Amacron", 667},
        {-1, "rcaron", 333},
        {-1, "ccedilla", 500},
        {-1, "Zdotaccent", 611},
        {-1, "Thorn", 667},
        {-1, "Omacron", 778},
        {-1, "Racute", 722},
        {-1, "Sacute", 667},
        {-1, "dcaron", 643},
        {-1, "Umacron", 722},
        {-1, "uring", 556},
        {-1, "threesuperior", 333},
        {-1, "Ograve", 778},
        {-1, "Agrave", 667},
        {-1, "Abreve", 667},
        {-1, "multiply", 584},
        {-1, "uacute", 556},
        {-1, "Tcaron", 611},
        {-1, "partialdiff", 476},
        {-1, "ydieresis", 500},
        {-1, "Nacute", 722},
        {-1, "icircumflex", 278},
        {-1, "Ecircumflex", 667},
        {-1, "adieresis", 556},
        {-1, "edieresis", 556},
        {-1, "cacute", 500},
        {-1, "nacute", 556},
        {-1, "umacron", 556},
        {-1, "Ncaron", 722},
        {-1, "Iacute", 278},
        {-1, "plusminus", 584},
        {-1, "brokenbar", 260},
        {-1, "registered", 737},
        {-1, "Gbreve", 778},
        {-1, "Idotaccent", 278},
        {-1, "summation", 600},
        {-1, "Egrave", 667},
        {-1, "racute", 333},
        {-1, "omacron", 556},
        {-1, "Zacute", 611},
        {-1, "Zcaron", 611},
        {-1, "greaterequal", 549},
        {-1, "Eth", 722},
        {-1, "Ccedilla", 722},
        {-1, "lcommaaccent", 222},
        {-1, "tcaron", 316},
        {-1, "eogonek", 556},
        {-1, "Uogonek", 722},
        {-1, "Aacute", 667},
        {-1, "Adieresis", 667},
        {-1, "egrave", 556},
        {-1, "zacute", 500},
        {-1, "iogonek", 222},
        {-1, "Oacute", 778},
        {-1, "oacute", 556},
        {-1, "amacron", 556},
        {-1, "sacute", 500},
        {-1, "idieresis", 278},
        {-1, "Ocircumflex", 778},
        {-1, "Ugrave", 722},
        {-1, "Delta", 612},
        {-1, "thorn", 556},
        {-1, "twosuperior", 333},
        {-1, "Odieresis", 778},
        {-1, "mu", 556},
        {-1, "igrave", 278},
        {-1, "ohungarumlaut", 556},
        {-1, "Eogonek", 667},
        {-1, "dcroat", 556},
        {-1, "threequarters", 834},
        {-1, "Scedilla", 667},
        {-1, "lcaron", 299},
        {-1, "Kcommaaccent", 667},
        {-1, "Lacute", 556},
        {-1, "trademark", 1000},
        {-1, "edotaccent", 556},
        {-1, "Igrave", 278},
        {-1, "Imacron", 278},
        {-1, "Lcaron", 556},
        {-1, "onehalf", 834},
        {-1, "lessequal", 549},
        {-1, "ocircumflex", 556},
        {-1, "ntilde", 556},
        {-1, "Uhungarumlaut", 722},
        {-1, "Eacute", 667},
        {-1, "emacron", 556},
        {-1, "gbreve", 556},
        {-1, "onequarter", 834},
        {-1, "Scaron", 667},
        {-1, "Scommaaccent", 667},
        {-1, "Ohungarumlaut", 778},
        {-1, "degree", 400},
        {-1, "ograve", 556},
        {-1, "Ccaron", 722},
        {-1, "ugrave", 556},
        {-1, "radical", 453},
        {-1, "Dcaron", 722},
        {-1, "rcommaaccent", 333},
        {-1, "Ntilde", 722},
        {-1, "otilde", 556},
        {-1, "Rcommaaccent", 722},
        {-1, "Lcommaaccent", 556},
        {-1, "Atilde", 667},
        {-1, "Aogonek", 667},
        {-1, "Aring", 667},
        {-1, "Otilde", 778},
        {-1, "zdotaccent", 500},
        {-1, "Ecaron", 667},
        {-1, "Iogonek", 278},
        {-1, "kcommaaccent", 500},
        {-1, "minus", 584},
        {-1, "Icircumflex", 278},
        {-1, "ncaron", 556},
        {-1, "tcommaaccent", 278},
        {-1, "logicalnot", 584},
        {-1, "odieresis", 556},
        {-1, "udieresis", 556},
        {-1, "notequal", 549},
        {-1, "gcommaaccent", 556},
        {-1, "eth", 556},
        {-1, "zcaron", 500},
        {-1, "ncommaaccent", 556},
        {-1, "onesuperior", 333},
        {-1, "imacron", 278},
        {-1, "Euro", 556},
        {-1, NULL, 0}
    };
    fFontBBox.left = -170;
    fFontBBox.top = -225;
    fFontBBox.right = 1116;
    fFontBBox.bottom = 931;
    fAscent = 718;
    fDescent =-207;
    fXHeight = 523;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
