/*
 * << H a r u --free pdf library >> -- PdfCMap_EUC_H.cc
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

#include "libharu_jpfonts.h"

void ParseEUCText(const char* text, pdf_byte_type* btype);

static const pdf_mb_unicode_map1 EUC_UNICODE_ARRAY[] = {
    {0x00, 0x0000},
    {0x01, 0x0001},
    {0x02, 0x0002},
    {0x03, 0x0003},
    {0x04, 0x0004},
    {0x05, 0x0005},
    {0x06, 0x0006},
    {0x07, 0x0007},
    {0x08, 0x0008},
    {0x09, 0x0009},
    {0x0A, 0x000A},
    {0x0B, 0x000B},
    {0x0C, 0x000C},
    {0x0D, 0x000D},
    {0x0E, 0x000E},
    {0x0F, 0x000F},
    {0x10, 0x0010},
    {0x11, 0x0011},
    {0x12, 0x0012},
    {0x13, 0x0013},
    {0x14, 0x0014},
    {0x15, 0x0015},
    {0x16, 0x0016},
    {0x17, 0x0017},
    {0x18, 0x0018},
    {0x19, 0x0019},
    {0x1A, 0x001A},
    {0x1B, 0x001B},
    {0x1C, 0x001C},
    {0x1D, 0x001D},
    {0x1E, 0x001E},
    {0x1F, 0x001F},
    {0x20, 0x0020},
    {0x21, 0x0021},
    {0x22, 0x0022},
    {0x23, 0x0023},
    {0x24, 0x0024},
    {0x25, 0x0025},
    {0x26, 0x0026},
    {0x27, 0x0027},
    {0x28, 0x0028},
    {0x29, 0x0029},
    {0x2A, 0x002A},
    {0x2B, 0x002B},
    {0x2C, 0x002C},
    {0x2D, 0x002D},
    {0x2E, 0x002E},
    {0x2F, 0x002F},
    {0x30, 0x0030},
    {0x31, 0x0031},
    {0x32, 0x0032},
    {0x33, 0x0033},
    {0x34, 0x0034},
    {0x35, 0x0035},
    {0x36, 0x0036},
    {0x37, 0x0037},
    {0x38, 0x0038},
    {0x39, 0x0039},
    {0x3A, 0x003A},
    {0x3B, 0x003B},
    {0x3C, 0x003C},
    {0x3D, 0x003D},
    {0x3E, 0x003E},
    {0x3F, 0x003F},
    {0x40, 0x0040},
    {0x41, 0x0041},
    {0x42, 0x0042},
    {0x43, 0x0043},
    {0x44, 0x0044},
    {0x45, 0x0045},
    {0x46, 0x0046},
    {0x47, 0x0047},
    {0x48, 0x0048},
    {0x49, 0x0049},
    {0x4A, 0x004A},
    {0x4B, 0x004B},
    {0x4C, 0x004C},
    {0x4D, 0x004D},
    {0x4E, 0x004E},
    {0x4F, 0x004F},
    {0x50, 0x0050},
    {0x51, 0x0051},
    {0x52, 0x0052},
    {0x53, 0x0053},
    {0x54, 0x0054},
    {0x55, 0x0055},
    {0x56, 0x0056},
    {0x57, 0x0057},
    {0x58, 0x0058},
    {0x59, 0x0059},
    {0x5A, 0x005A},
    {0x5B, 0x005B},
    {0x5C, 0x005C},
    {0x5D, 0x005D},
    {0x5E, 0x005E},
    {0x5F, 0x005F},
    {0x60, 0x0060},
    {0x61, 0x0061},
    {0x62, 0x0062},
    {0x63, 0x0063},
    {0x64, 0x0064},
    {0x65, 0x0065},
    {0x66, 0x0066},
    {0x67, 0x0067},
    {0x68, 0x0068},
    {0x69, 0x0069},
    {0x6A, 0x006A},
    {0x6B, 0x006B},
    {0x6C, 0x006C},
    {0x6D, 0x006D},
    {0x6E, 0x006E},
    {0x6F, 0x006F},
    {0x70, 0x0070},
    {0x71, 0x0071},
    {0x72, 0x0072},
    {0x73, 0x0073},
    {0x74, 0x0074},
    {0x75, 0x0075},
    {0x76, 0x0076},
    {0x77, 0x0077},
    {0x78, 0x0078},
    {0x79, 0x0079},
    {0x7A, 0x007A},
    {0x7B, 0x007B},
    {0x7C, 0x007C},
    {0x7D, 0x007D},
    {0x7E, 0x007E},
    {0x7F, 0x007F},
    {0x80, 0x0080},
    {0x81, 0x0081},
    {0x82, 0x0082},
    {0x83, 0x0083},
    {0x84, 0x0084},
    {0x85, 0x0085},
    {0x86, 0x0086},
    {0x87, 0x0087},
    {0x88, 0x0088},
    {0x89, 0x0089},
    {0x8A, 0x008A},
    {0x8B, 0x008B},
    {0x8C, 0x008C},
    {0x8D, 0x008D},
    {0x8E, 0x008E},
    {0x8F, 0x008F},
    {0x90, 0x0090},
    {0x91, 0x0091},
    {0x92, 0x0092},
    {0x93, 0x0093},
    {0x94, 0x0094},
    {0x95, 0x0095},
    {0x96, 0x0096},
    {0x97, 0x0097},
    {0x98, 0x0098},
    {0x99, 0x0099},
    {0x9A, 0x009A},
    {0x9B, 0x009B},
    {0x9C, 0x009C},
    {0x9D, 0x009D},
    {0x9E, 0x009E},
    {0x9F, 0x009F},
    {0xA1A1, 0x3000},
    {0xA1A2, 0x3001},
    {0xA1A3, 0x3002},
    {0xA1A4, 0xFF0C},
    {0xA1A5, 0xFF0E},
    {0xA1A6, 0x30FB},
    {0xA1A7, 0xFF1A},
    {0xA1A8, 0xFF1B},
    {0xA1A9, 0xFF1F},
    {0xA1AA, 0xFF01},
    {0xA1AB, 0x309B},
    {0xA1AC, 0x309C},
    {0xA1AD, 0x00B4},
    {0xA1AE, 0xFF40},
    {0xA1AF, 0x00A8},
    {0xA1B0, 0xFF3E},
    {0xA1B1, 0x203E},
    {0xA1B2, 0xFF3F},
    {0xA1B3, 0x30FD},
    {0xA1B4, 0x30FE},
    {0xA1B5, 0x309D},
    {0xA1B6, 0x309E},
    {0xA1B7, 0x3003},
    {0xA1B8, 0x4EDD},
    {0xA1B9, 0x3005},
    {0xA1BA, 0x3006},
    {0xA1BB, 0x3007},
    {0xA1BC, 0x30FC},
    {0xA1BD, 0x2014},
    {0xA1BE, 0x2010},
    {0xA1BF, 0xFF0F},
    {0xA1C0, 0xFF3C},
    {0xA1C1, 0x301C},
    {0xA1C2, 0x2016},
    {0xA1C3, 0xFF5C},
    {0xA1C4, 0x2026},
    {0xA1C5, 0x2025},
    {0xA1C6, 0x2018},
    {0xA1C7, 0x2019},
    {0xA1C8, 0x201C},
    {0xA1C9, 0x201D},
    {0xA1CA, 0xFF08},
    {0xA1CB, 0xFF09},
    {0xA1CC, 0x3014},
    {0xA1CD, 0x3015},
    {0xA1CE, 0xFF3B},
    {0xA1CF, 0xFF3D},
    {0xA1D0, 0xFF5B},
    {0xA1D1, 0xFF5D},
    {0xA1D2, 0x3008},
    {0xA1D3, 0x3009},
    {0xA1D4, 0x300A},
    {0xA1D5, 0x300B},
    {0xA1D6, 0x300C},
    {0xA1D7, 0x300D},
    {0xA1D8, 0x300E},
    {0xA1D9, 0x300F},
    {0xA1DA, 0x3010},
    {0xA1DB, 0x3011},
    {0xA1DC, 0xFF0B},
    {0xA1DD, 0x2212},
    {0xA1DE, 0x00B1},
    {0xA1DF, 0x00D7},
    {0xA1E0, 0x00F7},
    {0xA1E1, 0xFF1D},
    {0xA1E2, 0x2260},
    {0xA1E3, 0xFF1C},
    {0xA1E4, 0xFF1E},
    {0xA1E5, 0x2266},
    {0xA1E6, 0x2267},
    {0xA1E7, 0x221E},
    {0xA1E8, 0x2234},
    {0xA1E9, 0x2642},
    {0xA1EA, 0x2640},
    {0xA1EB, 0x00B0},
    {0xA1EC, 0x2032},
    {0xA1ED, 0x2033},
    {0xA1EE, 0x2103},
    {0xA1EF, 0x00A5},
    {0xA1F0, 0xFF04},
    {0xA1F1, 0x00A2},
    {0xA1F2, 0x00A3},
    {0xA1F3, 0xFF05},
    {0xA1F4, 0xFF03},
    {0xA1F5, 0xFF06},
    {0xA1F6, 0xFF0A},
    {0xA1F7, 0xFF20},
    {0xA1F8, 0x00A7},
    {0xA1F9, 0x2606},
    {0xA1FA, 0x2605},
    {0xA1FB, 0x25CB},
    {0xA1FC, 0x25CF},
    {0xA1FD, 0x25CE},
    {0xA1FE, 0x25C7},
    {0xA2A1, 0x25C6},
    {0xA2A2, 0x25A1},
    {0xA2A3, 0x25A0},
    {0xA2A4, 0x25B3},
    {0xA2A5, 0x25B2},
    {0xA2A6, 0x25BD},
    {0xA2A7, 0x25BC},
    {0xA2A8, 0x203B},
    {0xA2A9, 0x3012},
    {0xA2AA, 0x2192},
    {0xA2AB, 0x2190},
    {0xA2AC, 0x2191},
    {0xA2AD, 0x2193},
    {0xA2AE, 0x3013},
    {0xA2AF, 0xFF07},
    {0xA2BA, 0x2208},
    {0xA2BB, 0x220B},
    {0xA2BC, 0x2286},
    {0xA2BD, 0x2287},
    {0xA2BE, 0x2282},
    {0xA2BF, 0x2283},
    {0xA2C0, 0x222A},
    {0xA2C1, 0x2229},
    {0xA2CA, 0x2227},
    {0xA2CB, 0x2228},
    {0xA2CC, 0x00AC},
    {0xA2CD, 0x21D2},
    {0xA2CE, 0x21D4},
    {0xA2CF, 0x2200},
    {0xA2D0, 0x2203},
    {0xA2DC, 0x2220},
    {0xA2DD, 0x22A5},
    {0xA2DE, 0x2312},
    {0xA2DF, 0x2202},
    {0xA2E0, 0x2207},
    {0xA2E1, 0x2261},
    {0xA2E2, 0x2252},
    {0xA2E3, 0x226A},
    {0xA2E4, 0x226B},
    {0xA2E5, 0x221A},
    {0xA2E6, 0x223D},
    {0xA2E7, 0x221D},
    {0xA2E8, 0x2235},
    {0xA2E9, 0x222B},
    {0xA2EA, 0x222C},
    {0xA2F2, 0x212B},
    {0xA2F3, 0x2030},
    {0xA2F4, 0x266F},
    {0xA2F5, 0x266D},
    {0xA2F6, 0x266A},
    {0xA2F7, 0x2020},
    {0xA2F8, 0x2021},
    {0xA2F9, 0x00B6},
    {0xA2FE, 0x25EF},
    {0xA3B0, 0xFF10},
    {0xA3B1, 0xFF11},
    {0xA3B2, 0xFF12},
    {0xA3B3, 0xFF13},
    {0xA3B4, 0xFF14},
    {0xA3B5, 0xFF15},
    {0xA3B6, 0xFF16},
    {0xA3B7, 0xFF17},
    {0xA3B8, 0xFF18},
    {0xA3B9, 0xFF19},
    {0xA3C1, 0xFF21},
    {0xA3C2, 0xFF22},
    {0xA3C3, 0xFF23},
    {0xA3C4, 0xFF24},
    {0xA3C5, 0xFF25},
    {0xA3C6, 0xFF26},
    {0xA3C7, 0xFF27},
    {0xA3C8, 0xFF28},
    {0xA3C9, 0xFF29},
    {0xA3CA, 0xFF2A},
    {0xA3CB, 0xFF2B},
    {0xA3CC, 0xFF2C},
    {0xA3CD, 0xFF2D},
    {0xA3CE, 0xFF2E},
    {0xA3CF, 0xFF2F},
    {0xA3D0, 0xFF30},
    {0xA3D1, 0xFF31},
    {0xA3D2, 0xFF32},
    {0xA3D3, 0xFF33},
    {0xA3D4, 0xFF34},
    {0xA3D5, 0xFF35},
    {0xA3D6, 0xFF36},
    {0xA3D7, 0xFF37},
    {0xA3D8, 0xFF38},
    {0xA3D9, 0xFF39},
    {0xA3DA, 0xFF3A},
    {0xA3E1, 0xFF41},
    {0xA3E2, 0xFF42},
    {0xA3E3, 0xFF43},
    {0xA3E4, 0xFF44},
    {0xA3E5, 0xFF45},
    {0xA3E6, 0xFF46},
    {0xA3E7, 0xFF47},
    {0xA3E8, 0xFF48},
    {0xA3E9, 0xFF49},
    {0xA3EA, 0xFF4A},
    {0xA3EB, 0xFF4B},
    {0xA3EC, 0xFF4C},
    {0xA3ED, 0xFF4D},
    {0xA3EE, 0xFF4E},
    {0xA3EF, 0xFF4F},
    {0xA3F0, 0xFF50},
    {0xA3F1, 0xFF51},
    {0xA3F2, 0xFF52},
    {0xA3F3, 0xFF53},
    {0xA3F4, 0xFF54},
    {0xA3F5, 0xFF55},
    {0xA3F6, 0xFF56},
    {0xA3F7, 0xFF57},
    {0xA3F8, 0xFF58},
    {0xA3F9, 0xFF59},
    {0xA3FA, 0xFF5A},
    {0xA4A1, 0x3041},
    {0xA4A2, 0x3042},
    {0xA4A3, 0x3043},
    {0xA4A4, 0x3044},
    {0xA4A5, 0x3045},
    {0xA4A6, 0x3046},
    {0xA4A7, 0x3047},
    {0xA4A8, 0x3048},
    {0xA4A9, 0x3049},
    {0xA4AA, 0x304A},
    {0xA4AB, 0x304B},
    {0xA4AC, 0x304C},
    {0xA4AD, 0x304D},
    {0xA4AE, 0x304E},
    {0xA4AF, 0x304F},
    {0xA4B0, 0x3050},
    {0xA4B1, 0x3051},
    {0xA4B2, 0x3052},
    {0xA4B3, 0x3053},
    {0xA4B4, 0x3054},
    {0xA4B5, 0x3055},
    {0xA4B6, 0x3056},
    {0xA4B7, 0x3057},
    {0xA4B8, 0x3058},
    {0xA4B9, 0x3059},
    {0xA4BA, 0x305A},
    {0xA4BB, 0x305B},
    {0xA4BC, 0x305C},
    {0xA4BD, 0x305D},
    {0xA4BE, 0x305E},
    {0xA4BF, 0x305F},
    {0xA4C0, 0x3060},
    {0xA4C1, 0x3061},
    {0xA4C2, 0x3062},
    {0xA4C3, 0x3063},
    {0xA4C4, 0x3064},
    {0xA4C5, 0x3065},
    {0xA4C6, 0x3066},
    {0xA4C7, 0x3067},
    {0xA4C8, 0x3068},
    {0xA4C9, 0x3069},
    {0xA4CA, 0x306A},
    {0xA4CB, 0x306B},
    {0xA4CC, 0x306C},
    {0xA4CD, 0x306D},
    {0xA4CE, 0x306E},
    {0xA4CF, 0x306F},
    {0xA4D0, 0x3070},
    {0xA4D1, 0x3071},
    {0xA4D2, 0x3072},
    {0xA4D3, 0x3073},
    {0xA4D4, 0x3074},
    {0xA4D5, 0x3075},
    {0xA4D6, 0x3076},
    {0xA4D7, 0x3077},
    {0xA4D8, 0x3078},
    {0xA4D9, 0x3079},
    {0xA4DA, 0x307A},
    {0xA4DB, 0x307B},
    {0xA4DC, 0x307C},
    {0xA4DD, 0x307D},
    {0xA4DE, 0x307E},
    {0xA4DF, 0x307F},
    {0xA4E0, 0x3080},
    {0xA4E1, 0x3081},
    {0xA4E2, 0x3082},
    {0xA4E3, 0x3083},
    {0xA4E4, 0x3084},
    {0xA4E5, 0x3085},
    {0xA4E6, 0x3086},
    {0xA4E7, 0x3087},
    {0xA4E8, 0x3088},
    {0xA4E9, 0x3089},
    {0xA4EA, 0x308A},
    {0xA4EB, 0x308B},
    {0xA4EC, 0x308C},
    {0xA4ED, 0x308D},
    {0xA4EE, 0x308E},
    {0xA4EF, 0x308F},
    {0xA4F0, 0x3090},
    {0xA4F1, 0x3091},
    {0xA4F2, 0x3092},
    {0xA4F3, 0x3093},
    {0xA5A1, 0x30A1},
    {0xA5A2, 0x30A2},
    {0xA5A3, 0x30A3},
    {0xA5A4, 0x30A4},
    {0xA5A5, 0x30A5},
    {0xA5A6, 0x30A6},
    {0xA5A7, 0x30A7},
    {0xA5A8, 0x30A8},
    {0xA5A9, 0x30A9},
    {0xA5AA, 0x30AA},
    {0xA5AB, 0x30AB},
    {0xA5AC, 0x30AC},
    {0xA5AD, 0x30AD},
    {0xA5AE, 0x30AE},
    {0xA5AF, 0x30AF},
    {0xA5B0, 0x30B0},
    {0xA5B1, 0x30B1},
    {0xA5B2, 0x30B2},
    {0xA5B3, 0x30B3},
    {0xA5B4, 0x30B4},
    {0xA5B5, 0x30B5},
    {0xA5B6, 0x30B6},
    {0xA5B7, 0x30B7},
    {0xA5B8, 0x30B8},
    {0xA5B9, 0x30B9},
    {0xA5BA, 0x30BA},
    {0xA5BB, 0x30BB},
    {0xA5BC, 0x30BC},
    {0xA5BD, 0x30BD},
    {0xA5BE, 0x30BE},
    {0xA5BF, 0x30BF},
    {0xA5C0, 0x30C0},
    {0xA5C1, 0x30C1},
    {0xA5C2, 0x30C2},
    {0xA5C3, 0x30C3},
    {0xA5C4, 0x30C4},
    {0xA5C5, 0x30C5},
    {0xA5C6, 0x30C6},
    {0xA5C7, 0x30C7},
    {0xA5C8, 0x30C8},
    {0xA5C9, 0x30C9},
    {0xA5CA, 0x30CA},
    {0xA5CB, 0x30CB},
    {0xA5CC, 0x30CC},
    {0xA5CD, 0x30CD},
    {0xA5CE, 0x30CE},
    {0xA5CF, 0x30CF},
    {0xA5D0, 0x30D0},
    {0xA5D1, 0x30D1},
    {0xA5D2, 0x30D2},
    {0xA5D3, 0x30D3},
    {0xA5D4, 0x30D4},
    {0xA5D5, 0x30D5},
    {0xA5D6, 0x30D6},
    {0xA5D7, 0x30D7},
    {0xA5D8, 0x30D8},
    {0xA5D9, 0x30D9},
    {0xA5DA, 0x30DA},
    {0xA5DB, 0x30DB},
    {0xA5DC, 0x30DC},
    {0xA5DD, 0x30DD},
    {0xA5DE, 0x30DE},
    {0xA5DF, 0x30DF},
    {0xA5E0, 0x30E0},
    {0xA5E1, 0x30E1},
    {0xA5E2, 0x30E2},
    {0xA5E3, 0x30E3},
    {0xA5E4, 0x30E4},
    {0xA5E5, 0x30E5},
    {0xA5E6, 0x30E6},
    {0xA5E7, 0x30E7},
    {0xA5E8, 0x30E8},
    {0xA5E9, 0x30E9},
    {0xA5EA, 0x30EA},
    {0xA5EB, 0x30EB},
    {0xA5EC, 0x30EC},
    {0xA5ED, 0x30ED},
    {0xA5EE, 0x30EE},
    {0xA5EF, 0x30EF},
    {0xA5F0, 0x30F0},
    {0xA5F1, 0x30F1},
    {0xA5F2, 0x30F2},
    {0xA5F3, 0x30F3},
    {0xA5F4, 0x30F4},
    {0xA5F5, 0x30F5},
    {0xA5F6, 0x30F6},
    {0xA6A1, 0x0391},
    {0xA6A2, 0x0392},
    {0xA6A3, 0x0393},
    {0xA6A4, 0x0394},
    {0xA6A5, 0x0395},
    {0xA6A6, 0x0396},
    {0xA6A7, 0x0397},
    {0xA6A8, 0x0398},
    {0xA6A9, 0x0399},
    {0xA6AA, 0x039A},
    {0xA6AB, 0x039B},
    {0xA6AC, 0x039C},
    {0xA6AD, 0x039D},
    {0xA6AE, 0x039E},
    {0xA6AF, 0x039F},
    {0xA6B0, 0x03A0},
    {0xA6B1, 0x03A1},
    {0xA6B2, 0x03A3},
    {0xA6B3, 0x03A4},
    {0xA6B4, 0x03A5},
    {0xA6B5, 0x03A6},
    {0xA6B6, 0x03A7},
    {0xA6B7, 0x03A8},
    {0xA6B8, 0x03A9},
    {0xA6C1, 0x03B1},
    {0xA6C2, 0x03B2},
    {0xA6C3, 0x03B3},
    {0xA6C4, 0x03B4},
    {0xA6C5, 0x03B5},
    {0xA6C6, 0x03B6},
    {0xA6C7, 0x03B7},
    {0xA6C8, 0x03B8},
    {0xA6C9, 0x03B9},
    {0xA6CA, 0x03BA},
    {0xA6CB, 0x03BB},
    {0xA6CC, 0x03BC},
    {0xA6CD, 0x03BD},
    {0xA6CE, 0x03BE},
    {0xA6CF, 0x03BF},
    {0xA6D0, 0x03C0},
    {0xA6D1, 0x03C1},
    {0xA6D2, 0x03C3},
    {0xA6D3, 0x03C4},
    {0xA6D4, 0x03C5},
    {0xA6D5, 0x03C6},
    {0xA6D6, 0x03C7},
    {0xA6D7, 0x03C8},
    {0xA6D8, 0x03C9},
    {0xA7A1, 0x0410},
    {0xA7A2, 0x0411},
    {0xA7A3, 0x0412},
    {0xA7A4, 0x0413},
    {0xA7A5, 0x0414},
    {0xA7A6, 0x0415},
    {0xA7A7, 0x0401},
    {0xA7A8, 0x0416},
    {0xA7A9, 0x0417},
    {0xA7AA, 0x0418},
    {0xA7AB, 0x0419},
    {0xA7AC, 0x041A},
    {0xA7AD, 0x041B},
    {0xA7AE, 0x041C},
    {0xA7AF, 0x041D},
    {0xA7B0, 0x041E},
    {0xA7B1, 0x041F},
    {0xA7B2, 0x0420},
    {0xA7B3, 0x0421},
    {0xA7B4, 0x0422},
    {0xA7B5, 0x0423},
    {0xA7B6, 0x0424},
    {0xA7B7, 0x0425},
    {0xA7B8, 0x0426},
    {0xA7B9, 0x0427},
    {0xA7BA, 0x0428},
    {0xA7BB, 0x0429},
    {0xA7BC, 0x042A},
    {0xA7BD, 0x042B},
    {0xA7BE, 0x042C},
    {0xA7BF, 0x042D},
    {0xA7C0, 0x042E},
    {0xA7C1, 0x042F},
    {0xA7D1, 0x0430},
    {0xA7D2, 0x0431},
    {0xA7D3, 0x0432},
    {0xA7D4, 0x0433},
    {0xA7D5, 0x0434},
    {0xA7D6, 0x0435},
    {0xA7D7, 0x0451},
    {0xA7D8, 0x0436},
    {0xA7D9, 0x0437},
    {0xA7DA, 0x0438},
    {0xA7DB, 0x0439},
    {0xA7DC, 0x043A},
    {0xA7DD, 0x043B},
    {0xA7DE, 0x043C},
    {0xA7DF, 0x043D},
    {0xA7E0, 0x043E},
    {0xA7E1, 0x043F},
    {0xA7E2, 0x0440},
    {0xA7E3, 0x0441},
    {0xA7E4, 0x0442},
    {0xA7E5, 0x0443},
    {0xA7E6, 0x0444},
    {0xA7E7, 0x0445},
    {0xA7E8, 0x0446},
    {0xA7E9, 0x0447},
    {0xA7EA, 0x0448},
    {0xA7EB, 0x0449},
    {0xA7EC, 0x044A},
    {0xA7ED, 0x044B},
    {0xA7EE, 0x044C},
    {0xA7EF, 0x044D},
    {0xA7F0, 0x044E},
    {0xA7F1, 0x044F},
    {0xA8A1, 0x2500},
    {0xA8A2, 0x2502},
    {0xA8A3, 0x250C},
    {0xA8A4, 0x2510},
    {0xA8A5, 0x2518},
    {0xA8A6, 0x2514},
    {0xA8A7, 0x251C},
    {0xA8A8, 0x252C},
    {0xA8A9, 0x2524},
    {0xA8AA, 0x2534},
    {0xA8AB, 0x253C},
    {0xA8AC, 0x2501},
    {0xA8AD, 0x2503},
    {0xA8AE, 0x250F},
    {0xA8AF, 0x2513},
    {0xA8B0, 0x251B},
    {0xA8B1, 0x2517},
    {0xA8B2, 0x2523},
    {0xA8B3, 0x2533},
    {0xA8B4, 0x252B},
    {0xA8B5, 0x253B},
    {0xA8B6, 0x254B},
    {0xA8B7, 0x2520},
    {0xA8B8, 0x252F},
    {0xA8B9, 0x2528},
    {0xA8BA, 0x2537},
    {0xA8BB, 0x253F},
    {0xA8BC, 0x251D},
    {0xA8BD, 0x2530},
    {0xA8BE, 0x2525},
    {0xA8BF, 0x2538},
    {0xA8C0, 0x2542},
    {0xB0A1, 0x4E9C},
    {0xB0A2, 0x5516},
    {0xB0A3, 0x5A03},
    {0xB0A4, 0x963F},
    {0xB0A5, 0x54C0},
    {0xB0A6, 0x611B},
    {0xB0A7, 0x6328},
    {0xB0A8, 0x59F6},
    {0xB0A9, 0x9022},
    {0xB0AA, 0x8475},
    {0xB0AB, 0x831C},
    {0xB0AC, 0x7A50},
    {0xB0AD, 0x60AA},
    {0xB0AE, 0x63E1},
    {0xB0AF, 0x6E25},
    {0xB0B0, 0x65ED},
    {0xB0B1, 0x8466},
    {0xB0B2, 0x82A6},
    {0xB0B3, 0x9BF5},
    {0xB0B4, 0x6893},
    {0xB0B5, 0x5727},
    {0xB0B6, 0x65A1},
    {0xB0B7, 0x6271},
    {0xB0B8, 0x5B9B},
    {0xB0B9, 0x59D0},
    {0xB0BA, 0x867B},
    {0xB0BB, 0x98F4},
    {0xB0BC, 0x7D62},
    {0xB0BD, 0x7DBE},
    {0xB0BE, 0x9B8E},
    {0xB0BF, 0x6216},
    {0xB0C0, 0x7C9F},
    {0xB0C1, 0x88B7},
    {0xB0C2, 0x5B89},
    {0xB0C3, 0x5EB5},
    {0xB0C4, 0x6309},
    {0xB0C5, 0x6697},
    {0xB0C6, 0x6848},
    {0xB0C7, 0x95C7},
    {0xB0C8, 0x978D},
    {0xB0C9, 0x674F},
    {0xB0CA, 0x4EE5},
    {0xB0CB, 0x4F0A},
    {0xB0CC, 0x4F4D},
    {0xB0CD, 0x4F9D},
    {0xB0CE, 0x5049},
    {0xB0CF, 0x56F2},
    {0xB0D0, 0x5937},
    {0xB0D1, 0x59D4},
    {0xB0D2, 0x5A01},
    {0xB0D3, 0x5C09},
    {0xB0D4, 0x60DF},
    {0xB0D5, 0x610F},
    {0xB0D6, 0x6170},
    {0xB0D7, 0x6613},
    {0xB0D8, 0x6905},
    {0xB0D9, 0x70BA},
    {0xB0DA, 0x754F},
    {0xB0DB, 0x7570},
    {0xB0DC, 0x79FB},
    {0xB0DD, 0x7DAD},
    {0xB0DE, 0x7DEF},
    {0xB0DF, 0x80C3},
    {0xB0E0, 0x840E},
    {0xB0E1, 0x8863},
    {0xB0E2, 0x8B02},
    {0xB0E3, 0x9055},
    {0xB0E4, 0x907A},
    {0xB0E5, 0x533B},
    {0xB0E6, 0x4E95},
    {0xB0E7, 0x4EA5},
    {0xB0E8, 0x57DF},
    {0xB0E9, 0x80B2},
    {0xB0EA, 0x90C1},
    {0xB0EB, 0x78EF},
    {0xB0EC, 0x4E00},
    {0xB0ED, 0x58F1},
    {0xB0EE, 0x6EA2},
    {0xB0EF, 0x9038},
    {0xB0F0, 0x7A32},
    {0xB0F1, 0x8328},
    {0xB0F2, 0x828B},
    {0xB0F3, 0x9C2F},
    {0xB0F4, 0x5141},
    {0xB0F5, 0x5370},
    {0xB0F6, 0x54BD},
    {0xB0F7, 0x54E1},
    {0xB0F8, 0x56E0},
    {0xB0F9, 0x59FB},
    {0xB0FA, 0x5F15},
    {0xB0FB, 0x98F2},
    {0xB0FC, 0x6DEB},
    {0xB0FD, 0x80E4},
    {0xB0FE, 0x852D},
    {0xB1A1, 0x9662},
    {0xB1A2, 0x9670},
    {0xB1A3, 0x96A0},
    {0xB1A4, 0x97FB},
    {0xB1A5, 0x540B},
    {0xB1A6, 0x53F3},
    {0xB1A7, 0x5B87},
    {0xB1A8, 0x70CF},
    {0xB1A9, 0x7FBD},
    {0xB1AA, 0x8FC2},
    {0xB1AB, 0x96E8},
    {0xB1AC, 0x536F},
    {0xB1AD, 0x9D5C},
    {0xB1AE, 0x7ABA},
    {0xB1AF, 0x4E11},
    {0xB1B0, 0x7893},
    {0xB1B1, 0x81FC},
    {0xB1B2, 0x6E26},
    {0xB1B3, 0x5618},
    {0xB1B4, 0x5504},
    {0xB1B5, 0x6B1D},
    {0xB1B6, 0x851A},
    {0xB1B7, 0x9C3B},
    {0xB1B8, 0x59E5},
    {0xB1B9, 0x53A9},
    {0xB1BA, 0x6D66},
    {0xB1BB, 0x74DC},
    {0xB1BC, 0x958F},
    {0xB1BD, 0x5642},
    {0xB1BE, 0x4E91},
    {0xB1BF, 0x904B},
    {0xB1C0, 0x96F2},
    {0xB1C1, 0x834F},
    {0xB1C2, 0x990C},
    {0xB1C3, 0x53E1},
    {0xB1C4, 0x55B6},
    {0xB1C5, 0x5B30},
    {0xB1C6, 0x5F71},
    {0xB1C7, 0x6620},
    {0xB1C8, 0x66F3},
    {0xB1C9, 0x6804},
    {0xB1CA, 0x6C38},
    {0xB1CB, 0x6CF3},
    {0xB1CC, 0x6D29},
    {0xB1CD, 0x745B},
    {0xB1CE, 0x76C8},
    {0xB1CF, 0x7A4E},
    {0xB1D0, 0x9834},
    {0xB1D1, 0x82F1},
    {0xB1D2, 0x885B},
    {0xB1D3, 0x8A60},
    {0xB1D4, 0x92ED},
    {0xB1D5, 0x6DB2},
    {0xB1D6, 0x75AB},
    {0xB1D7, 0x76CA},
    {0xB1D8, 0x99C5},
    {0xB1D9, 0x60A6},
    {0xB1DA, 0x8B01},
    {0xB1DB, 0x8D8A},
    {0xB1DC, 0x95B2},
    {0xB1DD, 0x698E},
    {0xB1DE, 0x53AD},
    {0xB1DF, 0x5186},
    {0xB1E0, 0x5712},
    {0xB1E1, 0x5830},
    {0xB1E2, 0x5944},
    {0xB1E3, 0x5BB4},
    {0xB1E4, 0x5EF6},
    {0xB1E5, 0x6028},
    {0xB1E6, 0x63A9},
    {0xB1E7, 0x63F4},
    {0xB1E8, 0x6CBF},
    {0xB1E9, 0x6F14},
    {0xB1EA, 0x708E},
    {0xB1EB, 0x7114},
    {0xB1EC, 0x7159},
    {0xB1ED, 0x71D5},
    {0xB1EE, 0x733F},
    {0xB1EF, 0x7E01},
    {0xB1F0, 0x8276},
    {0xB1F1, 0x82D1},
    {0xB1F2, 0x8597},
    {0xB1F3, 0x9060},
    {0xB1F4, 0x925B},
    {0xB1F5, 0x9D1B},
    {0xB1F6, 0x5869},
    {0xB1F7, 0x65BC},
    {0xB1F8, 0x6C5A},
    {0xB1F9, 0x7525},
    {0xB1FA, 0x51F9},
    {0xB1FB, 0x592E},
    {0xB1FC, 0x5965},
    {0xB1FD, 0x5F80},
    {0xB1FE, 0x5FDC},
    {0xB2A1, 0x62BC},
    {0xB2A2, 0x65FA},
    {0xB2A3, 0x6A2A},
    {0xB2A4, 0x6B27},
    {0xB2A5, 0x6BB4},
    {0xB2A6, 0x738B},
    {0xB2A7, 0x7FC1},
    {0xB2A8, 0x8956},
    {0xB2A9, 0x9D2C},
    {0xB2AA, 0x9D0E},
    {0xB2AB, 0x9EC4},
    {0xB2AC, 0x5CA1},
    {0xB2AD, 0x6C96},
    {0xB2AE, 0x837B},
    {0xB2AF, 0x5104},
    {0xB2B0, 0x5C4B},
    {0xB2B1, 0x61B6},
    {0xB2B2, 0x81C6},
    {0xB2B3, 0x6876},
    {0xB2B4, 0x7261},
    {0xB2B5, 0x4E59},
    {0xB2B6, 0x4FFA},
    {0xB2B7, 0x5378},
    {0xB2B8, 0x6069},
    {0xB2B9, 0x6E29},
    {0xB2BA, 0x7A4F},
    {0xB2BB, 0x97F3},
    {0xB2BC, 0x4E0B},
    {0xB2BD, 0x5316},
    {0xB2BE, 0x4EEE},
    {0xB2BF, 0x4F55},
    {0xB2C0, 0x4F3D},
    {0xB2C1, 0x4FA1},
    {0xB2C2, 0x4F73},
    {0xB2C3, 0x52A0},
    {0xB2C4, 0x53EF},
    {0xB2C5, 0x5609},
    {0xB2C6, 0x590F},
    {0xB2C7, 0x5AC1},
    {0xB2C8, 0x5BB6},
    {0xB2C9, 0x5BE1},
    {0xB2CA, 0x79D1},
    {0xB2CB, 0x6687},
    {0xB2CC, 0x679C},
    {0xB2CD, 0x67B6},
    {0xB2CE, 0x6B4C},
    {0xB2CF, 0x6CB3},
    {0xB2D0, 0x706B},
    {0xB2D1, 0x73C2},
    {0xB2D2, 0x798D},
    {0xB2D3, 0x79BE},
    {0xB2D4, 0x7A3C},
    {0xB2D5, 0x7B87},
    {0xB2D6, 0x82B1},
    {0xB2D7, 0x82DB},
    {0xB2D8, 0x8304},
    {0xB2D9, 0x8377},
    {0xB2DA, 0x83EF},
    {0xB2DB, 0x83D3},
    {0xB2DC, 0x8766},
    {0xB2DD, 0x8AB2},
    {0xB2DE, 0x5629},
    {0xB2DF, 0x8CA8},
    {0xB2E0, 0x8FE6},
    {0xB2E1, 0x904E},
    {0xB2E2, 0x971E},
    {0xB2E3, 0x868A},
    {0xB2E4, 0x4FC4},
    {0xB2E5, 0x5CE8},
    {0xB2E6, 0x6211},
    {0xB2E7, 0x7259},
    {0xB2E8, 0x753B},
    {0xB2E9, 0x81E5},
    {0xB2EA, 0x82BD},
    {0xB2EB, 0x86FE},
    {0xB2EC, 0x8CC0},
    {0xB2ED, 0x96C5},
    {0xB2EE, 0x9913},
    {0xB2EF, 0x99D5},
    {0xB2F0, 0x4ECB},
    {0xB2F1, 0x4F1A},
    {0xB2F2, 0x89E3},
    {0xB2F3, 0x56DE},
    {0xB2F4, 0x584A},
    {0xB2F5, 0x58CA},
    {0xB2F6, 0x5EFB},
    {0xB2F7, 0x5FEB},
    {0xB2F8, 0x602A},
    {0xB2F9, 0x6094},
    {0xB2FA, 0x6062},
    {0xB2FB, 0x61D0},
    {0xB2FC, 0x6212},
    {0xB2FD, 0x62D0},
    {0xB2FE, 0x6539},
    {0xB3A1, 0x9B41},
    {0xB3A2, 0x6666},
    {0xB3A3, 0x68B0},
    {0xB3A4, 0x6D77},
    {0xB3A5, 0x7070},
    {0xB3A6, 0x754C},
    {0xB3A7, 0x7686},
    {0xB3A8, 0x7D75},
    {0xB3A9, 0x82A5},
    {0xB3AA, 0x87F9},
    {0xB3AB, 0x958B},
    {0xB3AC, 0x968E},
    {0xB3AD, 0x8C9D},
    {0xB3AE, 0x51F1},
    {0xB3AF, 0x52BE},
    {0xB3B0, 0x5916},
    {0xB3B1, 0x54B3},
    {0xB3B2, 0x5BB3},
    {0xB3B3, 0x5D16},
    {0xB3B4, 0x6168},
    {0xB3B5, 0x6982},
    {0xB3B6, 0x6DAF},
    {0xB3B7, 0x788D},
    {0xB3B8, 0x84CB},
    {0xB3B9, 0x8857},
    {0xB3BA, 0x8A72},
    {0xB3BB, 0x93A7},
    {0xB3BC, 0x9AB8},
    {0xB3BD, 0x6D6C},
    {0xB3BE, 0x99A8},
    {0xB3BF, 0x86D9},
    {0xB3C0, 0x57A3},
    {0xB3C1, 0x67FF},
    {0xB3C2, 0x86CE},
    {0xB3C3, 0x920E},
    {0xB3C4, 0x5283},
    {0xB3C5, 0x5687},
    {0xB3C6, 0x5404},
    {0xB3C7, 0x5ED3},
    {0xB3C8, 0x62E1},
    {0xB3C9, 0x64B9},
    {0xB3CA, 0x683C},
    {0xB3CB, 0x6838},
    {0xB3CC, 0x6BBB},
    {0xB3CD, 0x7372},
    {0xB3CE, 0x78BA},
    {0xB3CF, 0x7A6B},
    {0xB3D0, 0x899A},
    {0xB3D1, 0x89D2},
    {0xB3D2, 0x8D6B},
    {0xB3D3, 0x8F03},
    {0xB3D4, 0x90ED},
    {0xB3D5, 0x95A3},
    {0xB3D6, 0x9694},
    {0xB3D7, 0x9769},
    {0xB3D8, 0x5B66},
    {0xB3D9, 0x5CB3},
    {0xB3DA, 0x697D},
    {0xB3DB, 0x984D},
    {0xB3DC, 0x984E},
    {0xB3DD, 0x639B},
    {0xB3DE, 0x7B20},
    {0xB3DF, 0x6A2B},
    {0xB3E0, 0x6A7F},
    {0xB3E1, 0x68B6},
    {0xB3E2, 0x9C0D},
    {0xB3E3, 0x6F5F},
    {0xB3E4, 0x5272},
    {0xB3E5, 0x559D},
    {0xB3E6, 0x6070},
    {0xB3E7, 0x62EC},
    {0xB3E8, 0x6D3B},
    {0xB3E9, 0x6E07},
    {0xB3EA, 0x6ED1},
    {0xB3EB, 0x845B},
    {0xB3EC, 0x8910},
    {0xB3ED, 0x8F44},
    {0xB3EE, 0x4E14},
    {0xB3EF, 0x9C39},
    {0xB3F0, 0x53F6},
    {0xB3F1, 0x691B},
    {0xB3F2, 0x6A3A},
    {0xB3F3, 0x9784},
    {0xB3F4, 0x682A},
    {0xB3F5, 0x515C},
    {0xB3F6, 0x7AC3},
    {0xB3F7, 0x84B2},
    {0xB3F8, 0x91DC},
    {0xB3F9, 0x938C},
    {0xB3FA, 0x565B},
    {0xB3FB, 0x9D28},
    {0xB3FC, 0x6822},
    {0xB3FD, 0x8305},
    {0xB3FE, 0x8431},
    {0xB4A1, 0x7CA5},
    {0xB4A2, 0x5208},
    {0xB4A3, 0x82C5},
    {0xB4A4, 0x74E6},
    {0xB4A5, 0x4E7E},
    {0xB4A6, 0x4F83},
    {0xB4A7, 0x51A0},
    {0xB4A8, 0x5BD2},
    {0xB4A9, 0x520A},
    {0xB4AA, 0x52D8},
    {0xB4AB, 0x52E7},
    {0xB4AC, 0x5DFB},
    {0xB4AD, 0x559A},
    {0xB4AE, 0x582A},
    {0xB4AF, 0x59E6},
    {0xB4B0, 0x5B8C},
    {0xB4B1, 0x5B98},
    {0xB4B2, 0x5BDB},
    {0xB4B3, 0x5E72},
    {0xB4B4, 0x5E79},
    {0xB4B5, 0x60A3},
    {0xB4B6, 0x611F},
    {0xB4B7, 0x6163},
    {0xB4B8, 0x61BE},
    {0xB4B9, 0x63DB},
    {0xB4BA, 0x6562},
    {0xB4BB, 0x67D1},
    {0xB4BC, 0x6853},
    {0xB4BD, 0x68FA},
    {0xB4BE, 0x6B3E},
    {0xB4BF, 0x6B53},
    {0xB4C0, 0x6C57},
    {0xB4C1, 0x6F22},
    {0xB4C2, 0x6F97},
    {0xB4C3, 0x6F45},
    {0xB4C4, 0x74B0},
    {0xB4C5, 0x7518},
    {0xB4C6, 0x76E3},
    {0xB4C7, 0x770B},
    {0xB4C8, 0x7AFF},
    {0xB4C9, 0x7BA1},
    {0xB4CA, 0x7C21},
    {0xB4CB, 0x7DE9},
    {0xB4CC, 0x7F36},
    {0xB4CD, 0x7FF0},
    {0xB4CE, 0x809D},
    {0xB4CF, 0x8266},
    {0xB4D0, 0x839E},
    {0xB4D1, 0x89B3},
    {0xB4D2, 0x8ACC},
    {0xB4D3, 0x8CAB},
    {0xB4D4, 0x9084},
    {0xB4D5, 0x9451},
    {0xB4D6, 0x9593},
    {0xB4D7, 0x9591},
    {0xB4D8, 0x95A2},
    {0xB4D9, 0x9665},
    {0xB4DA, 0x97D3},
    {0xB4DB, 0x9928},
    {0xB4DC, 0x8218},
    {0xB4DD, 0x4E38},
    {0xB4DE, 0x542B},
    {0xB4DF, 0x5CB8},
    {0xB4E0, 0x5DCC},
    {0xB4E1, 0x73A9},
    {0xB4E2, 0x764C},
    {0xB4E3, 0x773C},
    {0xB4E4, 0x5CA9},
    {0xB4E5, 0x7FEB},
    {0xB4E6, 0x8D0B},
    {0xB4E7, 0x96C1},
    {0xB4E8, 0x9811},
    {0xB4E9, 0x9854},
    {0xB4EA, 0x9858},
    {0xB4EB, 0x4F01},
    {0xB4EC, 0x4F0E},
    {0xB4ED, 0x5371},
    {0xB4EE, 0x559C},
    {0xB4EF, 0x5668},
    {0xB4F0, 0x57FA},
    {0xB4F1, 0x5947},
    {0xB4F2, 0x5B09},
    {0xB4F3, 0x5BC4},
    {0xB4F4, 0x5C90},
    {0xB4F5, 0x5E0C},
    {0xB4F6, 0x5E7E},
    {0xB4F7, 0x5FCC},
    {0xB4F8, 0x63EE},
    {0xB4F9, 0x673A},
    {0xB4FA, 0x65D7},
    {0xB4FB, 0x65E2},
    {0xB4FC, 0x671F},
    {0xB4FD, 0x68CB},
    {0xB4FE, 0x68C4},
    {0xB5A1, 0x6A5F},
    {0xB5A2, 0x5E30},
    {0xB5A3, 0x6BC5},
    {0xB5A4, 0x6C17},
    {0xB5A5, 0x6C7D},
    {0xB5A6, 0x757F},
    {0xB5A7, 0x7948},
    {0xB5A8, 0x5B63},
    {0xB5A9, 0x7A00},
    {0xB5AA, 0x7D00},
    {0xB5AB, 0x5FBD},
    {0xB5AC, 0x898F},
    {0xB5AD, 0x8A18},
    {0xB5AE, 0x8CB4},
    {0xB5AF, 0x8D77},
    {0xB5B0, 0x8ECC},
    {0xB5B1, 0x8F1D},
    {0xB5B2, 0x98E2},
    {0xB5B3, 0x9A0E},
    {0xB5B4, 0x9B3C},
    {0xB5B5, 0x4E80},
    {0xB5B6, 0x507D},
    {0xB5B7, 0x5100},
    {0xB5B8, 0x5993},
    {0xB5B9, 0x5B9C},
    {0xB5BA, 0x622F},
    {0xB5BB, 0x6280},
    {0xB5BC, 0x64EC},
    {0xB5BD, 0x6B3A},
    {0xB5BE, 0x72A0},
    {0xB5BF, 0x7591},
    {0xB5C0, 0x7947},
    {0xB5C1, 0x7FA9},
    {0xB5C2, 0x87FB},
    {0xB5C3, 0x8ABC},
    {0xB5C4, 0x8B70},
    {0xB5C5, 0x63AC},
    {0xB5C6, 0x83CA},
    {0xB5C7, 0x97A0},
    {0xB5C8, 0x5409},
    {0xB5C9, 0x5403},
    {0xB5CA, 0x55AB},
    {0xB5CB, 0x6854},
    {0xB5CC, 0x6A58},
    {0xB5CD, 0x8A70},
    {0xB5CE, 0x7827},
    {0xB5CF, 0x6775},
    {0xB5D0, 0x9ECD},
    {0xB5D1, 0x5374},
    {0xB5D2, 0x5BA2},
    {0xB5D3, 0x811A},
    {0xB5D4, 0x8650},
    {0xB5D5, 0x9006},
    {0xB5D6, 0x4E18},
    {0xB5D7, 0x4E45},
    {0xB5D8, 0x4EC7},
    {0xB5D9, 0x4F11},
    {0xB5DA, 0x53CA},
    {0xB5DB, 0x5438},
    {0xB5DC, 0x5BAE},
    {0xB5DD, 0x5F13},
    {0xB5DE, 0x6025},
    {0xB5DF, 0x6551},
    {0xB5E0, 0x673D},
    {0xB5E1, 0x6C42},
    {0xB5E2, 0x6C72},
    {0xB5E3, 0x6CE3},
    {0xB5E4, 0x7078},
    {0xB5E5, 0x7403},
    {0xB5E6, 0x7A76},
    {0xB5E7, 0x7AAE},
    {0xB5E8, 0x7B08},
    {0xB5E9, 0x7D1A},
    {0xB5EA, 0x7CFE},
    {0xB5EB, 0x7D66},
    {0xB5EC, 0x65E7},
    {0xB5ED, 0x725B},
    {0xB5EE, 0x53BB},
    {0xB5EF, 0x5C45},
    {0xB5F0, 0x5DE8},
    {0xB5F1, 0x62D2},
    {0xB5F2, 0x62E0},
    {0xB5F3, 0x6319},
    {0xB5F4, 0x6E20},
    {0xB5F5, 0x865A},
    {0xB5F6, 0x8A31},
    {0xB5F7, 0x8DDD},
    {0xB5F8, 0x92F8},
    {0xB5F9, 0x6F01},
    {0xB5FA, 0x79A6},
    {0xB5FB, 0x9B5A},
    {0xB5FC, 0x4EA8},
    {0xB5FD, 0x4EAB},
    {0xB5FE, 0x4EAC},
    {0xB6A1, 0x4F9B},
    {0xB6A2, 0x4FA0},
    {0xB6A3, 0x50D1},
    {0xB6A4, 0x5147},
    {0xB6A5, 0x7AF6},
    {0xB6A6, 0x5171},
    {0xB6A7, 0x51F6},
    {0xB6A8, 0x5354},
    {0xB6A9, 0x5321},
    {0xB6AA, 0x537F},
    {0xB6AB, 0x53EB},
    {0xB6AC, 0x55AC},
    {0xB6AD, 0x5883},
    {0xB6AE, 0x5CE1},
    {0xB6AF, 0x5F37},
    {0xB6B0, 0x5F4A},
    {0xB6B1, 0x602F},
    {0xB6B2, 0x6050},
    {0xB6B3, 0x606D},
    {0xB6B4, 0x631F},
    {0xB6B5, 0x6559},
    {0xB6B6, 0x6A4B},
    {0xB6B7, 0x6CC1},
    {0xB6B8, 0x72C2},
    {0xB6B9, 0x72ED},
    {0xB6BA, 0x77EF},
    {0xB6BB, 0x80F8},
    {0xB6BC, 0x8105},
    {0xB6BD, 0x8208},
    {0xB6BE, 0x854E},
    {0xB6BF, 0x90F7},
    {0xB6C0, 0x93E1},
    {0xB6C1, 0x97FF},
    {0xB6C2, 0x9957},
    {0xB6C3, 0x9A5A},
    {0xB6C4, 0x4EF0},
    {0xB6C5, 0x51DD},
    {0xB6C6, 0x5C2D},
    {0xB6C7, 0x6681},
    {0xB6C8, 0x696D},
    {0xB6C9, 0x5C40},
    {0xB6CA, 0x66F2},
    {0xB6CB, 0x6975},
    {0xB6CC, 0x7389},
    {0xB6CD, 0x6850},
    {0xB6CE, 0x7C81},
    {0xB6CF, 0x50C5},
    {0xB6D0, 0x52E4},
    {0xB6D1, 0x5747},
    {0xB6D2, 0x5DFE},
    {0xB6D3, 0x9326},
    {0xB6D4, 0x65A4},
    {0xB6D5, 0x6B23},
    {0xB6D6, 0x6B3D},
    {0xB6D7, 0x7434},
    {0xB6D8, 0x7981},
    {0xB6D9, 0x79BD},
    {0xB6DA, 0x7B4B},
    {0xB6DB, 0x7DCA},
    {0xB6DC, 0x82B9},
    {0xB6DD, 0x83CC},
    {0xB6DE, 0x887F},
    {0xB6DF, 0x895F},
    {0xB6E0, 0x8B39},
    {0xB6E1, 0x8FD1},
    {0xB6E2, 0x91D1},
    {0xB6E3, 0x541F},
    {0xB6E4, 0x9280},
    {0xB6E5, 0x4E5D},
    {0xB6E6, 0x5036},
    {0xB6E7, 0x53E5},
    {0xB6E8, 0x533A},
    {0xB6E9, 0x72D7},
    {0xB6EA, 0x7396},
    {0xB6EB, 0x77E9},
    {0xB6EC, 0x82E6},
    {0xB6ED, 0x8EAF},
    {0xB6EE, 0x99C6},
    {0xB6EF, 0x99C8},
    {0xB6F0, 0x99D2},
    {0xB6F1, 0x5177},
    {0xB6F2, 0x611A},
    {0xB6F3, 0x865E},
    {0xB6F4, 0x55B0},
    {0xB6F5, 0x7A7A},
    {0xB6F6, 0x5076},
    {0xB6F7, 0x5BD3},
    {0xB6F8, 0x9047},
    {0xB6F9, 0x9685},
    {0xB6FA, 0x4E32},
    {0xB6FB, 0x6ADB},
    {0xB6FC, 0x91E7},
    {0xB6FD, 0x5C51},
    {0xB6FE, 0x5C48},
    {0xB7A1, 0x6398},
    {0xB7A2, 0x7A9F},
    {0xB7A3, 0x6C93},
    {0xB7A4, 0x9774},
    {0xB7A5, 0x8F61},
    {0xB7A6, 0x7AAA},
    {0xB7A7, 0x718A},
    {0xB7A8, 0x9688},
    {0xB7A9, 0x7C82},
    {0xB7AA, 0x6817},
    {0xB7AB, 0x7E70},
    {0xB7AC, 0x6851},
    {0xB7AD, 0x936C},
    {0xB7AE, 0x52F2},
    {0xB7AF, 0x541B},
    {0xB7B0, 0x85AB},
    {0xB7B1, 0x8A13},
    {0xB7B2, 0x7FA4},
    {0xB7B3, 0x8ECD},
    {0xB7B4, 0x90E1},
    {0xB7B5, 0x5366},
    {0xB7B6, 0x8888},
    {0xB7B7, 0x7941},
    {0xB7B8, 0x4FC2},
    {0xB7B9, 0x50BE},
    {0xB7BA, 0x5211},
    {0xB7BB, 0x5144},
    {0xB7BC, 0x5553},
    {0xB7BD, 0x572D},
    {0xB7BE, 0x73EA},
    {0xB7BF, 0x578B},
    {0xB7C0, 0x5951},
    {0xB7C1, 0x5F62},
    {0xB7C2, 0x5F84},
    {0xB7C3, 0x6075},
    {0xB7C4, 0x6176},
    {0xB7C5, 0x6167},
    {0xB7C6, 0x61A9},
    {0xB7C7, 0x63B2},
    {0xB7C8, 0x643A},
    {0xB7C9, 0x656C},
    {0xB7CA, 0x666F},
    {0xB7CB, 0x6842},
    {0xB7CC, 0x6E13},
    {0xB7CD, 0x7566},
    {0xB7CE, 0x7A3D},
    {0xB7CF, 0x7CFB},
    {0xB7D0, 0x7D4C},
    {0xB7D1, 0x7D99},
    {0xB7D2, 0x7E4B},
    {0xB7D3, 0x7F6B},
    {0xB7D4, 0x830E},
    {0xB7D5, 0x834A},
    {0xB7D6, 0x86CD},
    {0xB7D7, 0x8A08},
    {0xB7D8, 0x8A63},
    {0xB7D9, 0x8B66},
    {0xB7DA, 0x8EFD},
    {0xB7DB, 0x981A},
    {0xB7DC, 0x9D8F},
    {0xB7DD, 0x82B8},
    {0xB7DE, 0x8FCE},
    {0xB7DF, 0x9BE8},
    {0xB7E0, 0x5287},
    {0xB7E1, 0x621F},
    {0xB7E2, 0x6483},
    {0xB7E3, 0x6FC0},
    {0xB7E4, 0x9699},
    {0xB7E5, 0x6841},
    {0xB7E6, 0x5091},
    {0xB7E7, 0x6B20},
    {0xB7E8, 0x6C7A},
    {0xB7E9, 0x6F54},
    {0xB7EA, 0x7A74},
    {0xB7EB, 0x7D50},
    {0xB7EC, 0x8840},
    {0xB7ED, 0x8A23},
    {0xB7EE, 0x6708},
    {0xB7EF, 0x4EF6},
    {0xB7F0, 0x5039},
    {0xB7F1, 0x5026},
    {0xB7F2, 0x5065},
    {0xB7F3, 0x517C},
    {0xB7F4, 0x5238},
    {0xB7F5, 0x5263},
    {0xB7F6, 0x55A7},
    {0xB7F7, 0x570F},
    {0xB7F8, 0x5805},
    {0xB7F9, 0x5ACC},
    {0xB7FA, 0x5EFA},
    {0xB7FB, 0x61B2},
    {0xB7FC, 0x61F8},
    {0xB7FD, 0x62F3},
    {0xB7FE, 0x6372},
    {0xB8A1, 0x691C},
    {0xB8A2, 0x6A29},
    {0xB8A3, 0x727D},
    {0xB8A4, 0x72AC},
    {0xB8A5, 0x732E},
    {0xB8A6, 0x7814},
    {0xB8A7, 0x786F},
    {0xB8A8, 0x7D79},
    {0xB8A9, 0x770C},
    {0xB8AA, 0x80A9},
    {0xB8AB, 0x898B},
    {0xB8AC, 0x8B19},
    {0xB8AD, 0x8CE2},
    {0xB8AE, 0x8ED2},
    {0xB8AF, 0x9063},
    {0xB8B0, 0x9375},
    {0xB8B1, 0x967A},
    {0xB8B2, 0x9855},
    {0xB8B3, 0x9A13},
    {0xB8B4, 0x9E78},
    {0xB8B5, 0x5143},
    {0xB8B6, 0x539F},
    {0xB8B7, 0x53B3},
    {0xB8B8, 0x5E7B},
    {0xB8B9, 0x5F26},
    {0xB8BA, 0x6E1B},
    {0xB8BB, 0x6E90},
    {0xB8BC, 0x7384},
    {0xB8BD, 0x73FE},
    {0xB8BE, 0x7D43},
    {0xB8BF, 0x8237},
    {0xB8C0, 0x8A00},
    {0xB8C1, 0x8AFA},
    {0xB8C2, 0x9650},
    {0xB8C3, 0x4E4E},
    {0xB8C4, 0x500B},
    {0xB8C5, 0x53E4},
    {0xB8C6, 0x547C},
    {0xB8C7, 0x56FA},
    {0xB8C8, 0x59D1},
    {0xB8C9, 0x5B64},
    {0xB8CA, 0x5DF1},
    {0xB8CB, 0x5EAB},
    {0xB8CC, 0x5F27},
    {0xB8CD, 0x6238},
    {0xB8CE, 0x6545},
    {0xB8CF, 0x67AF},
    {0xB8D0, 0x6E56},
    {0xB8D1, 0x72D0},
    {0xB8D2, 0x7CCA},
    {0xB8D3, 0x88B4},
    {0xB8D4, 0x80A1},
    {0xB8D5, 0x80E1},
    {0xB8D6, 0x83F0},
    {0xB8D7, 0x864E},
    {0xB8D8, 0x8A87},
    {0xB8D9, 0x8DE8},
    {0xB8DA, 0x9237},
    {0xB8DB, 0x96C7},
    {0xB8DC, 0x9867},
    {0xB8DD, 0x9F13},
    {0xB8DE, 0x4E94},
    {0xB8DF, 0x4E92},
    {0xB8E0, 0x4F0D},
    {0xB8E1, 0x5348},
    {0xB8E2, 0x5449},
    {0xB8E3, 0x543E},
    {0xB8E4, 0x5A2F},
    {0xB8E5, 0x5F8C},
    {0xB8E6, 0x5FA1},
    {0xB8E7, 0x609F},
    {0xB8E8, 0x68A7},
    {0xB8E9, 0x6A8E},
    {0xB8EA, 0x745A},
    {0xB8EB, 0x7881},
    {0xB8EC, 0x8A9E},
    {0xB8ED, 0x8AA4},
    {0xB8EE, 0x8B77},
    {0xB8EF, 0x9190},
    {0xB8F0, 0x4E5E},
    {0xB8F1, 0x9BC9},
    {0xB8F2, 0x4EA4},
    {0xB8F3, 0x4F7C},
    {0xB8F4, 0x4FAF},
    {0xB8F5, 0x5019},
    {0xB8F6, 0x5016},
    {0xB8F7, 0x5149},
    {0xB8F8, 0x516C},
    {0xB8F9, 0x529F},
    {0xB8FA, 0x52B9},
    {0xB8FB, 0x52FE},
    {0xB8FC, 0x539A},
    {0xB8FD, 0x53E3},
    {0xB8FE, 0x5411},
    {0xB9A1, 0x540E},
    {0xB9A2, 0x5589},
    {0xB9A3, 0x5751},
    {0xB9A4, 0x57A2},
    {0xB9A5, 0x597D},
    {0xB9A6, 0x5B54},
    {0xB9A7, 0x5B5D},
    {0xB9A8, 0x5B8F},
    {0xB9A9, 0x5DE5},
    {0xB9AA, 0x5DE7},
    {0xB9AB, 0x5DF7},
    {0xB9AC, 0x5E78},
    {0xB9AD, 0x5E83},
    {0xB9AE, 0x5E9A},
    {0xB9AF, 0x5EB7},
    {0xB9B0, 0x5F18},
    {0xB9B1, 0x6052},
    {0xB9B2, 0x614C},
    {0xB9B3, 0x6297},
    {0xB9B4, 0x62D8},
    {0xB9B5, 0x63A7},
    {0xB9B6, 0x653B},
    {0xB9B7, 0x6602},
    {0xB9B8, 0x6643},
    {0xB9B9, 0x66F4},
    {0xB9BA, 0x676D},
    {0xB9BB, 0x6821},
    {0xB9BC, 0x6897},
    {0xB9BD, 0x69CB},
    {0xB9BE, 0x6C5F},
    {0xB9BF, 0x6D2A},
    {0xB9C0, 0x6D69},
    {0xB9C1, 0x6E2F},
    {0xB9C2, 0x6E9D},
    {0xB9C3, 0x7532},
    {0xB9C4, 0x7687},
    {0xB9C5, 0x786C},
    {0xB9C6, 0x7A3F},
    {0xB9C7, 0x7CE0},
    {0xB9C8, 0x7D05},
    {0xB9C9, 0x7D18},
    {0xB9CA, 0x7D5E},
    {0xB9CB, 0x7DB1},
    {0xB9CC, 0x8015},
    {0xB9CD, 0x8003},
    {0xB9CE, 0x80AF},
    {0xB9CF, 0x80B1},
    {0xB9D0, 0x8154},
    {0xB9D1, 0x818F},
    {0xB9D2, 0x822A},
    {0xB9D3, 0x8352},
    {0xB9D4, 0x884C},
    {0xB9D5, 0x8861},
    {0xB9D6, 0x8B1B},
    {0xB9D7, 0x8CA2},
    {0xB9D8, 0x8CFC},
    {0xB9D9, 0x90CA},
    {0xB9DA, 0x9175},
    {0xB9DB, 0x9271},
    {0xB9DC, 0x783F},
    {0xB9DD, 0x92FC},
    {0xB9DE, 0x95A4},
    {0xB9DF, 0x964D},
    {0xB9E0, 0x9805},
    {0xB9E1, 0x9999},
    {0xB9E2, 0x9AD8},
    {0xB9E3, 0x9D3B},
    {0xB9E4, 0x525B},
    {0xB9E5, 0x52AB},
    {0xB9E6, 0x53F7},
    {0xB9E7, 0x5408},
    {0xB9E8, 0x58D5},
    {0xB9E9, 0x62F7},
    {0xB9EA, 0x6FE0},
    {0xB9EB, 0x8C6A},
    {0xB9EC, 0x8F5F},
    {0xB9ED, 0x9EB9},
    {0xB9EE, 0x514B},
    {0xB9EF, 0x523B},
    {0xB9F0, 0x544A},
    {0xB9F1, 0x56FD},
    {0xB9F2, 0x7A40},
    {0xB9F3, 0x9177},
    {0xB9F4, 0x9D60},
    {0xB9F5, 0x9ED2},
    {0xB9F6, 0x7344},
    {0xB9F7, 0x6F09},
    {0xB9F8, 0x8170},
    {0xB9F9, 0x7511},
    {0xB9FA, 0x5FFD},
    {0xB9FB, 0x60DA},
    {0xB9FC, 0x9AA8},
    {0xB9FD, 0x72DB},
    {0xB9FE, 0x8FBC},
    {0xBAA1, 0x6B64},
    {0xBAA2, 0x9803},
    {0xBAA3, 0x4ECA},
    {0xBAA4, 0x56F0},
    {0xBAA5, 0x5764},
    {0xBAA6, 0x58BE},
    {0xBAA7, 0x5A5A},
    {0xBAA8, 0x6068},
    {0xBAA9, 0x61C7},
    {0xBAAA, 0x660F},
    {0xBAAB, 0x6606},
    {0xBAAC, 0x6839},
    {0xBAAD, 0x68B1},
    {0xBAAE, 0x6DF7},
    {0xBAAF, 0x75D5},
    {0xBAB0, 0x7D3A},
    {0xBAB1, 0x826E},
    {0xBAB2, 0x9B42},
    {0xBAB3, 0x4E9B},
    {0xBAB4, 0x4F50},
    {0xBAB5, 0x53C9},
    {0xBAB6, 0x5506},
    {0xBAB7, 0x5D6F},
    {0xBAB8, 0x5DE6},
    {0xBAB9, 0x5DEE},
    {0xBABA, 0x67FB},
    {0xBABB, 0x6C99},
    {0xBABC, 0x7473},
    {0xBABD, 0x7802},
    {0xBABE, 0x8A50},
    {0xBABF, 0x9396},
    {0xBAC0, 0x88DF},
    {0xBAC1, 0x5750},
    {0xBAC2, 0x5EA7},
    {0xBAC3, 0x632B},
    {0xBAC4, 0x50B5},
    {0xBAC5, 0x50AC},
    {0xBAC6, 0x518D},
    {0xBAC7, 0x6700},
    {0xBAC8, 0x54C9},
    {0xBAC9, 0x585E},
    {0xBACA, 0x59BB},
    {0xBACB, 0x5BB0},
    {0xBACC, 0x5F69},
    {0xBACD, 0x624D},
    {0xBACE, 0x63A1},
    {0xBACF, 0x683D},
    {0xBAD0, 0x6B73},
    {0xBAD1, 0x6E08},
    {0xBAD2, 0x707D},
    {0xBAD3, 0x91C7},
    {0xBAD4, 0x7280},
    {0xBAD5, 0x7815},
    {0xBAD6, 0x7826},
    {0xBAD7, 0x796D},
    {0xBAD8, 0x658E},
    {0xBAD9, 0x7D30},
    {0xBADA, 0x83DC},
    {0xBADB, 0x88C1},
    {0xBADC, 0x8F09},
    {0xBADD, 0x969B},
    {0xBADE, 0x5264},
    {0xBADF, 0x5728},
    {0xBAE0, 0x6750},
    {0xBAE1, 0x7F6A},
    {0xBAE2, 0x8CA1},
    {0xBAE3, 0x51B4},
    {0xBAE4, 0x5742},
    {0xBAE5, 0x962A},
    {0xBAE6, 0x583A},
    {0xBAE7, 0x698A},
    {0xBAE8, 0x80B4},
    {0xBAE9, 0x54B2},
    {0xBAEA, 0x5D0E},
    {0xBAEB, 0x57FC},
    {0xBAEC, 0x7895},
    {0xBAED, 0x9DFA},
    {0xBAEE, 0x4F5C},
    {0xBAEF, 0x524A},
    {0xBAF0, 0x548B},
    {0xBAF1, 0x643E},
    {0xBAF2, 0x6628},
    {0xBAF3, 0x6714},
    {0xBAF4, 0x67F5},
    {0xBAF5, 0x7A84},
    {0xBAF6, 0x7B56},
    {0xBAF7, 0x7D22},
    {0xBAF8, 0x932F},
    {0xBAF9, 0x685C},
    {0xBAFA, 0x9BAD},
    {0xBAFB, 0x7B39},
    {0xBAFC, 0x5319},
    {0xBAFD, 0x518A},
    {0xBAFE, 0x5237},
    {0xBBA1, 0x5BDF},
    {0xBBA2, 0x62F6},
    {0xBBA3, 0x64AE},
    {0xBBA4, 0x64E6},
    {0xBBA5, 0x672D},
    {0xBBA6, 0x6BBA},
    {0xBBA7, 0x85A9},
    {0xBBA8, 0x96D1},
    {0xBBA9, 0x7690},
    {0xBBAA, 0x9BD6},
    {0xBBAB, 0x634C},
    {0xBBAC, 0x9306},
    {0xBBAD, 0x9BAB},
    {0xBBAE, 0x76BF},
    {0xBBAF, 0x6652},
    {0xBBB0, 0x4E09},
    {0xBBB1, 0x5098},
    {0xBBB2, 0x53C2},
    {0xBBB3, 0x5C71},
    {0xBBB4, 0x60E8},
    {0xBBB5, 0x6492},
    {0xBBB6, 0x6563},
    {0xBBB7, 0x685F},
    {0xBBB8, 0x71E6},
    {0xBBB9, 0x73CA},
    {0xBBBA, 0x7523},
    {0xBBBB, 0x7B97},
    {0xBBBC, 0x7E82},
    {0xBBBD, 0x8695},
    {0xBBBE, 0x8B83},
    {0xBBBF, 0x8CDB},
    {0xBBC0, 0x9178},
    {0xBBC1, 0x9910},
    {0xBBC2, 0x65AC},
    {0xBBC3, 0x66AB},
    {0xBBC4, 0x6B8B},
    {0xBBC5, 0x4ED5},
    {0xBBC6, 0x4ED4},
    {0xBBC7, 0x4F3A},
    {0xBBC8, 0x4F7F},
    {0xBBC9, 0x523A},
    {0xBBCA, 0x53F8},
    {0xBBCB, 0x53F2},
    {0xBBCC, 0x55E3},
    {0xBBCD, 0x56DB},
    {0xBBCE, 0x58EB},
    {0xBBCF, 0x59CB},
    {0xBBD0, 0x59C9},
    {0xBBD1, 0x59FF},
    {0xBBD2, 0x5B50},
    {0xBBD3, 0x5C4D},
    {0xBBD4, 0x5E02},
    {0xBBD5, 0x5E2B},
    {0xBBD6, 0x5FD7},
    {0xBBD7, 0x601D},
    {0xBBD8, 0x6307},
    {0xBBD9, 0x652F},
    {0xBBDA, 0x5B5C},
    {0xBBDB, 0x65AF},
    {0xBBDC, 0x65BD},
    {0xBBDD, 0x65E8},
    {0xBBDE, 0x679D},
    {0xBBDF, 0x6B62},
    {0xBBE0, 0x6B7B},
    {0xBBE1, 0x6C0F},
    {0xBBE2, 0x7345},
    {0xBBE3, 0x7949},
    {0xBBE4, 0x79C1},
    {0xBBE5, 0x7CF8},
    {0xBBE6, 0x7D19},
    {0xBBE7, 0x7D2B},
    {0xBBE8, 0x80A2},
    {0xBBE9, 0x8102},
    {0xBBEA, 0x81F3},
    {0xBBEB, 0x8996},
    {0xBBEC, 0x8A5E},
    {0xBBED, 0x8A69},
    {0xBBEE, 0x8A66},
    {0xBBEF, 0x8A8C},
    {0xBBF0, 0x8AEE},
    {0xBBF1, 0x8CC7},
    {0xBBF2, 0x8CDC},
    {0xBBF3, 0x96CC},
    {0xBBF4, 0x98FC},
    {0xBBF5, 0x6B6F},
    {0xBBF6, 0x4E8B},
    {0xBBF7, 0x4F3C},
    {0xBBF8, 0x4F8D},
    {0xBBF9, 0x5150},
    {0xBBFA, 0x5B57},
    {0xBBFB, 0x5BFA},
    {0xBBFC, 0x6148},
    {0xBBFD, 0x6301},
    {0xBBFE, 0x6642},
    {0xBCA1, 0x6B21},
    {0xBCA2, 0x6ECB},
    {0xBCA3, 0x6CBB},
    {0xBCA4, 0x723E},
    {0xBCA5, 0x74BD},
    {0xBCA6, 0x75D4},
    {0xBCA7, 0x78C1},
    {0xBCA8, 0x793A},
    {0xBCA9, 0x800C},
    {0xBCAA, 0x8033},
    {0xBCAB, 0x81EA},
    {0xBCAC, 0x8494},
    {0xBCAD, 0x8F9E},
    {0xBCAE, 0x6C50},
    {0xBCAF, 0x9E7F},
    {0xBCB0, 0x5F0F},
    {0xBCB1, 0x8B58},
    {0xBCB2, 0x9D2B},
    {0xBCB3, 0x7AFA},
    {0xBCB4, 0x8EF8},
    {0xBCB5, 0x5B8D},
    {0xBCB6, 0x96EB},
    {0xBCB7, 0x4E03},
    {0xBCB8, 0x53F1},
    {0xBCB9, 0x57F7},
    {0xBCBA, 0x5931},
    {0xBCBB, 0x5AC9},
    {0xBCBC, 0x5BA4},
    {0xBCBD, 0x6089},
    {0xBCBE, 0x6E7F},
    {0xBCBF, 0x6F06},
    {0xBCC0, 0x75BE},
    {0xBCC1, 0x8CEA},
    {0xBCC2, 0x5B9F},
    {0xBCC3, 0x8500},
    {0xBCC4, 0x7BE0},
    {0xBCC5, 0x5072},
    {0xBCC6, 0x67F4},
    {0xBCC7, 0x829D},
    {0xBCC8, 0x5C61},
    {0xBCC9, 0x854A},
    {0xBCCA, 0x7E1E},
    {0xBCCB, 0x820E},
    {0xBCCC, 0x5199},
    {0xBCCD, 0x5C04},
    {0xBCCE, 0x6368},
    {0xBCCF, 0x8D66},
    {0xBCD0, 0x659C},
    {0xBCD1, 0x716E},
    {0xBCD2, 0x793E},
    {0xBCD3, 0x7D17},
    {0xBCD4, 0x8005},
    {0xBCD5, 0x8B1D},
    {0xBCD6, 0x8ECA},
    {0xBCD7, 0x906E},
    {0xBCD8, 0x86C7},
    {0xBCD9, 0x90AA},
    {0xBCDA, 0x501F},
    {0xBCDB, 0x52FA},
    {0xBCDC, 0x5C3A},
    {0xBCDD, 0x6753},
    {0xBCDE, 0x707C},
    {0xBCDF, 0x7235},
    {0xBCE0, 0x914C},
    {0xBCE1, 0x91C8},
    {0xBCE2, 0x932B},
    {0xBCE3, 0x82E5},
    {0xBCE4, 0x5BC2},
    {0xBCE5, 0x5F31},
    {0xBCE6, 0x60F9},
    {0xBCE7, 0x4E3B},
    {0xBCE8, 0x53D6},
    {0xBCE9, 0x5B88},
    {0xBCEA, 0x624B},
    {0xBCEB, 0x6731},
    {0xBCEC, 0x6B8A},
    {0xBCED, 0x72E9},
    {0xBCEE, 0x73E0},
    {0xBCEF, 0x7A2E},
    {0xBCF0, 0x816B},
    {0xBCF1, 0x8DA3},
    {0xBCF2, 0x9152},
    {0xBCF3, 0x9996},
    {0xBCF4, 0x5112},
    {0xBCF5, 0x53D7},
    {0xBCF6, 0x546A},
    {0xBCF7, 0x5BFF},
    {0xBCF8, 0x6388},
    {0xBCF9, 0x6A39},
    {0xBCFA, 0x7DAC},
    {0xBCFB, 0x9700},
    {0xBCFC, 0x56DA},
    {0xBCFD, 0x53CE},
    {0xBCFE, 0x5468},
    {0xBDA1, 0x5B97},
    {0xBDA2, 0x5C31},
    {0xBDA3, 0x5DDE},
    {0xBDA4, 0x4FEE},
    {0xBDA5, 0x6101},
    {0xBDA6, 0x62FE},
    {0xBDA7, 0x6D32},
    {0xBDA8, 0x79C0},
    {0xBDA9, 0x79CB},
    {0xBDAA, 0x7D42},
    {0xBDAB, 0x7E4D},
    {0xBDAC, 0x7FD2},
    {0xBDAD, 0x81ED},
    {0xBDAE, 0x821F},
    {0xBDAF, 0x8490},
    {0xBDB0, 0x8846},
    {0xBDB1, 0x8972},
    {0xBDB2, 0x8B90},
    {0xBDB3, 0x8E74},
    {0xBDB4, 0x8F2F},
    {0xBDB5, 0x9031},
    {0xBDB6, 0x914B},
    {0xBDB7, 0x916C},
    {0xBDB8, 0x96C6},
    {0xBDB9, 0x919C},
    {0xBDBA, 0x4EC0},
    {0xBDBB, 0x4F4F},
    {0xBDBC, 0x5145},
    {0xBDBD, 0x5341},
    {0xBDBE, 0x5F93},
    {0xBDBF, 0x620E},
    {0xBDC0, 0x67D4},
    {0xBDC1, 0x6C41},
    {0xBDC2, 0x6E0B},
    {0xBDC3, 0x7363},
    {0xBDC4, 0x7E26},
    {0xBDC5, 0x91CD},
    {0xBDC6, 0x9283},
    {0xBDC7, 0x53D4},
    {0xBDC8, 0x5919},
    {0xBDC9, 0x5BBF},
    {0xBDCA, 0x6DD1},
    {0xBDCB, 0x795D},
    {0xBDCC, 0x7E2E},
    {0xBDCD, 0x7C9B},
    {0xBDCE, 0x587E},
    {0xBDCF, 0x719F},
    {0xBDD0, 0x51FA},
    {0xBDD1, 0x8853},
    {0xBDD2, 0x8FF0},
    {0xBDD3, 0x4FCA},
    {0xBDD4, 0x5CFB},
    {0xBDD5, 0x6625},
    {0xBDD6, 0x77AC},
    {0xBDD7, 0x7AE3},
    {0xBDD8, 0x821C},
    {0xBDD9, 0x99FF},
    {0xBDDA, 0x51C6},
    {0xBDDB, 0x5FAA},
    {0xBDDC, 0x65EC},
    {0xBDDD, 0x696F},
    {0xBDDE, 0x6B89},
    {0xBDDF, 0x6DF3},
    {0xBDE0, 0x6E96},
    {0xBDE1, 0x6F64},
    {0xBDE2, 0x76FE},
    {0xBDE3, 0x7D14},
    {0xBDE4, 0x5DE1},
    {0xBDE5, 0x9075},
    {0xBDE6, 0x9187},
    {0xBDE7, 0x9806},
    {0xBDE8, 0x51E6},
    {0xBDE9, 0x521D},
    {0xBDEA, 0x6240},
    {0xBDEB, 0x6691},
    {0xBDEC, 0x66D9},
    {0xBDED, 0x6E1A},
    {0xBDEE, 0x5EB6},
    {0xBDEF, 0x7DD2},
    {0xBDF0, 0x7F72},
    {0xBDF1, 0x66F8},
    {0xBDF2, 0x85AF},
    {0xBDF3, 0x85F7},
    {0xBDF4, 0x8AF8},
    {0xBDF5, 0x52A9},
    {0xBDF6, 0x53D9},
    {0xBDF7, 0x5973},
    {0xBDF8, 0x5E8F},
    {0xBDF9, 0x5F90},
    {0xBDFA, 0x6055},
    {0xBDFB, 0x92E4},
    {0xBDFC, 0x9664},
    {0xBDFD, 0x50B7},
    {0xBDFE, 0x511F},
    {0xBEA1, 0x52DD},
    {0xBEA2, 0x5320},
    {0xBEA3, 0x5347},
    {0xBEA4, 0x53EC},
    {0xBEA5, 0x54E8},
    {0xBEA6, 0x5546},
    {0xBEA7, 0x5531},
    {0xBEA8, 0x5617},
    {0xBEA9, 0x5968},
    {0xBEAA, 0x59BE},
    {0xBEAB, 0x5A3C},
    {0xBEAC, 0x5BB5},
    {0xBEAD, 0x5C06},
    {0xBEAE, 0x5C0F},
    {0xBEAF, 0x5C11},
    {0xBEB0, 0x5C1A},
    {0xBEB1, 0x5E84},
    {0xBEB2, 0x5E8A},
    {0xBEB3, 0x5EE0},
    {0xBEB4, 0x5F70},
    {0xBEB5, 0x627F},
    {0xBEB6, 0x6284},
    {0xBEB7, 0x62DB},
    {0xBEB8, 0x638C},
    {0xBEB9, 0x6377},
    {0xBEBA, 0x6607},
    {0xBEBB, 0x660C},
    {0xBEBC, 0x662D},
    {0xBEBD, 0x6676},
    {0xBEBE, 0x677E},
    {0xBEBF, 0x68A2},
    {0xBEC0, 0x6A1F},
    {0xBEC1, 0x6A35},
    {0xBEC2, 0x6CBC},
    {0xBEC3, 0x6D88},
    {0xBEC4, 0x6E09},
    {0xBEC5, 0x6E58},
    {0xBEC6, 0x713C},
    {0xBEC7, 0x7126},
    {0xBEC8, 0x7167},
    {0xBEC9, 0x75C7},
    {0xBECA, 0x7701},
    {0xBECB, 0x785D},
    {0xBECC, 0x7901},
    {0xBECD, 0x7965},
    {0xBECE, 0x79F0},
    {0xBECF, 0x7AE0},
    {0xBED0, 0x7B11},
    {0xBED1, 0x7CA7},
    {0xBED2, 0x7D39},
    {0xBED3, 0x8096},
    {0xBED4, 0x83D6},
    {0xBED5, 0x848B},
    {0xBED6, 0x8549},
    {0xBED7, 0x885D},
    {0xBED8, 0x88F3},
    {0xBED9, 0x8A1F},
    {0xBEDA, 0x8A3C},
    {0xBEDB, 0x8A54},
    {0xBEDC, 0x8A73},
    {0xBEDD, 0x8C61},
    {0xBEDE, 0x8CDE},
    {0xBEDF, 0x91A4},
    {0xBEE0, 0x9266},
    {0xBEE1, 0x937E},
    {0xBEE2, 0x9418},
    {0xBEE3, 0x969C},
    {0xBEE4, 0x9798},
    {0xBEE5, 0x4E0A},
    {0xBEE6, 0x4E08},
    {0xBEE7, 0x4E1E},
    {0xBEE8, 0x4E57},
    {0xBEE9, 0x5197},
    {0xBEEA, 0x5270},
    {0xBEEB, 0x57CE},
    {0xBEEC, 0x5834},
    {0xBEED, 0x58CC},
    {0xBEEE, 0x5B22},
    {0xBEEF, 0x5E38},
    {0xBEF0, 0x60C5},
    {0xBEF1, 0x64FE},
    {0xBEF2, 0x6761},
    {0xBEF3, 0x6756},
    {0xBEF4, 0x6D44},
    {0xBEF5, 0x72B6},
    {0xBEF6, 0x7573},
    {0xBEF7, 0x7A63},
    {0xBEF8, 0x84B8},
    {0xBEF9, 0x8B72},
    {0xBEFA, 0x91B8},
    {0xBEFB, 0x9320},
    {0xBEFC, 0x5631},
    {0xBEFD, 0x57F4},
    {0xBEFE, 0x98FE},
    {0xBFA1, 0x62ED},
    {0xBFA2, 0x690D},
    {0xBFA3, 0x6B96},
    {0xBFA4, 0x71ED},
    {0xBFA5, 0x7E54},
    {0xBFA6, 0x8077},
    {0xBFA7, 0x8272},
    {0xBFA8, 0x89E6},
    {0xBFA9, 0x98DF},
    {0xBFAA, 0x8755},
    {0xBFAB, 0x8FB1},
    {0xBFAC, 0x5C3B},
    {0xBFAD, 0x4F38},
    {0xBFAE, 0x4FE1},
    {0xBFAF, 0x4FB5},
    {0xBFB0, 0x5507},
    {0xBFB1, 0x5A20},
    {0xBFB2, 0x5BDD},
    {0xBFB3, 0x5BE9},
    {0xBFB4, 0x5FC3},
    {0xBFB5, 0x614E},
    {0xBFB6, 0x632F},
    {0xBFB7, 0x65B0},
    {0xBFB8, 0x664B},
    {0xBFB9, 0x68EE},
    {0xBFBA, 0x699B},
    {0xBFBB, 0x6D78},
    {0xBFBC, 0x6DF1},
    {0xBFBD, 0x7533},
    {0xBFBE, 0x75B9},
    {0xBFBF, 0x771F},
    {0xBFC0, 0x795E},
    {0xBFC1, 0x79E6},
    {0xBFC2, 0x7D33},
    {0xBFC3, 0x81E3},
    {0xBFC4, 0x82AF},
    {0xBFC5, 0x85AA},
    {0xBFC6, 0x89AA},
    {0xBFC7, 0x8A3A},
    {0xBFC8, 0x8EAB},
    {0xBFC9, 0x8F9B},
    {0xBFCA, 0x9032},
    {0xBFCB, 0x91DD},
    {0xBFCC, 0x9707},
    {0xBFCD, 0x4EBA},
    {0xBFCE, 0x4EC1},
    {0xBFCF, 0x5203},
    {0xBFD0, 0x5875},
    {0xBFD1, 0x58EC},
    {0xBFD2, 0x5C0B},
    {0xBFD3, 0x751A},
    {0xBFD4, 0x5C3D},
    {0xBFD5, 0x814E},
    {0xBFD6, 0x8A0A},
    {0xBFD7, 0x8FC5},
    {0xBFD8, 0x9663},
    {0xBFD9, 0x976D},
    {0xBFDA, 0x7B25},
    {0xBFDB, 0x8ACF},
    {0xBFDC, 0x9808},
    {0xBFDD, 0x9162},
    {0xBFDE, 0x56F3},
    {0xBFDF, 0x53A8},
    {0xBFE0, 0x9017},
    {0xBFE1, 0x5439},
    {0xBFE2, 0x5782},
    {0xBFE3, 0x5E25},
    {0xBFE4, 0x63A8},
    {0xBFE5, 0x6C34},
    {0xBFE6, 0x708A},
    {0xBFE7, 0x7761},
    {0xBFE8, 0x7C8B},
    {0xBFE9, 0x7FE0},
    {0xBFEA, 0x8870},
    {0xBFEB, 0x9042},
    {0xBFEC, 0x9154},
    {0xBFED, 0x9310},
    {0xBFEE, 0x9318},
    {0xBFEF, 0x968F},
    {0xBFF0, 0x745E},
    {0xBFF1, 0x9AC4},
    {0xBFF2, 0x5D07},
    {0xBFF3, 0x5D69},
    {0xBFF4, 0x6570},
    {0xBFF5, 0x67A2},
    {0xBFF6, 0x8DA8},
    {0xBFF7, 0x96DB},
    {0xBFF8, 0x636E},
    {0xBFF9, 0x6749},
    {0xBFFA, 0x6919},
    {0xBFFB, 0x83C5},
    {0xBFFC, 0x9817},
    {0xBFFD, 0x96C0},
    {0xBFFE, 0x88FE},
    {0xC0A1, 0x6F84},
    {0xC0A2, 0x647A},
    {0xC0A3, 0x5BF8},
    {0xC0A4, 0x4E16},
    {0xC0A5, 0x702C},
    {0xC0A6, 0x755D},
    {0xC0A7, 0x662F},
    {0xC0A8, 0x51C4},
    {0xC0A9, 0x5236},
    {0xC0AA, 0x52E2},
    {0xC0AB, 0x59D3},
    {0xC0AC, 0x5F81},
    {0xC0AD, 0x6027},
    {0xC0AE, 0x6210},
    {0xC0AF, 0x653F},
    {0xC0B0, 0x6574},
    {0xC0B1, 0x661F},
    {0xC0B2, 0x6674},
    {0xC0B3, 0x68F2},
    {0xC0B4, 0x6816},
    {0xC0B5, 0x6B63},
    {0xC0B6, 0x6E05},
    {0xC0B7, 0x7272},
    {0xC0B8, 0x751F},
    {0xC0B9, 0x76DB},
    {0xC0BA, 0x7CBE},
    {0xC0BB, 0x8056},
    {0xC0BC, 0x58F0},
    {0xC0BD, 0x88FD},
    {0xC0BE, 0x897F},
    {0xC0BF, 0x8AA0},
    {0xC0C0, 0x8A93},
    {0xC0C1, 0x8ACB},
    {0xC0C2, 0x901D},
    {0xC0C3, 0x9192},
    {0xC0C4, 0x9752},
    {0xC0C5, 0x9759},
    {0xC0C6, 0x6589},
    {0xC0C7, 0x7A0E},
    {0xC0C8, 0x8106},
    {0xC0C9, 0x96BB},
    {0xC0CA, 0x5E2D},
    {0xC0CB, 0x60DC},
    {0xC0CC, 0x621A},
    {0xC0CD, 0x65A5},
    {0xC0CE, 0x6614},
    {0xC0CF, 0x6790},
    {0xC0D0, 0x77F3},
    {0xC0D1, 0x7A4D},
    {0xC0D2, 0x7C4D},
    {0xC0D3, 0x7E3E},
    {0xC0D4, 0x810A},
    {0xC0D5, 0x8CAC},
    {0xC0D6, 0x8D64},
    {0xC0D7, 0x8DE1},
    {0xC0D8, 0x8E5F},
    {0xC0D9, 0x78A9},
    {0xC0DA, 0x5207},
    {0xC0DB, 0x62D9},
    {0xC0DC, 0x63A5},
    {0xC0DD, 0x6442},
    {0xC0DE, 0x6298},
    {0xC0DF, 0x8A2D},
    {0xC0E0, 0x7A83},
    {0xC0E1, 0x7BC0},
    {0xC0E2, 0x8AAC},
    {0xC0E3, 0x96EA},
    {0xC0E4, 0x7D76},
    {0xC0E5, 0x820C},
    {0xC0E6, 0x8749},
    {0xC0E7, 0x4ED9},
    {0xC0E8, 0x5148},
    {0xC0E9, 0x5343},
    {0xC0EA, 0x5360},
    {0xC0EB, 0x5BA3},
    {0xC0EC, 0x5C02},
    {0xC0ED, 0x5C16},
    {0xC0EE, 0x5DDD},
    {0xC0EF, 0x6226},
    {0xC0F0, 0x6247},
    {0xC0F1, 0x64B0},
    {0xC0F2, 0x6813},
    {0xC0F3, 0x6834},
    {0xC0F4, 0x6CC9},
    {0xC0F5, 0x6D45},
    {0xC0F6, 0x6D17},
    {0xC0F7, 0x67D3},
    {0xC0F8, 0x6F5C},
    {0xC0F9, 0x714E},
    {0xC0FA, 0x717D},
    {0xC0FB, 0x65CB},
    {0xC0FC, 0x7A7F},
    {0xC0FD, 0x7BAD},
    {0xC0FE, 0x7DDA},
    {0xC1A1, 0x7E4A},
    {0xC1A2, 0x7FA8},
    {0xC1A3, 0x817A},
    {0xC1A4, 0x821B},
    {0xC1A5, 0x8239},
    {0xC1A6, 0x85A6},
    {0xC1A7, 0x8A6E},
    {0xC1A8, 0x8CCE},
    {0xC1A9, 0x8DF5},
    {0xC1AA, 0x9078},
    {0xC1AB, 0x9077},
    {0xC1AC, 0x92AD},
    {0xC1AD, 0x9291},
    {0xC1AE, 0x9583},
    {0xC1AF, 0x9BAE},
    {0xC1B0, 0x524D},
    {0xC1B1, 0x5584},
    {0xC1B2, 0x6F38},
    {0xC1B3, 0x7136},
    {0xC1B4, 0x5168},
    {0xC1B5, 0x7985},
    {0xC1B6, 0x7E55},
    {0xC1B7, 0x81B3},
    {0xC1B8, 0x7CCE},
    {0xC1B9, 0x564C},
    {0xC1BA, 0x5851},
    {0xC1BB, 0x5CA8},
    {0xC1BC, 0x63AA},
    {0xC1BD, 0x66FE},
    {0xC1BE, 0x66FD},
    {0xC1BF, 0x695A},
    {0xC1C0, 0x72D9},
    {0xC1C1, 0x758F},
    {0xC1C2, 0x758E},
    {0xC1C3, 0x790E},
    {0xC1C4, 0x7956},
    {0xC1C5, 0x79DF},
    {0xC1C6, 0x7C97},
    {0xC1C7, 0x7D20},
    {0xC1C8, 0x7D44},
    {0xC1C9, 0x8607},
    {0xC1CA, 0x8A34},
    {0xC1CB, 0x963B},
    {0xC1CC, 0x9061},
    {0xC1CD, 0x9F20},
    {0xC1CE, 0x50E7},
    {0xC1CF, 0x5275},
    {0xC1D0, 0x53CC},
    {0xC1D1, 0x53E2},
    {0xC1D2, 0x5009},
    {0xC1D3, 0x55AA},
    {0xC1D4, 0x58EE},
    {0xC1D5, 0x594F},
    {0xC1D6, 0x723D},
    {0xC1D7, 0x5B8B},
    {0xC1D8, 0x5C64},
    {0xC1D9, 0x531D},
    {0xC1DA, 0x60E3},
    {0xC1DB, 0x60F3},
    {0xC1DC, 0x635C},
    {0xC1DD, 0x6383},
    {0xC1DE, 0x633F},
    {0xC1DF, 0x63BB},
    {0xC1E0, 0x64CD},
    {0xC1E1, 0x65E9},
    {0xC1E2, 0x66F9},
    {0xC1E3, 0x5DE3},
    {0xC1E4, 0x69CD},
    {0xC1E5, 0x69FD},
    {0xC1E6, 0x6F15},
    {0xC1E7, 0x71E5},
    {0xC1E8, 0x4E89},
    {0xC1E9, 0x75E9},
    {0xC1EA, 0x76F8},
    {0xC1EB, 0x7A93},
    {0xC1EC, 0x7CDF},
    {0xC1ED, 0x7DCF},
    {0xC1EE, 0x7D9C},
    {0xC1EF, 0x8061},
    {0xC1F0, 0x8349},
    {0xC1F1, 0x8358},
    {0xC1F2, 0x846C},
    {0xC1F3, 0x84BC},
    {0xC1F4, 0x85FB},
    {0xC1F5, 0x88C5},
    {0xC1F6, 0x8D70},
    {0xC1F7, 0x9001},
    {0xC1F8, 0x906D},
    {0xC1F9, 0x9397},
    {0xC1FA, 0x971C},
    {0xC1FB, 0x9A12},
    {0xC1FC, 0x50CF},
    {0xC1FD, 0x5897},
    {0xC1FE, 0x618E},
    {0xC2A1, 0x81D3},
    {0xC2A2, 0x8535},
    {0xC2A3, 0x8D08},
    {0xC2A4, 0x9020},
    {0xC2A5, 0x4FC3},
    {0xC2A6, 0x5074},
    {0xC2A7, 0x5247},
    {0xC2A8, 0x5373},
    {0xC2A9, 0x606F},
    {0xC2AA, 0x6349},
    {0xC2AB, 0x675F},
    {0xC2AC, 0x6E2C},
    {0xC2AD, 0x8DB3},
    {0xC2AE, 0x901F},
    {0xC2AF, 0x4FD7},
    {0xC2B0, 0x5C5E},
    {0xC2B1, 0x8CCA},
    {0xC2B2, 0x65CF},
    {0xC2B3, 0x7D9A},
    {0xC2B4, 0x5352},
    {0xC2B5, 0x8896},
    {0xC2B6, 0x5176},
    {0xC2B7, 0x63C3},
    {0xC2B8, 0x5B58},
    {0xC2B9, 0x5B6B},
    {0xC2BA, 0x5C0A},
    {0xC2BB, 0x640D},
    {0xC2BC, 0x6751},
    {0xC2BD, 0x905C},
    {0xC2BE, 0x4ED6},
    {0xC2BF, 0x591A},
    {0xC2C0, 0x592A},
    {0xC2C1, 0x6C70},
    {0xC2C2, 0x8A51},
    {0xC2C3, 0x553E},
    {0xC2C4, 0x5815},
    {0xC2C5, 0x59A5},
    {0xC2C6, 0x60F0},
    {0xC2C7, 0x6253},
    {0xC2C8, 0x67C1},
    {0xC2C9, 0x8235},
    {0xC2CA, 0x6955},
    {0xC2CB, 0x9640},
    {0xC2CC, 0x99C4},
    {0xC2CD, 0x9A28},
    {0xC2CE, 0x4F53},
    {0xC2CF, 0x5806},
    {0xC2D0, 0x5BFE},
    {0xC2D1, 0x8010},
    {0xC2D2, 0x5CB1},
    {0xC2D3, 0x5E2F},
    {0xC2D4, 0x5F85},
    {0xC2D5, 0x6020},
    {0xC2D6, 0x614B},
    {0xC2D7, 0x6234},
    {0xC2D8, 0x66FF},
    {0xC2D9, 0x6CF0},
    {0xC2DA, 0x6EDE},
    {0xC2DB, 0x80CE},
    {0xC2DC, 0x817F},
    {0xC2DD, 0x82D4},
    {0xC2DE, 0x888B},
    {0xC2DF, 0x8CB8},
    {0xC2E0, 0x9000},
    {0xC2E1, 0x902E},
    {0xC2E2, 0x968A},
    {0xC2E3, 0x9EDB},
    {0xC2E4, 0x9BDB},
    {0xC2E5, 0x4EE3},
    {0xC2E6, 0x53F0},
    {0xC2E7, 0x5927},
    {0xC2E8, 0x7B2C},
    {0xC2E9, 0x918D},
    {0xC2EA, 0x984C},
    {0xC2EB, 0x9DF9},
    {0xC2EC, 0x6EDD},
    {0xC2ED, 0x7027},
    {0xC2EE, 0x5353},
    {0xC2EF, 0x5544},
    {0xC2F0, 0x5B85},
    {0xC2F1, 0x6258},
    {0xC2F2, 0x629E},
    {0xC2F3, 0x62D3},
    {0xC2F4, 0x6CA2},
    {0xC2F5, 0x6FEF},
    {0xC2F6, 0x7422},
    {0xC2F7, 0x8A17},
    {0xC2F8, 0x9438},
    {0xC2F9, 0x6FC1},
    {0xC2FA, 0x8AFE},
    {0xC2FB, 0x8338},
    {0xC2FC, 0x51E7},
    {0xC2FD, 0x86F8},
    {0xC2FE, 0x53EA},
    {0xC3A1, 0x53E9},
    {0xC3A2, 0x4F46},
    {0xC3A3, 0x9054},
    {0xC3A4, 0x8FB0},
    {0xC3A5, 0x596A},
    {0xC3A6, 0x8131},
    {0xC3A7, 0x5DFD},
    {0xC3A8, 0x7AEA},
    {0xC3A9, 0x8FBF},
    {0xC3AA, 0x68DA},
    {0xC3AB, 0x8C37},
    {0xC3AC, 0x72F8},
    {0xC3AD, 0x9C48},
    {0xC3AE, 0x6A3D},
    {0xC3AF, 0x8AB0},
    {0xC3B0, 0x4E39},
    {0xC3B1, 0x5358},
    {0xC3B2, 0x5606},
    {0xC3B3, 0x5766},
    {0xC3B4, 0x62C5},
    {0xC3B5, 0x63A2},
    {0xC3B6, 0x65E6},
    {0xC3B7, 0x6B4E},
    {0xC3B8, 0x6DE1},
    {0xC3B9, 0x6E5B},
    {0xC3BA, 0x70AD},
    {0xC3BB, 0x77ED},
    {0xC3BC, 0x7AEF},
    {0xC3BD, 0x7BAA},
    {0xC3BE, 0x7DBB},
    {0xC3BF, 0x803D},
    {0xC3C0, 0x80C6},
    {0xC3C1, 0x86CB},
    {0xC3C2, 0x8A95},
    {0xC3C3, 0x935B},
    {0xC3C4, 0x56E3},
    {0xC3C5, 0x58C7},
    {0xC3C6, 0x5F3E},
    {0xC3C7, 0x65AD},
    {0xC3C8, 0x6696},
    {0xC3C9, 0x6A80},
    {0xC3CA, 0x6BB5},
    {0xC3CB, 0x7537},
    {0xC3CC, 0x8AC7},
    {0xC3CD, 0x5024},
    {0xC3CE, 0x77E5},
    {0xC3CF, 0x5730},
    {0xC3D0, 0x5F1B},
    {0xC3D1, 0x6065},
    {0xC3D2, 0x667A},
    {0xC3D3, 0x6C60},
    {0xC3D4, 0x75F4},
    {0xC3D5, 0x7A1A},
    {0xC3D6, 0x7F6E},
    {0xC3D7, 0x81F4},
    {0xC3D8, 0x8718},
    {0xC3D9, 0x9045},
    {0xC3DA, 0x99B3},
    {0xC3DB, 0x7BC9},
    {0xC3DC, 0x755C},
    {0xC3DD, 0x7AF9},
    {0xC3DE, 0x7B51},
    {0xC3DF, 0x84C4},
    {0xC3E0, 0x9010},
    {0xC3E1, 0x79E9},
    {0xC3E2, 0x7A92},
    {0xC3E3, 0x8336},
    {0xC3E4, 0x5AE1},
    {0xC3E5, 0x7740},
    {0xC3E6, 0x4E2D},
    {0xC3E7, 0x4EF2},
    {0xC3E8, 0x5B99},
    {0xC3E9, 0x5FE0},
    {0xC3EA, 0x62BD},
    {0xC3EB, 0x663C},
    {0xC3EC, 0x67F1},
    {0xC3ED, 0x6CE8},
    {0xC3EE, 0x866B},
    {0xC3EF, 0x8877},
    {0xC3F0, 0x8A3B},
    {0xC3F1, 0x914E},
    {0xC3F2, 0x92F3},
    {0xC3F3, 0x99D0},
    {0xC3F4, 0x6A17},
    {0xC3F5, 0x7026},
    {0xC3F6, 0x732A},
    {0xC3F7, 0x82E7},
    {0xC3F8, 0x8457},
    {0xC3F9, 0x8CAF},
    {0xC3FA, 0x4E01},
    {0xC3FB, 0x5146},
    {0xC3FC, 0x51CB},
    {0xC3FD, 0x558B},
    {0xC3FE, 0x5BF5},
    {0xC4A1, 0x5E16},
    {0xC4A2, 0x5E33},
    {0xC4A3, 0x5E81},
    {0xC4A4, 0x5F14},
    {0xC4A5, 0x5F35},
    {0xC4A6, 0x5F6B},
    {0xC4A7, 0x5FB4},
    {0xC4A8, 0x61F2},
    {0xC4A9, 0x6311},
    {0xC4AA, 0x66A2},
    {0xC4AB, 0x671D},
    {0xC4AC, 0x6F6E},
    {0xC4AD, 0x7252},
    {0xC4AE, 0x753A},
    {0xC4AF, 0x773A},
    {0xC4B0, 0x8074},
    {0xC4B1, 0x8139},
    {0xC4B2, 0x8178},
    {0xC4B3, 0x8776},
    {0xC4B4, 0x8ABF},
    {0xC4B5, 0x8ADC},
    {0xC4B6, 0x8D85},
    {0xC4B7, 0x8DF3},
    {0xC4B8, 0x929A},
    {0xC4B9, 0x9577},
    {0xC4BA, 0x9802},
    {0xC4BB, 0x9CE5},
    {0xC4BC, 0x52C5},
    {0xC4BD, 0x6357},
    {0xC4BE, 0x76F4},
    {0xC4BF, 0x6715},
    {0xC4C0, 0x6C88},
    {0xC4C1, 0x73CD},
    {0xC4C2, 0x8CC3},
    {0xC4C3, 0x93AE},
    {0xC4C4, 0x9673},
    {0xC4C5, 0x6D25},
    {0xC4C6, 0x589C},
    {0xC4C7, 0x690E},
    {0xC4C8, 0x69CC},
    {0xC4C9, 0x8FFD},
    {0xC4CA, 0x939A},
    {0xC4CB, 0x75DB},
    {0xC4CC, 0x901A},
    {0xC4CD, 0x585A},
    {0xC4CE, 0x6802},
    {0xC4CF, 0x63B4},
    {0xC4D0, 0x69FB},
    {0xC4D1, 0x4F43},
    {0xC4D2, 0x6F2C},
    {0xC4D3, 0x67D8},
    {0xC4D4, 0x8FBB},
    {0xC4D5, 0x8526},
    {0xC4D6, 0x7DB4},
    {0xC4D7, 0x9354},
    {0xC4D8, 0x693F},
    {0xC4D9, 0x6F70},
    {0xC4DA, 0x576A},
    {0xC4DB, 0x58F7},
    {0xC4DC, 0x5B2C},
    {0xC4DD, 0x7D2C},
    {0xC4DE, 0x722A},
    {0xC4DF, 0x540A},
    {0xC4E0, 0x91E3},
    {0xC4E1, 0x9DB4},
    {0xC4E2, 0x4EAD},
    {0xC4E3, 0x4F4E},
    {0xC4E4, 0x505C},
    {0xC4E5, 0x5075},
    {0xC4E6, 0x5243},
    {0xC4E7, 0x8C9E},
    {0xC4E8, 0x5448},
    {0xC4E9, 0x5824},
    {0xC4EA, 0x5B9A},
    {0xC4EB, 0x5E1D},
    {0xC4EC, 0x5E95},
    {0xC4ED, 0x5EAD},
    {0xC4EE, 0x5EF7},
    {0xC4EF, 0x5F1F},
    {0xC4F0, 0x608C},
    {0xC4F1, 0x62B5},
    {0xC4F2, 0x633A},
    {0xC4F3, 0x63D0},
    {0xC4F4, 0x68AF},
    {0xC4F5, 0x6C40},
    {0xC4F6, 0x7887},
    {0xC4F7, 0x798E},
    {0xC4F8, 0x7A0B},
    {0xC4F9, 0x7DE0},
    {0xC4FA, 0x8247},
    {0xC4FB, 0x8A02},
    {0xC4FC, 0x8AE6},
    {0xC4FD, 0x8E44},
    {0xC4FE, 0x9013},
    {0xC5A1, 0x90B8},
    {0xC5A2, 0x912D},
    {0xC5A3, 0x91D8},
    {0xC5A4, 0x9F0E},
    {0xC5A5, 0x6CE5},
    {0xC5A6, 0x6458},
    {0xC5A7, 0x64E2},
    {0xC5A8, 0x6575},
    {0xC5A9, 0x6EF4},
    {0xC5AA, 0x7684},
    {0xC5AB, 0x7B1B},
    {0xC5AC, 0x9069},
    {0xC5AD, 0x93D1},
    {0xC5AE, 0x6EBA},
    {0xC5AF, 0x54F2},
    {0xC5B0, 0x5FB9},
    {0xC5B1, 0x64A4},
    {0xC5B2, 0x8F4D},
    {0xC5B3, 0x8FED},
    {0xC5B4, 0x9244},
    {0xC5B5, 0x5178},
    {0xC5B6, 0x586B},
    {0xC5B7, 0x5929},
    {0xC5B8, 0x5C55},
    {0xC5B9, 0x5E97},
    {0xC5BA, 0x6DFB},
    {0xC5BB, 0x7E8F},
    {0xC5BC, 0x751C},
    {0xC5BD, 0x8CBC},
    {0xC5BE, 0x8EE2},
    {0xC5BF, 0x985B},
    {0xC5C0, 0x70B9},
    {0xC5C1, 0x4F1D},
    {0xC5C2, 0x6BBF},
    {0xC5C3, 0x6FB1},
    {0xC5C4, 0x7530},
    {0xC5C5, 0x96FB},
    {0xC5C6, 0x514E},
    {0xC5C7, 0x5410},
    {0xC5C8, 0x5835},
    {0xC5C9, 0x5857},
    {0xC5CA, 0x59AC},
    {0xC5CB, 0x5C60},
    {0xC5CC, 0x5F92},
    {0xC5CD, 0x6597},
    {0xC5CE, 0x675C},
    {0xC5CF, 0x6E21},
    {0xC5D0, 0x767B},
    {0xC5D1, 0x83DF},
    {0xC5D2, 0x8CED},
    {0xC5D3, 0x9014},
    {0xC5D4, 0x90FD},
    {0xC5D5, 0x934D},
    {0xC5D6, 0x7825},
    {0xC5D7, 0x783A},
    {0xC5D8, 0x52AA},
    {0xC5D9, 0x5EA6},
    {0xC5DA, 0x571F},
    {0xC5DB, 0x5974},
    {0xC5DC, 0x6012},
    {0xC5DD, 0x5012},
    {0xC5DE, 0x515A},
    {0xC5DF, 0x51AC},
    {0xC5E0, 0x51CD},
    {0xC5E1, 0x5200},
    {0xC5E2, 0x5510},
    {0xC5E3, 0x5854},
    {0xC5E4, 0x5858},
    {0xC5E5, 0x5957},
    {0xC5E6, 0x5B95},
    {0xC5E7, 0x5CF6},
    {0xC5E8, 0x5D8B},
    {0xC5E9, 0x60BC},
    {0xC5EA, 0x6295},
    {0xC5EB, 0x642D},
    {0xC5EC, 0x6771},
    {0xC5ED, 0x6843},
    {0xC5EE, 0x68BC},
    {0xC5EF, 0x68DF},
    {0xC5F0, 0x76D7},
    {0xC5F1, 0x6DD8},
    {0xC5F2, 0x6E6F},
    {0xC5F3, 0x6D9B},
    {0xC5F4, 0x706F},
    {0xC5F5, 0x71C8},
    {0xC5F6, 0x5F53},
    {0xC5F7, 0x75D8},
    {0xC5F8, 0x7977},
    {0xC5F9, 0x7B49},
    {0xC5FA, 0x7B54},
    {0xC5FB, 0x7B52},
    {0xC5FC, 0x7CD6},
    {0xC5FD, 0x7D71},
    {0xC5FE, 0x5230},
    {0xC6A1, 0x8463},
    {0xC6A2, 0x8569},
    {0xC6A3, 0x85E4},
    {0xC6A4, 0x8A0E},
    {0xC6A5, 0x8B04},
    {0xC6A6, 0x8C46},
    {0xC6A7, 0x8E0F},
    {0xC6A8, 0x9003},
    {0xC6A9, 0x900F},
    {0xC6AA, 0x9419},
    {0xC6AB, 0x9676},
    {0xC6AC, 0x982D},
    {0xC6AD, 0x9A30},
    {0xC6AE, 0x95D8},
    {0xC6AF, 0x50CD},
    {0xC6B0, 0x52D5},
    {0xC6B1, 0x540C},
    {0xC6B2, 0x5802},
    {0xC6B3, 0x5C0E},
    {0xC6B4, 0x61A7},
    {0xC6B5, 0x649E},
    {0xC6B6, 0x6D1E},
    {0xC6B7, 0x77B3},
    {0xC6B8, 0x7AE5},
    {0xC6B9, 0x80F4},
    {0xC6BA, 0x8404},
    {0xC6BB, 0x9053},
    {0xC6BC, 0x9285},
    {0xC6BD, 0x5CE0},
    {0xC6BE, 0x9D07},
    {0xC6BF, 0x533F},
    {0xC6C0, 0x5F97},
    {0xC6C1, 0x5FB3},
    {0xC6C2, 0x6D9C},
    {0xC6C3, 0x7279},
    {0xC6C4, 0x7763},
    {0xC6C5, 0x79BF},
    {0xC6C6, 0x7BE4},
    {0xC6C7, 0x6BD2},
    {0xC6C8, 0x72EC},
    {0xC6C9, 0x8AAD},
    {0xC6CA, 0x6803},
    {0xC6CB, 0x6A61},
    {0xC6CC, 0x51F8},
    {0xC6CD, 0x7A81},
    {0xC6CE, 0x6934},
    {0xC6CF, 0x5C4A},
    {0xC6D0, 0x9CF6},
    {0xC6D1, 0x82EB},
    {0xC6D2, 0x5BC5},
    {0xC6D3, 0x9149},
    {0xC6D4, 0x701E},
    {0xC6D5, 0x5678},
    {0xC6D6, 0x5C6F},
    {0xC6D7, 0x60C7},
    {0xC6D8, 0x6566},
    {0xC6D9, 0x6C8C},
    {0xC6DA, 0x8C5A},
    {0xC6DB, 0x9041},
    {0xC6DC, 0x9813},
    {0xC6DD, 0x5451},
    {0xC6DE, 0x66C7},
    {0xC6DF, 0x920D},
    {0xC6E0, 0x5948},
    {0xC6E1, 0x90A3},
    {0xC6E2, 0x5185},
    {0xC6E3, 0x4E4D},
    {0xC6E4, 0x51EA},
    {0xC6E5, 0x8599},
    {0xC6E6, 0x8B0E},
    {0xC6E7, 0x7058},
    {0xC6E8, 0x637A},
    {0xC6E9, 0x934B},
    {0xC6EA, 0x6962},
    {0xC6EB, 0x99B4},
    {0xC6EC, 0x7E04},
    {0xC6ED, 0x7577},
    {0xC6EE, 0x5357},
    {0xC6EF, 0x6960},
    {0xC6F0, 0x8EDF},
    {0xC6F1, 0x96E3},
    {0xC6F2, 0x6C5D},
    {0xC6F3, 0x4E8C},
    {0xC6F4, 0x5C3C},
    {0xC6F5, 0x5F10},
    {0xC6F6, 0x8FE9},
    {0xC6F7, 0x5302},
    {0xC6F8, 0x8CD1},
    {0xC6F9, 0x8089},
    {0xC6FA, 0x8679},
    {0xC6FB, 0x5EFF},
    {0xC6FC, 0x65E5},
    {0xC6FD, 0x4E73},
    {0xC6FE, 0x5165},
    {0xC7A1, 0x5982},
    {0xC7A2, 0x5C3F},
    {0xC7A3, 0x97EE},
    {0xC7A4, 0x4EFB},
    {0xC7A5, 0x598A},
    {0xC7A6, 0x5FCD},
    {0xC7A7, 0x8A8D},
    {0xC7A8, 0x6FE1},
    {0xC7A9, 0x79B0},
    {0xC7AA, 0x7962},
    {0xC7AB, 0x5BE7},
    {0xC7AC, 0x8471},
    {0xC7AD, 0x732B},
    {0xC7AE, 0x71B1},
    {0xC7AF, 0x5E74},
    {0xC7B0, 0x5FF5},
    {0xC7B1, 0x637B},
    {0xC7B2, 0x649A},
    {0xC7B3, 0x71C3},
    {0xC7B4, 0x7C98},
    {0xC7B5, 0x4E43},
    {0xC7B6, 0x5EFC},
    {0xC7B7, 0x4E4B},
    {0xC7B8, 0x57DC},
    {0xC7B9, 0x56A2},
    {0xC7BA, 0x60A9},
    {0xC7BB, 0x6FC3},
    {0xC7BC, 0x7D0D},
    {0xC7BD, 0x80FD},
    {0xC7BE, 0x8133},
    {0xC7BF, 0x81BF},
    {0xC7C0, 0x8FB2},
    {0xC7C1, 0x8997},
    {0xC7C2, 0x86A4},
    {0xC7C3, 0x5DF4},
    {0xC7C4, 0x628A},
    {0xC7C5, 0x64AD},
    {0xC7C6, 0x8987},
    {0xC7C7, 0x6777},
    {0xC7C8, 0x6CE2},
    {0xC7C9, 0x6D3E},
    {0xC7CA, 0x7436},
    {0xC7CB, 0x7834},
    {0xC7CC, 0x5A46},
    {0xC7CD, 0x7F75},
    {0xC7CE, 0x82AD},
    {0xC7CF, 0x99AC},
    {0xC7D0, 0x4FF3},
    {0xC7D1, 0x5EC3},
    {0xC7D2, 0x62DD},
    {0xC7D3, 0x6392},
    {0xC7D4, 0x6557},
    {0xC7D5, 0x676F},
    {0xC7D6, 0x76C3},
    {0xC7D7, 0x724C},
    {0xC7D8, 0x80CC},
    {0xC7D9, 0x80BA},
    {0xC7DA, 0x8F29},
    {0xC7DB, 0x914D},
    {0xC7DC, 0x500D},
    {0xC7DD, 0x57F9},
    {0xC7DE, 0x5A92},
    {0xC7DF, 0x6885},
    {0xC7E0, 0x6973},
    {0xC7E1, 0x7164},
    {0xC7E2, 0x72FD},
    {0xC7E3, 0x8CB7},
    {0xC7E4, 0x58F2},
    {0xC7E5, 0x8CE0},
    {0xC7E6, 0x966A},
    {0xC7E7, 0x9019},
    {0xC7E8, 0x877F},
    {0xC7E9, 0x79E4},
    {0xC7EA, 0x77E7},
    {0xC7EB, 0x8429},
    {0xC7EC, 0x4F2F},
    {0xC7ED, 0x5265},
    {0xC7EE, 0x535A},
    {0xC7EF, 0x62CD},
    {0xC7F0, 0x67CF},
    {0xC7F1, 0x6CCA},
    {0xC7F2, 0x767D},
    {0xC7F3, 0x7B94},
    {0xC7F4, 0x7C95},
    {0xC7F5, 0x8236},
    {0xC7F6, 0x8584},
    {0xC7F7, 0x8FEB},
    {0xC7F8, 0x66DD},
    {0xC7F9, 0x6F20},
    {0xC7FA, 0x7206},
    {0xC7FB, 0x7E1B},
    {0xC7FC, 0x83AB},
    {0xC7FD, 0x99C1},
    {0xC7FE, 0x9EA6},
    {0xC8A1, 0x51FD},
    {0xC8A2, 0x7BB1},
    {0xC8A3, 0x7872},
    {0xC8A4, 0x7BB8},
    {0xC8A5, 0x8087},
    {0xC8A6, 0x7B48},
    {0xC8A7, 0x6AE8},
    {0xC8A8, 0x5E61},
    {0xC8A9, 0x808C},
    {0xC8AA, 0x7551},
    {0xC8AB, 0x7560},
    {0xC8AC, 0x516B},
    {0xC8AD, 0x9262},
    {0xC8AE, 0x6E8C},
    {0xC8AF, 0x767A},
    {0xC8B0, 0x9197},
    {0xC8B1, 0x9AEA},
    {0xC8B2, 0x4F10},
    {0xC8B3, 0x7F70},
    {0xC8B4, 0x629C},
    {0xC8B5, 0x7B4F},
    {0xC8B6, 0x95A5},
    {0xC8B7, 0x9CE9},
    {0xC8B8, 0x567A},
    {0xC8B9, 0x5859},
    {0xC8BA, 0x86E4},
    {0xC8BB, 0x96BC},
    {0xC8BC, 0x4F34},
    {0xC8BD, 0x5224},
    {0xC8BE, 0x534A},
    {0xC8BF, 0x53CD},
    {0xC8C0, 0x53DB},
    {0xC8C1, 0x5E06},
    {0xC8C2, 0x642C},
    {0xC8C3, 0x6591},
    {0xC8C4, 0x677F},
    {0xC8C5, 0x6C3E},
    {0xC8C6, 0x6C4E},
    {0xC8C7, 0x7248},
    {0xC8C8, 0x72AF},
    {0xC8C9, 0x73ED},
    {0xC8CA, 0x7554},
    {0xC8CB, 0x7E41},
    {0xC8CC, 0x822C},
    {0xC8CD, 0x85E9},
    {0xC8CE, 0x8CA9},
    {0xC8CF, 0x7BC4},
    {0xC8D0, 0x91C6},
    {0xC8D1, 0x7169},
    {0xC8D2, 0x9812},
    {0xC8D3, 0x98EF},
    {0xC8D4, 0x633D},
    {0xC8D5, 0x6669},
    {0xC8D6, 0x756A},
    {0xC8D7, 0x76E4},
    {0xC8D8, 0x78D0},
    {0xC8D9, 0x8543},
    {0xC8DA, 0x86EE},
    {0xC8DB, 0x532A},
    {0xC8DC, 0x5351},
    {0xC8DD, 0x5426},
    {0xC8DE, 0x5983},
    {0xC8DF, 0x5E87},
    {0xC8E0, 0x5F7C},
    {0xC8E1, 0x60B2},
    {0xC8E2, 0x6249},
    {0xC8E3, 0x6279},
    {0xC8E4, 0x62AB},
    {0xC8E5, 0x6590},
    {0xC8E6, 0x6BD4},
    {0xC8E7, 0x6CCC},
    {0xC8E8, 0x75B2},
    {0xC8E9, 0x76AE},
    {0xC8EA, 0x7891},
    {0xC8EB, 0x79D8},
    {0xC8EC, 0x7DCB},
    {0xC8ED, 0x7F77},
    {0xC8EE, 0x80A5},
    {0xC8EF, 0x88AB},
    {0xC8F0, 0x8AB9},
    {0xC8F1, 0x8CBB},
    {0xC8F2, 0x907F},
    {0xC8F3, 0x975E},
    {0xC8F4, 0x98DB},
    {0xC8F5, 0x6A0B},
    {0xC8F6, 0x7C38},
    {0xC8F7, 0x5099},
    {0xC8F8, 0x5C3E},
    {0xC8F9, 0x5FAE},
    {0xC8FA, 0x6787},
    {0xC8FB, 0x6BD8},
    {0xC8FC, 0x7435},
    {0xC8FD, 0x7709},
    {0xC8FE, 0x7F8E},
    {0xC9A1, 0x9F3B},
    {0xC9A2, 0x67CA},
    {0xC9A3, 0x7A17},
    {0xC9A4, 0x5339},
    {0xC9A5, 0x758B},
    {0xC9A6, 0x9AED},
    {0xC9A7, 0x5F66},
    {0xC9A8, 0x819D},
    {0xC9A9, 0x83F1},
    {0xC9AA, 0x8098},
    {0xC9AB, 0x5F3C},
    {0xC9AC, 0x5FC5},
    {0xC9AD, 0x7562},
    {0xC9AE, 0x7B46},
    {0xC9AF, 0x903C},
    {0xC9B0, 0x6867},
    {0xC9B1, 0x59EB},
    {0xC9B2, 0x5A9B},
    {0xC9B3, 0x7D10},
    {0xC9B4, 0x767E},
    {0xC9B5, 0x8B2C},
    {0xC9B6, 0x4FF5},
    {0xC9B7, 0x5F6A},
    {0xC9B8, 0x6A19},
    {0xC9B9, 0x6C37},
    {0xC9BA, 0x6F02},
    {0xC9BB, 0x74E2},
    {0xC9BC, 0x7968},
    {0xC9BD, 0x8868},
    {0xC9BE, 0x8A55},
    {0xC9BF, 0x8C79},
    {0xC9C0, 0x5EDF},
    {0xC9C1, 0x63CF},
    {0xC9C2, 0x75C5},
    {0xC9C3, 0x79D2},
    {0xC9C4, 0x82D7},
    {0xC9C5, 0x9328},
    {0xC9C6, 0x92F2},
    {0xC9C7, 0x849C},
    {0xC9C8, 0x86ED},
    {0xC9C9, 0x9C2D},
    {0xC9CA, 0x54C1},
    {0xC9CB, 0x5F6C},
    {0xC9CC, 0x658C},
    {0xC9CD, 0x6D5C},
    {0xC9CE, 0x7015},
    {0xC9CF, 0x8CA7},
    {0xC9D0, 0x8CD3},
    {0xC9D1, 0x983B},
    {0xC9D2, 0x654F},
    {0xC9D3, 0x74F6},
    {0xC9D4, 0x4E0D},
    {0xC9D5, 0x4ED8},
    {0xC9D6, 0x57E0},
    {0xC9D7, 0x592B},
    {0xC9D8, 0x5A66},
    {0xC9D9, 0x5BCC},
    {0xC9DA, 0x51A8},
    {0xC9DB, 0x5E03},
    {0xC9DC, 0x5E9C},
    {0xC9DD, 0x6016},
    {0xC9DE, 0x6276},
    {0xC9DF, 0x6577},
    {0xC9E0, 0x65A7},
    {0xC9E1, 0x666E},
    {0xC9E2, 0x6D6E},
    {0xC9E3, 0x7236},
    {0xC9E4, 0x7B26},
    {0xC9E5, 0x8150},
    {0xC9E6, 0x819A},
    {0xC9E7, 0x8299},
    {0xC9E8, 0x8B5C},
    {0xC9E9, 0x8CA0},
    {0xC9EA, 0x8CE6},
    {0xC9EB, 0x8D74},
    {0xC9EC, 0x961C},
    {0xC9ED, 0x9644},
    {0xC9EE, 0x4FAE},
    {0xC9EF, 0x64AB},
    {0xC9F0, 0x6B66},
    {0xC9F1, 0x821E},
    {0xC9F2, 0x8461},
    {0xC9F3, 0x856A},
    {0xC9F4, 0x90E8},
    {0xC9F5, 0x5C01},
    {0xC9F6, 0x6953},
    {0xC9F7, 0x98A8},
    {0xC9F8, 0x847A},
    {0xC9F9, 0x8557},
    {0xC9FA, 0x4F0F},
    {0xC9FB, 0x526F},
    {0xC9FC, 0x5FA9},
    {0xC9FD, 0x5E45},
    {0xC9FE, 0x670D},
    {0xCAA1, 0x798F},
    {0xCAA2, 0x8179},
    {0xCAA3, 0x8907},
    {0xCAA4, 0x8986},
    {0xCAA5, 0x6DF5},
    {0xCAA6, 0x5F17},
    {0xCAA7, 0x6255},
    {0xCAA8, 0x6CB8},
    {0xCAA9, 0x4ECF},
    {0xCAAA, 0x7269},
    {0xCAAB, 0x9B92},
    {0xCAAC, 0x5206},
    {0xCAAD, 0x543B},
    {0xCAAE, 0x5674},
    {0xCAAF, 0x58B3},
    {0xCAB0, 0x61A4},
    {0xCAB1, 0x626E},
    {0xCAB2, 0x711A},
    {0xCAB3, 0x596E},
    {0xCAB4, 0x7C89},
    {0xCAB5, 0x7CDE},
    {0xCAB6, 0x7D1B},
    {0xCAB7, 0x96F0},
    {0xCAB8, 0x6587},
    {0xCAB9, 0x805E},
    {0xCABA, 0x4E19},
    {0xCABB, 0x4F75},
    {0xCABC, 0x5175},
    {0xCABD, 0x5840},
    {0xCABE, 0x5E63},
    {0xCABF, 0x5E73},
    {0xCAC0, 0x5F0A},
    {0xCAC1, 0x67C4},
    {0xCAC2, 0x4E26},
    {0xCAC3, 0x853D},
    {0xCAC4, 0x9589},
    {0xCAC5, 0x965B},
    {0xCAC6, 0x7C73},
    {0xCAC7, 0x9801},
    {0xCAC8, 0x50FB},
    {0xCAC9, 0x58C1},
    {0xCACA, 0x7656},
    {0xCACB, 0x78A7},
    {0xCACC, 0x5225},
    {0xCACD, 0x77A5},
    {0xCACE, 0x8511},
    {0xCACF, 0x7B86},
    {0xCAD0, 0x504F},
    {0xCAD1, 0x5909},
    {0xCAD2, 0x7247},
    {0xCAD3, 0x7BC7},
    {0xCAD4, 0x7DE8},
    {0xCAD5, 0x8FBA},
    {0xCAD6, 0x8FD4},
    {0xCAD7, 0x904D},
    {0xCAD8, 0x4FBF},
    {0xCAD9, 0x52C9},
    {0xCADA, 0x5A29},
    {0xCADB, 0x5F01},
    {0xCADC, 0x97AD},
    {0xCADD, 0x4FDD},
    {0xCADE, 0x8217},
    {0xCADF, 0x92EA},
    {0xCAE0, 0x5703},
    {0xCAE1, 0x6355},
    {0xCAE2, 0x6B69},
    {0xCAE3, 0x752B},
    {0xCAE4, 0x88DC},
    {0xCAE5, 0x8F14},
    {0xCAE6, 0x7A42},
    {0xCAE7, 0x52DF},
    {0xCAE8, 0x5893},
    {0xCAE9, 0x6155},
    {0xCAEA, 0x620A},
    {0xCAEB, 0x66AE},
    {0xCAEC, 0x6BCD},
    {0xCAED, 0x7C3F},
    {0xCAEE, 0x83E9},
    {0xCAEF, 0x5023},
    {0xCAF0, 0x4FF8},
    {0xCAF1, 0x5305},
    {0xCAF2, 0x5446},
    {0xCAF3, 0x5831},
    {0xCAF4, 0x5949},
    {0xCAF5, 0x5B9D},
    {0xCAF6, 0x5CF0},
    {0xCAF7, 0x5CEF},
    {0xCAF8, 0x5D29},
    {0xCAF9, 0x5E96},
    {0xCAFA, 0x62B1},
    {0xCAFB, 0x6367},
    {0xCAFC, 0x653E},
    {0xCAFD, 0x65B9},
    {0xCAFE, 0x670B},
    {0xCBA1, 0x6CD5},
    {0xCBA2, 0x6CE1},
    {0xCBA3, 0x70F9},
    {0xCBA4, 0x7832},
    {0xCBA5, 0x7E2B},
    {0xCBA6, 0x80DE},
    {0xCBA7, 0x82B3},
    {0xCBA8, 0x840C},
    {0xCBA9, 0x84EC},
    {0xCBAA, 0x8702},
    {0xCBAB, 0x8912},
    {0xCBAC, 0x8A2A},
    {0xCBAD, 0x8C4A},
    {0xCBAE, 0x90A6},
    {0xCBAF, 0x92D2},
    {0xCBB0, 0x98FD},
    {0xCBB1, 0x9CF3},
    {0xCBB2, 0x9D6C},
    {0xCBB3, 0x4E4F},
    {0xCBB4, 0x4EA1},
    {0xCBB5, 0x508D},
    {0xCBB6, 0x5256},
    {0xCBB7, 0x574A},
    {0xCBB8, 0x59A8},
    {0xCBB9, 0x5E3D},
    {0xCBBA, 0x5FD8},
    {0xCBBB, 0x5FD9},
    {0xCBBC, 0x623F},
    {0xCBBD, 0x66B4},
    {0xCBBE, 0x671B},
    {0xCBBF, 0x67D0},
    {0xCBC0, 0x68D2},
    {0xCBC1, 0x5192},
    {0xCBC2, 0x7D21},
    {0xCBC3, 0x80AA},
    {0xCBC4, 0x81A8},
    {0xCBC5, 0x8B00},
    {0xCBC6, 0x8C8C},
    {0xCBC7, 0x8CBF},
    {0xCBC8, 0x927E},
    {0xCBC9, 0x9632},
    {0xCBCA, 0x5420},
    {0xCBCB, 0x982C},
    {0xCBCC, 0x5317},
    {0xCBCD, 0x50D5},
    {0xCBCE, 0x535C},
    {0xCBCF, 0x58A8},
    {0xCBD0, 0x64B2},
    {0xCBD1, 0x6734},
    {0xCBD2, 0x7267},
    {0xCBD3, 0x7766},
    {0xCBD4, 0x7A46},
    {0xCBD5, 0x91E6},
    {0xCBD6, 0x52C3},
    {0xCBD7, 0x6CA1},
    {0xCBD8, 0x6B86},
    {0xCBD9, 0x5800},
    {0xCBDA, 0x5E4C},
    {0xCBDB, 0x5954},
    {0xCBDC, 0x672C},
    {0xCBDD, 0x7FFB},
    {0xCBDE, 0x51E1},
    {0xCBDF, 0x76C6},
    {0xCBE0, 0x6469},
    {0xCBE1, 0x78E8},
    {0xCBE2, 0x9B54},
    {0xCBE3, 0x9EBB},
    {0xCBE4, 0x57CB},
    {0xCBE5, 0x59B9},
    {0xCBE6, 0x6627},
    {0xCBE7, 0x679A},
    {0xCBE8, 0x6BCE},
    {0xCBE9, 0x54E9},
    {0xCBEA, 0x69D9},
    {0xCBEB, 0x5E55},
    {0xCBEC, 0x819C},
    {0xCBED, 0x6795},
    {0xCBEE, 0x9BAA},
    {0xCBEF, 0x67FE},
    {0xCBF0, 0x9C52},
    {0xCBF1, 0x685D},
    {0xCBF2, 0x4EA6},
    {0xCBF3, 0x4FE3},
    {0xCBF4, 0x53C8},
    {0xCBF5, 0x62B9},
    {0xCBF6, 0x672B},
    {0xCBF7, 0x6CAB},
    {0xCBF8, 0x8FC4},
    {0xCBF9, 0x4FAD},
    {0xCBFA, 0x7E6D},
    {0xCBFB, 0x9EBF},
    {0xCBFC, 0x4E07},
    {0xCBFD, 0x6162},
    {0xCBFE, 0x6E80},
    {0xCCA1, 0x6F2B},
    {0xCCA2, 0x8513},
    {0xCCA3, 0x5473},
    {0xCCA4, 0x672A},
    {0xCCA5, 0x9B45},
    {0xCCA6, 0x5DF3},
    {0xCCA7, 0x7B95},
    {0xCCA8, 0x5CAC},
    {0xCCA9, 0x5BC6},
    {0xCCAA, 0x871C},
    {0xCCAB, 0x6E4A},
    {0xCCAC, 0x84D1},
    {0xCCAD, 0x7A14},
    {0xCCAE, 0x8108},
    {0xCCAF, 0x5999},
    {0xCCB0, 0x7C8D},
    {0xCCB1, 0x6C11},
    {0xCCB2, 0x7720},
    {0xCCB3, 0x52D9},
    {0xCCB4, 0x5922},
    {0xCCB5, 0x7121},
    {0xCCB6, 0x725F},
    {0xCCB7, 0x77DB},
    {0xCCB8, 0x9727},
    {0xCCB9, 0x9D61},
    {0xCCBA, 0x690B},
    {0xCCBB, 0x5A7F},
    {0xCCBC, 0x5A18},
    {0xCCBD, 0x51A5},
    {0xCCBE, 0x540D},
    {0xCCBF, 0x547D},
    {0xCCC0, 0x660E},
    {0xCCC1, 0x76DF},
    {0xCCC2, 0x8FF7},
    {0xCCC3, 0x9298},
    {0xCCC4, 0x9CF4},
    {0xCCC5, 0x59EA},
    {0xCCC6, 0x725D},
    {0xCCC7, 0x6EC5},
    {0xCCC8, 0x514D},
    {0xCCC9, 0x68C9},
    {0xCCCA, 0x7DBF},
    {0xCCCB, 0x7DEC},
    {0xCCCC, 0x9762},
    {0xCCCD, 0x9EBA},
    {0xCCCE, 0x6478},
    {0xCCCF, 0x6A21},
    {0xCCD0, 0x8302},
    {0xCCD1, 0x5984},
    {0xCCD2, 0x5B5F},
    {0xCCD3, 0x6BDB},
    {0xCCD4, 0x731B},
    {0xCCD5, 0x76F2},
    {0xCCD6, 0x7DB2},
    {0xCCD7, 0x8017},
    {0xCCD8, 0x8499},
    {0xCCD9, 0x5132},
    {0xCCDA, 0x6728},
    {0xCCDB, 0x9ED9},
    {0xCCDC, 0x76EE},
    {0xCCDD, 0x6762},
    {0xCCDE, 0x52FF},
    {0xCCDF, 0x9905},
    {0xCCE0, 0x5C24},
    {0xCCE1, 0x623B},
    {0xCCE2, 0x7C7E},
    {0xCCE3, 0x8CB0},
    {0xCCE4, 0x554F},
    {0xCCE5, 0x60B6},
    {0xCCE6, 0x7D0B},
    {0xCCE7, 0x9580},
    {0xCCE8, 0x5301},
    {0xCCE9, 0x4E5F},
    {0xCCEA, 0x51B6},
    {0xCCEB, 0x591C},
    {0xCCEC, 0x723A},
    {0xCCED, 0x8036},
    {0xCCEE, 0x91CE},
    {0xCCEF, 0x5F25},
    {0xCCF0, 0x77E2},
    {0xCCF1, 0x5384},
    {0xCCF2, 0x5F79},
    {0xCCF3, 0x7D04},
    {0xCCF4, 0x85AC},
    {0xCCF5, 0x8A33},
    {0xCCF6, 0x8E8D},
    {0xCCF7, 0x9756},
    {0xCCF8, 0x67F3},
    {0xCCF9, 0x85AE},
    {0xCCFA, 0x9453},
    {0xCCFB, 0x6109},
    {0xCCFC, 0x6108},
    {0xCCFD, 0x6CB9},
    {0xCCFE, 0x7652},
    {0xCDA1, 0x8AED},
    {0xCDA2, 0x8F38},
    {0xCDA3, 0x552F},
    {0xCDA4, 0x4F51},
    {0xCDA5, 0x512A},
    {0xCDA6, 0x52C7},
    {0xCDA7, 0x53CB},
    {0xCDA8, 0x5BA5},
    {0xCDA9, 0x5E7D},
    {0xCDAA, 0x60A0},
    {0xCDAB, 0x6182},
    {0xCDAC, 0x63D6},
    {0xCDAD, 0x6709},
    {0xCDAE, 0x67DA},
    {0xCDAF, 0x6E67},
    {0xCDB0, 0x6D8C},
    {0xCDB1, 0x7336},
    {0xCDB2, 0x7337},
    {0xCDB3, 0x7531},
    {0xCDB4, 0x7950},
    {0xCDB5, 0x88D5},
    {0xCDB6, 0x8A98},
    {0xCDB7, 0x904A},
    {0xCDB8, 0x9091},
    {0xCDB9, 0x90F5},
    {0xCDBA, 0x96C4},
    {0xCDBB, 0x878D},
    {0xCDBC, 0x5915},
    {0xCDBD, 0x4E88},
    {0xCDBE, 0x4F59},
    {0xCDBF, 0x4E0E},
    {0xCDC0, 0x8A89},
    {0xCDC1, 0x8F3F},
    {0xCDC2, 0x9810},
    {0xCDC3, 0x50AD},
    {0xCDC4, 0x5E7C},
    {0xCDC5, 0x5996},
    {0xCDC6, 0x5BB9},
    {0xCDC7, 0x5EB8},
    {0xCDC8, 0x63DA},
    {0xCDC9, 0x63FA},
    {0xCDCA, 0x64C1},
    {0xCDCB, 0x66DC},
    {0xCDCC, 0x694A},
    {0xCDCD, 0x69D8},
    {0xCDCE, 0x6D0B},
    {0xCDCF, 0x6EB6},
    {0xCDD0, 0x7194},
    {0xCDD1, 0x7528},
    {0xCDD2, 0x7AAF},
    {0xCDD3, 0x7F8A},
    {0xCDD4, 0x8000},
    {0xCDD5, 0x8449},
    {0xCDD6, 0x84C9},
    {0xCDD7, 0x8981},
    {0xCDD8, 0x8B21},
    {0xCDD9, 0x8E0A},
    {0xCDDA, 0x9065},
    {0xCDDB, 0x967D},
    {0xCDDC, 0x990A},
    {0xCDDD, 0x617E},
    {0xCDDE, 0x6291},
    {0xCDDF, 0x6B32},
    {0xCDE0, 0x6C83},
    {0xCDE1, 0x6D74},
    {0xCDE2, 0x7FCC},
    {0xCDE3, 0x7FFC},
    {0xCDE4, 0x6DC0},
    {0xCDE5, 0x7F85},
    {0xCDE6, 0x87BA},
    {0xCDE7, 0x88F8},
    {0xCDE8, 0x6765},
    {0xCDE9, 0x83B1},
    {0xCDEA, 0x983C},
    {0xCDEB, 0x96F7},
    {0xCDEC, 0x6D1B},
    {0xCDED, 0x7D61},
    {0xCDEE, 0x843D},
    {0xCDEF, 0x916A},
    {0xCDF0, 0x4E71},
    {0xCDF1, 0x5375},
    {0xCDF2, 0x5D50},
    {0xCDF3, 0x6B04},
    {0xCDF4, 0x6FEB},
    {0xCDF5, 0x85CD},
    {0xCDF6, 0x862D},
    {0xCDF7, 0x89A7},
    {0xCDF8, 0x5229},
    {0xCDF9, 0x540F},
    {0xCDFA, 0x5C65},
    {0xCDFB, 0x674E},
    {0xCDFC, 0x68A8},
    {0xCDFD, 0x7406},
    {0xCDFE, 0x7483},
    {0xCEA1, 0x75E2},
    {0xCEA2, 0x88CF},
    {0xCEA3, 0x88E1},
    {0xCEA4, 0x91CC},
    {0xCEA5, 0x96E2},
    {0xCEA6, 0x9678},
    {0xCEA7, 0x5F8B},
    {0xCEA8, 0x7387},
    {0xCEA9, 0x7ACB},
    {0xCEAA, 0x844E},
    {0xCEAB, 0x63A0},
    {0xCEAC, 0x7565},
    {0xCEAD, 0x5289},
    {0xCEAE, 0x6D41},
    {0xCEAF, 0x6E9C},
    {0xCEB0, 0x7409},
    {0xCEB1, 0x7559},
    {0xCEB2, 0x786B},
    {0xCEB3, 0x7C92},
    {0xCEB4, 0x9686},
    {0xCEB5, 0x7ADC},
    {0xCEB6, 0x9F8D},
    {0xCEB7, 0x4FB6},
    {0xCEB8, 0x616E},
    {0xCEB9, 0x65C5},
    {0xCEBA, 0x865C},
    {0xCEBB, 0x4E86},
    {0xCEBC, 0x4EAE},
    {0xCEBD, 0x50DA},
    {0xCEBE, 0x4E21},
    {0xCEBF, 0x51CC},
    {0xCEC0, 0x5BEE},
    {0xCEC1, 0x6599},
    {0xCEC2, 0x6881},
    {0xCEC3, 0x6DBC},
    {0xCEC4, 0x731F},
    {0xCEC5, 0x7642},
    {0xCEC6, 0x77AD},
    {0xCEC7, 0x7A1C},
    {0xCEC8, 0x7CE7},
    {0xCEC9, 0x826F},
    {0xCECA, 0x8AD2},
    {0xCECB, 0x907C},
    {0xCECC, 0x91CF},
    {0xCECD, 0x9675},
    {0xCECE, 0x9818},
    {0xCECF, 0x529B},
    {0xCED0, 0x7DD1},
    {0xCED1, 0x502B},
    {0xCED2, 0x5398},
    {0xCED3, 0x6797},
    {0xCED4, 0x6DCB},
    {0xCED5, 0x71D0},
    {0xCED6, 0x7433},
    {0xCED7, 0x81E8},
    {0xCED8, 0x8F2A},
    {0xCED9, 0x96A3},
    {0xCEDA, 0x9C57},
    {0xCEDB, 0x9E9F},
    {0xCEDC, 0x7460},
    {0xCEDD, 0x5841},
    {0xCEDE, 0x6D99},
    {0xCEDF, 0x7D2F},
    {0xCEE0, 0x985E},
    {0xCEE1, 0x4EE4},
    {0xCEE2, 0x4F36},
    {0xCEE3, 0x4F8B},
    {0xCEE4, 0x51B7},
    {0xCEE5, 0x52B1},
    {0xCEE6, 0x5DBA},
    {0xCEE7, 0x601C},
    {0xCEE8, 0x73B2},
    {0xCEE9, 0x793C},
    {0xCEEA, 0x82D3},
    {0xCEEB, 0x9234},
    {0xCEEC, 0x96B7},
    {0xCEED, 0x96F6},
    {0xCEEE, 0x970A},
    {0xCEEF, 0x9E97},
    {0xCEF0, 0x9F62},
    {0xCEF1, 0x66A6},
    {0xCEF2, 0x6B74},
    {0xCEF3, 0x5217},
    {0xCEF4, 0x52A3},
    {0xCEF5, 0x70C8},
    {0xCEF6, 0x88C2},
    {0xCEF7, 0x5EC9},
    {0xCEF8, 0x604B},
    {0xCEF9, 0x6190},
    {0xCEFA, 0x6F23},
    {0xCEFB, 0x7149},
    {0xCEFC, 0x7C3E},
    {0xCEFD, 0x7DF4},
    {0xCEFE, 0x806F},
    {0xCFA1, 0x84EE},
    {0xCFA2, 0x9023},
    {0xCFA3, 0x932C},
    {0xCFA4, 0x5442},
    {0xCFA5, 0x9B6F},
    {0xCFA6, 0x6AD3},
    {0xCFA7, 0x7089},
    {0xCFA8, 0x8CC2},
    {0xCFA9, 0x8DEF},
    {0xCFAA, 0x9732},
    {0xCFAB, 0x52B4},
    {0xCFAC, 0x5A41},
    {0xCFAD, 0x5ECA},
    {0xCFAE, 0x5F04},
    {0xCFAF, 0x6717},
    {0xCFB0, 0x697C},
    {0xCFB1, 0x6994},
    {0xCFB2, 0x6D6A},
    {0xCFB3, 0x6F0F},
    {0xCFB4, 0x7262},
    {0xCFB5, 0x72FC},
    {0xCFB6, 0x7BED},
    {0xCFB7, 0x8001},
    {0xCFB8, 0x807E},
    {0xCFB9, 0x874B},
    {0xCFBA, 0x90CE},
    {0xCFBB, 0x516D},
    {0xCFBC, 0x9E93},
    {0xCFBD, 0x7984},
    {0xCFBE, 0x808B},
    {0xCFBF, 0x9332},
    {0xCFC0, 0x8AD6},
    {0xCFC1, 0x502D},
    {0xCFC2, 0x548C},
    {0xCFC3, 0x8A71},
    {0xCFC4, 0x6B6A},
    {0xCFC5, 0x8CC4},
    {0xCFC6, 0x8107},
    {0xCFC7, 0x60D1},
    {0xCFC8, 0x67A0},
    {0xCFC9, 0x9DF2},
    {0xCFCA, 0x4E99},
    {0xCFCB, 0x4E98},
    {0xCFCC, 0x9C10},
    {0xCFCD, 0x8A6B},
    {0xCFCE, 0x85C1},
    {0xCFCF, 0x8568},
    {0xCFD0, 0x6900},
    {0xCFD1, 0x6E7E},
    {0xCFD2, 0x7897},
    {0xCFD3, 0x8155},
    {0xD0A1, 0x5F0C},
    {0xD0A2, 0x4E10},
    {0xD0A3, 0x4E15},
    {0xD0A4, 0x4E2A},
    {0xD0A5, 0x4E31},
    {0xD0A6, 0x4E36},
    {0xD0A7, 0x4E3C},
    {0xD0A8, 0x4E3F},
    {0xD0A9, 0x4E42},
    {0xD0AA, 0x4E56},
    {0xD0AB, 0x4E58},
    {0xD0AC, 0x4E82},
    {0xD0AD, 0x4E85},
    {0xD0AE, 0x8C6B},
    {0xD0AF, 0x4E8A},
    {0xD0B0, 0x8212},
    {0xD0B1, 0x5F0D},
    {0xD0B2, 0x4E8E},
    {0xD0B3, 0x4E9E},
    {0xD0B4, 0x4E9F},
    {0xD0B5, 0x4EA0},
    {0xD0B6, 0x4EA2},
    {0xD0B7, 0x4EB0},
    {0xD0B8, 0x4EB3},
    {0xD0B9, 0x4EB6},
    {0xD0BA, 0x4ECE},
    {0xD0BB, 0x4ECD},
    {0xD0BC, 0x4EC4},
    {0xD0BD, 0x4EC6},
    {0xD0BE, 0x4EC2},
    {0xD0BF, 0x4ED7},
    {0xD0C0, 0x4EDE},
    {0xD0C1, 0x4EED},
    {0xD0C2, 0x4EDF},
    {0xD0C3, 0x4EF7},
    {0xD0C4, 0x4F09},
    {0xD0C5, 0x4F5A},
    {0xD0C6, 0x4F30},
    {0xD0C7, 0x4F5B},
    {0xD0C8, 0x4F5D},
    {0xD0C9, 0x4F57},
    {0xD0CA, 0x4F47},
    {0xD0CB, 0x4F76},
    {0xD0CC, 0x4F88},
    {0xD0CD, 0x4F8F},
    {0xD0CE, 0x4F98},
    {0xD0CF, 0x4F7B},
    {0xD0D0, 0x4F69},
    {0xD0D1, 0x4F70},
    {0xD0D2, 0x4F91},
    {0xD0D3, 0x4F6F},
    {0xD0D4, 0x4F86},
    {0xD0D5, 0x4F96},
    {0xD0D6, 0x5118},
    {0xD0D7, 0x4FD4},
    {0xD0D8, 0x4FDF},
    {0xD0D9, 0x4FCE},
    {0xD0DA, 0x4FD8},
    {0xD0DB, 0x4FDB},
    {0xD0DC, 0x4FD1},
    {0xD0DD, 0x4FDA},
    {0xD0DE, 0x4FD0},
    {0xD0DF, 0x4FE4},
    {0xD0E0, 0x4FE5},
    {0xD0E1, 0x501A},
    {0xD0E2, 0x5028},
    {0xD0E3, 0x5014},
    {0xD0E4, 0x502A},
    {0xD0E5, 0x5025},
    {0xD0E6, 0x5005},
    {0xD0E7, 0x4F1C},
    {0xD0E8, 0x4FF6},
    {0xD0E9, 0x5021},
    {0xD0EA, 0x5029},
    {0xD0EB, 0x502C},
    {0xD0EC, 0x4FFE},
    {0xD0ED, 0x4FEF},
    {0xD0EE, 0x5011},
    {0xD0EF, 0x5006},
    {0xD0F0, 0x5043},
    {0xD0F1, 0x5047},
    {0xD0F2, 0x6703},
    {0xD0F3, 0x5055},
    {0xD0F4, 0x5050},
    {0xD0F5, 0x5048},
    {0xD0F6, 0x505A},
    {0xD0F7, 0x5056},
    {0xD0F8, 0x506C},
    {0xD0F9, 0x5078},
    {0xD0FA, 0x5080},
    {0xD0FB, 0x509A},
    {0xD0FC, 0x5085},
    {0xD0FD, 0x50B4},
    {0xD0FE, 0x50B2},
    {0xD1A1, 0x50C9},
    {0xD1A2, 0x50CA},
    {0xD1A3, 0x50B3},
    {0xD1A4, 0x50C2},
    {0xD1A5, 0x50D6},
    {0xD1A6, 0x50DE},
    {0xD1A7, 0x50E5},
    {0xD1A8, 0x50ED},
    {0xD1A9, 0x50E3},
    {0xD1AA, 0x50EE},
    {0xD1AB, 0x50F9},
    {0xD1AC, 0x50F5},
    {0xD1AD, 0x5109},
    {0xD1AE, 0x5101},
    {0xD1AF, 0x5102},
    {0xD1B0, 0x5116},
    {0xD1B1, 0x5115},
    {0xD1B2, 0x5114},
    {0xD1B3, 0x511A},
    {0xD1B4, 0x5121},
    {0xD1B5, 0x513A},
    {0xD1B6, 0x5137},
    {0xD1B7, 0x513C},
    {0xD1B8, 0x513B},
    {0xD1B9, 0x513F},
    {0xD1BA, 0x5140},
    {0xD1BB, 0x5152},
    {0xD1BC, 0x514C},
    {0xD1BD, 0x5154},
    {0xD1BE, 0x5162},
    {0xD1BF, 0x7AF8},
    {0xD1C0, 0x5169},
    {0xD1C1, 0x516A},
    {0xD1C2, 0x516E},
    {0xD1C3, 0x5180},
    {0xD1C4, 0x5182},
    {0xD1C5, 0x56D8},
    {0xD1C6, 0x518C},
    {0xD1C7, 0x5189},
    {0xD1C8, 0x518F},
    {0xD1C9, 0x5191},
    {0xD1CA, 0x5193},
    {0xD1CB, 0x5195},
    {0xD1CC, 0x5196},
    {0xD1CD, 0x51A4},
    {0xD1CE, 0x51A6},
    {0xD1CF, 0x51A2},
    {0xD1D0, 0x51A9},
    {0xD1D1, 0x51AA},
    {0xD1D2, 0x51AB},
    {0xD1D3, 0x51B3},
    {0xD1D4, 0x51B1},
    {0xD1D5, 0x51B2},
    {0xD1D6, 0x51B0},
    {0xD1D7, 0x51B5},
    {0xD1D8, 0x51BD},
    {0xD1D9, 0x51C5},
    {0xD1DA, 0x51C9},
    {0xD1DB, 0x51DB},
    {0xD1DC, 0x51E0},
    {0xD1DD, 0x8655},
    {0xD1DE, 0x51E9},
    {0xD1DF, 0x51ED},
    {0xD1E0, 0x51F0},
    {0xD1E1, 0x51F5},
    {0xD1E2, 0x51FE},
    {0xD1E3, 0x5204},
    {0xD1E4, 0x520B},
    {0xD1E5, 0x5214},
    {0xD1E6, 0x520E},
    {0xD1E7, 0x5227},
    {0xD1E8, 0x522A},
    {0xD1E9, 0x522E},
    {0xD1EA, 0x5233},
    {0xD1EB, 0x5239},
    {0xD1EC, 0x524F},
    {0xD1ED, 0x5244},
    {0xD1EE, 0x524B},
    {0xD1EF, 0x524C},
    {0xD1F0, 0x525E},
    {0xD1F1, 0x5254},
    {0xD1F2, 0x526A},
    {0xD1F3, 0x5274},
    {0xD1F4, 0x5269},
    {0xD1F5, 0x5273},
    {0xD1F6, 0x527F},
    {0xD1F7, 0x527D},
    {0xD1F8, 0x528D},
    {0xD1F9, 0x5294},
    {0xD1FA, 0x5292},
    {0xD1FB, 0x5271},
    {0xD1FC, 0x5288},
    {0xD1FD, 0x5291},
    {0xD1FE, 0x8FA8},
    {0xD2A1, 0x8FA7},
    {0xD2A2, 0x52AC},
    {0xD2A3, 0x52AD},
    {0xD2A4, 0x52BC},
    {0xD2A5, 0x52B5},
    {0xD2A6, 0x52C1},
    {0xD2A7, 0x52CD},
    {0xD2A8, 0x52D7},
    {0xD2A9, 0x52DE},
    {0xD2AA, 0x52E3},
    {0xD2AB, 0x52E6},
    {0xD2AC, 0x98ED},
    {0xD2AD, 0x52E0},
    {0xD2AE, 0x52F3},
    {0xD2AF, 0x52F5},
    {0xD2B0, 0x52F8},
    {0xD2B1, 0x52F9},
    {0xD2B2, 0x5306},
    {0xD2B3, 0x5308},
    {0xD2B4, 0x7538},
    {0xD2B5, 0x530D},
    {0xD2B6, 0x5310},
    {0xD2B7, 0x530F},
    {0xD2B8, 0x5315},
    {0xD2B9, 0x531A},
    {0xD2BA, 0x5323},
    {0xD2BB, 0x532F},
    {0xD2BC, 0x5331},
    {0xD2BD, 0x5333},
    {0xD2BE, 0x5338},
    {0xD2BF, 0x5340},
    {0xD2C0, 0x5346},
    {0xD2C1, 0x5345},
    {0xD2C2, 0x4E17},
    {0xD2C3, 0x5349},
    {0xD2C4, 0x534D},
    {0xD2C5, 0x51D6},
    {0xD2C6, 0x535E},
    {0xD2C7, 0x5369},
    {0xD2C8, 0x536E},
    {0xD2C9, 0x5918},
    {0xD2CA, 0x537B},
    {0xD2CB, 0x5377},
    {0xD2CC, 0x5382},
    {0xD2CD, 0x5396},
    {0xD2CE, 0x53A0},
    {0xD2CF, 0x53A6},
    {0xD2D0, 0x53A5},
    {0xD2D1, 0x53AE},
    {0xD2D2, 0x53B0},
    {0xD2D3, 0x53B6},
    {0xD2D4, 0x53C3},
    {0xD2D5, 0x7C12},
    {0xD2D6, 0x96D9},
    {0xD2D7, 0x53DF},
    {0xD2D8, 0x66FC},
    {0xD2D9, 0x71EE},
    {0xD2DA, 0x53EE},
    {0xD2DB, 0x53E8},
    {0xD2DC, 0x53ED},
    {0xD2DD, 0x53FA},
    {0xD2DE, 0x5401},
    {0xD2DF, 0x543D},
    {0xD2E0, 0x5440},
    {0xD2E1, 0x542C},
    {0xD2E2, 0x542D},
    {0xD2E3, 0x543C},
    {0xD2E4, 0x542E},
    {0xD2E5, 0x5436},
    {0xD2E6, 0x5429},
    {0xD2E7, 0x541D},
    {0xD2E8, 0x544E},
    {0xD2E9, 0x548F},
    {0xD2EA, 0x5475},
    {0xD2EB, 0x548E},
    {0xD2EC, 0x545F},
    {0xD2ED, 0x5471},
    {0xD2EE, 0x5477},
    {0xD2EF, 0x5470},
    {0xD2F0, 0x5492},
    {0xD2F1, 0x547B},
    {0xD2F2, 0x5480},
    {0xD2F3, 0x5476},
    {0xD2F4, 0x5484},
    {0xD2F5, 0x5490},
    {0xD2F6, 0x5486},
    {0xD2F7, 0x54C7},
    {0xD2F8, 0x54A2},
    {0xD2F9, 0x54B8},
    {0xD2FA, 0x54A5},
    {0xD2FB, 0x54AC},
    {0xD2FC, 0x54C4},
    {0xD2FD, 0x54C8},
    {0xD2FE, 0x54A8},
    {0xD3A1, 0x54AB},
    {0xD3A2, 0x54C2},
    {0xD3A3, 0x54A4},
    {0xD3A4, 0x54BE},
    {0xD3A5, 0x54BC},
    {0xD3A6, 0x54D8},
    {0xD3A7, 0x54E5},
    {0xD3A8, 0x54E6},
    {0xD3A9, 0x550F},
    {0xD3AA, 0x5514},
    {0xD3AB, 0x54FD},
    {0xD3AC, 0x54EE},
    {0xD3AD, 0x54ED},
    {0xD3AE, 0x54FA},
    {0xD3AF, 0x54E2},
    {0xD3B0, 0x5539},
    {0xD3B1, 0x5540},
    {0xD3B2, 0x5563},
    {0xD3B3, 0x554C},
    {0xD3B4, 0x552E},
    {0xD3B5, 0x555C},
    {0xD3B6, 0x5545},
    {0xD3B7, 0x5556},
    {0xD3B8, 0x5557},
    {0xD3B9, 0x5538},
    {0xD3BA, 0x5533},
    {0xD3BB, 0x555D},
    {0xD3BC, 0x5599},
    {0xD3BD, 0x5580},
    {0xD3BE, 0x54AF},
    {0xD3BF, 0x558A},
    {0xD3C0, 0x559F},
    {0xD3C1, 0x557B},
    {0xD3C2, 0x557E},
    {0xD3C3, 0x5598},
    {0xD3C4, 0x559E},
    {0xD3C5, 0x55AE},
    {0xD3C6, 0x557C},
    {0xD3C7, 0x5583},
    {0xD3C8, 0x55A9},
    {0xD3C9, 0x5587},
    {0xD3CA, 0x55A8},
    {0xD3CB, 0x55DA},
    {0xD3CC, 0x55C5},
    {0xD3CD, 0x55DF},
    {0xD3CE, 0x55C4},
    {0xD3CF, 0x55DC},
    {0xD3D0, 0x55E4},
    {0xD3D1, 0x55D4},
    {0xD3D2, 0x5614},
    {0xD3D3, 0x55F7},
    {0xD3D4, 0x5616},
    {0xD3D5, 0x55FE},
    {0xD3D6, 0x55FD},
    {0xD3D7, 0x561B},
    {0xD3D8, 0x55F9},
    {0xD3D9, 0x564E},
    {0xD3DA, 0x5650},
    {0xD3DB, 0x71DF},
    {0xD3DC, 0x5634},
    {0xD3DD, 0x5636},
    {0xD3DE, 0x5632},
    {0xD3DF, 0x5638},
    {0xD3E0, 0x566B},
    {0xD3E1, 0x5664},
    {0xD3E2, 0x562F},
    {0xD3E3, 0x566C},
    {0xD3E4, 0x566A},
    {0xD3E5, 0x5686},
    {0xD3E6, 0x5680},
    {0xD3E7, 0x568A},
    {0xD3E8, 0x56A0},
    {0xD3E9, 0x5694},
    {0xD3EA, 0x568F},
    {0xD3EB, 0x56A5},
    {0xD3EC, 0x56AE},
    {0xD3ED, 0x56B6},
    {0xD3EE, 0x56B4},
    {0xD3EF, 0x56C2},
    {0xD3F0, 0x56BC},
    {0xD3F1, 0x56C1},
    {0xD3F2, 0x56C3},
    {0xD3F3, 0x56C0},
    {0xD3F4, 0x56C8},
    {0xD3F5, 0x56CE},
    {0xD3F6, 0x56D1},
    {0xD3F7, 0x56D3},
    {0xD3F8, 0x56D7},
    {0xD3F9, 0x56EE},
    {0xD3FA, 0x56F9},
    {0xD3FB, 0x5700},
    {0xD3FC, 0x56FF},
    {0xD3FD, 0x5704},
    {0xD3FE, 0x5709},
    {0xD4A1, 0x5708},
    {0xD4A2, 0x570B},
    {0xD4A3, 0x570D},
    {0xD4A4, 0x5713},
    {0xD4A5, 0x5718},
    {0xD4A6, 0x5716},
    {0xD4A7, 0x55C7},
    {0xD4A8, 0x571C},
    {0xD4A9, 0x5726},
    {0xD4AA, 0x5737},
    {0xD4AB, 0x5738},
    {0xD4AC, 0x574E},
    {0xD4AD, 0x573B},
    {0xD4AE, 0x5740},
    {0xD4AF, 0x574F},
    {0xD4B0, 0x5769},
    {0xD4B1, 0x57C0},
    {0xD4B2, 0x5788},
    {0xD4B3, 0x5761},
    {0xD4B4, 0x577F},
    {0xD4B5, 0x5789},
    {0xD4B6, 0x5793},
    {0xD4B7, 0x57A0},
    {0xD4B8, 0x57B3},
    {0xD4B9, 0x57A4},
    {0xD4BA, 0x57AA},
    {0xD4BB, 0x57B0},
    {0xD4BC, 0x57C3},
    {0xD4BD, 0x57C6},
    {0xD4BE, 0x57D4},
    {0xD4BF, 0x57D2},
    {0xD4C0, 0x57D3},
    {0xD4C1, 0x580A},
    {0xD4C2, 0x57D6},
    {0xD4C3, 0x57E3},
    {0xD4C4, 0x580B},
    {0xD4C5, 0x5819},
    {0xD4C6, 0x581D},
    {0xD4C7, 0x5872},
    {0xD4C8, 0x5821},
    {0xD4C9, 0x5862},
    {0xD4CA, 0x584B},
    {0xD4CB, 0x5870},
    {0xD4CC, 0x6BC0},
    {0xD4CD, 0x5852},
    {0xD4CE, 0x583D},
    {0xD4CF, 0x5879},
    {0xD4D0, 0x5885},
    {0xD4D1, 0x58B9},
    {0xD4D2, 0x589F},
    {0xD4D3, 0x58AB},
    {0xD4D4, 0x58BA},
    {0xD4D5, 0x58DE},
    {0xD4D6, 0x58BB},
    {0xD4D7, 0x58B8},
    {0xD4D8, 0x58AE},
    {0xD4D9, 0x58C5},
    {0xD4DA, 0x58D3},
    {0xD4DB, 0x58D1},
    {0xD4DC, 0x58D7},
    {0xD4DD, 0x58D9},
    {0xD4DE, 0x58D8},
    {0xD4DF, 0x58E5},
    {0xD4E0, 0x58DC},
    {0xD4E1, 0x58E4},
    {0xD4E2, 0x58DF},
    {0xD4E3, 0x58EF},
    {0xD4E4, 0x58FA},
    {0xD4E5, 0x58F9},
    {0xD4E6, 0x58FB},
    {0xD4E7, 0x58FC},
    {0xD4E8, 0x58FD},
    {0xD4E9, 0x5902},
    {0xD4EA, 0x590A},
    {0xD4EB, 0x5910},
    {0xD4EC, 0x591B},
    {0xD4ED, 0x68A6},
    {0xD4EE, 0x5925},
    {0xD4EF, 0x592C},
    {0xD4F0, 0x592D},
    {0xD4F1, 0x5932},
    {0xD4F2, 0x5938},
    {0xD4F3, 0x593E},
    {0xD4F4, 0x7AD2},
    {0xD4F5, 0x5955},
    {0xD4F6, 0x5950},
    {0xD4F7, 0x594E},
    {0xD4F8, 0x595A},
    {0xD4F9, 0x5958},
    {0xD4FA, 0x5962},
    {0xD4FB, 0x5960},
    {0xD4FC, 0x5967},
    {0xD4FD, 0x596C},
    {0xD4FE, 0x5969},
    {0xD5A1, 0x5978},
    {0xD5A2, 0x5981},
    {0xD5A3, 0x599D},
    {0xD5A4, 0x4F5E},
    {0xD5A5, 0x4FAB},
    {0xD5A6, 0x59A3},
    {0xD5A7, 0x59B2},
    {0xD5A8, 0x59C6},
    {0xD5A9, 0x59E8},
    {0xD5AA, 0x59DC},
    {0xD5AB, 0x598D},
    {0xD5AC, 0x59D9},
    {0xD5AD, 0x59DA},
    {0xD5AE, 0x5A25},
    {0xD5AF, 0x5A1F},
    {0xD5B0, 0x5A11},
    {0xD5B1, 0x5A1C},
    {0xD5B2, 0x5A09},
    {0xD5B3, 0x5A1A},
    {0xD5B4, 0x5A40},
    {0xD5B5, 0x5A6C},
    {0xD5B6, 0x5A49},
    {0xD5B7, 0x5A35},
    {0xD5B8, 0x5A36},
    {0xD5B9, 0x5A62},
    {0xD5BA, 0x5A6A},
    {0xD5BB, 0x5A9A},
    {0xD5BC, 0x5ABC},
    {0xD5BD, 0x5ABE},
    {0xD5BE, 0x5ACB},
    {0xD5BF, 0x5AC2},
    {0xD5C0, 0x5ABD},
    {0xD5C1, 0x5AE3},
    {0xD5C2, 0x5AD7},
    {0xD5C3, 0x5AE6},
    {0xD5C4, 0x5AE9},
    {0xD5C5, 0x5AD6},
    {0xD5C6, 0x5AFA},
    {0xD5C7, 0x5AFB},
    {0xD5C8, 0x5B0C},
    {0xD5C9, 0x5B0B},
    {0xD5CA, 0x5B16},
    {0xD5CB, 0x5B32},
    {0xD5CC, 0x5AD0},
    {0xD5CD, 0x5B2A},
    {0xD5CE, 0x5B36},
    {0xD5CF, 0x5B3E},
    {0xD5D0, 0x5B43},
    {0xD5D1, 0x5B45},
    {0xD5D2, 0x5B40},
    {0xD5D3, 0x5B51},
    {0xD5D4, 0x5B55},
    {0xD5D5, 0x5B5A},
    {0xD5D6, 0x5B5B},
    {0xD5D7, 0x5B65},
    {0xD5D8, 0x5B69},
    {0xD5D9, 0x5B70},
    {0xD5DA, 0x5B73},
    {0xD5DB, 0x5B75},
    {0xD5DC, 0x5B78},
    {0xD5DD, 0x6588},
    {0xD5DE, 0x5B7A},
    {0xD5DF, 0x5B80},
    {0xD5E0, 0x5B83},
    {0xD5E1, 0x5BA6},
    {0xD5E2, 0x5BB8},
    {0xD5E3, 0x5BC3},
    {0xD5E4, 0x5BC7},
    {0xD5E5, 0x5BC9},
    {0xD5E6, 0x5BD4},
    {0xD5E7, 0x5BD0},
    {0xD5E8, 0x5BE4},
    {0xD5E9, 0x5BE6},
    {0xD5EA, 0x5BE2},
    {0xD5EB, 0x5BDE},
    {0xD5EC, 0x5BE5},
    {0xD5ED, 0x5BEB},
    {0xD5EE, 0x5BF0},
    {0xD5EF, 0x5BF6},
    {0xD5F0, 0x5BF3},
    {0xD5F1, 0x5C05},
    {0xD5F2, 0x5C07},
    {0xD5F3, 0x5C08},
    {0xD5F4, 0x5C0D},
    {0xD5F5, 0x5C13},
    {0xD5F6, 0x5C20},
    {0xD5F7, 0x5C22},
    {0xD5F8, 0x5C28},
    {0xD5F9, 0x5C38},
    {0xD5FA, 0x5C39},
    {0xD5FB, 0x5C41},
    {0xD5FC, 0x5C46},
    {0xD5FD, 0x5C4E},
    {0xD5FE, 0x5C53},
    {0xD6A1, 0x5C50},
    {0xD6A2, 0x5C4F},
    {0xD6A3, 0x5B71},
    {0xD6A4, 0x5C6C},
    {0xD6A5, 0x5C6E},
    {0xD6A6, 0x4E62},
    {0xD6A7, 0x5C76},
    {0xD6A8, 0x5C79},
    {0xD6A9, 0x5C8C},
    {0xD6AA, 0x5C91},
    {0xD6AB, 0x5C94},
    {0xD6AC, 0x599B},
    {0xD6AD, 0x5CAB},
    {0xD6AE, 0x5CBB},
    {0xD6AF, 0x5CB6},
    {0xD6B0, 0x5CBC},
    {0xD6B1, 0x5CB7},
    {0xD6B2, 0x5CC5},
    {0xD6B3, 0x5CBE},
    {0xD6B4, 0x5CC7},
    {0xD6B5, 0x5CD9},
    {0xD6B6, 0x5CE9},
    {0xD6B7, 0x5CFD},
    {0xD6B8, 0x5CFA},
    {0xD6B9, 0x5CED},
    {0xD6BA, 0x5D8C},
    {0xD6BB, 0x5CEA},
    {0xD6BC, 0x5D0B},
    {0xD6BD, 0x5D15},
    {0xD6BE, 0x5D17},
    {0xD6BF, 0x5D5C},
    {0xD6C0, 0x5D1F},
    {0xD6C1, 0x5D1B},
    {0xD6C2, 0x5D11},
    {0xD6C3, 0x5D14},
    {0xD6C4, 0x5D22},
    {0xD6C5, 0x5D1A},
    {0xD6C6, 0x5D19},
    {0xD6C7, 0x5D18},
    {0xD6C8, 0x5D4C},
    {0xD6C9, 0x5D52},
    {0xD6CA, 0x5D4E},
    {0xD6CB, 0x5D4B},
    {0xD6CC, 0x5D6C},
    {0xD6CD, 0x5D73},
    {0xD6CE, 0x5D76},
    {0xD6CF, 0x5D87},
    {0xD6D0, 0x5D84},
    {0xD6D1, 0x5D82},
    {0xD6D2, 0x5DA2},
    {0xD6D3, 0x5D9D},
    {0xD6D4, 0x5DAC},
    {0xD6D5, 0x5DAE},
    {0xD6D6, 0x5DBD},
    {0xD6D7, 0x5D90},
    {0xD6D8, 0x5DB7},
    {0xD6D9, 0x5DBC},
    {0xD6DA, 0x5DC9},
    {0xD6DB, 0x5DCD},
    {0xD6DC, 0x5DD3},
    {0xD6DD, 0x5DD2},
    {0xD6DE, 0x5DD6},
    {0xD6DF, 0x5DDB},
    {0xD6E0, 0x5DEB},
    {0xD6E1, 0x5DF2},
    {0xD6E2, 0x5DF5},
    {0xD6E3, 0x5E0B},
    {0xD6E4, 0x5E1A},
    {0xD6E5, 0x5E19},
    {0xD6E6, 0x5E11},
    {0xD6E7, 0x5E1B},
    {0xD6E8, 0x5E36},
    {0xD6E9, 0x5E37},
    {0xD6EA, 0x5E44},
    {0xD6EB, 0x5E43},
    {0xD6EC, 0x5E40},
    {0xD6ED, 0x5E4E},
    {0xD6EE, 0x5E57},
    {0xD6EF, 0x5E54},
    {0xD6F0, 0x5E5F},
    {0xD6F1, 0x5E62},
    {0xD6F2, 0x5E64},
    {0xD6F3, 0x5E47},
    {0xD6F4, 0x5E75},
    {0xD6F5, 0x5E76},
    {0xD6F6, 0x5E7A},
    {0xD6F7, 0x9EBC},
    {0xD6F8, 0x5E7F},
    {0xD6F9, 0x5EA0},
    {0xD6FA, 0x5EC1},
    {0xD6FB, 0x5EC2},
    {0xD6FC, 0x5EC8},
    {0xD6FD, 0x5ED0},
    {0xD6FE, 0x5ECF},
    {0xD7A1, 0x5ED6},
    {0xD7A2, 0x5EE3},
    {0xD7A3, 0x5EDD},
    {0xD7A4, 0x5EDA},
    {0xD7A5, 0x5EDB},
    {0xD7A6, 0x5EE2},
    {0xD7A7, 0x5EE1},
    {0xD7A8, 0x5EE8},
    {0xD7A9, 0x5EE9},
    {0xD7AA, 0x5EEC},
    {0xD7AB, 0x5EF1},
    {0xD7AC, 0x5EF3},
    {0xD7AD, 0x5EF0},
    {0xD7AE, 0x5EF4},
    {0xD7AF, 0x5EF8},
    {0xD7B0, 0x5EFE},
    {0xD7B1, 0x5F03},
    {0xD7B2, 0x5F09},
    {0xD7B3, 0x5F5D},
    {0xD7B4, 0x5F5C},
    {0xD7B5, 0x5F0B},
    {0xD7B6, 0x5F11},
    {0xD7B7, 0x5F16},
    {0xD7B8, 0x5F29},
    {0xD7B9, 0x5F2D},
    {0xD7BA, 0x5F38},
    {0xD7BB, 0x5F41},
    {0xD7BC, 0x5F48},
    {0xD7BD, 0x5F4C},
    {0xD7BE, 0x5F4E},
    {0xD7BF, 0x5F2F},
    {0xD7C0, 0x5F51},
    {0xD7C1, 0x5F56},
    {0xD7C2, 0x5F57},
    {0xD7C3, 0x5F59},
    {0xD7C4, 0x5F61},
    {0xD7C5, 0x5F6D},
    {0xD7C6, 0x5F73},
    {0xD7C7, 0x5F77},
    {0xD7C8, 0x5F83},
    {0xD7C9, 0x5F82},
    {0xD7CA, 0x5F7F},
    {0xD7CB, 0x5F8A},
    {0xD7CC, 0x5F88},
    {0xD7CD, 0x5F91},
    {0xD7CE, 0x5F87},
    {0xD7CF, 0x5F9E},
    {0xD7D0, 0x5F99},
    {0xD7D1, 0x5F98},
    {0xD7D2, 0x5FA0},
    {0xD7D3, 0x5FA8},
    {0xD7D4, 0x5FAD},
    {0xD7D5, 0x5FBC},
    {0xD7D6, 0x5FD6},
    {0xD7D7, 0x5FFB},
    {0xD7D8, 0x5FE4},
    {0xD7D9, 0x5FF8},
    {0xD7DA, 0x5FF1},
    {0xD7DB, 0x5FDD},
    {0xD7DC, 0x60B3},
    {0xD7DD, 0x5FFF},
    {0xD7DE, 0x6021},
    {0xD7DF, 0x6060},
    {0xD7E0, 0x6019},
    {0xD7E1, 0x6010},
    {0xD7E2, 0x6029},
    {0xD7E3, 0x600E},
    {0xD7E4, 0x6031},
    {0xD7E5, 0x601B},
    {0xD7E6, 0x6015},
    {0xD7E7, 0x602B},
    {0xD7E8, 0x6026},
    {0xD7E9, 0x600F},
    {0xD7EA, 0x603A},
    {0xD7EB, 0x605A},
    {0xD7EC, 0x6041},
    {0xD7ED, 0x606A},
    {0xD7EE, 0x6077},
    {0xD7EF, 0x605F},
    {0xD7F0, 0x604A},
    {0xD7F1, 0x6046},
    {0xD7F2, 0x604D},
    {0xD7F3, 0x6063},
    {0xD7F4, 0x6043},
    {0xD7F5, 0x6064},
    {0xD7F6, 0x6042},
    {0xD7F7, 0x606C},
    {0xD7F8, 0x606B},
    {0xD7F9, 0x6059},
    {0xD7FA, 0x6081},
    {0xD7FB, 0x608D},
    {0xD7FC, 0x60E7},
    {0xD7FD, 0x6083},
    {0xD7FE, 0x609A},
    {0xD8A1, 0x6084},
    {0xD8A2, 0x609B},
    {0xD8A3, 0x6096},
    {0xD8A4, 0x6097},
    {0xD8A5, 0x6092},
    {0xD8A6, 0x60A7},
    {0xD8A7, 0x608B},
    {0xD8A8, 0x60E1},
    {0xD8A9, 0x60B8},
    {0xD8AA, 0x60E0},
    {0xD8AB, 0x60D3},
    {0xD8AC, 0x60B4},
    {0xD8AD, 0x5FF0},
    {0xD8AE, 0x60BD},
    {0xD8AF, 0x60C6},
    {0xD8B0, 0x60B5},
    {0xD8B1, 0x60D8},
    {0xD8B2, 0x614D},
    {0xD8B3, 0x6115},
    {0xD8B4, 0x6106},
    {0xD8B5, 0x60F6},
    {0xD8B6, 0x60F7},
    {0xD8B7, 0x6100},
    {0xD8B8, 0x60F4},
    {0xD8B9, 0x60FA},
    {0xD8BA, 0x6103},
    {0xD8BB, 0x6121},
    {0xD8BC, 0x60FB},
    {0xD8BD, 0x60F1},
    {0xD8BE, 0x610D},
    {0xD8BF, 0x610E},
    {0xD8C0, 0x6147},
    {0xD8C1, 0x613E},
    {0xD8C2, 0x6128},
    {0xD8C3, 0x6127},
    {0xD8C4, 0x614A},
    {0xD8C5, 0x613F},
    {0xD8C6, 0x613C},
    {0xD8C7, 0x612C},
    {0xD8C8, 0x6134},
    {0xD8C9, 0x613D},
    {0xD8CA, 0x6142},
    {0xD8CB, 0x6144},
    {0xD8CC, 0x6173},
    {0xD8CD, 0x6177},
    {0xD8CE, 0x6158},
    {0xD8CF, 0x6159},
    {0xD8D0, 0x615A},
    {0xD8D1, 0x616B},
    {0xD8D2, 0x6174},
    {0xD8D3, 0x616F},
    {0xD8D4, 0x6165},
    {0xD8D5, 0x6171},
    {0xD8D6, 0x615F},
    {0xD8D7, 0x615D},
    {0xD8D8, 0x6153},
    {0xD8D9, 0x6175},
    {0xD8DA, 0x6199},
    {0xD8DB, 0x6196},
    {0xD8DC, 0x6187},
    {0xD8DD, 0x61AC},
    {0xD8DE, 0x6194},
    {0xD8DF, 0x619A},
    {0xD8E0, 0x618A},
    {0xD8E1, 0x6191},
    {0xD8E2, 0x61AB},
    {0xD8E3, 0x61AE},
    {0xD8E4, 0x61CC},
    {0xD8E5, 0x61CA},
    {0xD8E6, 0x61C9},
    {0xD8E7, 0x61F7},
    {0xD8E8, 0x61C8},
    {0xD8E9, 0x61C3},
    {0xD8EA, 0x61C6},
    {0xD8EB, 0x61BA},
    {0xD8EC, 0x61CB},
    {0xD8ED, 0x7F79},
    {0xD8EE, 0x61CD},
    {0xD8EF, 0x61E6},
    {0xD8F0, 0x61E3},
    {0xD8F1, 0x61F6},
    {0xD8F2, 0x61FA},
    {0xD8F3, 0x61F4},
    {0xD8F4, 0x61FF},
    {0xD8F5, 0x61FD},
    {0xD8F6, 0x61FC},
    {0xD8F7, 0x61FE},
    {0xD8F8, 0x6200},
    {0xD8F9, 0x6208},
    {0xD8FA, 0x6209},
    {0xD8FB, 0x620D},
    {0xD8FC, 0x620C},
    {0xD8FD, 0x6214},
    {0xD8FE, 0x621B},
    {0xD9A1, 0x621E},
    {0xD9A2, 0x6221},
    {0xD9A3, 0x622A},
    {0xD9A4, 0x622E},
    {0xD9A5, 0x6230},
    {0xD9A6, 0x6232},
    {0xD9A7, 0x6233},
    {0xD9A8, 0x6241},
    {0xD9A9, 0x624E},
    {0xD9AA, 0x625E},
    {0xD9AB, 0x6263},
    {0xD9AC, 0x625B},
    {0xD9AD, 0x6260},
    {0xD9AE, 0x6268},
    {0xD9AF, 0x627C},
    {0xD9B0, 0x6282},
    {0xD9B1, 0x6289},
    {0xD9B2, 0x627E},
    {0xD9B3, 0x6292},
    {0xD9B4, 0x6293},
    {0xD9B5, 0x6296},
    {0xD9B6, 0x62D4},
    {0xD9B7, 0x6283},
    {0xD9B8, 0x6294},
    {0xD9B9, 0x62D7},
    {0xD9BA, 0x62D1},
    {0xD9BB, 0x62BB},
    {0xD9BC, 0x62CF},
    {0xD9BD, 0x62FF},
    {0xD9BE, 0x62C6},
    {0xD9BF, 0x64D4},
    {0xD9C0, 0x62C8},
    {0xD9C1, 0x62DC},
    {0xD9C2, 0x62CC},
    {0xD9C3, 0x62CA},
    {0xD9C4, 0x62C2},
    {0xD9C5, 0x62C7},
    {0xD9C6, 0x629B},
    {0xD9C7, 0x62C9},
    {0xD9C8, 0x630C},
    {0xD9C9, 0x62EE},
    {0xD9CA, 0x62F1},
    {0xD9CB, 0x6327},
    {0xD9CC, 0x6302},
    {0xD9CD, 0x6308},
    {0xD9CE, 0x62EF},
    {0xD9CF, 0x62F5},
    {0xD9D0, 0x6350},
    {0xD9D1, 0x633E},
    {0xD9D2, 0x634D},
    {0xD9D3, 0x641C},
    {0xD9D4, 0x634F},
    {0xD9D5, 0x6396},
    {0xD9D6, 0x638E},
    {0xD9D7, 0x6380},
    {0xD9D8, 0x63AB},
    {0xD9D9, 0x6376},
    {0xD9DA, 0x63A3},
    {0xD9DB, 0x638F},
    {0xD9DC, 0x6389},
    {0xD9DD, 0x639F},
    {0xD9DE, 0x63B5},
    {0xD9DF, 0x636B},
    {0xD9E0, 0x6369},
    {0xD9E1, 0x63BE},
    {0xD9E2, 0x63E9},
    {0xD9E3, 0x63C0},
    {0xD9E4, 0x63C6},
    {0xD9E5, 0x63E3},
    {0xD9E6, 0x63C9},
    {0xD9E7, 0x63D2},
    {0xD9E8, 0x63F6},
    {0xD9E9, 0x63C4},
    {0xD9EA, 0x6416},
    {0xD9EB, 0x6434},
    {0xD9EC, 0x6406},
    {0xD9ED, 0x6413},
    {0xD9EE, 0x6426},
    {0xD9EF, 0x6436},
    {0xD9F0, 0x651D},
    {0xD9F1, 0x6417},
    {0xD9F2, 0x6428},
    {0xD9F3, 0x640F},
    {0xD9F4, 0x6467},
    {0xD9F5, 0x646F},
    {0xD9F6, 0x6476},
    {0xD9F7, 0x644E},
    {0xD9F8, 0x652A},
    {0xD9F9, 0x6495},
    {0xD9FA, 0x6493},
    {0xD9FB, 0x64A5},
    {0xD9FC, 0x64A9},
    {0xD9FD, 0x6488},
    {0xD9FE, 0x64BC},
    {0xDAA1, 0x64DA},
    {0xDAA2, 0x64D2},
    {0xDAA3, 0x64C5},
    {0xDAA4, 0x64C7},
    {0xDAA5, 0x64BB},
    {0xDAA6, 0x64D8},
    {0xDAA7, 0x64C2},
    {0xDAA8, 0x64F1},
    {0xDAA9, 0x64E7},
    {0xDAAA, 0x8209},
    {0xDAAB, 0x64E0},
    {0xDAAC, 0x64E1},
    {0xDAAD, 0x62AC},
    {0xDAAE, 0x64E3},
    {0xDAAF, 0x64EF},
    {0xDAB0, 0x652C},
    {0xDAB1, 0x64F6},
    {0xDAB2, 0x64F4},
    {0xDAB3, 0x64F2},
    {0xDAB4, 0x64FA},
    {0xDAB5, 0x6500},
    {0xDAB6, 0x64FD},
    {0xDAB7, 0x6518},
    {0xDAB8, 0x651C},
    {0xDAB9, 0x6505},
    {0xDABA, 0x6524},
    {0xDABB, 0x6523},
    {0xDABC, 0x652B},
    {0xDABD, 0x6534},
    {0xDABE, 0x6535},
    {0xDABF, 0x6537},
    {0xDAC0, 0x6536},
    {0xDAC1, 0x6538},
    {0xDAC2, 0x754B},
    {0xDAC3, 0x6548},
    {0xDAC4, 0x6556},
    {0xDAC5, 0x6555},
    {0xDAC6, 0x654D},
    {0xDAC7, 0x6558},
    {0xDAC8, 0x655E},
    {0xDAC9, 0x655D},
    {0xDACA, 0x6572},
    {0xDACB, 0x6578},
    {0xDACC, 0x6582},
    {0xDACD, 0x6583},
    {0xDACE, 0x8B8A},
    {0xDACF, 0x659B},
    {0xDAD0, 0x659F},
    {0xDAD1, 0x65AB},
    {0xDAD2, 0x65B7},
    {0xDAD3, 0x65C3},
    {0xDAD4, 0x65C6},
    {0xDAD5, 0x65C1},
    {0xDAD6, 0x65C4},
    {0xDAD7, 0x65CC},
    {0xDAD8, 0x65D2},
    {0xDAD9, 0x65DB},
    {0xDADA, 0x65D9},
    {0xDADB, 0x65E0},
    {0xDADC, 0x65E1},
    {0xDADD, 0x65F1},
    {0xDADE, 0x6772},
    {0xDADF, 0x660A},
    {0xDAE0, 0x6603},
    {0xDAE1, 0x65FB},
    {0xDAE2, 0x6773},
    {0xDAE3, 0x6635},
    {0xDAE4, 0x6636},
    {0xDAE5, 0x6634},
    {0xDAE6, 0x661C},
    {0xDAE7, 0x664F},
    {0xDAE8, 0x6644},
    {0xDAE9, 0x6649},
    {0xDAEA, 0x6641},
    {0xDAEB, 0x665E},
    {0xDAEC, 0x665D},
    {0xDAED, 0x6664},
    {0xDAEE, 0x6667},
    {0xDAEF, 0x6668},
    {0xDAF0, 0x665F},
    {0xDAF1, 0x6662},
    {0xDAF2, 0x6670},
    {0xDAF3, 0x6683},
    {0xDAF4, 0x6688},
    {0xDAF5, 0x668E},
    {0xDAF6, 0x6689},
    {0xDAF7, 0x6684},
    {0xDAF8, 0x6698},
    {0xDAF9, 0x669D},
    {0xDAFA, 0x66C1},
    {0xDAFB, 0x66B9},
    {0xDAFC, 0x66C9},
    {0xDAFD, 0x66BE},
    {0xDAFE, 0x66BC},
    {0xDBA1, 0x66C4},
    {0xDBA2, 0x66B8},
    {0xDBA3, 0x66D6},
    {0xDBA4, 0x66DA},
    {0xDBA5, 0x66E0},
    {0xDBA6, 0x663F},
    {0xDBA7, 0x66E6},
    {0xDBA8, 0x66E9},
    {0xDBA9, 0x66F0},
    {0xDBAA, 0x66F5},
    {0xDBAB, 0x66F7},
    {0xDBAC, 0x670F},
    {0xDBAD, 0x6716},
    {0xDBAE, 0x671E},
    {0xDBAF, 0x6726},
    {0xDBB0, 0x6727},
    {0xDBB1, 0x9738},
    {0xDBB2, 0x672E},
    {0xDBB3, 0x673F},
    {0xDBB4, 0x6736},
    {0xDBB5, 0x6741},
    {0xDBB6, 0x6738},
    {0xDBB7, 0x6737},
    {0xDBB8, 0x6746},
    {0xDBB9, 0x675E},
    {0xDBBA, 0x6760},
    {0xDBBB, 0x6759},
    {0xDBBC, 0x6763},
    {0xDBBD, 0x6764},
    {0xDBBE, 0x6789},
    {0xDBBF, 0x6770},
    {0xDBC0, 0x67A9},
    {0xDBC1, 0x677C},
    {0xDBC2, 0x676A},
    {0xDBC3, 0x678C},
    {0xDBC4, 0x678B},
    {0xDBC5, 0x67A6},
    {0xDBC6, 0x67A1},
    {0xDBC7, 0x6785},
    {0xDBC8, 0x67B7},
    {0xDBC9, 0x67EF},
    {0xDBCA, 0x67B4},
    {0xDBCB, 0x67EC},
    {0xDBCC, 0x67B3},
    {0xDBCD, 0x67E9},
    {0xDBCE, 0x67B8},
    {0xDBCF, 0x67E4},
    {0xDBD0, 0x67DE},
    {0xDBD1, 0x67DD},
    {0xDBD2, 0x67E2},
    {0xDBD3, 0x67EE},
    {0xDBD4, 0x67B9},
    {0xDBD5, 0x67CE},
    {0xDBD6, 0x67C6},
    {0xDBD7, 0x67E7},
    {0xDBD8, 0x6A9C},
    {0xDBD9, 0x681E},
    {0xDBDA, 0x6846},
    {0xDBDB, 0x6829},
    {0xDBDC, 0x6840},
    {0xDBDD, 0x684D},
    {0xDBDE, 0x6832},
    {0xDBDF, 0x684E},
    {0xDBE0, 0x68B3},
    {0xDBE1, 0x682B},
    {0xDBE2, 0x6859},
    {0xDBE3, 0x6863},
    {0xDBE4, 0x6877},
    {0xDBE5, 0x687F},
    {0xDBE6, 0x689F},
    {0xDBE7, 0x688F},
    {0xDBE8, 0x68AD},
    {0xDBE9, 0x6894},
    {0xDBEA, 0x689D},
    {0xDBEB, 0x689B},
    {0xDBEC, 0x6883},
    {0xDBED, 0x6AAE},
    {0xDBEE, 0x68B9},
    {0xDBEF, 0x6874},
    {0xDBF0, 0x68B5},
    {0xDBF1, 0x68A0},
    {0xDBF2, 0x68BA},
    {0xDBF3, 0x690F},
    {0xDBF4, 0x688D},
    {0xDBF5, 0x687E},
    {0xDBF6, 0x6901},
    {0xDBF7, 0x68CA},
    {0xDBF8, 0x6908},
    {0xDBF9, 0x68D8},
    {0xDBFA, 0x6922},
    {0xDBFB, 0x6926},
    {0xDBFC, 0x68E1},
    {0xDBFD, 0x690C},
    {0xDBFE, 0x68CD},
    {0xDCA1, 0x68D4},
    {0xDCA2, 0x68E7},
    {0xDCA3, 0x68D5},
    {0xDCA4, 0x6936},
    {0xDCA5, 0x6912},
    {0xDCA6, 0x6904},
    {0xDCA7, 0x68D7},
    {0xDCA8, 0x68E3},
    {0xDCA9, 0x6925},
    {0xDCAA, 0x68F9},
    {0xDCAB, 0x68E0},
    {0xDCAC, 0x68EF},
    {0xDCAD, 0x6928},
    {0xDCAE, 0x692A},
    {0xDCAF, 0x691A},
    {0xDCB0, 0x6923},
    {0xDCB1, 0x6921},
    {0xDCB2, 0x68C6},
    {0xDCB3, 0x6979},
    {0xDCB4, 0x6977},
    {0xDCB5, 0x695C},
    {0xDCB6, 0x6978},
    {0xDCB7, 0x696B},
    {0xDCB8, 0x6954},
    {0xDCB9, 0x697E},
    {0xDCBA, 0x696E},
    {0xDCBB, 0x6939},
    {0xDCBC, 0x6974},
    {0xDCBD, 0x693D},
    {0xDCBE, 0x6959},
    {0xDCBF, 0x6930},
    {0xDCC0, 0x6961},
    {0xDCC1, 0x695E},
    {0xDCC2, 0x695D},
    {0xDCC3, 0x6981},
    {0xDCC4, 0x696A},
    {0xDCC5, 0x69B2},
    {0xDCC6, 0x69AE},
    {0xDCC7, 0x69D0},
    {0xDCC8, 0x69BF},
    {0xDCC9, 0x69C1},
    {0xDCCA, 0x69D3},
    {0xDCCB, 0x69BE},
    {0xDCCC, 0x69CE},
    {0xDCCD, 0x5BE8},
    {0xDCCE, 0x69CA},
    {0xDCCF, 0x69DD},
    {0xDCD0, 0x69BB},
    {0xDCD1, 0x69C3},
    {0xDCD2, 0x69A7},
    {0xDCD3, 0x6A2E},
    {0xDCD4, 0x6991},
    {0xDCD5, 0x69A0},
    {0xDCD6, 0x699C},
    {0xDCD7, 0x6995},
    {0xDCD8, 0x69B4},
    {0xDCD9, 0x69DE},
    {0xDCDA, 0x69E8},
    {0xDCDB, 0x6A02},
    {0xDCDC, 0x6A1B},
    {0xDCDD, 0x69FF},
    {0xDCDE, 0x6B0A},
    {0xDCDF, 0x69F9},
    {0xDCE0, 0x69F2},
    {0xDCE1, 0x69E7},
    {0xDCE2, 0x6A05},
    {0xDCE3, 0x69B1},
    {0xDCE4, 0x6A1E},
    {0xDCE5, 0x69ED},
    {0xDCE6, 0x6A14},
    {0xDCE7, 0x69EB},
    {0xDCE8, 0x6A0A},
    {0xDCE9, 0x6A12},
    {0xDCEA, 0x6AC1},
    {0xDCEB, 0x6A23},
    {0xDCEC, 0x6A13},
    {0xDCED, 0x6A44},
    {0xDCEE, 0x6A0C},
    {0xDCEF, 0x6A72},
    {0xDCF0, 0x6A36},
    {0xDCF1, 0x6A78},
    {0xDCF2, 0x6A47},
    {0xDCF3, 0x6A62},
    {0xDCF4, 0x6A59},
    {0xDCF5, 0x6A66},
    {0xDCF6, 0x6A48},
    {0xDCF7, 0x6A38},
    {0xDCF8, 0x6A22},
    {0xDCF9, 0x6A90},
    {0xDCFA, 0x6A8D},
    {0xDCFB, 0x6AA0},
    {0xDCFC, 0x6A84},
    {0xDCFD, 0x6AA2},
    {0xDCFE, 0x6AA3},
    {0xDDA1, 0x6A97},
    {0xDDA2, 0x8617},
    {0xDDA3, 0x6ABB},
    {0xDDA4, 0x6AC3},
    {0xDDA5, 0x6AC2},
    {0xDDA6, 0x6AB8},
    {0xDDA7, 0x6AB3},
    {0xDDA8, 0x6AAC},
    {0xDDA9, 0x6ADE},
    {0xDDAA, 0x6AD1},
    {0xDDAB, 0x6ADF},
    {0xDDAC, 0x6AAA},
    {0xDDAD, 0x6ADA},
    {0xDDAE, 0x6AEA},
    {0xDDAF, 0x6AFB},
    {0xDDB0, 0x6B05},
    {0xDDB1, 0x8616},
    {0xDDB2, 0x6AFA},
    {0xDDB3, 0x6B12},
    {0xDDB4, 0x6B16},
    {0xDDB5, 0x9B31},
    {0xDDB6, 0x6B1F},
    {0xDDB7, 0x6B38},
    {0xDDB8, 0x6B37},
    {0xDDB9, 0x76DC},
    {0xDDBA, 0x6B39},
    {0xDDBB, 0x98EE},
    {0xDDBC, 0x6B47},
    {0xDDBD, 0x6B43},
    {0xDDBE, 0x6B49},
    {0xDDBF, 0x6B50},
    {0xDDC0, 0x6B59},
    {0xDDC1, 0x6B54},
    {0xDDC2, 0x6B5B},
    {0xDDC3, 0x6B5F},
    {0xDDC4, 0x6B61},
    {0xDDC5, 0x6B78},
    {0xDDC6, 0x6B79},
    {0xDDC7, 0x6B7F},
    {0xDDC8, 0x6B80},
    {0xDDC9, 0x6B84},
    {0xDDCA, 0x6B83},
    {0xDDCB, 0x6B8D},
    {0xDDCC, 0x6B98},
    {0xDDCD, 0x6B95},
    {0xDDCE, 0x6B9E},
    {0xDDCF, 0x6BA4},
    {0xDDD0, 0x6BAA},
    {0xDDD1, 0x6BAB},
    {0xDDD2, 0x6BAF},
    {0xDDD3, 0x6BB2},
    {0xDDD4, 0x6BB1},
    {0xDDD5, 0x6BB3},
    {0xDDD6, 0x6BB7},
    {0xDDD7, 0x6BBC},
    {0xDDD8, 0x6BC6},
    {0xDDD9, 0x6BCB},
    {0xDDDA, 0x6BD3},
    {0xDDDB, 0x6BDF},
    {0xDDDC, 0x6BEC},
    {0xDDDD, 0x6BEB},
    {0xDDDE, 0x6BF3},
    {0xDDDF, 0x6BEF},
    {0xDDE0, 0x9EBE},
    {0xDDE1, 0x6C08},
    {0xDDE2, 0x6C13},
    {0xDDE3, 0x6C14},
    {0xDDE4, 0x6C1B},
    {0xDDE5, 0x6C24},
    {0xDDE6, 0x6C23},
    {0xDDE7, 0x6C5E},
    {0xDDE8, 0x6C55},
    {0xDDE9, 0x6C62},
    {0xDDEA, 0x6C6A},
    {0xDDEB, 0x6C82},
    {0xDDEC, 0x6C8D},
    {0xDDED, 0x6C9A},
    {0xDDEE, 0x6C81},
    {0xDDEF, 0x6C9B},
    {0xDDF0, 0x6C7E},
    {0xDDF1, 0x6C68},
    {0xDDF2, 0x6C73},
    {0xDDF3, 0x6C92},
    {0xDDF4, 0x6C90},
    {0xDDF5, 0x6CC4},
    {0xDDF6, 0x6CF1},
    {0xDDF7, 0x6CD3},
    {0xDDF8, 0x6CBD},
    {0xDDF9, 0x6CD7},
    {0xDDFA, 0x6CC5},
    {0xDDFB, 0x6CDD},
    {0xDDFC, 0x6CAE},
    {0xDDFD, 0x6CB1},
    {0xDDFE, 0x6CBE},
    {0xDEA1, 0x6CBA},
    {0xDEA2, 0x6CDB},
    {0xDEA3, 0x6CEF},
    {0xDEA4, 0x6CD9},
    {0xDEA5, 0x6CEA},
    {0xDEA6, 0x6D1F},
    {0xDEA7, 0x884D},
    {0xDEA8, 0x6D36},
    {0xDEA9, 0x6D2B},
    {0xDEAA, 0x6D3D},
    {0xDEAB, 0x6D38},
    {0xDEAC, 0x6D19},
    {0xDEAD, 0x6D35},
    {0xDEAE, 0x6D33},
    {0xDEAF, 0x6D12},
    {0xDEB0, 0x6D0C},
    {0xDEB1, 0x6D63},
    {0xDEB2, 0x6D93},
    {0xDEB3, 0x6D64},
    {0xDEB4, 0x6D5A},
    {0xDEB5, 0x6D79},
    {0xDEB6, 0x6D59},
    {0xDEB7, 0x6D8E},
    {0xDEB8, 0x6D95},
    {0xDEB9, 0x6FE4},
    {0xDEBA, 0x6D85},
    {0xDEBB, 0x6DF9},
    {0xDEBC, 0x6E15},
    {0xDEBD, 0x6E0A},
    {0xDEBE, 0x6DB5},
    {0xDEBF, 0x6DC7},
    {0xDEC0, 0x6DE6},
    {0xDEC1, 0x6DB8},
    {0xDEC2, 0x6DC6},
    {0xDEC3, 0x6DEC},
    {0xDEC4, 0x6DDE},
    {0xDEC5, 0x6DCC},
    {0xDEC6, 0x6DE8},
    {0xDEC7, 0x6DD2},
    {0xDEC8, 0x6DC5},
    {0xDEC9, 0x6DFA},
    {0xDECA, 0x6DD9},
    {0xDECB, 0x6DE4},
    {0xDECC, 0x6DD5},
    {0xDECD, 0x6DEA},
    {0xDECE, 0x6DEE},
    {0xDECF, 0x6E2D},
    {0xDED0, 0x6E6E},
    {0xDED1, 0x6E2E},
    {0xDED2, 0x6E19},
    {0xDED3, 0x6E72},
    {0xDED4, 0x6E5F},
    {0xDED5, 0x6E3E},
    {0xDED6, 0x6E23},
    {0xDED7, 0x6E6B},
    {0xDED8, 0x6E2B},
    {0xDED9, 0x6E76},
    {0xDEDA, 0x6E4D},
    {0xDEDB, 0x6E1F},
    {0xDEDC, 0x6E43},
    {0xDEDD, 0x6E3A},
    {0xDEDE, 0x6E4E},
    {0xDEDF, 0x6E24},
    {0xDEE0, 0x6EFF},
    {0xDEE1, 0x6E1D},
    {0xDEE2, 0x6E38},
    {0xDEE3, 0x6E82},
    {0xDEE4, 0x6EAA},
    {0xDEE5, 0x6E98},
    {0xDEE6, 0x6EC9},
    {0xDEE7, 0x6EB7},
    {0xDEE8, 0x6ED3},
    {0xDEE9, 0x6EBD},
    {0xDEEA, 0x6EAF},
    {0xDEEB, 0x6EC4},
    {0xDEEC, 0x6EB2},
    {0xDEED, 0x6ED4},
    {0xDEEE, 0x6ED5},
    {0xDEEF, 0x6E8F},
    {0xDEF0, 0x6EA5},
    {0xDEF1, 0x6EC2},
    {0xDEF2, 0x6E9F},
    {0xDEF3, 0x6F41},
    {0xDEF4, 0x6F11},
    {0xDEF5, 0x704C},
    {0xDEF6, 0x6EEC},
    {0xDEF7, 0x6EF8},
    {0xDEF8, 0x6EFE},
    {0xDEF9, 0x6F3F},
    {0xDEFA, 0x6EF2},
    {0xDEFB, 0x6F31},
    {0xDEFC, 0x6EEF},
    {0xDEFD, 0x6F32},
    {0xDEFE, 0x6ECC},
    {0xDFA1, 0x6F3E},
    {0xDFA2, 0x6F13},
    {0xDFA3, 0x6EF7},
    {0xDFA4, 0x6F86},
    {0xDFA5, 0x6F7A},
    {0xDFA6, 0x6F78},
    {0xDFA7, 0x6F81},
    {0xDFA8, 0x6F80},
    {0xDFA9, 0x6F6F},
    {0xDFAA, 0x6F5B},
    {0xDFAB, 0x6FF3},
    {0xDFAC, 0x6F6D},
    {0xDFAD, 0x6F82},
    {0xDFAE, 0x6F7C},
    {0xDFAF, 0x6F58},
    {0xDFB0, 0x6F8E},
    {0xDFB1, 0x6F91},
    {0xDFB2, 0x6FC2},
    {0xDFB3, 0x6F66},
    {0xDFB4, 0x6FB3},
    {0xDFB5, 0x6FA3},
    {0xDFB6, 0x6FA1},
    {0xDFB7, 0x6FA4},
    {0xDFB8, 0x6FB9},
    {0xDFB9, 0x6FC6},
    {0xDFBA, 0x6FAA},
    {0xDFBB, 0x6FDF},
    {0xDFBC, 0x6FD5},
    {0xDFBD, 0x6FEC},
    {0xDFBE, 0x6FD4},
    {0xDFBF, 0x6FD8},
    {0xDFC0, 0x6FF1},
    {0xDFC1, 0x6FEE},
    {0xDFC2, 0x6FDB},
    {0xDFC3, 0x7009},
    {0xDFC4, 0x700B},
    {0xDFC5, 0x6FFA},
    {0xDFC6, 0x7011},
    {0xDFC7, 0x7001},
    {0xDFC8, 0x700F},
    {0xDFC9, 0x6FFE},
    {0xDFCA, 0x701B},
    {0xDFCB, 0x701A},
    {0xDFCC, 0x6F74},
    {0xDFCD, 0x701D},
    {0xDFCE, 0x7018},
    {0xDFCF, 0x701F},
    {0xDFD0, 0x7030},
    {0xDFD1, 0x703E},
    {0xDFD2, 0x7032},
    {0xDFD3, 0x7051},
    {0xDFD4, 0x7063},
    {0xDFD5, 0x7099},
    {0xDFD6, 0x7092},
    {0xDFD7, 0x70AF},
    {0xDFD8, 0x70F1},
    {0xDFD9, 0x70AC},
    {0xDFDA, 0x70B8},
    {0xDFDB, 0x70B3},
    {0xDFDC, 0x70AE},
    {0xDFDD, 0x70DF},
    {0xDFDE, 0x70CB},
    {0xDFDF, 0x70DD},
    {0xDFE0, 0x70D9},
    {0xDFE1, 0x7109},
    {0xDFE2, 0x70FD},
    {0xDFE3, 0x711C},
    {0xDFE4, 0x7119},
    {0xDFE5, 0x7165},
    {0xDFE6, 0x7155},
    {0xDFE7, 0x7188},
    {0xDFE8, 0x7166},
    {0xDFE9, 0x7162},
    {0xDFEA, 0x714C},
    {0xDFEB, 0x7156},
    {0xDFEC, 0x716C},
    {0xDFED, 0x718F},
    {0xDFEE, 0x71FB},
    {0xDFEF, 0x7184},
    {0xDFF0, 0x7195},
    {0xDFF1, 0x71A8},
    {0xDFF2, 0x71AC},
    {0xDFF3, 0x71D7},
    {0xDFF4, 0x71B9},
    {0xDFF5, 0x71BE},
    {0xDFF6, 0x71D2},
    {0xDFF7, 0x71C9},
    {0xDFF8, 0x71D4},
    {0xDFF9, 0x71CE},
    {0xDFFA, 0x71E0},
    {0xDFFB, 0x71EC},
    {0xDFFC, 0x71E7},
    {0xDFFD, 0x71F5},
    {0xDFFE, 0x71FC},
    {0xE0A1, 0x71F9},
    {0xE0A2, 0x71FF},
    {0xE0A3, 0x720D},
    {0xE0A4, 0x7210},
    {0xE0A5, 0x721B},
    {0xE0A6, 0x7228},
    {0xE0A7, 0x722D},
    {0xE0A8, 0x722C},
    {0xE0A9, 0x7230},
    {0xE0AA, 0x7232},
    {0xE0AB, 0x723B},
    {0xE0AC, 0x723C},
    {0xE0AD, 0x723F},
    {0xE0AE, 0x7240},
    {0xE0AF, 0x7246},
    {0xE0B0, 0x724B},
    {0xE0B1, 0x7258},
    {0xE0B2, 0x7274},
    {0xE0B3, 0x727E},
    {0xE0B4, 0x7282},
    {0xE0B5, 0x7281},
    {0xE0B6, 0x7287},
    {0xE0B7, 0x7292},
    {0xE0B8, 0x7296},
    {0xE0B9, 0x72A2},
    {0xE0BA, 0x72A7},
    {0xE0BB, 0x72B9},
    {0xE0BC, 0x72B2},
    {0xE0BD, 0x72C3},
    {0xE0BE, 0x72C6},
    {0xE0BF, 0x72C4},
    {0xE0C0, 0x72CE},
    {0xE0C1, 0x72D2},
    {0xE0C2, 0x72E2},
    {0xE0C3, 0x72E0},
    {0xE0C4, 0x72E1},
    {0xE0C5, 0x72F9},
    {0xE0C6, 0x72F7},
    {0xE0C7, 0x500F},
    {0xE0C8, 0x7317},
    {0xE0C9, 0x730A},
    {0xE0CA, 0x731C},
    {0xE0CB, 0x7316},
    {0xE0CC, 0x731D},
    {0xE0CD, 0x7334},
    {0xE0CE, 0x732F},
    {0xE0CF, 0x7329},
    {0xE0D0, 0x7325},
    {0xE0D1, 0x733E},
    {0xE0D2, 0x734E},
    {0xE0D3, 0x734F},
    {0xE0D4, 0x9ED8},
    {0xE0D5, 0x7357},
    {0xE0D6, 0x736A},
    {0xE0D7, 0x7368},
    {0xE0D8, 0x7370},
    {0xE0D9, 0x7378},
    {0xE0DA, 0x7375},
    {0xE0DB, 0x737B},
    {0xE0DC, 0x737A},
    {0xE0DD, 0x73C8},
    {0xE0DE, 0x73B3},
    {0xE0DF, 0x73CE},
    {0xE0E0, 0x73BB},
    {0xE0E1, 0x73C0},
    {0xE0E2, 0x73E5},
    {0xE0E3, 0x73EE},
    {0xE0E4, 0x73DE},
    {0xE0E5, 0x74A2},
    {0xE0E6, 0x7405},
    {0xE0E7, 0x746F},
    {0xE0E8, 0x7425},
    {0xE0E9, 0x73F8},
    {0xE0EA, 0x7432},
    {0xE0EB, 0x743A},
    {0xE0EC, 0x7455},
    {0xE0ED, 0x743F},
    {0xE0EE, 0x745F},
    {0xE0EF, 0x7459},
    {0xE0F0, 0x7441},
    {0xE0F1, 0x745C},
    {0xE0F2, 0x7469},
    {0xE0F3, 0x7470},
    {0xE0F4, 0x7463},
    {0xE0F5, 0x746A},
    {0xE0F6, 0x7476},
    {0xE0F7, 0x747E},
    {0xE0F8, 0x748B},
    {0xE0F9, 0x749E},
    {0xE0FA, 0x74A7},
    {0xE0FB, 0x74CA},
    {0xE0FC, 0x74CF},
    {0xE0FD, 0x74D4},
    {0xE0FE, 0x73F1},
    {0xE1A1, 0x74E0},
    {0xE1A2, 0x74E3},
    {0xE1A3, 0x74E7},
    {0xE1A4, 0x74E9},
    {0xE1A5, 0x74EE},
    {0xE1A6, 0x74F2},
    {0xE1A7, 0x74F0},
    {0xE1A8, 0x74F1},
    {0xE1A9, 0x74F8},
    {0xE1AA, 0x74F7},
    {0xE1AB, 0x7504},
    {0xE1AC, 0x7503},
    {0xE1AD, 0x7505},
    {0xE1AE, 0x750C},
    {0xE1AF, 0x750E},
    {0xE1B0, 0x750D},
    {0xE1B1, 0x7515},
    {0xE1B2, 0x7513},
    {0xE1B3, 0x751E},
    {0xE1B4, 0x7526},
    {0xE1B5, 0x752C},
    {0xE1B6, 0x753C},
    {0xE1B7, 0x7544},
    {0xE1B8, 0x754D},
    {0xE1B9, 0x754A},
    {0xE1BA, 0x7549},
    {0xE1BB, 0x755B},
    {0xE1BC, 0x7546},
    {0xE1BD, 0x755A},
    {0xE1BE, 0x7569},
    {0xE1BF, 0x7564},
    {0xE1C0, 0x7567},
    {0xE1C1, 0x756B},
    {0xE1C2, 0x756D},
    {0xE1C3, 0x7578},
    {0xE1C4, 0x7576},
    {0xE1C5, 0x7586},
    {0xE1C6, 0x7587},
    {0xE1C7, 0x7574},
    {0xE1C8, 0x758A},
    {0xE1C9, 0x7589},
    {0xE1CA, 0x7582},
    {0xE1CB, 0x7594},
    {0xE1CC, 0x759A},
    {0xE1CD, 0x759D},
    {0xE1CE, 0x75A5},
    {0xE1CF, 0x75A3},
    {0xE1D0, 0x75C2},
    {0xE1D1, 0x75B3},
    {0xE1D2, 0x75C3},
    {0xE1D3, 0x75B5},
    {0xE1D4, 0x75BD},
    {0xE1D5, 0x75B8},
    {0xE1D6, 0x75BC},
    {0xE1D7, 0x75B1},
    {0xE1D8, 0x75CD},
    {0xE1D9, 0x75CA},
    {0xE1DA, 0x75D2},
    {0xE1DB, 0x75D9},
    {0xE1DC, 0x75E3},
    {0xE1DD, 0x75DE},
    {0xE1DE, 0x75FE},
    {0xE1DF, 0x75FF},
    {0xE1E0, 0x75FC},
    {0xE1E1, 0x7601},
    {0xE1E2, 0x75F0},
    {0xE1E3, 0x75FA},
    {0xE1E4, 0x75F2},
    {0xE1E5, 0x75F3},
    {0xE1E6, 0x760B},
    {0xE1E7, 0x760D},
    {0xE1E8, 0x7609},
    {0xE1E9, 0x761F},
    {0xE1EA, 0x7627},
    {0xE1EB, 0x7620},
    {0xE1EC, 0x7621},
    {0xE1ED, 0x7622},
    {0xE1EE, 0x7624},
    {0xE1EF, 0x7634},
    {0xE1F0, 0x7630},
    {0xE1F1, 0x763B},
    {0xE1F2, 0x7647},
    {0xE1F3, 0x7648},
    {0xE1F4, 0x7646},
    {0xE1F5, 0x765C},
    {0xE1F6, 0x7658},
    {0xE1F7, 0x7661},
    {0xE1F8, 0x7662},
    {0xE1F9, 0x7668},
    {0xE1FA, 0x7669},
    {0xE1FB, 0x766A},
    {0xE1FC, 0x7667},
    {0xE1FD, 0x766C},
    {0xE1FE, 0x7670},
    {0xE2A1, 0x7672},
    {0xE2A2, 0x7676},
    {0xE2A3, 0x7678},
    {0xE2A4, 0x767C},
    {0xE2A5, 0x7680},
    {0xE2A6, 0x7683},
    {0xE2A7, 0x7688},
    {0xE2A8, 0x768B},
    {0xE2A9, 0x768E},
    {0xE2AA, 0x7696},
    {0xE2AB, 0x7693},
    {0xE2AC, 0x7699},
    {0xE2AD, 0x769A},
    {0xE2AE, 0x76B0},
    {0xE2AF, 0x76B4},
    {0xE2B0, 0x76B8},
    {0xE2B1, 0x76B9},
    {0xE2B2, 0x76BA},
    {0xE2B3, 0x76C2},
    {0xE2B4, 0x76CD},
    {0xE2B5, 0x76D6},
    {0xE2B6, 0x76D2},
    {0xE2B7, 0x76DE},
    {0xE2B8, 0x76E1},
    {0xE2B9, 0x76E5},
    {0xE2BA, 0x76E7},
    {0xE2BB, 0x76EA},
    {0xE2BC, 0x862F},
    {0xE2BD, 0x76FB},
    {0xE2BE, 0x7708},
    {0xE2BF, 0x7707},
    {0xE2C0, 0x7704},
    {0xE2C1, 0x7729},
    {0xE2C2, 0x7724},
    {0xE2C3, 0x771E},
    {0xE2C4, 0x7725},
    {0xE2C5, 0x7726},
    {0xE2C6, 0x771B},
    {0xE2C7, 0x7737},
    {0xE2C8, 0x7738},
    {0xE2C9, 0x7747},
    {0xE2CA, 0x775A},
    {0xE2CB, 0x7768},
    {0xE2CC, 0x776B},
    {0xE2CD, 0x775B},
    {0xE2CE, 0x7765},
    {0xE2CF, 0x777F},
    {0xE2D0, 0x777E},
    {0xE2D1, 0x7779},
    {0xE2D2, 0x778E},
    {0xE2D3, 0x778B},
    {0xE2D4, 0x7791},
    {0xE2D5, 0x77A0},
    {0xE2D6, 0x779E},
    {0xE2D7, 0x77B0},
    {0xE2D8, 0x77B6},
    {0xE2D9, 0x77B9},
    {0xE2DA, 0x77BF},
    {0xE2DB, 0x77BC},
    {0xE2DC, 0x77BD},
    {0xE2DD, 0x77BB},
    {0xE2DE, 0x77C7},
    {0xE2DF, 0x77CD},
    {0xE2E0, 0x77D7},
    {0xE2E1, 0x77DA},
    {0xE2E2, 0x77DC},
    {0xE2E3, 0x77E3},
    {0xE2E4, 0x77EE},
    {0xE2E5, 0x77FC},
    {0xE2E6, 0x780C},
    {0xE2E7, 0x7812},
    {0xE2E8, 0x7926},
    {0xE2E9, 0x7820},
    {0xE2EA, 0x792A},
    {0xE2EB, 0x7845},
    {0xE2EC, 0x788E},
    {0xE2ED, 0x7874},
    {0xE2EE, 0x7886},
    {0xE2EF, 0x787C},
    {0xE2F0, 0x789A},
    {0xE2F1, 0x788C},
    {0xE2F2, 0x78A3},
    {0xE2F3, 0x78B5},
    {0xE2F4, 0x78AA},
    {0xE2F5, 0x78AF},
    {0xE2F6, 0x78D1},
    {0xE2F7, 0x78C6},
    {0xE2F8, 0x78CB},
    {0xE2F9, 0x78D4},
    {0xE2FA, 0x78BE},
    {0xE2FB, 0x78BC},
    {0xE2FC, 0x78C5},
    {0xE2FD, 0x78CA},
    {0xE2FE, 0x78EC},
    {0xE3A1, 0x78E7},
    {0xE3A2, 0x78DA},
    {0xE3A3, 0x78FD},
    {0xE3A4, 0x78F4},
    {0xE3A5, 0x7907},
    {0xE3A6, 0x7912},
    {0xE3A7, 0x7911},
    {0xE3A8, 0x7919},
    {0xE3A9, 0x792C},
    {0xE3AA, 0x792B},
    {0xE3AB, 0x7940},
    {0xE3AC, 0x7960},
    {0xE3AD, 0x7957},
    {0xE3AE, 0x795F},
    {0xE3AF, 0x795A},
    {0xE3B0, 0x7955},
    {0xE3B1, 0x7953},
    {0xE3B2, 0x797A},
    {0xE3B3, 0x797F},
    {0xE3B4, 0x798A},
    {0xE3B5, 0x799D},
    {0xE3B6, 0x79A7},
    {0xE3B7, 0x9F4B},
    {0xE3B8, 0x79AA},
    {0xE3B9, 0x79AE},
    {0xE3BA, 0x79B3},
    {0xE3BB, 0x79B9},
    {0xE3BC, 0x79BA},
    {0xE3BD, 0x79C9},
    {0xE3BE, 0x79D5},
    {0xE3BF, 0x79E7},
    {0xE3C0, 0x79EC},
    {0xE3C1, 0x79E1},
    {0xE3C2, 0x79E3},
    {0xE3C3, 0x7A08},
    {0xE3C4, 0x7A0D},
    {0xE3C5, 0x7A18},
    {0xE3C6, 0x7A19},
    {0xE3C7, 0x7A20},
    {0xE3C8, 0x7A1F},
    {0xE3C9, 0x7980},
    {0xE3CA, 0x7A31},
    {0xE3CB, 0x7A3B},
    {0xE3CC, 0x7A3E},
    {0xE3CD, 0x7A37},
    {0xE3CE, 0x7A43},
    {0xE3CF, 0x7A57},
    {0xE3D0, 0x7A49},
    {0xE3D1, 0x7A61},
    {0xE3D2, 0x7A62},
    {0xE3D3, 0x7A69},
    {0xE3D4, 0x9F9D},
    {0xE3D5, 0x7A70},
    {0xE3D6, 0x7A79},
    {0xE3D7, 0x7A7D},
    {0xE3D8, 0x7A88},
    {0xE3D9, 0x7A97},
    {0xE3DA, 0x7A95},
    {0xE3DB, 0x7A98},
    {0xE3DC, 0x7A96},
    {0xE3DD, 0x7AA9},
    {0xE3DE, 0x7AC8},
    {0xE3DF, 0x7AB0},
    {0xE3E0, 0x7AB6},
    {0xE3E1, 0x7AC5},
    {0xE3E2, 0x7AC4},
    {0xE3E3, 0x7ABF},
    {0xE3E4, 0x9083},
    {0xE3E5, 0x7AC7},
    {0xE3E6, 0x7ACA},
    {0xE3E7, 0x7ACD},
    {0xE3E8, 0x7ACF},
    {0xE3E9, 0x7AD5},
    {0xE3EA, 0x7AD3},
    {0xE3EB, 0x7AD9},
    {0xE3EC, 0x7ADA},
    {0xE3ED, 0x7ADD},
    {0xE3EE, 0x7AE1},
    {0xE3EF, 0x7AE2},
    {0xE3F0, 0x7AE6},
    {0xE3F1, 0x7AED},
    {0xE3F2, 0x7AF0},
    {0xE3F3, 0x7B02},
    {0xE3F4, 0x7B0F},
    {0xE3F5, 0x7B0A},
    {0xE3F6, 0x7B06},
    {0xE3F7, 0x7B33},
    {0xE3F8, 0x7B18},
    {0xE3F9, 0x7B19},
    {0xE3FA, 0x7B1E},
    {0xE3FB, 0x7B35},
    {0xE3FC, 0x7B28},
    {0xE3FD, 0x7B36},
    {0xE3FE, 0x7B50},
    {0xE4A1, 0x7B7A},
    {0xE4A2, 0x7B04},
    {0xE4A3, 0x7B4D},
    {0xE4A4, 0x7B0B},
    {0xE4A5, 0x7B4C},
    {0xE4A6, 0x7B45},
    {0xE4A7, 0x7B75},
    {0xE4A8, 0x7B65},
    {0xE4A9, 0x7B74},
    {0xE4AA, 0x7B67},
    {0xE4AB, 0x7B70},
    {0xE4AC, 0x7B71},
    {0xE4AD, 0x7B6C},
    {0xE4AE, 0x7B6E},
    {0xE4AF, 0x7B9D},
    {0xE4B0, 0x7B98},
    {0xE4B1, 0x7B9F},
    {0xE4B2, 0x7B8D},
    {0xE4B3, 0x7B9C},
    {0xE4B4, 0x7B9A},
    {0xE4B5, 0x7B8B},
    {0xE4B6, 0x7B92},
    {0xE4B7, 0x7B8F},
    {0xE4B8, 0x7B5D},
    {0xE4B9, 0x7B99},
    {0xE4BA, 0x7BCB},
    {0xE4BB, 0x7BC1},
    {0xE4BC, 0x7BCC},
    {0xE4BD, 0x7BCF},
    {0xE4BE, 0x7BB4},
    {0xE4BF, 0x7BC6},
    {0xE4C0, 0x7BDD},
    {0xE4C1, 0x7BE9},
    {0xE4C2, 0x7C11},
    {0xE4C3, 0x7C14},
    {0xE4C4, 0x7BE6},
    {0xE4C5, 0x7BE5},
    {0xE4C6, 0x7C60},
    {0xE4C7, 0x7C00},
    {0xE4C8, 0x7C07},
    {0xE4C9, 0x7C13},
    {0xE4CA, 0x7BF3},
    {0xE4CB, 0x7BF7},
    {0xE4CC, 0x7C17},
    {0xE4CD, 0x7C0D},
    {0xE4CE, 0x7BF6},
    {0xE4CF, 0x7C23},
    {0xE4D0, 0x7C27},
    {0xE4D1, 0x7C2A},
    {0xE4D2, 0x7C1F},
    {0xE4D3, 0x7C37},
    {0xE4D4, 0x7C2B},
    {0xE4D5, 0x7C3D},
    {0xE4D6, 0x7C4C},
    {0xE4D7, 0x7C43},
    {0xE4D8, 0x7C54},
    {0xE4D9, 0x7C4F},
    {0xE4DA, 0x7C40},
    {0xE4DB, 0x7C50},
    {0xE4DC, 0x7C58},
    {0xE4DD, 0x7C5F},
    {0xE4DE, 0x7C64},
    {0xE4DF, 0x7C56},
    {0xE4E0, 0x7C65},
    {0xE4E1, 0x7C6C},
    {0xE4E2, 0x7C75},
    {0xE4E3, 0x7C83},
    {0xE4E4, 0x7C90},
    {0xE4E5, 0x7CA4},
    {0xE4E6, 0x7CAD},
    {0xE4E7, 0x7CA2},
    {0xE4E8, 0x7CAB},
    {0xE4E9, 0x7CA1},
    {0xE4EA, 0x7CA8},
    {0xE4EB, 0x7CB3},
    {0xE4EC, 0x7CB2},
    {0xE4ED, 0x7CB1},
    {0xE4EE, 0x7CAE},
    {0xE4EF, 0x7CB9},
    {0xE4F0, 0x7CBD},
    {0xE4F1, 0x7CC0},
    {0xE4F2, 0x7CC5},
    {0xE4F3, 0x7CC2},
    {0xE4F4, 0x7CD8},
    {0xE4F5, 0x7CD2},
    {0xE4F6, 0x7CDC},
    {0xE4F7, 0x7CE2},
    {0xE4F8, 0x9B3B},
    {0xE4F9, 0x7CEF},
    {0xE4FA, 0x7CF2},
    {0xE4FB, 0x7CF4},
    {0xE4FC, 0x7CF6},
    {0xE4FD, 0x7CFA},
    {0xE4FE, 0x7D06},
    {0xE5A1, 0x7D02},
    {0xE5A2, 0x7D1C},
    {0xE5A3, 0x7D15},
    {0xE5A4, 0x7D0A},
    {0xE5A5, 0x7D45},
    {0xE5A6, 0x7D4B},
    {0xE5A7, 0x7D2E},
    {0xE5A8, 0x7D32},
    {0xE5A9, 0x7D3F},
    {0xE5AA, 0x7D35},
    {0xE5AB, 0x7D46},
    {0xE5AC, 0x7D73},
    {0xE5AD, 0x7D56},
    {0xE5AE, 0x7D4E},
    {0xE5AF, 0x7D72},
    {0xE5B0, 0x7D68},
    {0xE5B1, 0x7D6E},
    {0xE5B2, 0x7D4F},
    {0xE5B3, 0x7D63},
    {0xE5B4, 0x7D93},
    {0xE5B5, 0x7D89},
    {0xE5B6, 0x7D5B},
    {0xE5B7, 0x7D8F},
    {0xE5B8, 0x7D7D},
    {0xE5B9, 0x7D9B},
    {0xE5BA, 0x7DBA},
    {0xE5BB, 0x7DAE},
    {0xE5BC, 0x7DA3},
    {0xE5BD, 0x7DB5},
    {0xE5BE, 0x7DC7},
    {0xE5BF, 0x7DBD},
    {0xE5C0, 0x7DAB},
    {0xE5C1, 0x7E3D},
    {0xE5C2, 0x7DA2},
    {0xE5C3, 0x7DAF},
    {0xE5C4, 0x7DDC},
    {0xE5C5, 0x7DB8},
    {0xE5C6, 0x7D9F},
    {0xE5C7, 0x7DB0},
    {0xE5C8, 0x7DD8},
    {0xE5C9, 0x7DDD},
    {0xE5CA, 0x7DE4},
    {0xE5CB, 0x7DDE},
    {0xE5CC, 0x7DFB},
    {0xE5CD, 0x7DF2},
    {0xE5CE, 0x7DE1},
    {0xE5CF, 0x7E05},
    {0xE5D0, 0x7E0A},
    {0xE5D1, 0x7E23},
    {0xE5D2, 0x7E21},
    {0xE5D3, 0x7E12},
    {0xE5D4, 0x7E31},
    {0xE5D5, 0x7E1F},
    {0xE5D6, 0x7E09},
    {0xE5D7, 0x7E0B},
    {0xE5D8, 0x7E22},
    {0xE5D9, 0x7E46},
    {0xE5DA, 0x7E66},
    {0xE5DB, 0x7E3B},
    {0xE5DC, 0x7E35},
    {0xE5DD, 0x7E39},
    {0xE5DE, 0x7E43},
    {0xE5DF, 0x7E37},
    {0xE5E0, 0x7E32},
    {0xE5E1, 0x7E3A},
    {0xE5E2, 0x7E67},
    {0xE5E3, 0x7E5D},
    {0xE5E4, 0x7E56},
    {0xE5E5, 0x7E5E},
    {0xE5E6, 0x7E59},
    {0xE5E7, 0x7E5A},
    {0xE5E8, 0x7E79},
    {0xE5E9, 0x7E6A},
    {0xE5EA, 0x7E69},
    {0xE5EB, 0x7E7C},
    {0xE5EC, 0x7E7B},
    {0xE5ED, 0x7E83},
    {0xE5EE, 0x7DD5},
    {0xE5EF, 0x7E7D},
    {0xE5F0, 0x8FAE},
    {0xE5F1, 0x7E7F},
    {0xE5F2, 0x7E88},
    {0xE5F3, 0x7E89},
    {0xE5F4, 0x7E8C},
    {0xE5F5, 0x7E92},
    {0xE5F6, 0x7E90},
    {0xE5F7, 0x7E93},
    {0xE5F8, 0x7E94},
    {0xE5F9, 0x7E96},
    {0xE5FA, 0x7E8E},
    {0xE5FB, 0x7E9B},
    {0xE5FC, 0x7E9C},
    {0xE5FD, 0x7F38},
    {0xE5FE, 0x7F3A},
    {0xE6A1, 0x7F45},
    {0xE6A2, 0x7F4C},
    {0xE6A3, 0x7F4D},
    {0xE6A4, 0x7F4E},
    {0xE6A5, 0x7F50},
    {0xE6A6, 0x7F51},
    {0xE6A7, 0x7F55},
    {0xE6A8, 0x7F54},
    {0xE6A9, 0x7F58},
    {0xE6AA, 0x7F5F},
    {0xE6AB, 0x7F60},
    {0xE6AC, 0x7F68},
    {0xE6AD, 0x7F69},
    {0xE6AE, 0x7F67},
    {0xE6AF, 0x7F78},
    {0xE6B0, 0x7F82},
    {0xE6B1, 0x7F86},
    {0xE6B2, 0x7F83},
    {0xE6B3, 0x7F88},
    {0xE6B4, 0x7F87},
    {0xE6B5, 0x7F8C},
    {0xE6B6, 0x7F94},
    {0xE6B7, 0x7F9E},
    {0xE6B8, 0x7F9D},
    {0xE6B9, 0x7F9A},
    {0xE6BA, 0x7FA3},
    {0xE6BB, 0x7FAF},
    {0xE6BC, 0x7FB2},
    {0xE6BD, 0x7FB9},
    {0xE6BE, 0x7FAE},
    {0xE6BF, 0x7FB6},
    {0xE6C0, 0x7FB8},
    {0xE6C1, 0x8B71},
    {0xE6C2, 0x7FC5},
    {0xE6C3, 0x7FC6},
    {0xE6C4, 0x7FCA},
    {0xE6C5, 0x7FD5},
    {0xE6C6, 0x7FD4},
    {0xE6C7, 0x7FE1},
    {0xE6C8, 0x7FE6},
    {0xE6C9, 0x7FE9},
    {0xE6CA, 0x7FF3},
    {0xE6CB, 0x7FF9},
    {0xE6CC, 0x98DC},
    {0xE6CD, 0x8006},
    {0xE6CE, 0x8004},
    {0xE6CF, 0x800B},
    {0xE6D0, 0x8012},
    {0xE6D1, 0x8018},
    {0xE6D2, 0x8019},
    {0xE6D3, 0x801C},
    {0xE6D4, 0x8021},
    {0xE6D5, 0x8028},
    {0xE6D6, 0x803F},
    {0xE6D7, 0x803B},
    {0xE6D8, 0x804A},
    {0xE6D9, 0x8046},
    {0xE6DA, 0x8052},
    {0xE6DB, 0x8058},
    {0xE6DC, 0x805A},
    {0xE6DD, 0x805F},
    {0xE6DE, 0x8062},
    {0xE6DF, 0x8068},
    {0xE6E0, 0x8073},
    {0xE6E1, 0x8072},
    {0xE6E2, 0x8070},
    {0xE6E3, 0x8076},
    {0xE6E4, 0x8079},
    {0xE6E5, 0x807D},
    {0xE6E6, 0x807F},
    {0xE6E7, 0x8084},
    {0xE6E8, 0x8086},
    {0xE6E9, 0x8085},
    {0xE6EA, 0x809B},
    {0xE6EB, 0x8093},
    {0xE6EC, 0x809A},
    {0xE6ED, 0x80AD},
    {0xE6EE, 0x5190},
    {0xE6EF, 0x80AC},
    {0xE6F0, 0x80DB},
    {0xE6F1, 0x80E5},
    {0xE6F2, 0x80D9},
    {0xE6F3, 0x80DD},
    {0xE6F4, 0x80C4},
    {0xE6F5, 0x80DA},
    {0xE6F6, 0x80D6},
    {0xE6F7, 0x8109},
    {0xE6F8, 0x80EF},
    {0xE6F9, 0x80F1},
    {0xE6FA, 0x811B},
    {0xE6FB, 0x8129},
    {0xE6FC, 0x8123},
    {0xE6FD, 0x812F},
    {0xE6FE, 0x814B},
    {0xE7A1, 0x968B},
    {0xE7A2, 0x8146},
    {0xE7A3, 0x813E},
    {0xE7A4, 0x8153},
    {0xE7A5, 0x8151},
    {0xE7A6, 0x80FC},
    {0xE7A7, 0x8171},
    {0xE7A8, 0x816E},
    {0xE7A9, 0x8165},
    {0xE7AA, 0x8166},
    {0xE7AB, 0x8174},
    {0xE7AC, 0x8183},
    {0xE7AD, 0x8188},
    {0xE7AE, 0x818A},
    {0xE7AF, 0x8180},
    {0xE7B0, 0x8182},
    {0xE7B1, 0x81A0},
    {0xE7B2, 0x8195},
    {0xE7B3, 0x81A4},
    {0xE7B4, 0x81A3},
    {0xE7B5, 0x815F},
    {0xE7B6, 0x8193},
    {0xE7B7, 0x81A9},
    {0xE7B8, 0x81B0},
    {0xE7B9, 0x81B5},
    {0xE7BA, 0x81BE},
    {0xE7BB, 0x81B8},
    {0xE7BC, 0x81BD},
    {0xE7BD, 0x81C0},
    {0xE7BE, 0x81C2},
    {0xE7BF, 0x81BA},
    {0xE7C0, 0x81C9},
    {0xE7C1, 0x81CD},
    {0xE7C2, 0x81D1},
    {0xE7C3, 0x81D9},
    {0xE7C4, 0x81D8},
    {0xE7C5, 0x81C8},
    {0xE7C6, 0x81DA},
    {0xE7C7, 0x81DF},
    {0xE7C8, 0x81E0},
    {0xE7C9, 0x81E7},
    {0xE7CA, 0x81FA},
    {0xE7CB, 0x81FB},
    {0xE7CC, 0x81FE},
    {0xE7CD, 0x8201},
    {0xE7CE, 0x8202},
    {0xE7CF, 0x8205},
    {0xE7D0, 0x8207},
    {0xE7D1, 0x820A},
    {0xE7D2, 0x820D},
    {0xE7D3, 0x8210},
    {0xE7D4, 0x8216},
    {0xE7D5, 0x8229},
    {0xE7D6, 0x822B},
    {0xE7D7, 0x8238},
    {0xE7D8, 0x8233},
    {0xE7D9, 0x8240},
    {0xE7DA, 0x8259},
    {0xE7DB, 0x8258},
    {0xE7DC, 0x825D},
    {0xE7DD, 0x825A},
    {0xE7DE, 0x825F},
    {0xE7DF, 0x8264},
    {0xE7E0, 0x8262},
    {0xE7E1, 0x8268},
    {0xE7E2, 0x826A},
    {0xE7E3, 0x826B},
    {0xE7E4, 0x822E},
    {0xE7E5, 0x8271},
    {0xE7E6, 0x8277},
    {0xE7E7, 0x8278},
    {0xE7E8, 0x827E},
    {0xE7E9, 0x828D},
    {0xE7EA, 0x8292},
    {0xE7EB, 0x82AB},
    {0xE7EC, 0x829F},
    {0xE7ED, 0x82BB},
    {0xE7EE, 0x82AC},
    {0xE7EF, 0x82E1},
    {0xE7F0, 0x82E3},
    {0xE7F1, 0x82DF},
    {0xE7F2, 0x82D2},
    {0xE7F3, 0x82F4},
    {0xE7F4, 0x82F3},
    {0xE7F5, 0x82FA},
    {0xE7F6, 0x8393},
    {0xE7F7, 0x8303},
    {0xE7F8, 0x82FB},
    {0xE7F9, 0x82F9},
    {0xE7FA, 0x82DE},
    {0xE7FB, 0x8306},
    {0xE7FC, 0x82DC},
    {0xE7FD, 0x8309},
    {0xE7FE, 0x82D9},
    {0xE8A1, 0x8335},
    {0xE8A2, 0x8334},
    {0xE8A3, 0x8316},
    {0xE8A4, 0x8332},
    {0xE8A5, 0x8331},
    {0xE8A6, 0x8340},
    {0xE8A7, 0x8339},
    {0xE8A8, 0x8350},
    {0xE8A9, 0x8345},
    {0xE8AA, 0x832F},
    {0xE8AB, 0x832B},
    {0xE8AC, 0x8317},
    {0xE8AD, 0x8318},
    {0xE8AE, 0x8385},
    {0xE8AF, 0x839A},
    {0xE8B0, 0x83AA},
    {0xE8B1, 0x839F},
    {0xE8B2, 0x83A2},
    {0xE8B3, 0x8396},
    {0xE8B4, 0x8323},
    {0xE8B5, 0x838E},
    {0xE8B6, 0x8387},
    {0xE8B7, 0x838A},
    {0xE8B8, 0x837C},
    {0xE8B9, 0x83B5},
    {0xE8BA, 0x8373},
    {0xE8BB, 0x8375},
    {0xE8BC, 0x83A0},
    {0xE8BD, 0x8389},
    {0xE8BE, 0x83A8},
    {0xE8BF, 0x83F4},
    {0xE8C0, 0x8413},
    {0xE8C1, 0x83EB},
    {0xE8C2, 0x83CE},
    {0xE8C3, 0x83FD},
    {0xE8C4, 0x8403},
    {0xE8C5, 0x83D8},
    {0xE8C6, 0x840B},
    {0xE8C7, 0x83C1},
    {0xE8C8, 0x83F7},
    {0xE8C9, 0x8407},
    {0xE8CA, 0x83E0},
    {0xE8CB, 0x83F2},
    {0xE8CC, 0x840D},
    {0xE8CD, 0x8422},
    {0xE8CE, 0x8420},
    {0xE8CF, 0x83BD},
    {0xE8D0, 0x8438},
    {0xE8D1, 0x8506},
    {0xE8D2, 0x83FB},
    {0xE8D3, 0x846D},
    {0xE8D4, 0x842A},
    {0xE8D5, 0x843C},
    {0xE8D6, 0x855A},
    {0xE8D7, 0x8484},
    {0xE8D8, 0x8477},
    {0xE8D9, 0x846B},
    {0xE8DA, 0x84AD},
    {0xE8DB, 0x846E},
    {0xE8DC, 0x8482},
    {0xE8DD, 0x8469},
    {0xE8DE, 0x8446},
    {0xE8DF, 0x842C},
    {0xE8E0, 0x846F},
    {0xE8E1, 0x8479},
    {0xE8E2, 0x8435},
    {0xE8E3, 0x84CA},
    {0xE8E4, 0x8462},
    {0xE8E5, 0x84B9},
    {0xE8E6, 0x84BF},
    {0xE8E7, 0x849F},
    {0xE8E8, 0x84D9},
    {0xE8E9, 0x84CD},
    {0xE8EA, 0x84BB},
    {0xE8EB, 0x84DA},
    {0xE8EC, 0x84D0},
    {0xE8ED, 0x84C1},
    {0xE8EE, 0x84C6},
    {0xE8EF, 0x84D6},
    {0xE8F0, 0x84A1},
    {0xE8F1, 0x8521},
    {0xE8F2, 0x84FF},
    {0xE8F3, 0x84F4},
    {0xE8F4, 0x8517},
    {0xE8F5, 0x8518},
    {0xE8F6, 0x852C},
    {0xE8F7, 0x851F},
    {0xE8F8, 0x8515},
    {0xE8F9, 0x8514},
    {0xE8FA, 0x84FC},
    {0xE8FB, 0x8540},
    {0xE8FC, 0x8563},
    {0xE8FD, 0x8558},
    {0xE8FE, 0x8548},
    {0xE9A1, 0x8541},
    {0xE9A2, 0x8602},
    {0xE9A3, 0x854B},
    {0xE9A4, 0x8555},
    {0xE9A5, 0x8580},
    {0xE9A6, 0x85A4},
    {0xE9A7, 0x8588},
    {0xE9A8, 0x8591},
    {0xE9A9, 0x858A},
    {0xE9AA, 0x85A8},
    {0xE9AB, 0x856D},
    {0xE9AC, 0x8594},
    {0xE9AD, 0x859B},
    {0xE9AE, 0x85EA},
    {0xE9AF, 0x8587},
    {0xE9B0, 0x859C},
    {0xE9B1, 0x8577},
    {0xE9B2, 0x857E},
    {0xE9B3, 0x8590},
    {0xE9B4, 0x85C9},
    {0xE9B5, 0x85BA},
    {0xE9B6, 0x85CF},
    {0xE9B7, 0x85B9},
    {0xE9B8, 0x85D0},
    {0xE9B9, 0x85D5},
    {0xE9BA, 0x85DD},
    {0xE9BB, 0x85E5},
    {0xE9BC, 0x85DC},
    {0xE9BD, 0x85F9},
    {0xE9BE, 0x860A},
    {0xE9BF, 0x8613},
    {0xE9C0, 0x860B},
    {0xE9C1, 0x85FE},
    {0xE9C2, 0x85FA},
    {0xE9C3, 0x8606},
    {0xE9C4, 0x8622},
    {0xE9C5, 0x861A},
    {0xE9C6, 0x8630},
    {0xE9C7, 0x863F},
    {0xE9C8, 0x864D},
    {0xE9C9, 0x4E55},
    {0xE9CA, 0x8654},
    {0xE9CB, 0x865F},
    {0xE9CC, 0x8667},
    {0xE9CD, 0x8671},
    {0xE9CE, 0x8693},
    {0xE9CF, 0x86A3},
    {0xE9D0, 0x86A9},
    {0xE9D1, 0x86AA},
    {0xE9D2, 0x868B},
    {0xE9D3, 0x868C},
    {0xE9D4, 0x86B6},
    {0xE9D5, 0x86AF},
    {0xE9D6, 0x86C4},
    {0xE9D7, 0x86C6},
    {0xE9D8, 0x86B0},
    {0xE9D9, 0x86C9},
    {0xE9DA, 0x8823},
    {0xE9DB, 0x86AB},
    {0xE9DC, 0x86D4},
    {0xE9DD, 0x86DE},
    {0xE9DE, 0x86E9},
    {0xE9DF, 0x86EC},
    {0xE9E0, 0x86DF},
    {0xE9E1, 0x86DB},
    {0xE9E2, 0x86EF},
    {0xE9E3, 0x8712},
    {0xE9E4, 0x8706},
    {0xE9E5, 0x8708},
    {0xE9E6, 0x8700},
    {0xE9E7, 0x8703},
    {0xE9E8, 0x86FB},
    {0xE9E9, 0x8711},
    {0xE9EA, 0x8709},
    {0xE9EB, 0x870D},
    {0xE9EC, 0x86F9},
    {0xE9ED, 0x870A},
    {0xE9EE, 0x8734},
    {0xE9EF, 0x873F},
    {0xE9F0, 0x8737},
    {0xE9F1, 0x873B},
    {0xE9F2, 0x8725},
    {0xE9F3, 0x8729},
    {0xE9F4, 0x871A},
    {0xE9F5, 0x8760},
    {0xE9F6, 0x875F},
    {0xE9F7, 0x8778},
    {0xE9F8, 0x874C},
    {0xE9F9, 0x874E},
    {0xE9FA, 0x8774},
    {0xE9FB, 0x8757},
    {0xE9FC, 0x8768},
    {0xE9FD, 0x876E},
    {0xE9FE, 0x8759},
    {0xEAA1, 0x8753},
    {0xEAA2, 0x8763},
    {0xEAA3, 0x876A},
    {0xEAA4, 0x8805},
    {0xEAA5, 0x87A2},
    {0xEAA6, 0x879F},
    {0xEAA7, 0x8782},
    {0xEAA8, 0x87AF},
    {0xEAA9, 0x87CB},
    {0xEAAA, 0x87BD},
    {0xEAAB, 0x87C0},
    {0xEAAC, 0x87D0},
    {0xEAAD, 0x96D6},
    {0xEAAE, 0x87AB},
    {0xEAAF, 0x87C4},
    {0xEAB0, 0x87B3},
    {0xEAB1, 0x87C7},
    {0xEAB2, 0x87C6},
    {0xEAB3, 0x87BB},
    {0xEAB4, 0x87EF},
    {0xEAB5, 0x87F2},
    {0xEAB6, 0x87E0},
    {0xEAB7, 0x880F},
    {0xEAB8, 0x880D},
    {0xEAB9, 0x87FE},
    {0xEABA, 0x87F6},
    {0xEABB, 0x87F7},
    {0xEABC, 0x880E},
    {0xEABD, 0x87D2},
    {0xEABE, 0x8811},
    {0xEABF, 0x8816},
    {0xEAC0, 0x8815},
    {0xEAC1, 0x8822},
    {0xEAC2, 0x8821},
    {0xEAC3, 0x8831},
    {0xEAC4, 0x8836},
    {0xEAC5, 0x8839},
    {0xEAC6, 0x8827},
    {0xEAC7, 0x883B},
    {0xEAC8, 0x8844},
    {0xEAC9, 0x8842},
    {0xEACA, 0x8852},
    {0xEACB, 0x8859},
    {0xEACC, 0x885E},
    {0xEACD, 0x8862},
    {0xEACE, 0x886B},
    {0xEACF, 0x8881},
    {0xEAD0, 0x887E},
    {0xEAD1, 0x889E},
    {0xEAD2, 0x8875},
    {0xEAD3, 0x887D},
    {0xEAD4, 0x88B5},
    {0xEAD5, 0x8872},
    {0xEAD6, 0x8882},
    {0xEAD7, 0x8897},
    {0xEAD8, 0x8892},
    {0xEAD9, 0x88AE},
    {0xEADA, 0x8899},
    {0xEADB, 0x88A2},
    {0xEADC, 0x888D},
    {0xEADD, 0x88A4},
    {0xEADE, 0x88B0},
    {0xEADF, 0x88BF},
    {0xEAE0, 0x88B1},
    {0xEAE1, 0x88C3},
    {0xEAE2, 0x88C4},
    {0xEAE3, 0x88D4},
    {0xEAE4, 0x88D8},
    {0xEAE5, 0x88D9},
    {0xEAE6, 0x88DD},
    {0xEAE7, 0x88F9},
    {0xEAE8, 0x8902},
    {0xEAE9, 0x88FC},
    {0xEAEA, 0x88F4},
    {0xEAEB, 0x88E8},
    {0xEAEC, 0x88F2},
    {0xEAED, 0x8904},
    {0xEAEE, 0x890C},
    {0xEAEF, 0x890A},
    {0xEAF0, 0x8913},
    {0xEAF1, 0x8943},
    {0xEAF2, 0x891E},
    {0xEAF3, 0x8925},
    {0xEAF4, 0x892A},
    {0xEAF5, 0x892B},
    {0xEAF6, 0x8941},
    {0xEAF7, 0x8944},
    {0xEAF8, 0x893B},
    {0xEAF9, 0x8936},
    {0xEAFA, 0x8938},
    {0xEAFB, 0x894C},
    {0xEAFC, 0x891D},
    {0xEAFD, 0x8960},
    {0xEAFE, 0x895E},
    {0xEBA1, 0x8966},
    {0xEBA2, 0x8964},
    {0xEBA3, 0x896D},
    {0xEBA4, 0x896A},
    {0xEBA5, 0x896F},
    {0xEBA6, 0x8974},
    {0xEBA7, 0x8977},
    {0xEBA8, 0x897E},
    {0xEBA9, 0x8983},
    {0xEBAA, 0x8988},
    {0xEBAB, 0x898A},
    {0xEBAC, 0x8993},
    {0xEBAD, 0x8998},
    {0xEBAE, 0x89A1},
    {0xEBAF, 0x89A9},
    {0xEBB0, 0x89A6},
    {0xEBB1, 0x89AC},
    {0xEBB2, 0x89AF},
    {0xEBB3, 0x89B2},
    {0xEBB4, 0x89BA},
    {0xEBB5, 0x89BD},
    {0xEBB6, 0x89BF},
    {0xEBB7, 0x89C0},
    {0xEBB8, 0x89DA},
    {0xEBB9, 0x89DC},
    {0xEBBA, 0x89DD},
    {0xEBBB, 0x89E7},
    {0xEBBC, 0x89F4},
    {0xEBBD, 0x89F8},
    {0xEBBE, 0x8A03},
    {0xEBBF, 0x8A16},
    {0xEBC0, 0x8A10},
    {0xEBC1, 0x8A0C},
    {0xEBC2, 0x8A1B},
    {0xEBC3, 0x8A1D},
    {0xEBC4, 0x8A25},
    {0xEBC5, 0x8A36},
    {0xEBC6, 0x8A41},
    {0xEBC7, 0x8A5B},
    {0xEBC8, 0x8A52},
    {0xEBC9, 0x8A46},
    {0xEBCA, 0x8A48},
    {0xEBCB, 0x8A7C},
    {0xEBCC, 0x8A6D},
    {0xEBCD, 0x8A6C},
    {0xEBCE, 0x8A62},
    {0xEBCF, 0x8A85},
    {0xEBD0, 0x8A82},
    {0xEBD1, 0x8A84},
    {0xEBD2, 0x8AA8},
    {0xEBD3, 0x8AA1},
    {0xEBD4, 0x8A91},
    {0xEBD5, 0x8AA5},
    {0xEBD6, 0x8AA6},
    {0xEBD7, 0x8A9A},
    {0xEBD8, 0x8AA3},
    {0xEBD9, 0x8AC4},
    {0xEBDA, 0x8ACD},
    {0xEBDB, 0x8AC2},
    {0xEBDC, 0x8ADA},
    {0xEBDD, 0x8AEB},
    {0xEBDE, 0x8AF3},
    {0xEBDF, 0x8AE7},
    {0xEBE0, 0x8AE4},
    {0xEBE1, 0x8AF1},
    {0xEBE2, 0x8B14},
    {0xEBE3, 0x8AE0},
    {0xEBE4, 0x8AE2},
    {0xEBE5, 0x8AF7},
    {0xEBE6, 0x8ADE},
    {0xEBE7, 0x8ADB},
    {0xEBE8, 0x8B0C},
    {0xEBE9, 0x8B07},
    {0xEBEA, 0x8B1A},
    {0xEBEB, 0x8AE1},
    {0xEBEC, 0x8B16},
    {0xEBED, 0x8B10},
    {0xEBEE, 0x8B17},
    {0xEBEF, 0x8B20},
    {0xEBF0, 0x8B33},
    {0xEBF1, 0x97AB},
    {0xEBF2, 0x8B26},
    {0xEBF3, 0x8B2B},
    {0xEBF4, 0x8B3E},
    {0xEBF5, 0x8B28},
    {0xEBF6, 0x8B41},
    {0xEBF7, 0x8B4C},
    {0xEBF8, 0x8B4F},
    {0xEBF9, 0x8B4E},
    {0xEBFA, 0x8B49},
    {0xEBFB, 0x8B56},
    {0xEBFC, 0x8B5B},
    {0xEBFD, 0x8B5A},
    {0xEBFE, 0x8B6B},
    {0xECA1, 0x8B5F},
    {0xECA2, 0x8B6C},
    {0xECA3, 0x8B6F},
    {0xECA4, 0x8B74},
    {0xECA5, 0x8B7D},
    {0xECA6, 0x8B80},
    {0xECA7, 0x8B8C},
    {0xECA8, 0x8B8E},
    {0xECA9, 0x8B92},
    {0xECAA, 0x8B93},
    {0xECAB, 0x8B96},
    {0xECAC, 0x8B99},
    {0xECAD, 0x8B9A},
    {0xECAE, 0x8C3A},
    {0xECAF, 0x8C41},
    {0xECB0, 0x8C3F},
    {0xECB1, 0x8C48},
    {0xECB2, 0x8C4C},
    {0xECB3, 0x8C4E},
    {0xECB4, 0x8C50},
    {0xECB5, 0x8C55},
    {0xECB6, 0x8C62},
    {0xECB7, 0x8C6C},
    {0xECB8, 0x8C78},
    {0xECB9, 0x8C7A},
    {0xECBA, 0x8C82},
    {0xECBB, 0x8C89},
    {0xECBC, 0x8C85},
    {0xECBD, 0x8C8A},
    {0xECBE, 0x8C8D},
    {0xECBF, 0x8C8E},
    {0xECC0, 0x8C94},
    {0xECC1, 0x8C7C},
    {0xECC2, 0x8C98},
    {0xECC3, 0x621D},
    {0xECC4, 0x8CAD},
    {0xECC5, 0x8CAA},
    {0xECC6, 0x8CBD},
    {0xECC7, 0x8CB2},
    {0xECC8, 0x8CB3},
    {0xECC9, 0x8CAE},
    {0xECCA, 0x8CB6},
    {0xECCB, 0x8CC8},
    {0xECCC, 0x8CC1},
    {0xECCD, 0x8CE4},
    {0xECCE, 0x8CE3},
    {0xECCF, 0x8CDA},
    {0xECD0, 0x8CFD},
    {0xECD1, 0x8CFA},
    {0xECD2, 0x8CFB},
    {0xECD3, 0x8D04},
    {0xECD4, 0x8D05},
    {0xECD5, 0x8D0A},
    {0xECD6, 0x8D07},
    {0xECD7, 0x8D0F},
    {0xECD8, 0x8D0D},
    {0xECD9, 0x8D10},
    {0xECDA, 0x9F4E},
    {0xECDB, 0x8D13},
    {0xECDC, 0x8CCD},
    {0xECDD, 0x8D14},
    {0xECDE, 0x8D16},
    {0xECDF, 0x8D67},
    {0xECE0, 0x8D6D},
    {0xECE1, 0x8D71},
    {0xECE2, 0x8D73},
    {0xECE3, 0x8D81},
    {0xECE4, 0x8D99},
    {0xECE5, 0x8DC2},
    {0xECE6, 0x8DBE},
    {0xECE7, 0x8DBA},
    {0xECE8, 0x8DCF},
    {0xECE9, 0x8DDA},
    {0xECEA, 0x8DD6},
    {0xECEB, 0x8DCC},
    {0xECEC, 0x8DDB},
    {0xECED, 0x8DCB},
    {0xECEE, 0x8DEA},
    {0xECEF, 0x8DEB},
    {0xECF0, 0x8DDF},
    {0xECF1, 0x8DE3},
    {0xECF2, 0x8DFC},
    {0xECF3, 0x8E08},
    {0xECF4, 0x8E09},
    {0xECF5, 0x8DFF},
    {0xECF6, 0x8E1D},
    {0xECF7, 0x8E1E},
    {0xECF8, 0x8E10},
    {0xECF9, 0x8E1F},
    {0xECFA, 0x8E42},
    {0xECFB, 0x8E35},
    {0xECFC, 0x8E30},
    {0xECFD, 0x8E34},
    {0xECFE, 0x8E4A},
    {0xEDA1, 0x8E47},
    {0xEDA2, 0x8E49},
    {0xEDA3, 0x8E4C},
    {0xEDA4, 0x8E50},
    {0xEDA5, 0x8E48},
    {0xEDA6, 0x8E59},
    {0xEDA7, 0x8E64},
    {0xEDA8, 0x8E60},
    {0xEDA9, 0x8E2A},
    {0xEDAA, 0x8E63},
    {0xEDAB, 0x8E55},
    {0xEDAC, 0x8E76},
    {0xEDAD, 0x8E72},
    {0xEDAE, 0x8E7C},
    {0xEDAF, 0x8E81},
    {0xEDB0, 0x8E87},
    {0xEDB1, 0x8E85},
    {0xEDB2, 0x8E84},
    {0xEDB3, 0x8E8B},
    {0xEDB4, 0x8E8A},
    {0xEDB5, 0x8E93},
    {0xEDB6, 0x8E91},
    {0xEDB7, 0x8E94},
    {0xEDB8, 0x8E99},
    {0xEDB9, 0x8EAA},
    {0xEDBA, 0x8EA1},
    {0xEDBB, 0x8EAC},
    {0xEDBC, 0x8EB0},
    {0xEDBD, 0x8EC6},
    {0xEDBE, 0x8EB1},
    {0xEDBF, 0x8EBE},
    {0xEDC0, 0x8EC5},
    {0xEDC1, 0x8EC8},
    {0xEDC2, 0x8ECB},
    {0xEDC3, 0x8EDB},
    {0xEDC4, 0x8EE3},
    {0xEDC5, 0x8EFC},
    {0xEDC6, 0x8EFB},
    {0xEDC7, 0x8EEB},
    {0xEDC8, 0x8EFE},
    {0xEDC9, 0x8F0A},
    {0xEDCA, 0x8F05},
    {0xEDCB, 0x8F15},
    {0xEDCC, 0x8F12},
    {0xEDCD, 0x8F19},
    {0xEDCE, 0x8F13},
    {0xEDCF, 0x8F1C},
    {0xEDD0, 0x8F1F},
    {0xEDD1, 0x8F1B},
    {0xEDD2, 0x8F0C},
    {0xEDD3, 0x8F26},
    {0xEDD4, 0x8F33},
    {0xEDD5, 0x8F3B},
    {0xEDD6, 0x8F39},
    {0xEDD7, 0x8F45},
    {0xEDD8, 0x8F42},
    {0xEDD9, 0x8F3E},
    {0xEDDA, 0x8F4C},
    {0xEDDB, 0x8F49},
    {0xEDDC, 0x8F46},
    {0xEDDD, 0x8F4E},
    {0xEDDE, 0x8F57},
    {0xEDDF, 0x8F5C},
    {0xEDE0, 0x8F62},
    {0xEDE1, 0x8F63},
    {0xEDE2, 0x8F64},
    {0xEDE3, 0x8F9C},
    {0xEDE4, 0x8F9F},
    {0xEDE5, 0x8FA3},
    {0xEDE6, 0x8FAD},
    {0xEDE7, 0x8FAF},
    {0xEDE8, 0x8FB7},
    {0xEDE9, 0x8FDA},
    {0xEDEA, 0x8FE5},
    {0xEDEB, 0x8FE2},
    {0xEDEC, 0x8FEA},
    {0xEDED, 0x8FEF},
    {0xEDEE, 0x9087},
    {0xEDEF, 0x8FF4},
    {0xEDF0, 0x9005},
    {0xEDF1, 0x8FF9},
    {0xEDF2, 0x8FFA},
    {0xEDF3, 0x9011},
    {0xEDF4, 0x9015},
    {0xEDF5, 0x9021},
    {0xEDF6, 0x900D},
    {0xEDF7, 0x901E},
    {0xEDF8, 0x9016},
    {0xEDF9, 0x900B},
    {0xEDFA, 0x9027},
    {0xEDFB, 0x9036},
    {0xEDFC, 0x9035},
    {0xEDFD, 0x9039},
    {0xEDFE, 0x8FF8},
    {0xEEA1, 0x904F},
    {0xEEA2, 0x9050},
    {0xEEA3, 0x9051},
    {0xEEA4, 0x9052},
    {0xEEA5, 0x900E},
    {0xEEA6, 0x9049},
    {0xEEA7, 0x903E},
    {0xEEA8, 0x9056},
    {0xEEA9, 0x9058},
    {0xEEAA, 0x905E},
    {0xEEAB, 0x9068},
    {0xEEAC, 0x906F},
    {0xEEAD, 0x9076},
    {0xEEAE, 0x96A8},
    {0xEEAF, 0x9072},
    {0xEEB0, 0x9082},
    {0xEEB1, 0x907D},
    {0xEEB2, 0x9081},
    {0xEEB3, 0x9080},
    {0xEEB4, 0x908A},
    {0xEEB5, 0x9089},
    {0xEEB6, 0x908F},
    {0xEEB7, 0x90A8},
    {0xEEB8, 0x90AF},
    {0xEEB9, 0x90B1},
    {0xEEBA, 0x90B5},
    {0xEEBB, 0x90E2},
    {0xEEBC, 0x90E4},
    {0xEEBD, 0x6248},
    {0xEEBE, 0x90DB},
    {0xEEBF, 0x9102},
    {0xEEC0, 0x9112},
    {0xEEC1, 0x9119},
    {0xEEC2, 0x9132},
    {0xEEC3, 0x9130},
    {0xEEC4, 0x914A},
    {0xEEC5, 0x9156},
    {0xEEC6, 0x9158},
    {0xEEC7, 0x9163},
    {0xEEC8, 0x9165},
    {0xEEC9, 0x9169},
    {0xEECA, 0x9173},
    {0xEECB, 0x9172},
    {0xEECC, 0x918B},
    {0xEECD, 0x9189},
    {0xEECE, 0x9182},
    {0xEECF, 0x91A2},
    {0xEED0, 0x91AB},
    {0xEED1, 0x91AF},
    {0xEED2, 0x91AA},
    {0xEED3, 0x91B5},
    {0xEED4, 0x91B4},
    {0xEED5, 0x91BA},
    {0xEED6, 0x91C0},
    {0xEED7, 0x91C1},
    {0xEED8, 0x91C9},
    {0xEED9, 0x91CB},
    {0xEEDA, 0x91D0},
    {0xEEDB, 0x91D6},
    {0xEEDC, 0x91DF},
    {0xEEDD, 0x91E1},
    {0xEEDE, 0x91DB},
    {0xEEDF, 0x91FC},
    {0xEEE0, 0x91F5},
    {0xEEE1, 0x91F6},
    {0xEEE2, 0x921E},
    {0xEEE3, 0x91FF},
    {0xEEE4, 0x9214},
    {0xEEE5, 0x922C},
    {0xEEE6, 0x9215},
    {0xEEE7, 0x9211},
    {0xEEE8, 0x925E},
    {0xEEE9, 0x9257},
    {0xEEEA, 0x9245},
    {0xEEEB, 0x9249},
    {0xEEEC, 0x9264},
    {0xEEED, 0x9248},
    {0xEEEE, 0x9295},
    {0xEEEF, 0x923F},
    {0xEEF0, 0x924B},
    {0xEEF1, 0x9250},
    {0xEEF2, 0x929C},
    {0xEEF3, 0x9296},
    {0xEEF4, 0x9293},
    {0xEEF5, 0x929B},
    {0xEEF6, 0x925A},
    {0xEEF7, 0x92CF},
    {0xEEF8, 0x92B9},
    {0xEEF9, 0x92B7},
    {0xEEFA, 0x92E9},
    {0xEEFB, 0x930F},
    {0xEEFC, 0x92FA},
    {0xEEFD, 0x9344},
    {0xEEFE, 0x932E},
    {0xEFA1, 0x9319},
    {0xEFA2, 0x9322},
    {0xEFA3, 0x931A},
    {0xEFA4, 0x9323},
    {0xEFA5, 0x933A},
    {0xEFA6, 0x9335},
    {0xEFA7, 0x933B},
    {0xEFA8, 0x935C},
    {0xEFA9, 0x9360},
    {0xEFAA, 0x937C},
    {0xEFAB, 0x936E},
    {0xEFAC, 0x9356},
    {0xEFAD, 0x93B0},
    {0xEFAE, 0x93AC},
    {0xEFAF, 0x93AD},
    {0xEFB0, 0x9394},
    {0xEFB1, 0x93B9},
    {0xEFB2, 0x93D6},
    {0xEFB3, 0x93D7},
    {0xEFB4, 0x93E8},
    {0xEFB5, 0x93E5},
    {0xEFB6, 0x93D8},
    {0xEFB7, 0x93C3},
    {0xEFB8, 0x93DD},
    {0xEFB9, 0x93D0},
    {0xEFBA, 0x93C8},
    {0xEFBB, 0x93E4},
    {0xEFBC, 0x941A},
    {0xEFBD, 0x9414},
    {0xEFBE, 0x9413},
    {0xEFBF, 0x9403},
    {0xEFC0, 0x9407},
    {0xEFC1, 0x9410},
    {0xEFC2, 0x9436},
    {0xEFC3, 0x942B},
    {0xEFC4, 0x9435},
    {0xEFC5, 0x9421},
    {0xEFC6, 0x943A},
    {0xEFC7, 0x9441},
    {0xEFC8, 0x9452},
    {0xEFC9, 0x9444},
    {0xEFCA, 0x945B},
    {0xEFCB, 0x9460},
    {0xEFCC, 0x9462},
    {0xEFCD, 0x945E},
    {0xEFCE, 0x946A},
    {0xEFCF, 0x9229},
    {0xEFD0, 0x9470},
    {0xEFD1, 0x9475},
    {0xEFD2, 0x9477},
    {0xEFD3, 0x947D},
    {0xEFD4, 0x945A},
    {0xEFD5, 0x947C},
    {0xEFD6, 0x947E},
    {0xEFD7, 0x9481},
    {0xEFD8, 0x947F},
    {0xEFD9, 0x9582},
    {0xEFDA, 0x9587},
    {0xEFDB, 0x958A},
    {0xEFDC, 0x9594},
    {0xEFDD, 0x9596},
    {0xEFDE, 0x9598},
    {0xEFDF, 0x9599},
    {0xEFE0, 0x95A0},
    {0xEFE1, 0x95A8},
    {0xEFE2, 0x95A7},
    {0xEFE3, 0x95AD},
    {0xEFE4, 0x95BC},
    {0xEFE5, 0x95BB},
    {0xEFE6, 0x95B9},
    {0xEFE7, 0x95BE},
    {0xEFE8, 0x95CA},
    {0xEFE9, 0x6FF6},
    {0xEFEA, 0x95C3},
    {0xEFEB, 0x95CD},
    {0xEFEC, 0x95CC},
    {0xEFED, 0x95D5},
    {0xEFEE, 0x95D4},
    {0xEFEF, 0x95D6},
    {0xEFF0, 0x95DC},
    {0xEFF1, 0x95E1},
    {0xEFF2, 0x95E5},
    {0xEFF3, 0x95E2},
    {0xEFF4, 0x9621},
    {0xEFF5, 0x9628},
    {0xEFF6, 0x962E},
    {0xEFF7, 0x962F},
    {0xEFF8, 0x9642},
    {0xEFF9, 0x964C},
    {0xEFFA, 0x964F},
    {0xEFFB, 0x964B},
    {0xEFFC, 0x9677},
    {0xEFFD, 0x965C},
    {0xEFFE, 0x965E},
    {0xF0A1, 0x965D},
    {0xF0A2, 0x965F},
    {0xF0A3, 0x9666},
    {0xF0A4, 0x9672},
    {0xF0A5, 0x966C},
    {0xF0A6, 0x968D},
    {0xF0A7, 0x9698},
    {0xF0A8, 0x9695},
    {0xF0A9, 0x9697},
    {0xF0AA, 0x96AA},
    {0xF0AB, 0x96A7},
    {0xF0AC, 0x96B1},
    {0xF0AD, 0x96B2},
    {0xF0AE, 0x96B0},
    {0xF0AF, 0x96B4},
    {0xF0B0, 0x96B6},
    {0xF0B1, 0x96B8},
    {0xF0B2, 0x96B9},
    {0xF0B3, 0x96CE},
    {0xF0B4, 0x96CB},
    {0xF0B5, 0x96C9},
    {0xF0B6, 0x96CD},
    {0xF0B7, 0x894D},
    {0xF0B8, 0x96DC},
    {0xF0B9, 0x970D},
    {0xF0BA, 0x96D5},
    {0xF0BB, 0x96F9},
    {0xF0BC, 0x9704},
    {0xF0BD, 0x9706},
    {0xF0BE, 0x9708},
    {0xF0BF, 0x9713},
    {0xF0C0, 0x970E},
    {0xF0C1, 0x9711},
    {0xF0C2, 0x970F},
    {0xF0C3, 0x9716},
    {0xF0C4, 0x9719},
    {0xF0C5, 0x9724},
    {0xF0C6, 0x972A},
    {0xF0C7, 0x9730},
    {0xF0C8, 0x9739},
    {0xF0C9, 0x973D},
    {0xF0CA, 0x973E},
    {0xF0CB, 0x9744},
    {0xF0CC, 0x9746},
    {0xF0CD, 0x9748},
    {0xF0CE, 0x9742},
    {0xF0CF, 0x9749},
    {0xF0D0, 0x975C},
    {0xF0D1, 0x9760},
    {0xF0D2, 0x9764},
    {0xF0D3, 0x9766},
    {0xF0D4, 0x9768},
    {0xF0D5, 0x52D2},
    {0xF0D6, 0x976B},
    {0xF0D7, 0x9771},
    {0xF0D8, 0x9779},
    {0xF0D9, 0x9785},
    {0xF0DA, 0x977C},
    {0xF0DB, 0x9781},
    {0xF0DC, 0x977A},
    {0xF0DD, 0x9786},
    {0xF0DE, 0x978B},
    {0xF0DF, 0x978F},
    {0xF0E0, 0x9790},
    {0xF0E1, 0x979C},
    {0xF0E2, 0x97A8},
    {0xF0E3, 0x97A6},
    {0xF0E4, 0x97A3},
    {0xF0E5, 0x97B3},
    {0xF0E6, 0x97B4},
    {0xF0E7, 0x97C3},
    {0xF0E8, 0x97C6},
    {0xF0E9, 0x97C8},
    {0xF0EA, 0x97CB},
    {0xF0EB, 0x97DC},
    {0xF0EC, 0x97ED},
    {0xF0ED, 0x9F4F},
    {0xF0EE, 0x97F2},
    {0xF0EF, 0x7ADF},
    {0xF0F0, 0x97F6},
    {0xF0F1, 0x97F5},
    {0xF0F2, 0x980F},
    {0xF0F3, 0x980C},
    {0xF0F4, 0x9838},
    {0xF0F5, 0x9824},
    {0xF0F6, 0x9821},
    {0xF0F7, 0x9837},
    {0xF0F8, 0x983D},
    {0xF0F9, 0x9846},
    {0xF0FA, 0x984F},
    {0xF0FB, 0x984B},
    {0xF0FC, 0x986B},
    {0xF0FD, 0x986F},
    {0xF0FE, 0x9870},
    {0xF1A1, 0x9871},
    {0xF1A2, 0x9874},
    {0xF1A3, 0x9873},
    {0xF1A4, 0x98AA},
    {0xF1A5, 0x98AF},
    {0xF1A6, 0x98B1},
    {0xF1A7, 0x98B6},
    {0xF1A8, 0x98C4},
    {0xF1A9, 0x98C3},
    {0xF1AA, 0x98C6},
    {0xF1AB, 0x98E9},
    {0xF1AC, 0x98EB},
    {0xF1AD, 0x9903},
    {0xF1AE, 0x9909},
    {0xF1AF, 0x9912},
    {0xF1B0, 0x9914},
    {0xF1B1, 0x9918},
    {0xF1B2, 0x9921},
    {0xF1B3, 0x991D},
    {0xF1B4, 0x991E},
    {0xF1B5, 0x9924},
    {0xF1B6, 0x9920},
    {0xF1B7, 0x992C},
    {0xF1B8, 0x992E},
    {0xF1B9, 0x993D},
    {0xF1BA, 0x993E},
    {0xF1BB, 0x9942},
    {0xF1BC, 0x9949},
    {0xF1BD, 0x9945},
    {0xF1BE, 0x9950},
    {0xF1BF, 0x994B},
    {0xF1C0, 0x9951},
    {0xF1C1, 0x9952},
    {0xF1C2, 0x994C},
    {0xF1C3, 0x9955},
    {0xF1C4, 0x9997},
    {0xF1C5, 0x9998},
    {0xF1C6, 0x99A5},
    {0xF1C7, 0x99AD},
    {0xF1C8, 0x99AE},
    {0xF1C9, 0x99BC},
    {0xF1CA, 0x99DF},
    {0xF1CB, 0x99DB},
    {0xF1CC, 0x99DD},
    {0xF1CD, 0x99D8},
    {0xF1CE, 0x99D1},
    {0xF1CF, 0x99ED},
    {0xF1D0, 0x99EE},
    {0xF1D1, 0x99F1},
    {0xF1D2, 0x99F2},
    {0xF1D3, 0x99FB},
    {0xF1D4, 0x99F8},
    {0xF1D5, 0x9A01},
    {0xF1D6, 0x9A0F},
    {0xF1D7, 0x9A05},
    {0xF1D8, 0x99E2},
    {0xF1D9, 0x9A19},
    {0xF1DA, 0x9A2B},
    {0xF1DB, 0x9A37},
    {0xF1DC, 0x9A45},
    {0xF1DD, 0x9A42},
    {0xF1DE, 0x9A40},
    {0xF1DF, 0x9A43},
    {0xF1E0, 0x9A3E},
    {0xF1E1, 0x9A55},
    {0xF1E2, 0x9A4D},
    {0xF1E3, 0x9A5B},
    {0xF1E4, 0x9A57},
    {0xF1E5, 0x9A5F},
    {0xF1E6, 0x9A62},
    {0xF1E7, 0x9A65},
    {0xF1E8, 0x9A64},
    {0xF1E9, 0x9A69},
    {0xF1EA, 0x9A6B},
    {0xF1EB, 0x9A6A},
    {0xF1EC, 0x9AAD},
    {0xF1ED, 0x9AB0},
    {0xF1EE, 0x9ABC},
    {0xF1EF, 0x9AC0},
    {0xF1F0, 0x9ACF},
    {0xF1F1, 0x9AD1},
    {0xF1F2, 0x9AD3},
    {0xF1F3, 0x9AD4},
    {0xF1F4, 0x9ADE},
    {0xF1F5, 0x9ADF},
    {0xF1F6, 0x9AE2},
    {0xF1F7, 0x9AE3},
    {0xF1F8, 0x9AE6},
    {0xF1F9, 0x9AEF},
    {0xF1FA, 0x9AEB},
    {0xF1FB, 0x9AEE},
    {0xF1FC, 0x9AF4},
    {0xF1FD, 0x9AF1},
    {0xF1FE, 0x9AF7},
    {0xF2A1, 0x9AFB},
    {0xF2A2, 0x9B06},
    {0xF2A3, 0x9B18},
    {0xF2A4, 0x9B1A},
    {0xF2A5, 0x9B1F},
    {0xF2A6, 0x9B22},
    {0xF2A7, 0x9B23},
    {0xF2A8, 0x9B25},
    {0xF2A9, 0x9B27},
    {0xF2AA, 0x9B28},
    {0xF2AB, 0x9B29},
    {0xF2AC, 0x9B2A},
    {0xF2AD, 0x9B2E},
    {0xF2AE, 0x9B2F},
    {0xF2AF, 0x9B32},
    {0xF2B0, 0x9B44},
    {0xF2B1, 0x9B43},
    {0xF2B2, 0x9B4F},
    {0xF2B3, 0x9B4D},
    {0xF2B4, 0x9B4E},
    {0xF2B5, 0x9B51},
    {0xF2B6, 0x9B58},
    {0xF2B7, 0x9B74},
    {0xF2B8, 0x9B93},
    {0xF2B9, 0x9B83},
    {0xF2BA, 0x9B91},
    {0xF2BB, 0x9B96},
    {0xF2BC, 0x9B97},
    {0xF2BD, 0x9B9F},
    {0xF2BE, 0x9BA0},
    {0xF2BF, 0x9BA8},
    {0xF2C0, 0x9BB4},
    {0xF2C1, 0x9BC0},
    {0xF2C2, 0x9BCA},
    {0xF2C3, 0x9BB9},
    {0xF2C4, 0x9BC6},
    {0xF2C5, 0x9BCF},
    {0xF2C6, 0x9BD1},
    {0xF2C7, 0x9BD2},
    {0xF2C8, 0x9BE3},
    {0xF2C9, 0x9BE2},
    {0xF2CA, 0x9BE4},
    {0xF2CB, 0x9BD4},
    {0xF2CC, 0x9BE1},
    {0xF2CD, 0x9C3A},
    {0xF2CE, 0x9BF2},
    {0xF2CF, 0x9BF1},
    {0xF2D0, 0x9BF0},
    {0xF2D1, 0x9C15},
    {0xF2D2, 0x9C14},
    {0xF2D3, 0x9C09},
    {0xF2D4, 0x9C13},
    {0xF2D5, 0x9C0C},
    {0xF2D6, 0x9C06},
    {0xF2D7, 0x9C08},
    {0xF2D8, 0x9C12},
    {0xF2D9, 0x9C0A},
    {0xF2DA, 0x9C04},
    {0xF2DB, 0x9C2E},
    {0xF2DC, 0x9C1B},
    {0xF2DD, 0x9C25},
    {0xF2DE, 0x9C24},
    {0xF2DF, 0x9C21},
    {0xF2E0, 0x9C30},
    {0xF2E1, 0x9C47},
    {0xF2E2, 0x9C32},
    {0xF2E3, 0x9C46},
    {0xF2E4, 0x9C3E},
    {0xF2E5, 0x9C5A},
    {0xF2E6, 0x9C60},
    {0xF2E7, 0x9C67},
    {0xF2E8, 0x9C76},
    {0xF2E9, 0x9C78},
    {0xF2EA, 0x9CE7},
    {0xF2EB, 0x9CEC},
    {0xF2EC, 0x9CF0},
    {0xF2ED, 0x9D09},
    {0xF2EE, 0x9D08},
    {0xF2EF, 0x9CEB},
    {0xF2F0, 0x9D03},
    {0xF2F1, 0x9D06},
    {0xF2F2, 0x9D2A},
    {0xF2F3, 0x9D26},
    {0xF2F4, 0x9DAF},
    {0xF2F5, 0x9D23},
    {0xF2F6, 0x9D1F},
    {0xF2F7, 0x9D44},
    {0xF2F8, 0x9D15},
    {0xF2F9, 0x9D12},
    {0xF2FA, 0x9D41},
    {0xF2FB, 0x9D3F},
    {0xF2FC, 0x9D3E},
    {0xF2FD, 0x9D46},
    {0xF2FE, 0x9D48},
    {0xF3A1, 0x9D5D},
    {0xF3A2, 0x9D5E},
    {0xF3A3, 0x9D64},
    {0xF3A4, 0x9D51},
    {0xF3A5, 0x9D50},
    {0xF3A6, 0x9D59},
    {0xF3A7, 0x9D72},
    {0xF3A8, 0x9D89},
    {0xF3A9, 0x9D87},
    {0xF3AA, 0x9DAB},
    {0xF3AB, 0x9D6F},
    {0xF3AC, 0x9D7A},
    {0xF3AD, 0x9D9A},
    {0xF3AE, 0x9DA4},
    {0xF3AF, 0x9DA9},
    {0xF3B0, 0x9DB2},
    {0xF3B1, 0x9DC4},
    {0xF3B2, 0x9DC1},
    {0xF3B3, 0x9DBB},
    {0xF3B4, 0x9DB8},
    {0xF3B5, 0x9DBA},
    {0xF3B6, 0x9DC6},
    {0xF3B7, 0x9DCF},
    {0xF3B8, 0x9DC2},
    {0xF3B9, 0x9DD9},
    {0xF3BA, 0x9DD3},
    {0xF3BB, 0x9DF8},
    {0xF3BC, 0x9DE6},
    {0xF3BD, 0x9DED},
    {0xF3BE, 0x9DEF},
    {0xF3BF, 0x9DFD},
    {0xF3C0, 0x9E1A},
    {0xF3C1, 0x9E1B},
    {0xF3C2, 0x9E1E},
    {0xF3C3, 0x9E75},
    {0xF3C4, 0x9E79},
    {0xF3C5, 0x9E7D},
    {0xF3C6, 0x9E81},
    {0xF3C7, 0x9E88},
    {0xF3C8, 0x9E8B},
    {0xF3C9, 0x9E8C},
    {0xF3CA, 0x9E92},
    {0xF3CB, 0x9E95},
    {0xF3CC, 0x9E91},
    {0xF3CD, 0x9E9D},
    {0xF3CE, 0x9EA5},
    {0xF3CF, 0x9EA9},
    {0xF3D0, 0x9EB8},
    {0xF3D1, 0x9EAA},
    {0xF3D2, 0x9EAD},
    {0xF3D3, 0x9761},
    {0xF3D4, 0x9ECC},
    {0xF3D5, 0x9ECE},
    {0xF3D6, 0x9ECF},
    {0xF3D7, 0x9ED0},
    {0xF3D8, 0x9ED4},
    {0xF3D9, 0x9EDC},
    {0xF3DA, 0x9EDE},
    {0xF3DB, 0x9EDD},
    {0xF3DC, 0x9EE0},
    {0xF3DD, 0x9EE5},
    {0xF3DE, 0x9EE8},
    {0xF3DF, 0x9EEF},
    {0xF3E0, 0x9EF4},
    {0xF3E1, 0x9EF6},
    {0xF3E2, 0x9EF7},
    {0xF3E3, 0x9EF9},
    {0xF3E4, 0x9EFB},
    {0xF3E5, 0x9EFC},
    {0xF3E6, 0x9EFD},
    {0xF3E7, 0x9F07},
    {0xF3E8, 0x9F08},
    {0xF3E9, 0x76B7},
    {0xF3EA, 0x9F15},
    {0xF3EB, 0x9F21},
    {0xF3EC, 0x9F2C},
    {0xF3ED, 0x9F3E},
    {0xF3EE, 0x9F4A},
    {0xF3EF, 0x9F52},
    {0xF3F0, 0x9F54},
    {0xF3F1, 0x9F63},
    {0xF3F2, 0x9F5F},
    {0xF3F3, 0x9F60},
    {0xF3F4, 0x9F61},
    {0xF3F5, 0x9F66},
    {0xF3F6, 0x9F67},
    {0xF3F7, 0x9F6C},
    {0xF3F8, 0x9F6A},
    {0xF3F9, 0x9F77},
    {0xF3FA, 0x9F72},
    {0xF3FB, 0x9F76},
    {0xF3FC, 0x9F95},
    {0xF3FD, 0x9F9C},
    {0xF3FE, 0x9FA0},
    {0xF4A1, 0x582F},
    {0xF4A2, 0x69C7},
    {0xF4A3, 0x9059},
    {0xF4A4, 0x7464},
    {0xF4A5, 0x51DC},
    {0xF4A6, 0x7199},
    {0x8EA1, 0xFF61},
    {0x8EA2, 0xFF62},
    {0x8EA3, 0xFF63},
    {0x8EA4, 0xFF64},
    {0x8EA5, 0xFF65},
    {0x8EA6, 0xFF66},
    {0x8EA7, 0xFF67},
    {0x8EA8, 0xFF68},
    {0x8EA9, 0xFF69},
    {0x8EAA, 0xFF6A},
    {0x8EAB, 0xFF6B},
    {0x8EAC, 0xFF6C},
    {0x8EAD, 0xFF6D},
    {0x8EAE, 0xFF6E},
    {0x8EAF, 0xFF6F},
    {0x8EB0, 0xFF70},
    {0x8EB1, 0xFF71},
    {0x8EB2, 0xFF72},
    {0x8EB3, 0xFF73},
    {0x8EB4, 0xFF74},
    {0x8EB5, 0xFF75},
    {0x8EB6, 0xFF76},
    {0x8EB7, 0xFF77},
    {0x8EB8, 0xFF78},
    {0x8EB9, 0xFF79},
    {0x8EBA, 0xFF7A},
    {0x8EBB, 0xFF7B},
    {0x8EBC, 0xFF7C},
    {0x8EBD, 0xFF7D},
    {0x8EBE, 0xFF7E},
    {0x8EBF, 0xFF7F},
    {0x8EC0, 0xFF80},
    {0x8EC1, 0xFF81},
    {0x8EC2, 0xFF82},
    {0x8EC3, 0xFF83},
    {0x8EC4, 0xFF84},
    {0x8EC5, 0xFF85},
    {0x8EC6, 0xFF86},
    {0x8EC7, 0xFF87},
    {0x8EC8, 0xFF88},
    {0x8EC9, 0xFF89},
    {0x8ECA, 0xFF8A},
    {0x8ECB, 0xFF8B},
    {0x8ECC, 0xFF8C},
    {0x8ECD, 0xFF8D},
    {0x8ECE, 0xFF8E},
    {0x8ECF, 0xFF8F},
    {0x8ED0, 0xFF90},
    {0x8ED1, 0xFF91},
    {0x8ED2, 0xFF92},
    {0x8ED3, 0xFF93},
    {0x8ED4, 0xFF94},
    {0x8ED5, 0xFF95},
    {0x8ED6, 0xFF96},
    {0x8ED7, 0xFF97},
    {0x8ED8, 0xFF98},
    {0x8ED9, 0xFF99},
    {0x8EDA, 0xFF9A},
    {0x8EDB, 0xFF9B},
    {0x8EDC, 0xFF9C},
    {0x8EDD, 0xFF9D},
    {0x8EDE, 0xFF9E},
    {0x8EDF, 0xFF9F},
    {0xFFFF, 0xFFFF}
};

static const pdf_cid_range CID_ARRAY1[] = {
    {0x00, 0x1f, 0},
    {0x20, 0x7e, 231},
    {0x8ea0, 0x8edf, 326},
    {0xa1a1, 0xa1fe, 633},
    {0xa2a1, 0xa2ae, 727},
    {0xa2ba, 0xa2c1, 741},
    {0xa2ca, 0xa2d0, 749},
    {0xa2dc, 0xa2ea, 756},
    {0xa2f2, 0xa2f9, 771},
    {0xa2fe, 0xa2fe, 779},
    {0xa3b0, 0xa3b9, 780},
    {0xa3c1, 0xa3da, 790},
    {0xa3e1, 0xa3fa, 816},
    {0xa4a1, 0xa4f3, 842},
    {0xa5a1, 0xa5f6, 925},
    {0xa6a1, 0xa6b8, 1011},
    {0xa6c1, 0xa6d8, 1035},
    {0xa7a1, 0xa7c1, 1059},
    {0xa7d1, 0xa7f1, 1092},
    {0xa8a1, 0xa8a1, 7479},
    {0xa8a2, 0xa8a2, 7481},
    {0xa8a3, 0xa8a3, 7491},
    {0xa8a4, 0xa8a4, 7495},
    {0xa8a5, 0xa8a5, 7503},
    {0xa8a6, 0xa8a6, 7499},
    {0xa8a7, 0xa8a7, 7507},
    {0xa8a8, 0xa8a8, 7523},
    {0xa8a9, 0xa8a9, 7515},
    {0xa8aa, 0xa8aa, 7531},
    {0xa8ab, 0xa8ab, 7539},
    {0xa8ac, 0xa8ac, 7480},
    {0xa8ad, 0xa8ad, 7482},
    {0xa8ae, 0xa8ae, 7494},
    {0xa8af, 0xa8af, 7498},
    {0xa8b0, 0xa8b0, 7506},
    {0xa8b1, 0xa8b1, 7502},
    {0xa8b2, 0xa8b2, 7514},
    {0xa8b3, 0xa8b3, 7530},
    {0xa8b4, 0xa8b4, 7522},
    {0xa8b5, 0xa8b5, 7538},
    {0xa8b6, 0xa8b6, 7554},
    {0xa8b7, 0xa8b7, 7511},
    {0xa8b8, 0xa8b8, 7526},
    {0xa8b9, 0xa8b9, 7519},
    {0xa8ba, 0xa8ba, 7534},
    {0xa8bb, 0xa8bb, 7542},
    {0xa8bc, 0xa8bc, 7508},
    {0xa8bd, 0xa8bd, 7527},
    {0xa8be, 0xa8be, 7516},
    {0xa8bf, 0xa8bf, 7535},
    {0xa8c0, 0xa8c0, 7545},
    {0xb0a1, 0xb0fe, 1125},
    {0xb1a1, 0xb1fe, 1219},
    {0xb2a1, 0xb2fe, 1313},
    {0xb3a1, 0xb3fe, 1407},
    {0xb4a1, 0xb4fe, 1501},
    {0xb5a1, 0xb5fe, 1595},
    {0xb6a1, 0xb6fe, 1689},
    {0xb7a1, 0xb7fe, 1783},
    {0xb8a1, 0xb8fe, 1877},
    {0xb9a1, 0xb9fe, 1971},
    {0xbaa1, 0xbafe, 2065},
    {0xbba1, 0xbbfe, 2159},
    {0xbca1, 0xbcfe, 2253},
    {0xbda1, 0xbdfe, 2347},
    {0xbea1, 0xbefe, 2441},
    {0xbfa1, 0xbffe, 2535},
    {0xc0a1, 0xc0fe, 2629},
    {0xc1a1, 0xc1fe, 2723},
    {0xc2a1, 0xc2fe, 2817},
    {0xc3a1, 0xc3fe, 2911},
    {0xc4a1, 0xc4fe, 3005},
    {0xc5a1, 0xc5fe, 3099},
    {0xc6a1, 0xc6fe, 3193},
    {0xc7a1, 0xc7fe, 3287},
    {0xc8a1, 0xc8fe, 3381},
    {0xc9a1, 0xc9fe, 3475},
    {0xcaa1, 0xcafe, 3569},
    {0xcba1, 0xcbfe, 3663},
    {0xcca1, 0xccfe, 3757},
    {0xcda1, 0xcdfe, 3851},
    {0xcea1, 0xcefe, 3945},
    {0xcfa1, 0xcfd3, 4039},
    {0xd0a1, 0xd0fe, 4090},
    {0xd1a1, 0xd1fe, 4184},
    {0xd2a1, 0xd2fe, 4278},
    {0xd3a1, 0xd3fe, 4372},
    {0xd4a1, 0xd4fe, 4466},
    {0xd5a1, 0xd5fe, 4560},
    {0xd6a1, 0xd6fe, 4654},
    {0xd7a1, 0xd7fe, 4748},
    {0xd8a1, 0xd8fe, 4842},
    {0xd9a1, 0xd9fe, 4936},
    {0xdaa1, 0xdafe, 5030},
    {0xdba1, 0xdbfe, 5124},
    {0xdca1, 0xdcfe, 5218},
    {0xdda1, 0xddfe, 5312},
    {0xdea1, 0xdefe, 5406},
    {0xdfa1, 0xdffe, 5500},
    {0xe0a1, 0xe0fe, 5594},
    {0xe1a1, 0xe1fe, 5688},
    {0xe2a1, 0xe2fe, 5782},
    {0xe3a1, 0xe3fe, 5876},
    {0xe4a1, 0xe4fe, 5970},
    {0xe5a1, 0xe5fe, 6064},
    {0xe6a1, 0xe6fe, 6158},
    {0xe7a1, 0xe7fe, 6252},
    {0xe8a1, 0xe8fe, 6346},
    {0xe9a1, 0xe9fe, 6440},
    {0xeaa1, 0xeafe, 6534},
    {0xeba1, 0xebfe, 6628},
    {0xeca1, 0xecfe, 6722},
    {0xeda1, 0xedfe, 6816},
    {0xeea1, 0xeefe, 6910},
    {0xefa1, 0xeffe, 7004},
    {0xf0a1, 0xf0fe, 7098},
    {0xf1a1, 0xf1fe, 7192},
    {0xf2a1, 0xf2fe, 7286},
    {0xf3a1, 0xf3fe, 7380},
    {0xf4a1, 0xf4a4, 7474},
    {0xf4a5, 0xf4a6, 8284},
    {0xffff, 0xffff, 0}
};

static const pdf_cid_range CID_ARRAY2[] = {
    {0xa1a2, 0xa1a3, 0x7887},
    {0xa1b1, 0xa1b2, 0x7889},
    {0xa1bc, 0xa1be, 0x7891},
    {0xa1c1, 0xa1c5, 0x7894},
    {0xa1ca, 0xa1db, 0x7899},
    {0xa1e1, 0xa1e1, 0x7917},
    {0xa4a1, 0xa4a1, 0x7918},
    {0xa4a3, 0xa4a3, 0x7919},
    {0xa4a5, 0xa4a5, 0x7920},
    {0xa4a7, 0xa4a7, 0x7921},
    {0xa4a9, 0xa4a9, 0x7922},
    {0xa4c3, 0xa4c3, 0x7923},
    {0xa4e3, 0xa4e3, 0x7924},
    {0xa4e5, 0xa4e5, 0x7925},
    {0xa4e7, 0xa4e7, 0x7926},
    {0xa4ee, 0xa4ee, 0x7927},
    {0xa5a1, 0xa5a1, 0x7928},
    {0xa5a3, 0xa5a3, 0x7929},
    {0xa5a5, 0xa5a5, 0x7930},
    {0xa5a7, 0xa5a7, 0x7931},
    {0xa5a9, 0xa5a9, 0x7932},
    {0xa5c3, 0xa5c3, 0x7933},
    {0xa5e3, 0xa5e3, 0x7934},
    {0xa5e5, 0xa5e5, 0x7935},
    {0xa5e7, 0xa5e7, 0x7936},
    {0xa5ee, 0xa5ee, 0x7937},
    {0xa5f5, 0xa5f6, 0x7938},
    {0xffff, 0xffff, 0}
};

void
PdfCMap_EUC_H::Init()
{
    AddCMap(CID_ARRAY1);
    SetCIDSystemInfo("Adobe", "Japan1", 1);
    SetUnicodeArray(EUC_UNICODE_ARRAY, NULL);
}

void
PdfCMap_EUC_H::ParseText(const char* text, pdf_byte_type* btype)
{
    ParseEUCText(text, btype);
}
    
void
PdfCMap_EUC_V::Init()
{
    AddCMap(CID_ARRAY2);
    AddCMap(CID_ARRAY1);
    SetCIDSystemInfo("Adobe", "Japan1", 1);
    SetUnicodeArray(EUC_UNICODE_ARRAY, NULL);
}

void
PdfCMap_EUC_V::ParseText(const char* text, pdf_byte_type* btype)
{
    ParseEUCText(text, btype);
}
void
ParseEUCText(const char* text, pdf_byte_type* btype)
{
    pdf_byte_type* ptype = btype;
    const char* ptext = text;
    pdf_byte_type type = PDF_BYTE_TYPE_SINGLE;

    for (unsigned int i = 0; i < strlen(text); i++, ptext++, ptype++) {
        unsigned char c = (unsigned char)*ptext;
        if (type == PDF_BYTE_TYPE_LEAD)
            if (c >= 0xa0 && c <= 0xfe)
                *ptype = PDF_BYTE_TYPE_TRIAL;
            else
                *ptype = PDF_BYTE_TYPE_SINGLE; /* Cannot judge byte type. */
        else if (type == PDF_BYTE_TYPE_SINGLE || type == PDF_BYTE_TYPE_TRIAL)
            if ((c >= 0xa1 && c <= 0xfe) || c == 0x8e )
                *ptype = PDF_BYTE_TYPE_LEAD;
            else
                *ptype = PDF_BYTE_TYPE_SINGLE;
        type = *ptype;
    }
}

