/*
 * << H a r u free pdf library >> -- PdfFontDef_Courier.cpp
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */


#include "libharu.h"

/*----- Courier Font ---------------------------------------------------------*/

PdfCourierFontDef::PdfCourierFontDef()
    : PdfType1FontDef("Courier")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 600},
        {33, "exclam", 600},
        {34, "quotedbl", 600},
        {35, "numbersign", 600},
        {36, "dollar", 600},
        {37, "percent", 600},
        {38, "ampersand", 600},
        {39, "quoteright", 600},
        {40, "parenleft", 600},
        {41, "parenright", 600},
        {42, "asterisk", 600},
        {43, "plus", 600},
        {44, "comma", 600},
        {45, "hyphen", 600},
        {46, "period", 600},
        {47, "slash", 600},
        {48, "zero", 600},
        {49, "one", 600},
        {50, "two", 600},
        {51, "three", 600},
        {52, "four", 600},
        {53, "five", 600},
        {54, "six", 600},
        {55, "seven", 600},
        {56, "eight", 600},
        {57, "nine", 600},
        {58, "colon", 600},
        {59, "semicolon", 600},
        {60, "less", 600},
        {61, "equal", 600},
        {62, "greater", 600},
        {63, "question", 600},
        {64, "at", 600},
        {65, "A", 600},
        {66, "B", 600},
        {67, "C", 600},
        {68, "D", 600},
        {69, "E", 600},
        {70, "F", 600},
        {71, "G", 600},
        {72, "H", 600},
        {73, "I", 600},
        {74, "J", 600},
        {75, "K", 600},
        {76, "L", 600},
        {77, "M", 600},
        {78, "N", 600},
        {79, "O", 600},
        {80, "P", 600},
        {81, "Q", 600},
        {82, "R", 600},
        {83, "S", 600},
        {84, "T", 600},
        {85, "U", 600},
        {86, "V", 600},
        {87, "W", 600},
        {88, "X", 600},
        {89, "Y", 600},
        {90, "Z", 600},
        {91, "bracketleft", 600},
        {92, "backslash", 600},
        {93, "bracketright", 600},
        {94, "asciicircum", 600},
        {95, "underscore", 600},
        {96, "quoteleft", 600},
        {97, "a", 600},
        {98, "b", 600},
        {99, "c", 600},
        {100, "d", 600},
        {101, "e", 600},
        {102, "f", 600},
        {103, "g", 600},
        {104, "h", 600},
        {105, "i", 600},
        {106, "j", 600},
        {107, "k", 600},
        {108, "l", 600},
        {109, "m", 600},
        {110, "n", 600},
        {111, "o", 600},
        {112, "p", 600},
        {113, "q", 600},
        {114, "r", 600},
        {115, "s", 600},
        {116, "t", 600},
        {117, "u", 600},
        {118, "v", 600},
        {119, "w", 600},
        {120, "x", 600},
        {121, "y", 600},
        {122, "z", 600},
        {123, "braceleft", 600},
        {124, "bar", 600},
        {125, "braceright", 600},
        {126, "asciitilde", 600},
        {161, "exclamdown", 600},
        {162, "cent", 600},
        {163, "sterling", 600},
        {164, "fraction", 600},
        {165, "yen", 600},
        {166, "florin", 600},
        {167, "section", 600},
        {168, "currency", 600},
        {169, "quotesingle", 600},
        {170, "quotedblleft", 600},
        {171, "guillemotleft", 600},
        {172, "guilsinglleft", 600},
        {173, "guilsinglright", 600},
        {174, "fi", 600},
        {175, "fl", 600},
        {177, "endash", 600},
        {178, "dagger", 600},
        {179, "daggerdbl", 600},
        {180, "periodcentered", 600},
        {182, "paragraph", 600},
        {183, "bullet", 600},
        {184, "quotesinglbase", 600},
        {185, "quotedblbase", 600},
        {186, "quotedblright", 600},
        {187, "guillemotright", 600},
        {188, "ellipsis", 600},
        {189, "perthousand", 600},
        {191, "questiondown", 600},
        {193, "grave", 600},
        {194, "acute", 600},
        {195, "circumflex", 600},
        {196, "tilde", 600},
        {197, "macron", 600},
        {198, "breve", 600},
        {199, "dotaccent", 600},
        {200, "dieresis", 600},
        {202, "ring", 600},
        {203, "cedilla", 600},
        {205, "hungarumlaut", 600},
        {206, "ogonek", 600},
        {207, "caron", 600},
        {208, "emdash", 600},
        {225, "AE", 600},
        {227, "ordfeminine", 600},
        {232, "Lslash", 600},
        {233, "Oslash", 600},
        {234, "OE", 600},
        {235, "ordmasculine", 600},
        {241, "ae", 600},
        {245, "dotlessi", 600},
        {248, "lslash", 600},
        {249, "oslash", 600},
        {250, "oe", 600},
        {251, "germandbls", 600},
        {-1, "Idieresis", 600},
        {-1, "eacute", 600},
        {-1, "abreve", 600},
        {-1, "uhungarumlaut", 600},
        {-1, "ecaron", 600},
        {-1, "Ydieresis", 600},
        {-1, "divide", 600},
        {-1, "Yacute", 600},
        {-1, "Acircumflex", 600},
        {-1, "aacute", 600},
        {-1, "Ucircumflex", 600},
        {-1, "yacute", 600},
        {-1, "scommaaccent", 600},
        {-1, "ecircumflex", 600},
        {-1, "Uring", 600},
        {-1, "Udieresis", 600},
        {-1, "aogonek", 600},
        {-1, "Uacute", 600},
        {-1, "uogonek", 600},
        {-1, "Edieresis", 600},
        {-1, "Dcroat", 600},
        {-1, "commaaccent", 600},
        {-1, "copyright", 600},
        {-1, "Emacron", 600},
        {-1, "ccaron", 600},
        {-1, "aring", 600},
        {-1, "Ncommaaccent", 600},
        {-1, "lacute", 600},
        {-1, "agrave", 600},
        {-1, "Tcommaaccent", 600},
        {-1, "Cacute", 600},
        {-1, "atilde", 600},
        {-1, "Edotaccent", 600},
        {-1, "scaron", 600},
        {-1, "scedilla", 600},
        {-1, "iacute", 600},
        {-1, "lozenge", 600},
        {-1, "Rcaron", 600},
        {-1, "Gcommaaccent", 600},
        {-1, "ucircumflex", 600},
        {-1, "acircumflex", 600},
        {-1, "Amacron", 600},
        {-1, "rcaron", 600},
        {-1, "ccedilla", 600},
        {-1, "Zdotaccent", 600},
        {-1, "Thorn", 600},
        {-1, "Omacron", 600},
        {-1, "Racute", 600},
        {-1, "Sacute", 600},
        {-1, "dcaron", 600},
        {-1, "Umacron", 600},
        {-1, "uring", 600},
        {-1, "threesuperior", 600},
        {-1, "Ograve", 600},
        {-1, "Agrave", 600},
        {-1, "Abreve", 600},
        {-1, "multiply", 600},
        {-1, "uacute", 600},
        {-1, "Tcaron", 600},
        {-1, "partialdiff", 600},
        {-1, "ydieresis", 600},
        {-1, "Nacute", 600},
        {-1, "icircumflex", 600},
        {-1, "Ecircumflex", 600},
        {-1, "adieresis", 600},
        {-1, "edieresis", 600},
        {-1, "cacute", 600},
        {-1, "nacute", 600},
        {-1, "umacron", 600},
        {-1, "Ncaron", 600},
        {-1, "Iacute", 600},
        {-1, "plusminus", 600},
        {-1, "brokenbar", 600},
        {-1, "registered", 600},
        {-1, "Gbreve", 600},
        {-1, "Idotaccent", 600},
        {-1, "summation", 600},
        {-1, "Egrave", 600},
        {-1, "racute", 600},
        {-1, "omacron", 600},
        {-1, "Zacute", 600},
        {-1, "Zcaron", 600},
        {-1, "greaterequal", 600},
        {-1, "Eth", 600},
        {-1, "Ccedilla", 600},
        {-1, "lcommaaccent", 600},
        {-1, "tcaron", 600},
        {-1, "eogonek", 600},
        {-1, "Uogonek", 600},
        {-1, "Aacute", 600},
        {-1, "Adieresis", 600},
        {-1, "egrave", 600},
        {-1, "zacute", 600},
        {-1, "iogonek", 600},
        {-1, "Oacute", 600},
        {-1, "oacute", 600},
        {-1, "amacron", 600},
        {-1, "sacute", 600},
        {-1, "idieresis", 600},
        {-1, "Ocircumflex", 600},
        {-1, "Ugrave", 600},
        {-1, "Delta", 600},
        {-1, "thorn", 600},
        {-1, "twosuperior", 600},
        {-1, "Odieresis", 600},
        {-1, "mu", 600},
        {-1, "igrave", 600},
        {-1, "ohungarumlaut", 600},
        {-1, "Eogonek", 600},
        {-1, "dcroat", 600},
        {-1, "threequarters", 600},
        {-1, "Scedilla", 600},
        {-1, "lcaron", 600},
        {-1, "Kcommaaccent", 600},
        {-1, "Lacute", 600},
        {-1, "trademark", 600},
        {-1, "edotaccent", 600},
        {-1, "Igrave", 600},
        {-1, "Imacron", 600},
        {-1, "Lcaron", 600},
        {-1, "onehalf", 600},
        {-1, "lessequal", 600},
        {-1, "ocircumflex", 600},
        {-1, "ntilde", 600},
        {-1, "Uhungarumlaut", 600},
        {-1, "Eacute", 600},
        {-1, "emacron", 600},
        {-1, "gbreve", 600},
        {-1, "onequarter", 600},
        {-1, "Scaron", 600},
        {-1, "Scommaaccent", 600},
        {-1, "Ohungarumlaut", 600},
        {-1, "degree", 600},
        {-1, "ograve", 600},
        {-1, "Ccaron", 600},
        {-1, "ugrave", 600},
        {-1, "radical", 600},
        {-1, "Dcaron", 600},
        {-1, "rcommaaccent", 600},
        {-1, "Ntilde", 600},
        {-1, "otilde", 600},
        {-1, "Rcommaaccent", 600},
        {-1, "Lcommaaccent", 600},
        {-1, "Atilde", 600},
        {-1, "Aogonek", 600},
        {-1, "Aring", 600},
        {-1, "Otilde", 600},
        {-1, "zdotaccent", 600},
        {-1, "Ecaron", 600},
        {-1, "Iogonek", 600},
        {-1, "kcommaaccent", 600},
        {-1, "minus", 600},
        {-1, "Icircumflex", 600},
        {-1, "ncaron", 600},
        {-1, "tcommaaccent", 600},
        {-1, "logicalnot", 600},
        {-1, "odieresis", 600},
        {-1, "udieresis", 600},
        {-1, "notequal", 600},
        {-1, "gcommaaccent", 600},
        {-1, "eth", 600},
        {-1, "zcaron", 600},
        {-1, "ncommaaccent", 600},
        {-1, "onesuperior", 600},
        {-1, "imacron", 600},
        {-1, "Euro", 600},
        {-1, NULL, 0}
    };

    fFontBBox.left = -23;
    fFontBBox.top = -250;
    fFontBBox.right = 715;
    fFontBBox.bottom = 805;
    fAscent = 629;
    fDescent =-157;
    fXHeight = 426;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- CourierBold Font ----------------------------------------------------*/

PdfCourierBoldFontDef::PdfCourierBoldFontDef()
    : PdfType1FontDef("Courier-Bold")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 600},
        {33, "exclam", 600},
        {34, "quotedbl", 600},
        {35, "numbersign", 600},
        {36, "dollar", 600},
        {37, "percent", 600},
        {38, "ampersand", 600},
        {39, "quoteright", 600},
        {40, "parenleft", 600},
        {41, "parenright", 600},
        {42, "asterisk", 600},
        {43, "plus", 600},
        {44, "comma", 600},
        {45, "hyphen", 600},
        {46, "period", 600},
        {47, "slash", 600},
        {48, "zero", 600},
        {49, "one", 600},
        {50, "two", 600},
        {51, "three", 600},
        {52, "four", 600},
        {53, "five", 600},
        {54, "six", 600},
        {55, "seven", 600},
        {56, "eight", 600},
        {57, "nine", 600},
        {58, "colon", 600},
        {59, "semicolon", 600},
        {60, "less", 600},
        {61, "equal", 600},
        {62, "greater", 600},
        {63, "question", 600},
        {64, "at", 600},
        {65, "A", 600},
        {66, "B", 600},
        {67, "C", 600},
        {68, "D", 600},
        {69, "E", 600},
        {70, "F", 600},
        {71, "G", 600},
        {72, "H", 600},
        {73, "I", 600},
        {74, "J", 600},
        {75, "K", 600},
        {76, "L", 600},
        {77, "M", 600},
        {78, "N", 600},
        {79, "O", 600},
        {80, "P", 600},
        {81, "Q", 600},
        {82, "R", 600},
        {83, "S", 600},
        {84, "T", 600},
        {85, "U", 600},
        {86, "V", 600},
        {87, "W", 600},
        {88, "X", 600},
        {89, "Y", 600},
        {90, "Z", 600},
        {91, "bracketleft", 600},
        {92, "backslash", 600},
        {93, "bracketright", 600},
        {94, "asciicircum", 600},
        {95, "underscore", 600},
        {96, "quoteleft", 600},
        {97, "a", 600},
        {98, "b", 600},
        {99, "c", 600},
        {100, "d", 600},
        {101, "e", 600},
        {102, "f", 600},
        {103, "g", 600},
        {104, "h", 600},
        {105, "i", 600},
        {106, "j", 600},
        {107, "k", 600},
        {108, "l", 600},
        {109, "m", 600},
        {110, "n", 600},
        {111, "o", 600},
        {112, "p", 600},
        {113, "q", 600},
        {114, "r", 600},
        {115, "s", 600},
        {116, "t", 600},
        {117, "u", 600},
        {118, "v", 600},
        {119, "w", 600},
        {120, "x", 600},
        {121, "y", 600},
        {122, "z", 600},
        {123, "braceleft", 600},
        {124, "bar", 600},
        {125, "braceright", 600},
        {126, "asciitilde", 600},
        {161, "exclamdown", 600},
        {162, "cent", 600},
        {163, "sterling", 600},
        {164, "fraction", 600},
        {165, "yen", 600},
        {166, "florin", 600},
        {167, "section", 600},
        {168, "currency", 600},
        {169, "quotesingle", 600},
        {170, "quotedblleft", 600},
        {171, "guillemotleft", 600},
        {172, "guilsinglleft", 600},
        {173, "guilsinglright", 600},
        {174, "fi", 600},
        {175, "fl", 600},
        {177, "endash", 600},
        {178, "dagger", 600},
        {179, "daggerdbl", 600},
        {180, "periodcentered", 600},
        {182, "paragraph", 600},
        {183, "bullet", 600},
        {184, "quotesinglbase", 600},
        {185, "quotedblbase", 600},
        {186, "quotedblright", 600},
        {187, "guillemotright", 600},
        {188, "ellipsis", 600},
        {189, "perthousand", 600},
        {191, "questiondown", 600},
        {193, "grave", 600},
        {194, "acute", 600},
        {195, "circumflex", 600},
        {196, "tilde", 600},
        {197, "macron", 600},
        {198, "breve", 600},
        {199, "dotaccent", 600},
        {200, "dieresis", 600},
        {202, "ring", 600},
        {203, "cedilla", 600},
        {205, "hungarumlaut", 600},
        {206, "ogonek", 600},
        {207, "caron", 600},
        {208, "emdash", 600},
        {225, "AE", 600},
        {227, "ordfeminine", 600},
        {232, "Lslash", 600},
        {233, "Oslash", 600},
        {234, "OE", 600},
        {235, "ordmasculine", 600},
        {241, "ae", 600},
        {245, "dotlessi", 600},
        {248, "lslash", 600},
        {249, "oslash", 600},
        {250, "oe", 600},
        {251, "germandbls", 600},
        {-1, "Idieresis", 600},
        {-1, "eacute", 600},
        {-1, "abreve", 600},
        {-1, "uhungarumlaut", 600},
        {-1, "ecaron", 600},
        {-1, "Ydieresis", 600},
        {-1, "divide", 600},
        {-1, "Yacute", 600},
        {-1, "Acircumflex", 600},
        {-1, "aacute", 600},
        {-1, "Ucircumflex", 600},
        {-1, "yacute", 600},
        {-1, "scommaaccent", 600},
        {-1, "ecircumflex", 600},
        {-1, "Uring", 600},
        {-1, "Udieresis", 600},
        {-1, "aogonek", 600},
        {-1, "Uacute", 600},
        {-1, "uogonek", 600},
        {-1, "Edieresis", 600},
        {-1, "Dcroat", 600},
        {-1, "commaaccent", 600},
        {-1, "copyright", 600},
        {-1, "Emacron", 600},
        {-1, "ccaron", 600},
        {-1, "aring", 600},
        {-1, "Ncommaaccent", 600},
        {-1, "lacute", 600},
        {-1, "agrave", 600},
        {-1, "Tcommaaccent", 600},
        {-1, "Cacute", 600},
        {-1, "atilde", 600},
        {-1, "Edotaccent", 600},
        {-1, "scaron", 600},
        {-1, "scedilla", 600},
        {-1, "iacute", 600},
        {-1, "lozenge", 600},
        {-1, "Rcaron", 600},
        {-1, "Gcommaaccent", 600},
        {-1, "ucircumflex", 600},
        {-1, "acircumflex", 600},
        {-1, "Amacron", 600},
        {-1, "rcaron", 600},
        {-1, "ccedilla", 600},
        {-1, "Zdotaccent", 600},
        {-1, "Thorn", 600},
        {-1, "Omacron", 600},
        {-1, "Racute", 600},
        {-1, "Sacute", 600},
        {-1, "dcaron", 600},
        {-1, "Umacron", 600},
        {-1, "uring", 600},
        {-1, "threesuperior", 600},
        {-1, "Ograve", 600},
        {-1, "Agrave", 600},
        {-1, "Abreve", 600},
        {-1, "multiply", 600},
        {-1, "uacute", 600},
        {-1, "Tcaron", 600},
        {-1, "partialdiff", 600},
        {-1, "ydieresis", 600},
        {-1, "Nacute", 600},
        {-1, "icircumflex", 600},
        {-1, "Ecircumflex", 600},
        {-1, "adieresis", 600},
        {-1, "edieresis", 600},
        {-1, "cacute", 600},
        {-1, "nacute", 600},
        {-1, "umacron", 600},
        {-1, "Ncaron", 600},
        {-1, "Iacute", 600},
        {-1, "plusminus", 600},
        {-1, "brokenbar", 600},
        {-1, "registered", 600},
        {-1, "Gbreve", 600},
        {-1, "Idotaccent", 600},
        {-1, "summation", 600},
        {-1, "Egrave", 600},
        {-1, "racute", 600},
        {-1, "omacron", 600},
        {-1, "Zacute", 600},
        {-1, "Zcaron", 600},
        {-1, "greaterequal", 600},
        {-1, "Eth", 600},
        {-1, "Ccedilla", 600},
        {-1, "lcommaaccent", 600},
        {-1, "tcaron", 600},
        {-1, "eogonek", 600},
        {-1, "Uogonek", 600},
        {-1, "Aacute", 600},
        {-1, "Adieresis", 600},
        {-1, "egrave", 600},
        {-1, "zacute", 600},
        {-1, "iogonek", 600},
        {-1, "Oacute", 600},
        {-1, "oacute", 600},
        {-1, "amacron", 600},
        {-1, "sacute", 600},
        {-1, "idieresis", 600},
        {-1, "Ocircumflex", 600},
        {-1, "Ugrave", 600},
        {-1, "Delta", 600},
        {-1, "thorn", 600},
        {-1, "twosuperior", 600},
        {-1, "Odieresis", 600},
        {-1, "mu", 600},
        {-1, "igrave", 600},
        {-1, "ohungarumlaut", 600},
        {-1, "Eogonek", 600},
        {-1, "dcroat", 600},
        {-1, "threequarters", 600},
        {-1, "Scedilla", 600},
        {-1, "lcaron", 600},
        {-1, "Kcommaaccent", 600},
        {-1, "Lacute", 600},
        {-1, "trademark", 600},
        {-1, "edotaccent", 600},
        {-1, "Igrave", 600},
        {-1, "Imacron", 600},
        {-1, "Lcaron", 600},
        {-1, "onehalf", 600},
        {-1, "lessequal", 600},
        {-1, "ocircumflex", 600},
        {-1, "ntilde", 600},
        {-1, "Uhungarumlaut", 600},
        {-1, "Eacute", 600},
        {-1, "emacron", 600},
        {-1, "gbreve", 600},
        {-1, "onequarter", 600},
        {-1, "Scaron", 600},
        {-1, "Scommaaccent", 600},
        {-1, "Ohungarumlaut", 600},
        {-1, "degree", 600},
        {-1, "ograve", 600},
        {-1, "Ccaron", 600},
        {-1, "ugrave", 600},
        {-1, "radical", 600},
        {-1, "Dcaron", 600},
        {-1, "rcommaaccent", 600},
        {-1, "Ntilde", 600},
        {-1, "otilde", 600},
        {-1, "Rcommaaccent", 600},
        {-1, "Lcommaaccent", 600},
        {-1, "Atilde", 600},
        {-1, "Aogonek", 600},
        {-1, "Aring", 600},
        {-1, "Otilde", 600},
        {-1, "zdotaccent", 600},
        {-1, "Ecaron", 600},
        {-1, "Iogonek", 600},
        {-1, "kcommaaccent", 600},
        {-1, "minus", 600},
        {-1, "Icircumflex", 600},
        {-1, "ncaron", 600},
        {-1, "tcommaaccent", 600},
        {-1, "logicalnot", 600},
        {-1, "odieresis", 600},
        {-1, "udieresis", 600},
        {-1, "notequal", 600},
        {-1, "gcommaaccent", 600},
        {-1, "eth", 600},
        {-1, "zcaron", 600},
        {-1, "ncommaaccent", 600},
        {-1, "onesuperior", 600},
        {-1, "imacron", 600},
        {-1, "Euro", 600},
        {-1, NULL, 0}
    };
    fFontBBox.left = -113;
    fFontBBox.top = -250;
    fFontBBox.right = 749;
    fFontBBox.bottom = 801;
    fAscent = 629;
    fDescent =-157;
    fXHeight = 439;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- CourierBoldOblique Font ---------------------------------------------*/

PdfCourierBoldObliqueFontDef::PdfCourierBoldObliqueFontDef()
    : PdfType1FontDef("Courier-BoldOblique")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 600},
        {33, "exclam", 600},
        {34, "quotedbl", 600},
        {35, "numbersign", 600},
        {36, "dollar", 600},
        {37, "percent", 600},
        {38, "ampersand", 600},
        {39, "quoteright", 600},
        {40, "parenleft", 600},
        {41, "parenright", 600},
        {42, "asterisk", 600},
        {43, "plus", 600},
        {44, "comma", 600},
        {45, "hyphen", 600},
        {46, "period", 600},
        {47, "slash", 600},
        {48, "zero", 600},
        {49, "one", 600},
        {50, "two", 600},
        {51, "three", 600},
        {52, "four", 600},
        {53, "five", 600},
        {54, "six", 600},
        {55, "seven", 600},
        {56, "eight", 600},
        {57, "nine", 600},
        {58, "colon", 600},
        {59, "semicolon", 600},
        {60, "less", 600},
        {61, "equal", 600},
        {62, "greater", 600},
        {63, "question", 600},
        {64, "at", 600},
        {65, "A", 600},
        {66, "B", 600},
        {67, "C", 600},
        {68, "D", 600},
        {69, "E", 600},
        {70, "F", 600},
        {71, "G", 600},
        {72, "H", 600},
        {73, "I", 600},
        {74, "J", 600},
        {75, "K", 600},
        {76, "L", 600},
        {77, "M", 600},
        {78, "N", 600},
        {79, "O", 600},
        {80, "P", 600},
        {81, "Q", 600},
        {82, "R", 600},
        {83, "S", 600},
        {84, "T", 600},
        {85, "U", 600},
        {86, "V", 600},
        {87, "W", 600},
        {88, "X", 600},
        {89, "Y", 600},
        {90, "Z", 600},
        {91, "bracketleft", 600},
        {92, "backslash", 600},
        {93, "bracketright", 600},
        {94, "asciicircum", 600},
        {95, "underscore", 600},
        {96, "quoteleft", 600},
        {97, "a", 600},
        {98, "b", 600},
        {99, "c", 600},
        {100, "d", 600},
        {101, "e", 600},
        {102, "f", 600},
        {103, "g", 600},
        {104, "h", 600},
        {105, "i", 600},
        {106, "j", 600},
        {107, "k", 600},
        {108, "l", 600},
        {109, "m", 600},
        {110, "n", 600},
        {111, "o", 600},
        {112, "p", 600},
        {113, "q", 600},
        {114, "r", 600},
        {115, "s", 600},
        {116, "t", 600},
        {117, "u", 600},
        {118, "v", 600},
        {119, "w", 600},
        {120, "x", 600},
        {121, "y", 600},
        {122, "z", 600},
        {123, "braceleft", 600},
        {124, "bar", 600},
        {125, "braceright", 600},
        {126, "asciitilde", 600},
        {161, "exclamdown", 600},
        {162, "cent", 600},
        {163, "sterling", 600},
        {164, "fraction", 600},
        {165, "yen", 600},
        {166, "florin", 600},
        {167, "section", 600},
        {168, "currency", 600},
        {169, "quotesingle", 600},
        {170, "quotedblleft", 600},
        {171, "guillemotleft", 600},
        {172, "guilsinglleft", 600},
        {173, "guilsinglright", 600},
        {174, "fi", 600},
        {175, "fl", 600},
        {177, "endash", 600},
        {178, "dagger", 600},
        {179, "daggerdbl", 600},
        {180, "periodcentered", 600},
        {182, "paragraph", 600},
        {183, "bullet", 600},
        {184, "quotesinglbase", 600},
        {185, "quotedblbase", 600},
        {186, "quotedblright", 600},
        {187, "guillemotright", 600},
        {188, "ellipsis", 600},
        {189, "perthousand", 600},
        {191, "questiondown", 600},
        {193, "grave", 600},
        {194, "acute", 600},
        {195, "circumflex", 600},
        {196, "tilde", 600},
        {197, "macron", 600},
        {198, "breve", 600},
        {199, "dotaccent", 600},
        {200, "dieresis", 600},
        {202, "ring", 600},
        {203, "cedilla", 600},
        {205, "hungarumlaut", 600},
        {206, "ogonek", 600},
        {207, "caron", 600},
        {208, "emdash", 600},
        {225, "AE", 600},
        {227, "ordfeminine", 600},
        {232, "Lslash", 600},
        {233, "Oslash", 600},
        {234, "OE", 600},
        {235, "ordmasculine", 600},
        {241, "ae", 600},
        {245, "dotlessi", 600},
        {248, "lslash", 600},
        {249, "oslash", 600},
        {250, "oe", 600},
        {251, "germandbls", 600},
        {-1, "Idieresis", 600},
        {-1, "eacute", 600},
        {-1, "abreve", 600},
        {-1, "uhungarumlaut", 600},
        {-1, "ecaron", 600},
        {-1, "Ydieresis", 600},
        {-1, "divide", 600},
        {-1, "Yacute", 600},
        {-1, "Acircumflex", 600},
        {-1, "aacute", 600},
        {-1, "Ucircumflex", 600},
        {-1, "yacute", 600},
        {-1, "scommaaccent", 600},
        {-1, "ecircumflex", 600},
        {-1, "Uring", 600},
        {-1, "Udieresis", 600},
        {-1, "aogonek", 600},
        {-1, "Uacute", 600},
        {-1, "uogonek", 600},
        {-1, "Edieresis", 600},
        {-1, "Dcroat", 600},
        {-1, "commaaccent", 600},
        {-1, "copyright", 600},
        {-1, "Emacron", 600},
        {-1, "ccaron", 600},
        {-1, "aring", 600},
        {-1, "Ncommaaccent", 600},
        {-1, "lacute", 600},
        {-1, "agrave", 600},
        {-1, "Tcommaaccent", 600},
        {-1, "Cacute", 600},
        {-1, "atilde", 600},
        {-1, "Edotaccent", 600},
        {-1, "scaron", 600},
        {-1, "scedilla", 600},
        {-1, "iacute", 600},
        {-1, "lozenge", 600},
        {-1, "Rcaron", 600},
        {-1, "Gcommaaccent", 600},
        {-1, "ucircumflex", 600},
        {-1, "acircumflex", 600},
        {-1, "Amacron", 600},
        {-1, "rcaron", 600},
        {-1, "ccedilla", 600},
        {-1, "Zdotaccent", 600},
        {-1, "Thorn", 600},
        {-1, "Omacron", 600},
        {-1, "Racute", 600},
        {-1, "Sacute", 600},
        {-1, "dcaron", 600},
        {-1, "Umacron", 600},
        {-1, "uring", 600},
        {-1, "threesuperior", 600},
        {-1, "Ograve", 600},
        {-1, "Agrave", 600},
        {-1, "Abreve", 600},
        {-1, "multiply", 600},
        {-1, "uacute", 600},
        {-1, "Tcaron", 600},
        {-1, "partialdiff", 600},
        {-1, "ydieresis", 600},
        {-1, "Nacute", 600},
        {-1, "icircumflex", 600},
        {-1, "Ecircumflex", 600},
        {-1, "adieresis", 600},
        {-1, "edieresis", 600},
        {-1, "cacute", 600},
        {-1, "nacute", 600},
        {-1, "umacron", 600},
        {-1, "Ncaron", 600},
        {-1, "Iacute", 600},
        {-1, "plusminus", 600},
        {-1, "brokenbar", 600},
        {-1, "registered", 600},
        {-1, "Gbreve", 600},
        {-1, "Idotaccent", 600},
        {-1, "summation", 600},
        {-1, "Egrave", 600},
        {-1, "racute", 600},
        {-1, "omacron", 600},
        {-1, "Zacute", 600},
        {-1, "Zcaron", 600},
        {-1, "greaterequal", 600},
        {-1, "Eth", 600},
        {-1, "Ccedilla", 600},
        {-1, "lcommaaccent", 600},
        {-1, "tcaron", 600},
        {-1, "eogonek", 600},
        {-1, "Uogonek", 600},
        {-1, "Aacute", 600},
        {-1, "Adieresis", 600},
        {-1, "egrave", 600},
        {-1, "zacute", 600},
        {-1, "iogonek", 600},
        {-1, "Oacute", 600},
        {-1, "oacute", 600},
        {-1, "amacron", 600},
        {-1, "sacute", 600},
        {-1, "idieresis", 600},
        {-1, "Ocircumflex", 600},
        {-1, "Ugrave", 600},
        {-1, "Delta", 600},
        {-1, "thorn", 600},
        {-1, "twosuperior", 600},
        {-1, "Odieresis", 600},
        {-1, "mu", 600},
        {-1, "igrave", 600},
        {-1, "ohungarumlaut", 600},
        {-1, "Eogonek", 600},
        {-1, "dcroat", 600},
        {-1, "threequarters", 600},
        {-1, "Scedilla", 600},
        {-1, "lcaron", 600},
        {-1, "Kcommaaccent", 600},
        {-1, "Lacute", 600},
        {-1, "trademark", 600},
        {-1, "edotaccent", 600},
        {-1, "Igrave", 600},
        {-1, "Imacron", 600},
        {-1, "Lcaron", 600},
        {-1, "onehalf", 600},
        {-1, "lessequal", 600},
        {-1, "ocircumflex", 600},
        {-1, "ntilde", 600},
        {-1, "Uhungarumlaut", 600},
        {-1, "Eacute", 600},
        {-1, "emacron", 600},
        {-1, "gbreve", 600},
        {-1, "onequarter", 600},
        {-1, "Scaron", 600},
        {-1, "Scommaaccent", 600},
        {-1, "Ohungarumlaut", 600},
        {-1, "degree", 600},
        {-1, "ograve", 600},
        {-1, "Ccaron", 600},
        {-1, "ugrave", 600},
        {-1, "radical", 600},
        {-1, "Dcaron", 600},
        {-1, "rcommaaccent", 600},
        {-1, "Ntilde", 600},
        {-1, "otilde", 600},
        {-1, "Rcommaaccent", 600},
        {-1, "Lcommaaccent", 600},
        {-1, "Atilde", 600},
        {-1, "Aogonek", 600},
        {-1, "Aring", 600},
        {-1, "Otilde", 600},
        {-1, "zdotaccent", 600},
        {-1, "Ecaron", 600},
        {-1, "Iogonek", 600},
        {-1, "kcommaaccent", 600},
        {-1, "minus", 600},
        {-1, "Icircumflex", 600},
        {-1, "ncaron", 600},
        {-1, "tcommaaccent", 600},
        {-1, "logicalnot", 600},
        {-1, "odieresis", 600},
        {-1, "udieresis", 600},
        {-1, "notequal", 600},
        {-1, "gcommaaccent", 600},
        {-1, "eth", 600},
        {-1, "zcaron", 600},
        {-1, "ncommaaccent", 600},
        {-1, "onesuperior", 600},
        {-1, "imacron", 600},
        {-1, "Euro", 600},
        {-1, NULL, 0}
    };
    fFontBBox.left = -57;
    fFontBBox.top = -250;
    fFontBBox.right = 869;
    fFontBBox.bottom = 801;
    fAscent = 629;
    fDescent =-157;
    fXHeight = 439;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
/*----- CourierOblique Font -------------------------------------------------*/

PdfCourierObliqueFontDef::PdfCourierObliqueFontDef()
    : PdfType1FontDef("Courier-Oblique")
{
    const pdf_char_data_ro char_data[316] = {
        {32, "space", 600},
        {33, "exclam", 600},
        {34, "quotedbl", 600},
        {35, "numbersign", 600},
        {36, "dollar", 600},
        {37, "percent", 600},
        {38, "ampersand", 600},
        {39, "quoteright", 600},
        {40, "parenleft", 600},
        {41, "parenright", 600},
        {42, "asterisk", 600},
        {43, "plus", 600},
        {44, "comma", 600},
        {45, "hyphen", 600},
        {46, "period", 600},
        {47, "slash", 600},
        {48, "zero", 600},
        {49, "one", 600},
        {50, "two", 600},
        {51, "three", 600},
        {52, "four", 600},
        {53, "five", 600},
        {54, "six", 600},
        {55, "seven", 600},
        {56, "eight", 600},
        {57, "nine", 600},
        {58, "colon", 600},
        {59, "semicolon", 600},
        {60, "less", 600},
        {61, "equal", 600},
        {62, "greater", 600},
        {63, "question", 600},
        {64, "at", 600},
        {65, "A", 600},
        {66, "B", 600},
        {67, "C", 600},
        {68, "D", 600},
        {69, "E", 600},
        {70, "F", 600},
        {71, "G", 600},
        {72, "H", 600},
        {73, "I", 600},
        {74, "J", 600},
        {75, "K", 600},
        {76, "L", 600},
        {77, "M", 600},
        {78, "N", 600},
        {79, "O", 600},
        {80, "P", 600},
        {81, "Q", 600},
        {82, "R", 600},
        {83, "S", 600},
        {84, "T", 600},
        {85, "U", 600},
        {86, "V", 600},
        {87, "W", 600},
        {88, "X", 600},
        {89, "Y", 600},
        {90, "Z", 600},
        {91, "bracketleft", 600},
        {92, "backslash", 600},
        {93, "bracketright", 600},
        {94, "asciicircum", 600},
        {95, "underscore", 600},
        {96, "quoteleft", 600},
        {97, "a", 600},
        {98, "b", 600},
        {99, "c", 600},
        {100, "d", 600},
        {101, "e", 600},
        {102, "f", 600},
        {103, "g", 600},
        {104, "h", 600},
        {105, "i", 600},
        {106, "j", 600},
        {107, "k", 600},
        {108, "l", 600},
        {109, "m", 600},
        {110, "n", 600},
        {111, "o", 600},
        {112, "p", 600},
        {113, "q", 600},
        {114, "r", 600},
        {115, "s", 600},
        {116, "t", 600},
        {117, "u", 600},
        {118, "v", 600},
        {119, "w", 600},
        {120, "x", 600},
        {121, "y", 600},
        {122, "z", 600},
        {123, "braceleft", 600},
        {124, "bar", 600},
        {125, "braceright", 600},
        {126, "asciitilde", 600},
        {161, "exclamdown", 600},
        {162, "cent", 600},
        {163, "sterling", 600},
        {164, "fraction", 600},
        {165, "yen", 600},
        {166, "florin", 600},
        {167, "section", 600},
        {168, "currency", 600},
        {169, "quotesingle", 600},
        {170, "quotedblleft", 600},
        {171, "guillemotleft", 600},
        {172, "guilsinglleft", 600},
        {173, "guilsinglright", 600},
        {174, "fi", 600},
        {175, "fl", 600},
        {177, "endash", 600},
        {178, "dagger", 600},
        {179, "daggerdbl", 600},
        {180, "periodcentered", 600},
        {182, "paragraph", 600},
        {183, "bullet", 600},
        {184, "quotesinglbase", 600},
        {185, "quotedblbase", 600},
        {186, "quotedblright", 600},
        {187, "guillemotright", 600},
        {188, "ellipsis", 600},
        {189, "perthousand", 600},
        {191, "questiondown", 600},
        {193, "grave", 600},
        {194, "acute", 600},
        {195, "circumflex", 600},
        {196, "tilde", 600},
        {197, "macron", 600},
        {198, "breve", 600},
        {199, "dotaccent", 600},
        {200, "dieresis", 600},
        {202, "ring", 600},
        {203, "cedilla", 600},
        {205, "hungarumlaut", 600},
        {206, "ogonek", 600},
        {207, "caron", 600},
        {208, "emdash", 600},
        {225, "AE", 600},
        {227, "ordfeminine", 600},
        {232, "Lslash", 600},
        {233, "Oslash", 600},
        {234, "OE", 600},
        {235, "ordmasculine", 600},
        {241, "ae", 600},
        {245, "dotlessi", 600},
        {248, "lslash", 600},
        {249, "oslash", 600},
        {250, "oe", 600},
        {251, "germandbls", 600},
        {-1, "Idieresis", 600},
        {-1, "eacute", 600},
        {-1, "abreve", 600},
        {-1, "uhungarumlaut", 600},
        {-1, "ecaron", 600},
        {-1, "Ydieresis", 600},
        {-1, "divide", 600},
        {-1, "Yacute", 600},
        {-1, "Acircumflex", 600},
        {-1, "aacute", 600},
        {-1, "Ucircumflex", 600},
        {-1, "yacute", 600},
        {-1, "scommaaccent", 600},
        {-1, "ecircumflex", 600},
        {-1, "Uring", 600},
        {-1, "Udieresis", 600},
        {-1, "aogonek", 600},
        {-1, "Uacute", 600},
        {-1, "uogonek", 600},
        {-1, "Edieresis", 600},
        {-1, "Dcroat", 600},
        {-1, "commaaccent", 600},
        {-1, "copyright", 600},
        {-1, "Emacron", 600},
        {-1, "ccaron", 600},
        {-1, "aring", 600},
        {-1, "Ncommaaccent", 600},
        {-1, "lacute", 600},
        {-1, "agrave", 600},
        {-1, "Tcommaaccent", 600},
        {-1, "Cacute", 600},
        {-1, "atilde", 600},
        {-1, "Edotaccent", 600},
        {-1, "scaron", 600},
        {-1, "scedilla", 600},
        {-1, "iacute", 600},
        {-1, "lozenge", 600},
        {-1, "Rcaron", 600},
        {-1, "Gcommaaccent", 600},
        {-1, "ucircumflex", 600},
        {-1, "acircumflex", 600},
        {-1, "Amacron", 600},
        {-1, "rcaron", 600},
        {-1, "ccedilla", 600},
        {-1, "Zdotaccent", 600},
        {-1, "Thorn", 600},
        {-1, "Omacron", 600},
        {-1, "Racute", 600},
        {-1, "Sacute", 600},
        {-1, "dcaron", 600},
        {-1, "Umacron", 600},
        {-1, "uring", 600},
        {-1, "threesuperior", 600},
        {-1, "Ograve", 600},
        {-1, "Agrave", 600},
        {-1, "Abreve", 600},
        {-1, "multiply", 600},
        {-1, "uacute", 600},
        {-1, "Tcaron", 600},
        {-1, "partialdiff", 600},
        {-1, "ydieresis", 600},
        {-1, "Nacute", 600},
        {-1, "icircumflex", 600},
        {-1, "Ecircumflex", 600},
        {-1, "adieresis", 600},
        {-1, "edieresis", 600},
        {-1, "cacute", 600},
        {-1, "nacute", 600},
        {-1, "umacron", 600},
        {-1, "Ncaron", 600},
        {-1, "Iacute", 600},
        {-1, "plusminus", 600},
        {-1, "brokenbar", 600},
        {-1, "registered", 600},
        {-1, "Gbreve", 600},
        {-1, "Idotaccent", 600},
        {-1, "summation", 600},
        {-1, "Egrave", 600},
        {-1, "racute", 600},
        {-1, "omacron", 600},
        {-1, "Zacute", 600},
        {-1, "Zcaron", 600},
        {-1, "greaterequal", 600},
        {-1, "Eth", 600},
        {-1, "Ccedilla", 600},
        {-1, "lcommaaccent", 600},
        {-1, "tcaron", 600},
        {-1, "eogonek", 600},
        {-1, "Uogonek", 600},
        {-1, "Aacute", 600},
        {-1, "Adieresis", 600},
        {-1, "egrave", 600},
        {-1, "zacute", 600},
        {-1, "iogonek", 600},
        {-1, "Oacute", 600},
        {-1, "oacute", 600},
        {-1, "amacron", 600},
        {-1, "sacute", 600},
        {-1, "idieresis", 600},
        {-1, "Ocircumflex", 600},
        {-1, "Ugrave", 600},
        {-1, "Delta", 600},
        {-1, "thorn", 600},
        {-1, "twosuperior", 600},
        {-1, "Odieresis", 600},
        {-1, "mu", 600},
        {-1, "igrave", 600},
        {-1, "ohungarumlaut", 600},
        {-1, "Eogonek", 600},
        {-1, "dcroat", 600},
        {-1, "threequarters", 600},
        {-1, "Scedilla", 600},
        {-1, "lcaron", 600},
        {-1, "Kcommaaccent", 600},
        {-1, "Lacute", 600},
        {-1, "trademark", 600},
        {-1, "edotaccent", 600},
        {-1, "Igrave", 600},
        {-1, "Imacron", 600},
        {-1, "Lcaron", 600},
        {-1, "onehalf", 600},
        {-1, "lessequal", 600},
        {-1, "ocircumflex", 600},
        {-1, "ntilde", 600},
        {-1, "Uhungarumlaut", 600},
        {-1, "Eacute", 600},
        {-1, "emacron", 600},
        {-1, "gbreve", 600},
        {-1, "onequarter", 600},
        {-1, "Scaron", 600},
        {-1, "Scommaaccent", 600},
        {-1, "Ohungarumlaut", 600},
        {-1, "degree", 600},
        {-1, "ograve", 600},
        {-1, "Ccaron", 600},
        {-1, "ugrave", 600},
        {-1, "radical", 600},
        {-1, "Dcaron", 600},
        {-1, "rcommaaccent", 600},
        {-1, "Ntilde", 600},
        {-1, "otilde", 600},
        {-1, "Rcommaaccent", 600},
        {-1, "Lcommaaccent", 600},
        {-1, "Atilde", 600},
        {-1, "Aogonek", 600},
        {-1, "Aring", 600},
        {-1, "Otilde", 600},
        {-1, "zdotaccent", 600},
        {-1, "Ecaron", 600},
        {-1, "Iogonek", 600},
        {-1, "kcommaaccent", 600},
        {-1, "minus", 600},
        {-1, "Icircumflex", 600},
        {-1, "ncaron", 600},
        {-1, "tcommaaccent", 600},
        {-1, "logicalnot", 600},
        {-1, "odieresis", 600},
        {-1, "udieresis", 600},
        {-1, "notequal", 600},
        {-1, "gcommaaccent", 600},
        {-1, "eth", 600},
        {-1, "zcaron", 600},
        {-1, "ncommaaccent", 600},
        {-1, "onesuperior", 600},
        {-1, "imacron", 600},
        {-1, "Euro", 600},
        {-1, NULL, 0}
    };
    fFontBBox.left = -27;
    fFontBBox.top = -250;
    fFontBBox.right = 849;
    fFontBBox.bottom = 805;
    fAscent = 629;
    fDescent =-157;
    fXHeight = 426;
    fIsBase14Font = true;

    SetWidths(char_data);
}

/*---------------------------------------------------------------------------*/
