/// hash functionality
/// for migrate, currently uses string with 0 1 characters of 'any' length
/// and adding a count to the values, this is geared towards counting patterns
/// but may be easily expanded to more complex storage devices
/// currently the keys are partitioned into 1<<9 blocks and subkeys are link hashtables
/// I guess they call this a perfect hash, but this one is sparse and not all subtrees are completely
/// allocated.
///
/// LGPL - license
/// Peter Beerli 2010
#ifndef _HASH_INCLUDE 
#define _HASH_INCLUDE
#include "migration.h"

boolean insert_hash(char *key, int *offset, int numstates, int realnumstates, long ptr, hash_fmt **hash, int *numhash);
long find_hash(char *key, int numstates, hash_fmt *hash, int *numhash);

void hash_elements(hash_fmt *hash, int numhash, long *total);
void hash_leaves(hash_fmt *hash, int numhash, long *leaves);
void show_hash(hash_fmt *hash, int numhash, int numstates, char ***showkeys, int **showvalues, long *z);
void free_hash(hash_fmt *hash, int numhash, int numstates);
#endif
