/*
 * << H a r u --free pdf library >> -- PdfCMap_KSC_EUC_H.cc
 *
 * Copyright (c) 1999-2003 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

#include "libharu_krfonts.h"

static const pdf_cid_range CID_ARRAY1[] = {
    {0x20, 0x7e, 8094},
    {0xa1a1, 0xa1fe, 101},
    {0xa2a1, 0xa2e5, 195},
    {0xa3a1, 0xa3fe, 264},
    {0xa4a1, 0xa4d3, 358},
    {0xa4d5, 0xa4fe, 409},
    {0xa5a1, 0xa5aa, 451},
    {0xa5b0, 0xa5b9, 461},
    {0xa5c1, 0xa5d8, 471},
    {0xa5e1, 0xa5f8, 495},
    {0xa6a1, 0xa6e4, 519},
    {0xa7a1, 0xa7ef, 587},
    {0xa8a1, 0xa8a4, 666},
    {0xa8a6, 0xa8a6, 670},
    {0xa8a8, 0xa8af, 671},
    {0xa8b1, 0xa8fe, 679},
    {0xa9a1, 0xa9fe, 757},
    {0xaaa1, 0xaaf3, 851},
    {0xaba1, 0xabf6, 934},
    {0xaca1, 0xacc1, 1020},
    {0xacd1, 0xacf1, 1053},
    {0xb0a1, 0xb0fe, 1086},
    {0xb1a1, 0xb1fe, 1180},
    {0xb2a1, 0xb2fe, 1274},
    {0xb3a1, 0xb3fe, 1368},
    {0xb4a1, 0xb4fe, 1462},
    {0xb5a1, 0xb5fe, 1556},
    {0xb6a1, 0xb6fe, 1650},
    {0xb7a1, 0xb7fe, 1744},
    {0xb8a1, 0xb8fe, 1838},
    {0xb9a1, 0xb9fe, 1932},
    {0xbaa1, 0xbafe, 2026},
    {0xbba1, 0xbbfe, 2120},
    {0xbca1, 0xbcfe, 2214},
    {0xbda1, 0xbdfe, 2308},
    {0xbea1, 0xbefe, 2402},
    {0xbfa1, 0xbffe, 2496},
    {0xc0a1, 0xc0fe, 2590},
    {0xc1a1, 0xc1fe, 2684},
    {0xc2a1, 0xc2fe, 2778},
    {0xc3a1, 0xc3fe, 2872},
    {0xc4a1, 0xc4fe, 2966},
    {0xc5a1, 0xc5fe, 3060},
    {0xc6a1, 0xc6fe, 3154},
    {0xc7a1, 0xc7fe, 3248},
    {0xc8a1, 0xc8fe, 3342},
    {0xcaa1, 0xcafe, 3436},
    {0xcba1, 0xcbcf, 3530},
    {0xcbd0, 0xcbd0, 4116},
    {0xcbd1, 0xcbd5, 3577},
    {0xcbd6, 0xcbd6, 3678},
    {0xcbd7, 0xcbe6, 3582},
    {0xcbe7, 0xcbe7, 7053},
    {0xcbe8, 0xcbfe, 3598},
    {0xcca1, 0xccfe, 3621},
    {0xcda1, 0xcdce, 3715},
    {0xcdcf, 0xcdcf, 3460},
    {0xcdd0, 0xcde7, 3761},
    {0xcde8, 0xcde8, 7900},
    {0xcde9, 0xcdfe, 3785},
    {0xcea1, 0xceac, 3807},
    {0xcead, 0xcead, 3802},
    {0xceae, 0xcefe, 3819},
    {0xcfa1, 0xcffa, 3900},
    {0xcffb, 0xcffb, 3902},
    {0xcffc, 0xcffe, 3990},
    {0xd0a1, 0xd0a1, 3993},
    {0xd0a2, 0xd0a2, 3946},
    {0xd0a3, 0xd0b7, 3994},
    {0xd0b8, 0xd0b8, 3946},
    {0xd0b9, 0xd0cf, 4015},
    {0xd0d0, 0xd0d0, 3708},
    {0xd0d1, 0xd0dc, 4038},
    {0xd0dd, 0xd0dd, 4131},
    {0xd0de, 0xd0fe, 4050},
    {0xd1a1, 0xd1d3, 4083},
    {0xd1d4, 0xd1d4, 4374},
    {0xd1d5, 0xd1d5, 4156},
    {0xd1d6, 0xd1d7, 4134},
    {0xd1d8, 0xd1d8, 4375},
    {0xd1d9, 0xd1da, 4136},
    {0xd1db, 0xd1e0, 4376},
    {0xd1e1, 0xd1e1, 4138},
    {0xd1e2, 0xd1e2, 5800},
    {0xd1e3, 0xd1e5, 4382},
    {0xd1e6, 0xd1e6, 4386},
    {0xd1e7, 0xd1e7, 4139},
    {0xd1e8, 0xd1eb, 4387},
    {0xd1ec, 0xd1ec, 4140},
    {0xd1ed, 0xd1ed, 4391},
    {0xd1ee, 0xd1ee, 4141},
    {0xd1ef, 0xd1f0, 4394},
    {0xd1f1, 0xd1f1, 4142},
    {0xd1f2, 0xd1f2, 4396},
    {0xd1f3, 0xd1f5, 4143},
    {0xd1f6, 0xd1f6, 4399},
    {0xd1f7, 0xd1f9, 4146},
    {0xd1fa, 0xd1fa, 4403},
    {0xd1fb, 0xd1fb, 4149},
    {0xd1fc, 0xd1fd, 4406},
    {0xd1fe, 0xd1fe, 4409},
    {0xd2a1, 0xd2a1, 4150},
    {0xd2a2, 0xd2a3, 4410},
    {0xd2a4, 0xd2a6, 4151},
    {0xd2a7, 0xd2aa, 4412},
    {0xd2ab, 0xd2ab, 4419},
    {0xd2ac, 0xd2ac, 4154},
    {0xd2ad, 0xd2ad, 4420},
    {0xd2ae, 0xd2b1, 4155},
    {0xd2b2, 0xd2b2, 4424},
    {0xd2b3, 0xd2bd, 4159},
    {0xd2be, 0xd2be, 4511},
    {0xd2bf, 0xd2c1, 4170},
    {0xd2c2, 0xd2c3, 4513},
    {0xd2c4, 0xd2c4, 4517},
    {0xd2c5, 0xd2c5, 4173},
    {0xd2c6, 0xd2ca, 4518},
    {0xd2cb, 0xd2cb, 4524},
    {0xd2cc, 0xd2cc, 4174},
    {0xd2cd, 0xd2ce, 4525},
    {0xd2cf, 0xd2d4, 4528},
    {0xd2d5, 0xd2d7, 4535},
    {0xd2d8, 0xd2d8, 4175},
    {0xd2d9, 0xd2da, 4541},
    {0xd2db, 0xd2dd, 4176},
    {0xd2de, 0xd2df, 4545},
    {0xd2e0, 0xd2e0, 4179},
    {0xd2e1, 0xd2e1, 4547},
    {0xd2e2, 0xd2e2, 4550},
    {0xd2e3, 0xd2e3, 4180},
    {0xd2e4, 0xd2e4, 4564},
    {0xd2e5, 0xd2e8, 4566},
    {0xd2e9, 0xd2ea, 4571},
    {0xd2eb, 0xd2eb, 4576},
    {0xd2ec, 0xd2ef, 4181},
    {0xd2f0, 0xd2f3, 4604},
    {0xd2f4, 0xd2f5, 4609},
    {0xd2f6, 0xd2f6, 4185},
    {0xd2f7, 0xd2f8, 4611},
    {0xd2f9, 0xd2fe, 4186},
    {0xd3a1, 0xd3fe, 4192},
    {0xd4a1, 0xd4e5, 4286},
    {0xd4e6, 0xd4e6, 4318},
    {0xd4e7, 0xd4fb, 4355},
    {0xd4fc, 0xd4fc, 4136},
    {0xd4fd, 0xd4fe, 4376},
    {0xd5a1, 0xd5a4, 4378},
    {0xd5a5, 0xd5a5, 5800},
    {0xd5a6, 0xd5aa, 4382},
    {0xd5ab, 0xd5ab, 4139},
    {0xd5ac, 0xd5ad, 4387},
    {0xd5ae, 0xd5ae, 4192},
    {0xd5af, 0xd5fe, 4389},
    {0xd6a1, 0xd6b7, 4469},
    {0xd6b8, 0xd6b8, 4167},
    {0xd6b9, 0xd6cc, 4492},
    {0xd6cd, 0xd6cd, 4172},
    {0xd6ce, 0xd6fe, 4512},
    {0xd7a1, 0xd7ca, 4561},
    {0xd7cb, 0xd7cb, 5552},
    {0xd7cc, 0xd7e3, 4603},
    {0xd7e4, 0xd7e4, 6424},
    {0xd7e5, 0xd7fe, 4627},
    {0xd8a1, 0xd8fe, 4653},
    {0xd9a1, 0xd9fe, 4747},
    {0xdaa1, 0xdafe, 4841},
    {0xdba1, 0xdbc4, 4935},
    {0xdbc5, 0xdbc5, 5151},
    {0xdbc6, 0xdbe3, 4971},
    {0xdbe4, 0xdbe4, 4922},
    {0xdbe5, 0xdbfe, 5001},
    {0xdca1, 0xdca4, 5027},
    {0xdca5, 0xdca5, 7518},
    {0xdca6, 0xdcfe, 5031},
    {0xdda1, 0xdda4, 5120},
    {0xdda5, 0xdda5, 5079},
    {0xdda6, 0xddd4, 5124},
    {0xddd5, 0xddd5, 5109},
    {0xddd6, 0xddf3, 5171},
    {0xddf4, 0xddf4, 7607},
    {0xddf5, 0xddfe, 5201},
    {0xdea1, 0xdefb, 5211},
    {0xdefc, 0xdefc, 5584},
    {0xdefd, 0xdefd, 5302},
    {0xdefe, 0xdefe, 5367},
    {0xdfa1, 0xdfb2, 5303},
    {0xdfb3, 0xdfb3, 7083},
    {0xdfb4, 0xdfe0, 5321},
    {0xdfe1, 0xdfe1, 5362},
    {0xdfe2, 0xdfe7, 5366},
    {0xdfe8, 0xdfe8, 5485},
    {0xdfe9, 0xdffe, 5372},
    {0xe0a1, 0xe0f0, 5394},
    {0xe0f1, 0xe0f1, 6001},
    {0xe0f2, 0xe0fe, 5474},
    {0xe1a1, 0xe1ac, 5487},
    {0xe1ad, 0xe1ad, 5460},
    {0xe1ae, 0xe1ec, 5499},
    {0xe1ed, 0xe1ed, 5317},
    {0xe1ee, 0xe1fe, 5562},
    {0xe2a1, 0xe2fe, 5579},
    {0xe3a1, 0xe3f4, 5673},
    {0xe3f5, 0xe3f5, 7009},
    {0xe3f6, 0xe3fe, 5757},
    {0xe4a1, 0xe4a1, 7370},
    {0xe4a2, 0xe4a8, 5766},
    {0xe4a9, 0xe4a9, 5678},
    {0xe4aa, 0xe4fe, 5773},
    {0xe5a1, 0xe5ad, 5858},
    {0xe5ae, 0xe5ae, 5874},
    {0xe5af, 0xe5b0, 5871},
    {0xe5b1, 0xe5b2, 4425},
    {0xe5b3, 0xe5b8, 5873},
    {0xe5b9, 0xe5b9, 4427},
    {0xe5ba, 0xe5ba, 5879},
    {0xe5bb, 0xe5bc, 4429},
    {0xe5bd, 0xe5c3, 5880},
    {0xe5c4, 0xe5c4, 4431},
    {0xe5c5, 0xe5cd, 5887},
    {0xe5ce, 0xe5ce, 4435},
    {0xe5cf, 0xe5cf, 5896},
    {0xe5d0, 0xe5d0, 4436},
    {0xe5d1, 0xe5d1, 5897},
    {0xe5d2, 0xe5d2, 4437},
    {0xe5d3, 0xe5d5, 5898},
    {0xe5d6, 0xe5d6, 4439},
    {0xe5d7, 0xe5f9, 5901},
    {0xe5fa, 0xe5fb, 4442},
    {0xe5fc, 0xe5fc, 4159},
    {0xe5fd, 0xe5fd, 5936},
    {0xe5fe, 0xe5fe, 4444},
    {0xe6a1, 0xe6a1, 4447},
    {0xe6a2, 0xe6a3, 5937},
    {0xe6a4, 0xe6a4, 4449},
    {0xe6a5, 0xe6a6, 5939},
    {0xe6a7, 0xe6a7, 4450},
    {0xe6a8, 0xe6ac, 5941},
    {0xe6ad, 0xe6ad, 4453},
    {0xe6ae, 0xe6ae, 5946},
    {0xe6af, 0xe6b1, 4455},
    {0xe6b2, 0xe6b2, 5947},
    {0xe6b3, 0xe6b3, 4458},
    {0xe6b4, 0xe6b6, 5948},
    {0xe6b7, 0xe6b8, 4459},
    {0xe6b9, 0xe6bb, 5951},
    {0xe6bc, 0xe6bc, 4463},
    {0xe6bd, 0xe6c3, 5954},
    {0xe6c4, 0xe6c4, 4160},
    {0xe6c5, 0xe6c5, 5961},
    {0xe6c6, 0xe6c7, 4465},
    {0xe6c8, 0xe6c9, 5962},
    {0xe6ca, 0xe6ca, 4161},
    {0xe6cb, 0xe6d1, 5964},
    {0xe6d2, 0xe6d2, 4468},
    {0xe6d3, 0xe6d5, 5971},
    {0xe6d6, 0xe6d6, 4469},
    {0xe6d7, 0xe6d8, 5974},
    {0xe6d9, 0xe6d9, 4470},
    {0xe6da, 0xe6db, 5976},
    {0xe6dc, 0xe6dc, 4162},
    {0xe6dd, 0xe6de, 5978},
    {0xe6df, 0xe6df, 4471},
    {0xe6e0, 0xe6e0, 5980},
    {0xe6e1, 0xe6e1, 4472},
    {0xe6e2, 0xe6e3, 5981},
    {0xe6e4, 0xe6e4, 4474},
    {0xe6e5, 0xe6e5, 4473},
    {0xe6e6, 0xe6e6, 4475},
    {0xe6e7, 0xe6e7, 5983},
    {0xe6e8, 0xe6e8, 4476},
    {0xe6e9, 0xe6e9, 5984},
    {0xe6ea, 0xe6eb, 4478},
    {0xe6ec, 0xe6ec, 6447},
    {0xe6ed, 0xe6ee, 5985},
    {0xe6ef, 0xe6ef, 4481},
    {0xe6f0, 0xe6f0, 5987},
    {0xe6f1, 0xe6f1, 4482},
    {0xe6f2, 0xe6f2, 5460},
    {0xe6f3, 0xe6f4, 5988},
    {0xe6f5, 0xe6f5, 4483},
    {0xe6f6, 0xe6f6, 4163},
    {0xe6f7, 0xe6f7, 4166},
    {0xe6f8, 0xe6f8, 5990},
    {0xe6f9, 0xe6f9, 4485},
    {0xe6fa, 0xe6fe, 5991},
    {0xe7a1, 0xe7a1, 4487},
    {0xe7a2, 0xe7a5, 5996},
    {0xe7a6, 0xe7a6, 4488},
    {0xe7a7, 0xe7a8, 6000},
    {0xe7a9, 0xe7a9, 4489},
    {0xe7aa, 0xe7aa, 4491},
    {0xe7ab, 0xe7ab, 6002},
    {0xe7ac, 0xe7ac, 4167},
    {0xe7ad, 0xe7ad, 4493},
    {0xe7ae, 0xe7af, 6003},
    {0xe7b0, 0xe7b0, 4494},
    {0xe7b1, 0xe7be, 6005},
    {0xe7bf, 0xe7bf, 4495},
    {0xe7c0, 0xe7c0, 6019},
    {0xe7c1, 0xe7c1, 7783},
    {0xe7c2, 0xe7c5, 6020},
    {0xe7c6, 0xe7c6, 4497},
    {0xe7c7, 0xe7c7, 4499},
    {0xe7c8, 0xe7ca, 6024},
    {0xe7cb, 0xe7cb, 4501},
    {0xe7cc, 0xe7cc, 6027},
    {0xe7cd, 0xe7cd, 4502},
    {0xe7ce, 0xe7ce, 6028},
    {0xe7cf, 0xe7d0, 4503},
    {0xe7d1, 0xe7d2, 6029},
    {0xe7d3, 0xe7d3, 4506},
    {0xe7d4, 0xe7de, 6031},
    {0xe7df, 0xe7df, 4508},
    {0xe7e0, 0xe7e3, 6042},
    {0xe7e4, 0xe7e4, 4509},
    {0xe7e5, 0xe7e5, 6046},
    {0xe7e6, 0xe7e6, 4510},
    {0xe7e7, 0xe7f6, 6047},
    {0xe7f7, 0xe7f7, 5797},
    {0xe7f8, 0xe7fe, 6063},
    {0xe8a1, 0xe8e6, 6070},
    {0xe8e7, 0xe8e8, 4551},
    {0xe8e9, 0xe8ef, 6140},
    {0xe8f0, 0xe8f0, 4553},
    {0xe8f1, 0xe8f1, 4180},
    {0xe8f2, 0xe8f6, 6147},
    {0xe8f7, 0xe8f7, 4555},
    {0xe8f8, 0xe8f8, 6152},
    {0xe8f9, 0xe8f9, 5800},
    {0xe8fa, 0xe8fa, 6153},
    {0xe8fb, 0xe8fb, 4556},
    {0xe8fc, 0xe8fd, 6154},
    {0xe8fe, 0xe8fe, 4557},
    {0xe9a1, 0xe9a6, 6156},
    {0xe9a7, 0xe9a7, 4560},
    {0xe9a8, 0xe9ab, 6162},
    {0xe9ac, 0xe9ac, 4561},
    {0xe9ad, 0xe9cb, 6166},
    {0xe9cc, 0xe9cc, 4563},
    {0xe9cd, 0xe9f6, 6197},
    {0xe9f7, 0xe9f7, 7988},
    {0xe9f8, 0xe9fe, 6239},
    {0xeaa1, 0xeac0, 6246},
    {0xeac1, 0xeac1, 6123},
    {0xeac2, 0xeae4, 6278},
    {0xeae5, 0xeae5, 4577},
    {0xeae6, 0xeaf3, 6313},
    {0xeaf4, 0xeaf4, 4183},
    {0xeaf5, 0xeaf6, 6327},
    {0xeaf7, 0xeaf7, 4579},
    {0xeaf8, 0xeafb, 6329},
    {0xeafc, 0xeafc, 4581},
    {0xeafd, 0xeafd, 6333},
    {0xeafe, 0xeafe, 4582},
    {0xeba1, 0xeba3, 6334},
    {0xeba4, 0xeba4, 4584},
    {0xeba5, 0xeba6, 6337},
    {0xeba7, 0xeba7, 4586},
    {0xeba8, 0xeba8, 6339},
    {0xeba9, 0xeba9, 4588},
    {0xebaa, 0xebaa, 4184},
    {0xebab, 0xebb9, 6340},
    {0xebba, 0xebbb, 4590},
    {0xebbc, 0xebbc, 6355},
    {0xebbd, 0xebbd, 4592},
    {0xebbe, 0xebc0, 6356},
    {0xebc1, 0xebc1, 4593},
    {0xebc2, 0xebc2, 4595},
    {0xebc3, 0xebc5, 6359},
    {0xebc6, 0xebc7, 4596},
    {0xebc8, 0xebcb, 6362},
    {0xebcc, 0xebcc, 4599},
    {0xebcd, 0xebce, 6366},
    {0xebcf, 0xebd1, 4600},
    {0xebd2, 0xebd2, 5552},
    {0xebd3, 0xebd7, 6368},
    {0xebd8, 0xebd8, 4603},
    {0xebd9, 0xebfe, 6373},
    {0xeca1, 0xeca5, 6411},
    {0xeca6, 0xeca6, 4614},
    {0xeca7, 0xeca7, 4616},
    {0xeca8, 0xeca9, 6416},
    {0xecaa, 0xecaa, 4618},
    {0xecab, 0xecae, 6418},
    {0xecaf, 0xecaf, 5950},
    {0xecb0, 0xecb1, 4620},
    {0xecb2, 0xecb2, 4187},
    {0xecb3, 0xecb4, 6422},
    {0xecb5, 0xecb5, 4625},
    {0xecb6, 0xecb7, 6424},
    {0xecb8, 0xecb8, 4627},
    {0xecb9, 0xecb9, 6426},
    {0xecba, 0xecba, 4629},
    {0xecbb, 0xecbf, 6427},
    {0xecc0, 0xecc1, 4632},
    {0xecc2, 0xecc4, 6432},
    {0xecc5, 0xecc5, 4634},
    {0xecc6, 0xecc6, 4636},
    {0xecc7, 0xecc8, 6435},
    {0xecc9, 0xecca, 4188},
    {0xeccb, 0xecd4, 6437},
    {0xecd5, 0xecd5, 4638},
    {0xecd6, 0xecdc, 6447},
    {0xecdd, 0xecde, 4640},
    {0xecdf, 0xece0, 6454},
    {0xece1, 0xece1, 4642},
    {0xece2, 0xece3, 6456},
    {0xece4, 0xece4, 4644},
    {0xece5, 0xece6, 6458},
    {0xece7, 0xece8, 4645},
    {0xece9, 0xecf6, 6460},
    {0xecf7, 0xecf8, 4647},
    {0xecf9, 0xecf9, 6474},
    {0xecfa, 0xecfa, 4650},
    {0xecfb, 0xecfe, 6475},
    {0xeda1, 0xeda3, 4653},
    {0xeda4, 0xeded, 6479},
    {0xedee, 0xedee, 5351},
    {0xedef, 0xedfe, 6553},
    {0xeea1, 0xeeda, 6569},
    {0xeedb, 0xeedb, 6494},
    {0xeedc, 0xeefe, 6627},
    {0xefa1, 0xeffe, 6662},
    {0xf0a1, 0xf0fe, 6756},
    {0xf1a1, 0xf1fe, 6850},
    {0xf2a1, 0xf2bc, 6944},
    {0xf2bd, 0xf2bd, 5731},
    {0xf2be, 0xf2f9, 6972},
    {0xf2fa, 0xf2fa, 5771},
    {0xf2fb, 0xf2fe, 7032},
    {0xf3a1, 0xf3b0, 7036},
    {0xf3b1, 0xf3b1, 4191},
    {0xf3b2, 0xf3fe, 7052},
    {0xf4a1, 0xf4a6, 7129},
    {0xf4a7, 0xf4a7, 6484},
    {0xf4a8, 0xf4ed, 7135},
    {0xf4ee, 0xf4ee, 6684},
    {0xf4ef, 0xf4fe, 7205},
    {0xf5a1, 0xf5fe, 7221},
    {0xf6a1, 0xf6f3, 7315},
    {0xf6f4, 0xf6f4, 4279},
    {0xf6f5, 0xf6f5, 7398},
    {0xf6f6, 0xf6f6, 7139},
    {0xf6f7, 0xf6fe, 7399},
    {0xf7a1, 0xf7b7, 7407},
    {0xf7b8, 0xf7b8, 4247},
    {0xf7b9, 0xf7c7, 7430},
    {0xf7c8, 0xf7c8, 4266},
    {0xf7c9, 0xf7d2, 7445},
    {0xf7d3, 0xf7d3, 4340},
    {0xf7d4, 0xf7fe, 7455},
    {0xf8a1, 0xf8da, 7498},
    {0xf8db, 0xf8db, 7572},
    {0xf8dc, 0xf8ef, 7556},
    {0xf8f0, 0xf8f0, 5088},
    {0xf8f1, 0xf8fe, 7576},
    {0xf9a1, 0xf9fe, 7590},
    {0xfaa1, 0xfaa1, 7709},
    {0xfaa2, 0xfaa2, 3558},
    {0xfaa3, 0xfae5, 7684},
    {0xfae6, 0xfae6, 3644},
    {0xfae7, 0xfafe, 7751},
    {0xfba1, 0xfbfe, 7775},
    {0xfca1, 0xfca8, 7869},
    {0xfca9, 0xfca9, 3815},
    {0xfcaa, 0xfcfe, 7877},
    {0xfda1, 0xfdfe, 7962},
	{0xffff, 0xffff, 0}
};

void
PdfCMap_KSC_EUC_H::Init()
{
    AddCMap(CID_ARRAY1);
    SetCIDSystemInfo("Adobe", "Korea1", 0);
}

void
PdfCMap_KSC_EUC_H::ParseText(const char* text, pdf_byte_type* btype)
{
    pdf_byte_type* ptype = btype;
    const char* ptext = text;
    pdf_byte_type type = PDF_BYTE_TYPE_SINGLE;

    for (unsigned int i = 0; i < strlen(text); i++, ptext++, ptype++) {
        unsigned char c = (unsigned char)*ptext;
        if (type == PDF_BYTE_TYPE_LEAD)
            if (c >= 0xa0 && c <= 0xfe)
                *ptype = PDF_BYTE_TYPE_TRIAL;
            else
                *ptype = PDF_BYTE_TYPE_SINGLE; /* Cannot judge byte type. */
        else if (type == PDF_BYTE_TYPE_SINGLE || type == PDF_BYTE_TYPE_TRIAL)
	  {
	    if ((c >= 0xa1 && c <= 0xfe) || c == 0x8e )
                *ptype = PDF_BYTE_TYPE_LEAD;
            else
                *ptype = PDF_BYTE_TYPE_SINGLE;
	  }
        type = *ptype;
    }
}

